<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PricingRule extends Model
{
    use HasFactory;

    protected $fillable = [
        'beauty_salon_id',
        'name',
        'description',
        'rule_type',
        'pricing_type',
        'price_adjustment',
        'multiplier',
        'start_time',
        'end_time',
        'days_of_week',
        'start_date',
        'end_date',
        'demand_threshold',
        'staff_id',
        'service_id',
        'max_bookings',
        'is_active',
        'priority',
    ];

    protected $casts = [
        'price_adjustment' => 'decimal:2',
        'multiplier' => 'decimal:2',
        'days_of_week' => 'array',
        'start_date' => 'date',
        'end_date' => 'date',
        'is_active' => 'boolean',
    ];

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }

    public function service()
    {
        return $this->belongsTo(Service::class);
    }
}
