<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Referral extends Model
{
    use HasFactory;

    protected $fillable = [
        'beauty_salon_id',
        'referrer_id',
        'referred_id',
        'referral_code',
        'status',
        'first_appointment_id',
        'registered_at',
        'first_visit_at',
        'rewarded_at',
        'ip_address',
        'user_agent',
        'metadata',
    ];

    protected $casts = [
        'registered_at' => 'datetime',
        'first_visit_at' => 'datetime',
        'rewarded_at' => 'datetime',
        'metadata' => 'array',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($referral) {
            if (empty($referral->referral_code)) {
                $referral->referral_code = Str::upper(Str::random(8));
            }
        });
    }

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }

    public function referrer()
    {
        return $this->belongsTo(Customer::class, 'referrer_id');
    }

    public function referred()
    {
        return $this->belongsTo(Customer::class, 'referred_id');
    }

    public function rewardHistory()
    {
        return $this->hasMany(ReferralRewardHistory::class);
    }
}
