<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ReferralReward extends Model
{
    protected $fillable = [
        'beauty_salon_id',
        'reward_type',
        'referrer_reward_amount',
        'referred_reward_amount',
        'referrer_reward_percentage',
        'referred_reward_percentage',
        'min_visits_required',
        'require_payment',
        'is_active',
    ];

    protected $casts = [
        'referrer_reward_amount' => 'decimal:2',
        'referred_reward_amount' => 'decimal:2',
        'referrer_reward_percentage' => 'decimal:2',
        'referred_reward_percentage' => 'decimal:2',
        'min_visits_required' => 'integer',
        'require_payment' => 'boolean',
        'is_active' => 'boolean',
    ];

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }
}
