<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ReferralRewardHistory extends Model
{
    protected $table = 'referral_reward_history';

    protected $fillable = [
        'referral_id',
        'customer_id',
        'reward_for',
        'reward_type',
        'reward_amount',
        'appointment_id',
        'description',
    ];

    protected $casts = [
        'reward_amount' => 'decimal:2',
    ];

    public function referral()
    {
        return $this->belongsTo(Referral::class);
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
}
