<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Reservation extends Model
{
    use HasFactory;

    protected $fillable = [
        'code',
        'customer_id',
        'company_id',
        'salon_id',
        'beauty_salon_id',
        'menu_id',
        'room_id',
        'personel_id',
        'personel_service_id',
        'date',
        'reservation_date',
        'start_time',
        'end_time',
        'guest_count',
        'total_price',
        'deposit_paid',
        'remaining_amount',
        'status',
        'notes',
        'items_data',
        'created_by',
        'updated_by',
        'bride_name',
        'groom_name',
        'bride_phone',
        'groom_phone',
    ];

    protected $casts = [
        'date' => 'date',
        'reservation_date' => 'date',
        'total_price' => 'decimal:2',
        'deposit_paid' => 'decimal:2',
        'remaining_amount' => 'decimal:2',
        'guest_count' => 'integer',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function salon()
    {
        return $this->belongsTo(Salon::class);
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function personel()
    {
        return $this->belongsTo(User::class, 'personel_id');
    }

    public function room()
    {
        return $this->belongsTo(Room::class, 'room_id');
    }

    public function appointmentRequest()
    {
        return $this->hasOne(\App\Models\AppointmentRequest::class, 'reservation_id');
    }

    public function extras()
    {
        return $this->belongsToMany(Extra::class, 'reservation_extras')
                    ->withPivot('quantity', 'price')
                    ->withTimestamps();
    }

    public function services()
    {
        return $this->belongsToMany(Service::class, 'reservation_services')
                    ->withPivot('price', 'quantity')
                    ->withTimestamps();
    }
}

