<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Room extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'beauty_salon_id',
        'capacity',
        'color',
        'tags',
    ];

    protected $casts = [
        'capacity' => 'integer',
        'tags' => 'array',
    ];

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }

    public function reservations()
    {
        return $this->hasMany(Reservation::class);
    }
}

