<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SmartDiscount extends Model
{
    use HasFactory;

    protected $fillable = [
        'beauty_salon_id',
        'name',
        'description',
        'campaign_type',
        'days_of_week',
        'discount_percentage',
        'discount_amount',
        'service_ids',
        'target_segments',
        'start_time',
        'end_time',
        'start_date',
        'end_date',
        'is_active',
        'status',
        'auto_apply',
        'budget',
        'budget_used',
        'max_redemptions',
        'redemptions_count',
        'auto_stop_on_loss',
        'min_roi',
    ];

    protected $casts = [
        'days_of_week' => 'array',
        'service_ids' => 'array',
        'target_segments' => 'array',
        'discount_percentage' => 'decimal:2',
        'discount_amount' => 'decimal:2',
        'budget' => 'decimal:2',
        'budget_used' => 'decimal:2',
        'min_roi' => 'decimal:2',
        'is_active' => 'boolean',
        'auto_apply' => 'boolean',
        'auto_stop_on_loss' => 'boolean',
        'start_time' => 'datetime:H:i',
        'end_time' => 'datetime:H:i',
        'start_date' => 'date',
        'end_date' => 'date',
    ];

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }

    public function services()
    {
        if (!$this->service_ids) {
            return collect();
        }
        return Service::whereIn('id', $this->service_ids)->get();
    }
}
