<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StaffBonus extends Model
{
    protected $fillable = [
        'beauty_salon_id',
        'staff_id',
        'bonus_name',
        'bonus_type',
        'target_amount',
        'bonus_amount',
        'period_start',
        'period_end',
        'status',
        'description',
    ];

    protected $casts = [
        'target_amount' => 'decimal:2',
        'bonus_amount' => 'decimal:2',
        'period_start' => 'date',
        'period_end' => 'date',
    ];

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }

    public function staff()
    {
        return $this->belongsTo(User::class, 'staff_id');
    }
}
