<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StaffCommission extends Model
{
    use HasFactory;

    protected $fillable = [
        'beauty_salon_id',
        'staff_id',
        'commission_type',
        'commission_percentage',
        'commission_amount',
        'tiered_rules',
        'min_threshold',
        'max_threshold',
        'is_active',
    ];

    protected $casts = [
        'commission_percentage' => 'decimal:2',
        'commission_amount' => 'decimal:2',
        'min_threshold' => 'decimal:2',
        'max_threshold' => 'decimal:2',
        'tiered_rules' => 'array',
        'is_active' => 'boolean',
    ];

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }

    public function staff()
    {
        return $this->belongsTo(User::class, 'staff_id');
    }

    public function commissionHistory()
    {
        return $this->hasMany(StaffCommissionHistory::class);
    }
}
