<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StaffPerformanceMetric extends Model
{
    use HasFactory;

    protected $fillable = [
        'staff_id',
        'beauty_salon_id',
        'period_date',
        'appointments_count',
        'completed_appointments',
        'cancelled_appointments',
        'total_revenue',
        'service_revenue',
        'customer_count',
        'repeat_customers',
        'average_rating',
        'rating_count',
        'satisfaction_score',
        'on_time_percentage',
    ];

    protected $casts = [
        'period_date' => 'date',
        'total_revenue' => 'decimal:2',
        'service_revenue' => 'decimal:2',
        'average_rating' => 'decimal:2',
        'satisfaction_score' => 'decimal:2',
    ];

    public function staff()
    {
        return $this->belongsTo(User::class, 'staff_id');
    }

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }
}
