<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StaffSalary extends Model
{
    protected $fillable = [
        'staff_id',
        'beauty_salon_id',
        'base_salary',
        'commission_rate',
        'bonus_amount',
        'period_start',
        'period_end',
        'total_earnings',
        'total_commission',
        'total_bonus',
        'total_appointments',
        'total_revenue',
        'status',
        'paid_at',
        'notes',
    ];

    protected $casts = [
        'base_salary' => 'decimal:2',
        'commission_rate' => 'decimal:2',
        'bonus_amount' => 'decimal:2',
        'total_earnings' => 'decimal:2',
        'total_commission' => 'decimal:2',
        'total_bonus' => 'decimal:2',
        'total_revenue' => 'decimal:2',
        'period_start' => 'date',
        'period_end' => 'date',
        'paid_at' => 'date',
    ];

    public function staff()
    {
        return $this->belongsTo(User::class, 'staff_id');
    }

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }

    public function payments()
    {
        return $this->hasMany(StaffSalaryPayment::class, 'staff_salary_id');
    }
}

