<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StaffSalaryPayment extends Model
{
    protected $fillable = [
        'staff_salary_id',
        'staff_id',
        'beauty_salon_id',
        'amount',
        'payment_method',
        'payment_reference',
        'payment_date',
        'notes',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'payment_date' => 'date',
    ];

    public function staffSalary()
    {
        return $this->belongsTo(StaffSalary::class, 'staff_salary_id');
    }

    public function staff()
    {
        return $this->belongsTo(User::class, 'staff_id');
    }

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }
}

