<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StaffServiceTracking extends Model
{
    protected $table = 'staff_service_tracking';

    protected $fillable = [
        'reservation_id',
        'staff_id',
        'service_id',
        'beauty_salon_id',
        'service_price',
        'commission_amount',
        'service_date',
        'service_time',
        'status',
    ];

    protected $casts = [
        'service_price' => 'decimal:2',
        'commission_amount' => 'decimal:2',
        'service_date' => 'date',
    ];

    public function reservation()
    {
        return $this->belongsTo(Reservation::class);
    }

    public function staff()
    {
        return $this->belongsTo(User::class, 'staff_id');
    }

    public function service()
    {
        return $this->belongsTo(Service::class);
    }

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }
}

