<?php

namespace App\Notifications;

use App\Models\Reservation;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\DatabaseMessage;
use Illuminate\Notifications\Notification;

class AppointmentApproved extends Notification
{
    use Queueable;

    public function __construct(
        private Reservation $reservation
    ) {}

    public function via($notifiable): array
    {
        return ['database'];
    }

    public function toDatabase($notifiable): array
    {
        return [
            'type' => 'appointment_approved',
            'title' => 'Randevu Onaylandı',
            'message' => "Randevunuz onaylandı. Tarih: {$this->reservation->date->format('d.m.Y')} Saat: {$this->reservation->start_time}",
            'appointment_id' => $this->reservation->id,
            'data' => [
                'appointment_id' => $this->reservation->id,
            ],
        ];
    }
}

