<?php

namespace App\Notifications;

use App\Models\Reservation;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\DatabaseMessage;
use Illuminate\Notifications\Notification;

class AppointmentCancelled extends Notification
{
    use Queueable;

    public function __construct(
        private Reservation $reservation
    ) {}

    public function via($notifiable): array
    {
        return ['database'];
    }

    public function toDatabase($notifiable): array
    {
        return [
            'type' => 'appointment_cancelled',
            'title' => 'Randevu İptal Edildi',
            'message' => "Randevunuz iptal edildi. Tarih: {$this->reservation->date->format('d.m.Y')} Saat: {$this->reservation->start_time}",
            'appointment_id' => $this->reservation->id,
            'data' => [
                'appointment_id' => $this->reservation->id,
            ],
        ];
    }
}

