<?php

namespace App\Notifications;

use App\Models\AppointmentRequest;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;

class AppointmentRequestCreated extends Notification
{
    use Queueable;

    public function __construct(
        private AppointmentRequest $appointmentRequest
    ) {}

    public function via($notifiable): array
    {
        return ['database'];
    }

    public function toDatabase($notifiable): array
    {
        $customerName = trim($this->appointmentRequest->name . ' ' . ($this->appointmentRequest->surname ?? ''));
        $serviceName = 'Hizmet seçilmedi';
        
        if ($this->appointmentRequest->service_ids && is_array($this->appointmentRequest->service_ids) && count($this->appointmentRequest->service_ids) > 0) {
            $services = \App\Models\Service::whereIn('id', $this->appointmentRequest->service_ids)->get();
            if ($services->count() > 0) {
                $serviceName = $services->pluck('name')->join(', ');
            }
        } elseif ($this->appointmentRequest->service) {
            $serviceName = $this->appointmentRequest->service->name;
        }
        
        $dateTime = '';
        if ($this->appointmentRequest->appointment_date) {
            $dateTime = \Carbon\Carbon::parse($this->appointmentRequest->appointment_date)->format('d.m.Y');
            if ($this->appointmentRequest->appointment_time) {
                $dateTime .= ' ' . $this->appointmentRequest->appointment_time;
            }
        } else {
            $dateTime = 'Tarih belirtilmemiş';
        }
        
        return [
            'type' => 'appointment_request_created',
            'title' => 'Yeni Randevu Talebi',
            'message' => "{$customerName} adlı müşteriden yeni randevu talebi geldi. Hizmet: {$serviceName}, Tarih: {$dateTime}",
            'appointment_request_id' => $this->appointmentRequest->id,
            'data' => [
                'appointment_request_id' => $this->appointmentRequest->id,
                'customer_name' => $customerName,
                'phone' => $this->appointmentRequest->phone,
                'service_name' => $serviceName,
                'date' => $dateTime,
            ],
        ];
    }
}
