<?php

namespace App\Notifications;

use App\Models\Invoice;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\DatabaseMessage;
use Illuminate\Notifications\Notification;

class InvoiceCreated extends Notification
{
    use Queueable;

    public function __construct(
        private Invoice $invoice
    ) {}

    public function via($notifiable): array
    {
        return ['database'];
    }

    public function toDatabase($notifiable): array
    {
        return [
            'type' => 'invoice_created',
            'title' => 'Yeni Fatura',
            'message' => "Faturanız oluşturuldu. Tutar: {$this->invoice->total_amount} ₺",
            'invoice_id' => $this->invoice->id,
            'data' => [
                'invoice_id' => $this->invoice->id,
            ],
        ];
    }
}

