<?php

namespace App\Services\Payment;

use App\Models\Setting;
use Illuminate\Support\Facades\Log;

class PaymentService
{
    protected $provider;
    protected $paytrService;
    protected $iyzicoService;

    public function __construct()
    {
        $this->provider = Setting::where('key', 'payment_provider')->where('group', 'payment')->value('value') ?? config('payment.default_provider', 'paytr');
        $this->paytrService = new PayTRService();
        $this->iyzicoService = new IyzicoService();
    }

    public function createPayment($params)
    {
        if ($this->provider === 'iyzico') {
            return $this->iyzicoService->createPayment($params);
        } else {
            return $this->paytrService->createPayment($params);
        }
    }

    public function getDirectPaymentFormData($params)
    {
        if ($this->provider === 'paytr') {
            return $this->paytrService->getDirectPaymentFormData($params);
        }
        return ['success' => false, 'message' => 'Direkt ödeme sadece PayTR ile desteklenir.'];
    }

    public function verifyCallback($post)
    {
        if ($this->provider === 'iyzico') {
            return $this->iyzicoService->verifyCallback($post);
        } else {
            return $this->paytrService->verifyCallback($post);
        }
    }

    public function getProvider()
    {
        return $this->provider;
    }
}

