<?php

if (!function_exists('formatPrice')) {
    
    function formatPrice($price) {
        return number_format($price, 2, ',', '.') . ' ₺';
    }
}

if (!function_exists('formatDate')) {
    
    function formatDate($date, $format = 'd.m.Y') {
        if (!$date) return '';
        return \Carbon\Carbon::parse($date)->format($format);
    }
}

if (!function_exists('formatDateTime')) {
    
    function formatDateTime($dateTime, $format = 'd.m.Y H:i') {
        if (!$dateTime) return '';
        return \Carbon\Carbon::parse($dateTime)->format($format);
    }
}

if (!function_exists('truncate')) {
    
    function truncate($text, $length = 100, $suffix = '...') {
        if (mb_strlen($text) <= $length) {
            return $text;
        }
        return mb_substr($text, 0, $length) . $suffix;
    }
}

if (!function_exists('get_logo_url')) {
    
    function get_logo_url($preferBlue = false) {
        try {
            
            $logoSetting = \App\Models\Setting::where('key', 'logo')->first();
            if ($logoSetting && $logoSetting->value) {
                
                if (str_starts_with($logoSetting->value, 'storage/') || str_starts_with($logoSetting->value, 'public/')) {
                    return asset('storage/' . ltrim($logoSetting->value, 'public/'));
                }
                
                if (filter_var($logoSetting->value, FILTER_VALIDATE_URL)) {
                    return $logoSetting->value;
                }
                
                return asset($logoSetting->value);
            }

            $logoPath = $preferBlue ? 'images/logo-blue.png' : 'images/logo.png';
            $fullPath = public_path($logoPath);

            if (file_exists($fullPath)) {
                return asset($logoPath);
            }

            if ($preferBlue) {
                $normalLogoPath = public_path('images/logo.png');
                if (file_exists($normalLogoPath)) {
                    return asset('images/logo.png');
                }
            }

            return null;
        } catch (\Exception $e) {
            
            $logoPath = $preferBlue ? 'images/logo-blue.png' : 'images/logo.png';
            $fullPath = public_path($logoPath);
            
            if (file_exists($fullPath)) {
                return asset($logoPath);
            }
            
            return null;
        }
    }
}

