# Admin Panel Geri Yükleme Kılavuzu

Admin paneli yedeği alındı ve silindi.

## Yedek Konumu
Yedek dosyalar şu klasörde saklanmaktadır:
- `backup/admin_panel_backup_YYYYMMDD_HHMMSS/`

## Geri Yükleme Adımları

### 1. Dosyaları Geri Yükle
```bash
cd /Applications/XAMPP/xamppfiles/htdocs/adugun

# Yedek klasörünü bul
BACKUP_DIR=$(ls -td backup/admin_panel_backup_* | head -1)

# Views klasörünü geri yükle
cp -r $BACKUP_DIR/admin resources/views/

# Layout dosyasını geri yükle
cp $BACKUP_DIR/admin.blade.php resources/views/layouts/

# Controllers klasörünü geri yükle
cp -r $BACKUP_DIR/Admin app/Http/Controllers/

# Routes dosyasını geri yükle (manuel olarak web.php'ye eklemelisiniz)
# $BACKUP_DIR/web_admin_routes.php dosyasındaki admin route'larını
# routes/web.php dosyasına ekleyin
```

### 2. Route'ları Geri Ekle
`backup/admin_panel_backup_*/web_admin_routes.php` dosyasını açın ve içindeki admin route'larını `routes/web.php` dosyasına ekleyin.

### 3. Cache Temizle
```bash
php artisan route:clear
php artisan config:clear
php artisan cache:clear
php artisan view:clear
```

## Notlar
- Admin panel dosyaları tamamen yedeklendi
- API route'ları korundu (sadece admin panel route'ları silindi)
- SuperAdmin route'ları korundu


