@php
    // Sözleşmeler ve Faturalar sayfalarında sidebar kapalı kalsın
    $excludedFromSidebar = request()->routeIs('admin.settings.contracts.*') || request()->routeIs('admin.settings.invoices.*');
    $isSettingsPage = request()->routeIs('admin.settings.*') && !$excludedFromSidebar;
@endphp
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Adugun')</title>
    <link rel="icon" type="image/x-icon" href="{{ url('favicon.ico') }}">
    <link rel="shortcut icon" href="{{ url('favicon.ico') }}">
    <link rel="apple-touch-icon" href="{{ url('favicon.ico') }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap');
        
        /* Özel Onay Kutusu - Modal'lardan yüksek */
        #customConfirmBox {
            z-index: 999999 !important;
        }
        
        #customConfirmBackdrop {
            z-index: 999998 !important;
        }
        @font-face {
            font-family: 'LogoFont';
            src: url('{{ url("fonts/font.ttf") }}') format('truetype'),
                 url('{{ asset("fonts/font.ttf") }}') format('truetype'),
                 url('/fonts/font.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
            font-display: swap;
        }
        
        .header-logo {
            height: 40px;
            width: auto;
            filter: brightness(0) invert(1);
        }
        
        .logo-image {
            height: 40px;
            width: auto;
            object-fit: contain;
            filter: brightness(0) invert(1);
        }
        
        .logo-text {
            font-family: 'LogoFont', 'Inter', sans-serif;
            font-weight: normal;
            font-size: 32px;
            letter-spacing: 2px;
            color: white;
            user-select: none;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
        }
        :root {
            --primary-color: #2563eb;
            --secondary-color: #1e40af;
            --bg-color: #eff6ff;
            --text-primary: #1e293b;
            --text-secondary: #64748b;
            --header-top-height: 58px;
            --header-bottom-height: 50px;
            --header-height: calc(var(--header-top-height) + var(--header-bottom-height));
            --navbar-height: 0px; /* Beyaz navbar kaldırıldı */
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: var(--bg-color);
            color: var(--text-primary);
            padding-top: var(--header-height); /* Sadece header yüksekliği */
        }

        /* Top Header - İki Katmanlı Tasarım */
        .top-header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: var(--header-height);
            background: transparent;
            border-bottom: none;
            z-index: 10000;
            display: flex;
            flex-direction: column;
        }
        
        /* Header içindeki dropdown'lar header'ın üstünde görünmeli */
        .top-header .dropdown-menu.show,
        .top-header .search-results.show {
            z-index: 999999 !important;
        }
        
        /* Üst Katman - Premium Mavi Tema */
        .header-top {
            height: var(--header-top-height);
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 28px;
            background: linear-gradient(135deg, #1e40af 0%, #2563eb 50%, #3b82f6 100%);
            border-bottom: 1px solid rgba(255, 255, 255, 0.15);
            box-shadow: 0 2px 12px rgba(30, 64, 175, 0.2);
        }
        
        /* Alt Katman - Beyaz Tema */
        .header-bottom {
            height: var(--header-bottom-height);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 0 28px;
            background: #ffffff;
            border-bottom: 1px solid #e5e7eb;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        }
        
        .header-menu {
            display: flex;
            align-items: center;
            gap: 4px;
            flex: 1;
            justify-content: center;
            overflow-x: auto;
            overflow-y: hidden;
            scrollbar-width: none;
            -ms-overflow-style: none;
            height: 100%;
        }
        
        .header-menu::-webkit-scrollbar {
            display: none;
        }

        .top-header .header-left {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .header-top .header-left .logo-text,
        .header-top .logo-text {
            margin: 0;
            font-family: 'LogoFont', 'Inter', sans-serif !important;
            font-size: 28px;
            font-weight: normal;
            color: #ffffff;
            font-family: 'Think Smart', 'Inter', sans-serif;
            letter-spacing: 1px;
            user-select: none;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            text-shadow: 0 2px 8px rgba(0, 0, 0, 0.3);
            position: relative;
            z-index: 1;
        }

        .header-top .header-right {
            display: flex;
            align-items: center;
            gap: 12px;
            position: relative;
            z-index: 100;
        }
        
        /* SMS Al butonu - icon ile text arası mesafe */
        .sms-buy-btn {
            gap: 10px !important;
        }
        
        .sms-buy-btn i {
            margin-right: 0 !important;
        }
        
        .sms-buy-btn span {
            margin-left: 0 !important;
        }
        
        .header-top .header-right .dropdown {
            position: static !important;
        }
        
        .header-top .header-right .user-menu {
            position: static !important;
        }
        
        /* Bootstrap dropdown'ları için z-index düzeltmesi */
        .header-top .header-right .dropdown-menu {
            z-index: 999999 !important;
            position: fixed !important;
            margin-top: 8px !important;
        }
        
        .header-top .header-right .dropdown.show .dropdown-menu {
            z-index: 999999 !important;
        }
        
        /* User dropdown için de aynı - En üstte olmalı */
        .header-top .header-right .user-dropdown {
            z-index: 999999 !important;
            margin-top: 8px !important;
        }
        
        /* Bugünkü rezervasyonlar dropdown özel stil */
        #todayReservationsMenu {
            z-index: 999999 !important;
            position: fixed !important;
            background: white !important;
        }
        
        #todayReservationsMenu li {
            position: relative;
            z-index: 1;
        }

        .header-top .header-center {
            flex: 1;
            max-width: 500px;
            margin: 0 24px;
            position: relative;
            z-index: 100;
        }
        
        .header-top .header-center .search-container {
            position: relative;
            z-index: 100;
        }

        .search-container {
            position: relative;
        }

        .search-input {
            width: 100%;
            padding: 10px 45px 10px 16px;
            border: 1px solid rgba(255, 255, 255, 0.3);
            border-radius: 10px;
            background: rgba(255, 255, 255, 0.15);
            color: white;
            font-size: 14px;
            transition: all 0.3s;
            backdrop-filter: blur(10px);
        }
        
        .search-input::placeholder {
            color: rgba(255, 255, 255, 0.9);
        }

        .search-input:focus {
            outline: none;
            border-color: rgba(255, 255, 255, 0.5);
            background: rgba(255, 255, 255, 0.25);
            box-shadow: 0 0 0 3px rgba(255, 255, 255, 0.1);
            transform: translateY(-1px);
        }
        
        .search-icon {
            color: rgba(255, 255, 255, 0.8) !important;
        }
        
        .search-input:focus + .search-icon {
            color: white !important;
        }

        .search-icon {
            position: absolute;
            right: 18px;
            top: 50%;
            transform: translateY(-50%);
            color: rgba(255, 255, 255, 0.8);
            pointer-events: none;
            transition: all 0.3s ease;
            font-size: 18px;
        }
        
        .search-input:focus + .search-icon {
            color: #ffffff;
            transform: translateY(-50%) scale(1.1);
        }

        .search-results {
            position: absolute;
            top: calc(100% + 10px);
            left: 0;
            right: 0;
            background: white;
            border-radius: 12px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.25);
            max-height: 500px;
            overflow-y: auto;
            z-index: 999999 !important; /* Arama sonuçları en üstte */
            display: none;
            border: 1px solid #e5e7eb;
        }

        .search-results.show {
            display: block;
        }

        .search-result-item {
            padding: 12px 20px;
            border-bottom: 1px solid #f1f5f9;
            cursor: pointer;
            transition: all 0.2s;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .search-result-item:hover {
            background: #f8faff;
        }

        .search-result-item:last-child {
            border-bottom: none;
        }

        .search-result-icon {
            width: 36px;
            height: 36px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #eff6ff;
            color: #2563eb;
            font-size: 18px;
        }

        .search-result-content {
            flex: 1;
        }

        .search-result-title {
            font-weight: 600;
            color: #1e293b;
            font-size: 14px;
            margin-bottom: 2px;
        }

        .search-result-subtitle {
            font-size: 12px;
            color: #64748b;
        }

        .search-result-type {
            font-size: 11px;
            color: #64748b;
            background: #f1f5f9;
            padding: 2px 8px;
            border-radius: 4px;
        }

        .search-section-title {
            padding: 10px 20px;
            background: #f8fafc;
            font-weight: 600;
            font-size: 12px;
            color: #64748b;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .header-top .shortcuts-container {
            display: flex;
            align-items: center;
            gap: 8px;
            margin-right: 12px;
        }

        .shortcut-item {
            width: 42px;
            height: 42px;
            border-radius: 12px;
            background: rgba(255, 255, 255, 0.15);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            text-decoration: none;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(10px);
            position: relative;
            overflow: hidden;
        }
        
        .shortcut-item::before {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, rgba(255,255,255,0.2) 0%, transparent 100%);
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .shortcut-item i {
            position: relative;
            z-index: 1;
            transition: all 0.3s ease;
            color: white;
            font-size: 18px;
        }

        .shortcut-item:hover {
            background: rgba(255, 255, 255, 0.25);
            border-color: rgba(255, 255, 255, 0.35);
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
        }
        
        .shortcut-item:hover::before {
            opacity: 1;
        }
        
        .shortcut-item:hover i {
            color: white;
            transform: scale(1.15);
        }

        .top-header .btn,
        .header-top .btn {
            background: rgba(255, 255, 255, 0.15);
            border: 1px solid rgba(255, 255, 255, 0.2);
            color: white;
            padding: 10px 18px;
            border-radius: 10px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            font-weight: 500;
            font-size: 14px;
            backdrop-filter: blur(10px);
            position: relative;
            overflow: hidden;
        }
        
        .top-header .btn::before,
        .header-top .btn::before {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, rgba(255,255,255,0.2) 0%, transparent 100%);
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .top-header .btn:hover,
        .header-top .btn:hover {
            background: rgba(255, 255, 255, 0.25);
            border-color: rgba(255, 255, 255, 0.35);
            transform: translateY(-1px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
        }
        
        .top-header .btn:hover::before,
        .header-top .btn:hover::before {
            opacity: 1;
        }
        
        .header-top .btn i,
        .header-top .btn span {
            position: relative;
            z-index: 1;
            transition: all 0.3s ease;
            color: white;
        }

        .header-top .btn:hover {
            border-color: #3b82f6;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.15);
            background: #eff6ff;
        }
        
        .header-top .btn:hover i,
        .header-top .btn:hover span {
            color: #1d4ed8;
        }

        /* Main Navbar - KALDIRILDI, menü header içine entegre edildi */
        .main-navbar {
            display: none !important;
        }
        
        /* Header Menu - Mavi Tema */
        .header-menu {
            display: flex;
            align-items: center;
            gap: 4px;
            flex: 1;
            justify-content: center;
            overflow-x: auto;
            overflow-y: hidden;
            scrollbar-width: none;
            -ms-overflow-style: none;
            height: 100%;
        }
        
        .header-menu::-webkit-scrollbar {
            display: none;
        }
        
        .header-menu-item {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 8px 18px;
            color: #64748b;
            text-decoration: none;
            font-weight: 500;
            font-size: 14px;
            white-space: nowrap;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border-radius: 8px;
            background: transparent;
            position: relative;
            height: calc(100% - 8px);
            margin: 4px 2px;
        }
        
        .header-menu-item::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: #f1f5f9;
            opacity: 0;
            transition: opacity 0.3s ease;
            border-radius: 8px;
        }
        
        .header-menu-item i {
            font-size: 16px;
            position: relative;
            z-index: 1;
            transition: all 0.3s ease;
            color: #64748b;
        }
        
        .header-menu-item span {
            position: relative;
            z-index: 1;
            transition: all 0.3s ease;
            color: #64748b;
        }
        
        .header-menu-item:hover {
            color: #2563eb;
        }
        
        .header-menu-item:hover::before {
            opacity: 1;
        }
        
        .header-menu-item:hover i {
            transform: scale(1.1);
            color: #2563eb;
        }
        
        .header-menu-item:hover span {
            color: #2563eb;
        }
        
        .header-menu-item.active {
            background: rgba(37, 99, 235, 0.12);
            color: #2563eb;
            font-weight: 600;
            box-shadow: 0 2px 8px rgba(37, 99, 235, 0.1);
        }
        
        .header-menu-item.active::before {
            background: rgba(37, 99, 235, 0.08);
            opacity: 1;
        }
        
        .header-menu-item.active i {
            color: #2563eb;
            transform: scale(1.1);
        }
        
        .header-menu-item.active span {
            color: #2563eb;
        }
        
        .header-menu-item.active::after {
            content: '';
            position: absolute;
            bottom: -4px;
            left: 50%;
            transform: translateX(-50%);
            width: 70%;
            height: 3px;
            background: rgba(37, 99, 235, 0.4);
            border-radius: 2px 2px 0 0;
        }
        
        @media (max-width: 1200px) and (min-width: 769px) {
            .header-menu-item span {
                display: none;
            }
            .header-menu-item {
                padding: 8px 12px;
                min-width: 40px;
                justify-content: center;
            }
        }
        
        /* Mobile Menu Toggle Button */
        .mobile-menu-toggle {
            display: flex;
            background: rgba(255, 255, 255, 0.2);
            border: none;
            border-radius: 8px;
            width: 40px;
            height: 40px;
            padding: 0;
            cursor: pointer;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
            backdrop-filter: blur(10px);
            margin-right: 12px;
        }
        
        @media (min-width: 769px) {
            .mobile-menu-toggle {
                display: none !important;
            }
        }
        
        .mobile-menu-toggle:hover {
            background: rgba(255, 255, 255, 0.3);
            transform: scale(1.05);
        }
        
        .mobile-menu-toggle i {
            font-size: 22px;
            color: white;
            transition: transform 0.3s ease;
        }
        
        .mobile-menu-toggle.active i {
            transform: rotate(90deg);
        }
        
        /* Mobile Menu Overlay */
        .mobile-menu-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 9998;
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .mobile-menu-overlay.active {
            display: block;
            opacity: 1;
        }
        
        /* Mobile Menu Sidebar */
        .mobile-menu-sidebar {
            position: fixed;
            top: var(--header-top-height);
            left: -100%;
            width: 85%;
            max-width: 320px;
            height: calc(100vh - var(--header-top-height));
            background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
            box-shadow: 4px 0 24px rgba(0, 0, 0, 0.15);
            z-index: 9999;
            transition: left 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            overflow-y: auto;
            overflow-x: hidden;
        }
        
        .mobile-menu-sidebar.active {
            left: 0;
        }
        
        .mobile-menu-header {
            display: none; /* Mavi header bölümünü gizle */
        }
        
        
        .mobile-menu-content {
            padding: 20px 0;
            padding-bottom: 30px;
        }
        
        .mobile-menu-section {
            padding: 0 0 12px 0;
            border-bottom: 1px solid #e5e7eb;
            margin-bottom: 16px;
        }
        
        .mobile-menu-section:last-child {
            border-bottom: none;
            margin-bottom: 0;
        }
        
        .mobile-menu-section-title {
            padding: 12px 20px 8px;
            font-size: 11px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: #64748b;
            margin-bottom: 4px;
        }
        
        .mobile-menu-item {
            display: flex;
            align-items: center;
            padding: 14px 20px;
            color: #1e293b;
            text-decoration: none;
            transition: all 0.2s ease;
            border-left: 3px solid transparent;
        }
        
        .mobile-menu-item:hover,
        .mobile-menu-item.active {
            background: linear-gradient(90deg, rgba(37, 99, 235, 0.08) 0%, rgba(37, 99, 235, 0.04) 100%);
            color: #2563eb;
            border-left-color: #2563eb;
        }
        
        .mobile-menu-item i {
            font-size: 20px;
            width: 28px;
            margin-right: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .mobile-menu-item span {
            font-size: 15px;
            font-weight: 500;
        }
        
        @media (max-width: 768px) {
            :root {
                --header-top-height: 56px;
                --header-bottom-height: 0px;
            }
            
            body {
                padding-top: 56px !important;
            }
            
            .top-header {
                height: 56px;
            }
            
            .header-top {
                padding: 8px 12px;
                display: flex;
                align-items: center;
                justify-content: space-between;
                gap: 8px;
                height: 56px;
                flex-wrap: nowrap;
            }
            
            .header-top .header-left {
                flex: 0 0 auto;
                display: flex;
                align-items: center;
                gap: 12px;
            }
            
            .mobile-menu-toggle {
                display: flex !important;
            }
            
            .header-top .header-left .logo-text {
                font-size: 20px !important;
                letter-spacing: 0.5px;
            }
            
            .header-top .header-center {
                display: none !important;
            }
            
            .header-top .header-right {
                flex: 0 0 auto;
                display: flex;
                align-items: center;
                gap: 6px;
                flex-wrap: nowrap;
            }
            
            .header-top .header-right > * {
                flex-shrink: 0;
            }
            
            .header-top .header-right .btn {
                padding: 8px;
                font-size: 0;
                min-width: 40px;
                height: 40px;
                display: flex;
                align-items: center;
                justify-content: center;
                border-radius: 10px;
            }
            
            .header-top .header-right .btn i {
                font-size: 18px;
                margin: 0;
            }
            
            .header-top .header-right .btn span {
                display: none !important;
            }
            
            .header-top .header-right .shortcuts-container {
                display: none !important;
            }
            
            .mobile-menu-toggle {
                display: flex !important;
            }
            
            .header-top .header-right .sms-balance-bar {
                display: none !important;
            }
            
            .header-top .header-right .dropdown button {
                padding: 8px !important;
                font-size: 0 !important;
                min-width: 40px;
                height: 40px;
                border-radius: 10px;
            }
            
            .header-top .header-right .dropdown button i {
                font-size: 18px;
                margin: 0;
            }
            
            .header-top .header-right .dropdown button span {
                display: none !important;
            }
            
            .header-top .header-right .user-menu {
                order: 0;
            }
            
            .header-top .header-right .user-avatar {
                width: 40px;
                height: 40px;
            }
            
            .header-top .header-right .user-avatar i {
                font-size: 24px !important;
            }
            
            /* Dropdown menüler mobilde düzgün görünsün */
            .header-top .header-right .dropdown-menu {
                position: fixed !important;
                left: 12px !important;
                right: 12px !important;
                width: auto !important;
                max-width: calc(100% - 24px) !important;
                margin-top: 8px !important;
                transform: none !important;
                border-radius: 16px !important;
                box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2) !important;
            }
            
            .header-top .header-right #todayReservationsMenu {
                min-width: auto !important;
                width: auto !important;
                max-width: calc(100% - 24px) !important;
            }
            
            .header-bottom {
                display: none !important;
            }
            
            .header-menu {
                display: none;
            }
        }

        /* Navbar Dropdown - Professional Version */
        .nav-dropdown {
            position: relative;
            display: inline-block;
        }

        .nav-dropdown > .top-menu-item {
            cursor: pointer;
            user-select: none;
        }

        .nav-dropdown > .top-menu-item::after {
            content: '';
            display: inline-block;
            margin-left: 6px;
            width: 0;
            height: 0;
            border-left: 4px solid transparent;
            border-right: 4px solid transparent;
            border-top: 5px solid currentColor;
            vertical-align: middle;
            transition: transform 0.2s ease;
        }

        .nav-dropdown.is-active > .top-menu-item {
            color: #2563eb;
            background: #f8faff;
        }

        .nav-dropdown.is-active > .top-menu-item::after {
            transform: rotate(180deg);
        }

        .nav-dropdown-menu {
            position: absolute;
            top: calc(100% + 8px);
            left: 0;
            background: #ffffff;
            min-width: 260px;
            border-radius: 10px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.12), 0 8px 32px rgba(0, 0, 0, 0.08);
            border: 1px solid #e2e8f0;
            padding: 8px 0;
            margin: 0;
            list-style: none;
            z-index: 10050;
            display: none;
            max-height: calc(100vh - 150px);
            overflow-y: auto;
            overflow-x: hidden;
        }

        .nav-dropdown-menu.is-visible {
            display: block;
            animation: dropdownFadeIn 0.15s ease-out;
        }

        @keyframes dropdownFadeIn {
            from {
                opacity: 0;
                transform: translateY(-8px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .nav-dropdown-item {
            display: block;
            padding: 11px 20px;
            color: #334155;
            text-decoration: none;
            transition: all 0.15s ease;
            white-space: nowrap;
            font-size: 14px;
            line-height: 1.5;
        }

        .nav-dropdown-item:hover,
        .nav-dropdown-item:focus {
            background: #f1f5f9;
            color: #2563eb;
            text-decoration: none;
        }

        .nav-dropdown-item i {
            width: 20px;
            text-align: left;
            margin-right: 12px;
            font-size: 16px;
            vertical-align: middle;
        }

        /* User Menu */
        .user-menu {
            position: relative;
            z-index: 10000000 !important;
            width: fit-content;
            display: inline-block;
        }

        /* Hover ile açılmayı kaldır - sadece JS ile kontrol edilecek */
        .user-dropdown {
            display: none !important;
        }
        
        .user-dropdown.show {
            display: block !important;
        }

        .user-avatar {
            width: 42px;
            height: 42px;
            background: rgba(255, 255, 255, 0.15);
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            backdrop-filter: blur(10px);
            position: relative;
            overflow: hidden;
        }
        
        .user-avatar::before {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, rgba(255,255,255,0.3) 0%, transparent 100%);
            opacity: 0;
            transition: opacity 0.3s ease;
            border-radius: 50%;
        }
        
        .user-avatar i {
            position: relative;
            z-index: 1;
            transition: all 0.3s ease;
            color: white !important;
            font-size: 26px !important;
        }

        .user-avatar:hover {
            background: rgba(255, 255, 255, 0.25);
            border-color: rgba(255, 255, 255, 0.5);
            transform: scale(1.08);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
        }
        
        .user-avatar:hover::before {
            opacity: 1;
        }
        
        .user-avatar:hover i {
            color: white !important;
            transform: scale(1.1);
        }

        .user-dropdown {
            position: fixed !important;
            background: white;
            border-radius: 12px;
            box-shadow: 0 8px 30px rgba(0,0,0,0.15);
            min-width: 280px;
            display: none;
            z-index: 100004 !important;
            overflow: hidden;
            pointer-events: auto;
            margin-top: 8px !important;
            border: 1px solid #e5e7eb;
        }

        /* User dropdown artık sadece JS ile kontrol ediliyor - CSS hover kaldırıldı */

        /* Settings Sidebar */
        .settings-sidebar {
            position: fixed;
            top: var(--header-height);
            left: 0;
            width: 280px;
            height: calc(100vh - var(--header-height));
            background: linear-gradient(180deg, #ffffff 0%, #f8faff 100%);
            box-shadow: 4px 0 20px rgba(0,0,0,0.08);
            z-index: 10080;
            transform: translateX(-100%);
            transition: transform 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            overflow-y: auto;
            overflow-x: hidden;
            padding: 0;
            border-right: 1px solid #e5e7eb;
        }
        
        /* Mobilde settings sidebar'ı gizle - mobil menüden daha düşük z-index */
        @media (max-width: 768px) {
            .settings-sidebar {
                z-index: 9990 !important; /* Mobil menüden (9999) daha düşük */
                display: none !important; /* Mobilde tamamen gizle */
            }
            
            body.settings-page .main-content {
                margin-left: 0 !important;
            }
        }
        
        .settings-sidebar::-webkit-scrollbar {
            width: 6px;
        }
        
        .settings-sidebar::-webkit-scrollbar-track {
            background: #f1f5f9;
        }
        
        .settings-sidebar::-webkit-scrollbar-thumb {
            background: #cbd5e1;
            border-radius: 3px;
        }
        
        .settings-sidebar::-webkit-scrollbar-thumb:hover {
            background: #94a3b8;
        }

        .settings-sidebar.active {
            transform: translateX(0);
        }
        
        /* Ayarlar sayfasında sidebar otomatik açık olsun */
        body.settings-page .settings-sidebar {
            transform: translateX(0) !important;
        }
        
        body.settings-page .settings-overlay {
            display: none !important;
        }
        
        /* Ayarlar sayfasında main content'e margin ekle */
        body.settings-page .main-content {
            margin-left: 280px;
            transition: margin-left 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .settings-sidebar-header {
            padding: 25px 20px;
            border-bottom: 2px solid #e5e7eb;
            margin-bottom: 15px;
            background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
            color: white;
            position: sticky;
            top: 0;
            z-index: 10;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        
        .settings-sidebar-header h5 {
            color: white;
            font-size: 18px;
            font-weight: 700;
            margin: 0;
        }

        .settings-sidebar-item {
            display: flex;
            align-items: center;
            padding: 14px 20px;
            color: #475569;
            text-decoration: none;
            transition: all 0.2s ease;
            border-left: 4px solid transparent;
            font-weight: 500;
            font-size: 14px;
            margin: 2px 10px;
            border-radius: 8px;
        }
        
        .settings-sidebar-item:hover {
            background: linear-gradient(90deg, rgba(37, 99, 235, 0.08) 0%, rgba(37, 99, 235, 0.04) 100%);
            color: #2563eb;
            border-left-color: #2563eb;
            transform: translateX(4px);
        }

        .settings-sidebar-item.active {
            background: linear-gradient(90deg, rgba(37, 99, 235, 0.12) 0%, rgba(37, 99, 235, 0.06) 100%);
            color: #2563eb;
            border-left-color: #2563eb;
            font-weight: 600;
            box-shadow: 0 2px 8px rgba(37, 99, 235, 0.1);
        }

        .settings-sidebar-item i {
            width: 22px;
            margin-right: 12px;
            font-size: 18px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .settings-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.5);
            z-index: 10070;
            display: none;
            transition: opacity 0.3s ease;
        }

        .settings-overlay.active {
            display: block;
        }

        /* Main Content */
        .main-content {
            min-height: calc(100vh - var(--header-height));
            padding: 30px;
            margin-left: 0;
            transition: margin-left 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        /* Ayarlar sayfasında main content'e margin ekle */
        body.settings-page .main-content {
            margin-left: 280px;
        }

        .content-wrapper {
            max-width: 100%;
        }

        /* Cards */
        .card {
            border: 1px solid #e5e7eb;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            margin-bottom: 25px;
            border-radius: 12px;
            overflow: hidden;
            background: white;
        }

        .card-header {
            background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
            border-bottom: 1px solid #e5e7eb;
            font-weight: 600;
            padding: 20px;
            font-size: 18px;
            color: #1e293b;
        }

        .card-body {
            padding: 25px;
        }

        /* Buttons */
        .btn {
            border-radius: 8px;
            font-weight: 500;
            padding: 10px 20px;
            transition: all 0.2s;
        }

        .btn-primary {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            border: none;
            color: white;
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
        }

        /* Tables */
        .table {
            border-radius: 8px;
            overflow: hidden;
        }

        .table thead {
            background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        }

        .table thead th {
            border: none;
            font-weight: 600;
            color: #1e40af;
            padding: 15px;
        }

        .table tbody tr:hover {
            background-color: #f8fafc;
        }

        /* Forms */
        .form-control, .form-select {
            border-radius: 8px;
            border: 1px solid #e2e8f0;
            padding: 10px 15px;
        }

        .form-control:focus, .form-select:focus {
            border-color: #60a5fa;
            box-shadow: 0 0 0 3px rgba(96, 165, 250, 0.2);
        }

        /* Alerts */
        .alert {
            border-radius: 10px;
            border: none;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }

        .alert-success {
            background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
            border-left: 4px solid #10b981;
            color: #065f46;
        }

        .alert-danger {
            background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
            border-left: 4px solid #ef4444;
            color: #991b1b;
        }

        /* Modal z-index düzeltmesi - header'ın üstünde olmalı */
        .modal {
            z-index: 100000 !important;
        }
        
        /* Modal backdrop - customConfirmBox'tan düşük olmalı */
        .modal-backdrop {
            z-index: 10040 !important;
        }
        
        .modal-backdrop.show {
            z-index: 10040 !important;
        }
        
        /* Standart Bootstrap modal */
        .modal {
            z-index: 10050 !important;
        }
        
        /* Rezervasyon detay modal */
        #reservationDetailModal {
            z-index: 10050 !important;
        }
        
        #reservationDetailModal .modal-content {
            z-index: 10051 !important;
        }
        
        /* Responsive */
        @media (max-width: 1200px) {
            .header-top .header-center {
                max-width: 300px;
                margin: 0 15px;
            }

            .shortcuts-container {
                gap: 4px;
                overflow-x: auto;
                overflow-y: hidden;
                scrollbar-width: none;
                -ms-overflow-style: none;
                max-width: 250px;
            }
            
            .shortcuts-container::-webkit-scrollbar {
                display: none;
            }
            
            .shortcut-item {
                width: 36px;
                height: 36px;
                flex-shrink: 0;
            }
            
            .shortcut-item i {
                font-size: 16px;
            }
        }

        @media (max-width: 768px) {
            body {
                padding-top: 0 !important;
            }
            
            .top-header {
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                z-index: 10000;
            }
            
            .main-content {
                padding: 10px !important;
                margin: 0 !important;
                margin-top: calc(var(--header-top-height) + var(--header-bottom-height)) !important;
            }
            
            .container-fluid {
                padding-left: 10px !important;
                padding-right: 10px !important;
            }
            
            /* Dashboard specific responsive */
            .dashboard-header {
                padding: 15px !important;
            }
            
            .dashboard-title {
                font-size: 20px !important;
            }
            
            .metric-card {
                margin-bottom: 10px !important;
            }
            
            .metric-value {
                font-size: 18px !important;
            }
            
            .secondary-metric-card {
                padding: 15px !important;
            }
            
            .quick-access-card-compact {
                padding: 10px 6px !important;
            }
            
            .quick-access-icon-compact {
                width: 32px !important;
                height: 32px !important;
                font-size: 14px !important;
            }
            
            .quick-access-label-compact {
                font-size: 10px !important;
            }
            
            .dashboard-card {
                margin-bottom: 15px !important;
            }
            
            .card-body-modern {
                padding: 15px !important;
            }
            
            .chart-container {
                height: 250px !important;
            }
            
            .chart-container-small {
                height: 180px !important;
            }

            .top-menu-item {
                padding: 0 8px;
                font-size: 12px;
                gap: 4px;
            }
            
            .top-menu-item i {
                font-size: 14px;
                width: 16px;
            }
            
            .top-menu-item span {
                display: none;
            }
            
            .top-menu-nav {
                padding: 0 5px;
                gap: 2px;
            }
            
            /* Cards */
            .card {
                margin-bottom: 10px !important;
                border-radius: 12px !important;
            }
            
            .card-header {
                padding: 12px 15px !important;
            }
            
            .card-body {
                padding: 12px 15px !important;
            }
            
            /* Tables - Horizontal Scroll */
            .table-responsive {
                margin: 0 -10px;
                padding: 0 10px;
            }
            
            .table {
                font-size: 12px !important;
                min-width: 600px;
            }
            
            .table th, .table td {
                padding: 8px 10px !important;
                white-space: nowrap;
            }
            
            /* Buttons */
            .btn {
                padding: 6px 12px !important;
                font-size: 12px !important;
            }
            
            .btn-sm {
                padding: 4px 8px !important;
                font-size: 11px !important;
            }
            
            .btn-lg {
                padding: 10px 16px !important;
                font-size: 14px !important;
            }
            
            /* Forms */
            .form-control, .form-select {
                font-size: 14px !important;
                padding: 8px 12px !important;
            }
            
            .form-label {
                font-size: 13px !important;
                margin-bottom: 4px !important;
            }
            
            /* Modals */
            .modal-dialog {
                margin: 10px !important;
                max-width: calc(100% - 20px) !important;
            }
            
            .modal-xl, .modal-lg {
                max-width: calc(100% - 20px) !important;
            }
            
            .modal-content {
                border-radius: 16px !important;
            }
            
            .modal-header {
                padding: 12px 15px !important;
            }
            
            .modal-body {
                padding: 15px !important;
            }
            
            .modal-footer {
                padding: 12px 15px !important;
                flex-wrap: wrap;
                gap: 8px;
            }
            
            .modal-footer .btn {
                flex: 1;
                min-width: 100px;
            }
            
            /* Page Titles */
            h1, .h1 { font-size: 1.5rem !important; }
            h2, .h2 { font-size: 1.3rem !important; }
            h3, .h3 { font-size: 1.15rem !important; }
            h4, .h4 { font-size: 1rem !important; }
            h5, .h5 { font-size: 0.9rem !important; }
            
            /* Alerts */
            .alert {
                padding: 10px 12px !important;
                font-size: 13px !important;
            }
            
            /* Badges */
            .badge {
                font-size: 10px !important;
                padding: 4px 8px !important;
            }
            
            /* Pagination */
            .pagination {
                flex-wrap: wrap;
                justify-content: center;
                gap: 4px;
            }
            
            .page-link {
                padding: 6px 10px !important;
                font-size: 12px !important;
            }
            
            /* Stat Cards */
            .stat-card, .info-box {
                padding: 15px !important;
                margin-bottom: 10px !important;
            }
            
            .stat-value {
                font-size: 1.5rem !important;
            }
            
            /* Row & Columns */
            .row {
                margin-left: -5px !important;
                margin-right: -5px !important;
            }
            
            .row > * {
                padding-left: 5px !important;
                padding-right: 5px !important;
            }
            
            /* Dropdown */
            .dropdown-menu {
                font-size: 13px !important;
            }
            
            .dropdown-item {
                padding: 8px 12px !important;
            }
        }
        
        /* Small Mobile */
        @media (max-width: 480px) {
            body {
                padding-top: 50px !important;
            }
            
            .main-content {
                padding: 8px !important;
            }
            
            .header-top .logo-text {
                font-family: 'LogoFont', 'Inter', sans-serif !important;
                font-size: 18px !important;
            }
            
            .header-top {
                padding: 6px 8px !important;
                min-height: 45px;
            }
            
            .header-top .header-left .logo-text {
                font-size: 16px !important;
            }
            
            .header-top .header-center {
                order: 3;
                width: 100%;
                margin: 4px 0 0 0;
                padding: 0;
            }
            
            .header-top .header-center .search-input {
                font-size: 12px;
                padding: 6px 30px 6px 10px;
            }
            
            .header-top .header-right {
                flex-wrap: nowrap;
                gap: 3px;
                overflow-x: auto;
                overflow-y: hidden;
                -webkit-overflow-scrolling: touch;
                scrollbar-width: none;
            }
            
            .header-top .header-right::-webkit-scrollbar {
                display: none;
            }
            
            .header-top .header-right .btn {
                padding: 4px 6px;
                font-size: 10px;
                min-width: 32px;
                height: 32px;
            }
            
            .header-top .header-right .btn i {
                font-size: 14px;
            }
            
            .header-top .header-right .user-avatar {
                width: 28px;
                height: 28px;
            }
            
            .header-top .header-right .user-avatar i {
                font-size: 18px !important;
            }
            
            .header-bottom {
                padding: 4px 6px;
                height: 40px;
            }
            
            .header-menu-item {
                padding: 5px 8px;
                font-size: 11px;
            }
            
            .header-menu-item i {
                font-size: 12px;
                margin-right: 3px;
            }
            
            .header-menu-item span {
                font-size: 11px;
            }
            
            /* Cards - Full Width */
            .card {
                border-radius: 10px !important;
            }
            
            .card-header {
                padding: 10px 12px !important;
            }
            
            .card-body {
                padding: 10px 12px !important;
            }
            
            /* Table - More Compact */
            .table {
                font-size: 11px !important;
            }
            
            .table th, .table td {
                padding: 6px 8px !important;
            }
            
            /* Buttons in Row */
            .btn-group-mobile {
                display: flex;
                flex-direction: column;
                gap: 8px;
                width: 100%;
            }
            
            .btn-group-mobile .btn {
                width: 100%;
            }
            
            /* Modal - Full Screen */
            .modal-dialog {
                margin: 5px !important;
                max-width: calc(100% - 10px) !important;
            }
            
            .modal-header .modal-title {
                font-size: 1rem !important;
            }
            
            /* Forms */
            .form-control, .form-select {
                font-size: 16px !important; /* Prevent zoom on iOS */
            }
            
            /* Grid - Stack */
            .col-md-6, .col-lg-4, .col-lg-3 {
                width: 100% !important;
            }
        }
        
        /* Mobile Menu Toggle */
        @media (max-width: 768px) {
            .mobile-menu-toggle {
                display: flex !important;
                align-items: center;
                justify-content: center;
                width: 36px;
                height: 36px;
                background: rgba(255,255,255,0.15);
                border: none;
                border-radius: 8px;
                color: white;
                cursor: pointer;
            }
            
            .mobile-menu-toggle i {
                font-size: 20px;
            }
        }
        
        @media (min-width: 769px) {
            .mobile-menu-toggle {
                display: none !important;
            }
        }
        /* Custom Checkbox Design */
        input[type="checkbox"] {
            appearance: none;
            -webkit-appearance: none;
            -moz-appearance: none;
            width: 22px;
            height: 22px;
            border: 2px solid #cbd5e1;
            border-radius: 5px;
            background-color: #ffffff;
            cursor: pointer;
            position: relative;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            margin: 0;
            flex-shrink: 0;
        }
        
        input[type="checkbox"]:hover {
            border-color: #2563eb;
            background-color: #eff6ff;
            transform: scale(1.05);
        }
        
        input[type="checkbox"]:checked {
            background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
            border-color: #2563eb;
            box-shadow: 0 2px 8px rgba(37, 99, 235, 0.3);
        }
        
        input[type="checkbox"]:checked::after {
            content: '';
            position: absolute;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%) rotate(45deg);
            width: 5px;
            height: 10px;
            border: solid white;
            border-width: 0 2px 2px 0;
            animation: checkmark 0.2s ease-in-out;
        }
        
        @keyframes checkmark {
            0% {
                opacity: 0;
                transform: translate(-50%, -50%) rotate(45deg) scale(0);
            }
            50% {
                transform: translate(-50%, -50%) rotate(45deg) scale(1.2);
            }
            100% {
                opacity: 1;
                transform: translate(-50%, -50%) rotate(45deg) scale(1);
            }
        }
        
        input[type="checkbox"]:focus {
            outline: none;
            box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
        }
        
        input[type="checkbox"]:disabled {
            opacity: 0.5;
            cursor: not-allowed;
            background-color: #f1f5f9;
            border-color: #e2e8f0;
        }
        
        input[type="checkbox"]:disabled:checked {
            background: linear-gradient(135deg, #94a3b8 0%, #64748b 100%);
            border-color: #94a3b8;
        }
        
        /* Form Check için özel stiller */
        .form-check {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 0.5rem 0;
        }
        
        .form-check-input {
            margin-top: 0;
            margin-right: 0;
        }
        
        .form-check-label {
            cursor: pointer;
            user-select: none;
            margin: 0;
            line-height: 1.5;
        }
        
        /* Form Switch için özel stiller */
        .form-switch .form-check-input {
            width: 48px;
            height: 26px;
            border-radius: 13px;
            background-color: #cbd5e1;
            border: none;
            position: relative;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        .form-switch .form-check-input::before {
            content: '';
            position: absolute;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            background-color: #ffffff;
            top: 3px;
            left: 3px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
        }
        
        .form-switch .form-check-input:checked {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            box-shadow: 0 2px 8px rgba(16, 185, 129, 0.3);
        }
        
        .form-switch .form-check-input:checked::before {
            left: 25px;
            background-color: #ffffff;
        }
        
        .form-switch .form-check-input:checked::after {
            display: none;
        }
        
        .form-switch .form-check-input:hover {
            transform: scale(1.05);
        }
        
        .form-switch .form-check-input:focus {
            box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.1);
        }
    </style>
    @stack('styles')
    
    <!-- Modern UI Global Styles -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <style>
        /* Modern UI Global Styles - Applied to all admin pages */
        :root {
            --glass-bg: rgba(255, 255, 255, 0.8);
            --glass-border: rgba(255, 255, 255, 0.3);
            --glass-shadow: 0 8px 32px rgba(0,0,0,0.1);
        }
        
        /* Modern Card Styles */
        .card, .dashboard-card {
            background: rgba(255, 255, 255, 0.85);
            backdrop-filter: blur(20px) saturate(180%);
            -webkit-backdrop-filter: blur(20px) saturate(180%);
            border-radius: 20px;
            box-shadow: 0 8px 32px rgba(0,0,0,0.1), 0 0 0 1px rgba(255,255,255,0.5);
            border: 1px solid rgba(255, 255, 255, 0.3);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            overflow: hidden;
            position: relative;
        }
        
        /* RGB çizgi efekti kaldırıldı */
        
        .card:hover, .dashboard-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 20px 60px rgba(0,0,0,0.15), 0 0 0 1px rgba(255,255,255,0.6), 0 0 40px rgba(102, 126, 234, 0.1);
        }
        
        /* Modern Button Styles */
        .btn {
            border-radius: 12px;
            font-weight: 600;
            padding: 10px 20px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
        }
        
        .btn::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.3);
            transform: translate(-50%, -50%);
            transition: width 0.6s, height 0.6s;
        }
        
        .btn:hover::before {
            width: 300px;
            height: 300px;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
            border: none;
            box-shadow: 0 4px 16px rgba(102, 126, 234, 0.3);
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 24px rgba(102, 126, 234, 0.5);
        }
        
        .btn-success {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            border: none;
        }
        
        .btn-danger {
            background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
            border: none;
        }
        
        .btn-info {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            border: none;
        }
        
        .btn-warning {
            background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
            border: none;
        }
        
        /* Modern Table Styles */
        .table {
            border-radius: 16px;
            overflow: hidden;
        }
        
        .table thead {
            background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(118, 75, 162, 0.1) 100%);
            backdrop-filter: blur(10px);
        }
        
        .table tbody tr {
            transition: all 0.2s ease;
        }
        
        .table tbody tr:hover {
            background: rgba(102, 126, 234, 0.05);
            transform: scale(1.01);
        }
        
        /* Modern Form Styles */
        .form-control, .form-select {
            border-radius: 12px;
            border: 1px solid rgba(226, 232, 240, 0.8);
            padding: 10px 16px;
            transition: all 0.3s ease;
            background: rgba(255, 255, 255, 0.9);
        }
        
        .form-control:focus, .form-select:focus {
            border-color: #2563eb;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
            background: white;
        }
        
        /* Modern Badge Styles */
        .badge {
            border-radius: 8px;
            padding: 6px 12px;
            font-weight: 600;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        
        /* Modern Alert Styles */
        .alert {
            border-radius: 16px;
            border: none;
            backdrop-filter: blur(10px);
            box-shadow: 0 4px 16px rgba(0,0,0,0.1);
        }
        
        /* Modern Modal Styles */
        .modal-content {
            border-radius: 24px;
            border: none;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        
        .modal-header {
            background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
            border-bottom: none;
            padding: 24px;
        }
        
        /* Smooth Animations */
        * {
            transition: background-color 0.3s ease, color 0.3s ease, transform 0.3s ease;
        }
        
        /* Page Title Styles */
        h1, h2, h3, h4, h5, h6 {
            font-weight: 700;
            letter-spacing: -0.5px;
        }
        
        /* Container Improvements */
        .container-fluid {
            padding: 24px;
        }
        
        /* Loading States */
        .btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }
    </style>
</head>
<body class="@if($isSettingsPage) settings-page @endif">
    <!-- Top Header - İki Katmanlı Tasarım -->
    <div class="top-header">
        <!-- Üst Katman: Logo, Kısayollar, Arama, Butonlar -->
        <div class="header-top">
            <div class="header-left">
                <!-- Mobile Menu Toggle (Hamburger) -->
                <button class="mobile-menu-toggle d-md-none" id="mobileMenuToggle" onclick="toggleMobileMenu()" aria-label="Menüyü Aç">
                    <i class="bi bi-list"></i>
                </button>
                <a href="{{ route('admin.dashboard') }}" style="text-decoration: none; display: flex; align-items: center;">
                    @php
                        $logoUrl = get_logo_url(false);
                    @endphp
                    @if($logoUrl)
                        <img src="{{ $logoUrl }}" alt="Adugun" class="logo-image" onerror="this.style.display='none'; this.nextElementSibling.style.display='inline-block';">
                        <span class="logo-text" style="display: none;">Adugun</span>
                    @else
                        <span class="logo-text">Adugun</span>
                    @endif
                </a>
            </div>
            
            <div class="header-center">
                <div class="search-container">
                    <input type="text" class="search-input" id="globalSearch" placeholder="Ara... (Rezervasyon, Müşteri, Gelin/Damat)" autocomplete="off">
                    <i class="bi bi-search search-icon"></i>
                    <div class="search-results" id="searchResults"></div>
                </div>
            </div>
            
            <div class="header-right">
                <div class="shortcuts-container d-none d-md-flex">
                    @if(!Auth::user()->isSuperAdmin())
                        <a href="#" class="shortcut-item" title="Yeni Rezervasyon" onclick="event.preventDefault(); if(typeof openNewReservationModal === 'function') { openNewReservationModal(); } else { window.location.href='{{ route('admin.rezervasyonlar.index') }}'; }">
                            <i class="bi bi-plus-circle"></i>
                        </a>
                        <a href="#" class="shortcut-item" title="Yeni Müşteri" onclick="event.preventDefault(); openNewCustomerModal();">
                            <i class="bi bi-person-plus"></i>
                        </a>
                        <a href="{{ route('admin.reservations.calendar') }}" class="shortcut-item" title="Takvim">
                            <i class="bi bi-calendar"></i>
                        </a>
                        <a href="{{ route('admin.accounting.cashbox') }}" class="shortcut-item" title="Kasa">
                            <i class="bi bi-cash-coin"></i>
                        </a>
                    @endif
                </div>
                
                @if(env('UYELIK'))
                    <a href="{{ env('UYELIK') }}" target="_blank" class="btn btn-sm" title="Üyelik Yenile">
                        <i class="bi bi-arrow-repeat"></i> <span>Üyelik Yenile</span>
                    </a>
                @endif
                
                @if(!Auth::user()->isSuperAdmin())
                <!-- SMS Bakiye Barı -->
                <div class="sms-balance-bar d-none d-md-flex align-items-center" style="background: rgba(255, 255, 255, 0.15); border: 1px solid rgba(255, 255, 255, 0.2); border-radius: 10px; padding: 6px 12px; margin-right: 8px; backdrop-filter: blur(10px);">
                    <i class="bi bi-chat-dots me-2" style="color: white;"></i>
                    <div class="d-flex flex-column" style="line-height: 1.2;">
                        <span style="font-size: 10px; color: rgba(255, 255, 255, 0.7);">SMS Bakiye</span>
                        <span style="font-size: 13px; font-weight: 600; color: white;">{{ Auth::user()->sms_balance ?? 0 }}</span>
                    </div>
                </div>
                @endif
                
                <a href="{{ route('admin.sms-packages.index') }}" class="btn btn-sm d-none d-md-inline-flex sms-buy-btn" title="SMS Paketleri">
                    <i class="bi bi-plus-circle"></i> <span>SMS Al</span>
                </a>
                
                <div class="dropdown">
                    <button class="btn btn-sm position-relative" type="button" data-bs-toggle="dropdown" aria-expanded="false" id="todayReservationsBtn" style="padding: 8px 12px;">
                        <i class="bi bi-calendar-check me-1"></i>
                        <span class="fw-semibold">Bugünkü Randevular</span>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end shadow-lg" id="todayReservationsMenu" style="min-width: 450px; max-width: 500px; width: 450px; border-radius: 12px; border: 1px solid #e5e7eb; padding: 8px 0;">
                        <li class="px-3 py-3 border-bottom" style="background: #ffffff;">
                            <h6 class="mb-0 fw-bold d-flex align-items-center justify-content-between" style="color: #1f2937;">
                                <span><i class="bi bi-calendar-check me-2 text-primary"></i> Bugünkü Rezervasyonlar</span>
                                <span class="badge bg-primary" id="todayReservationsCount">0</span>
                            </h6>
                        </li>
                        <li id="todayReservationsList" style="max-height: 450px; overflow-y: auto;">
                            <div class="dropdown-item text-center text-muted py-4">
                                <i class="bi bi-hourglass-split" style="font-size: 24px; opacity: 0.5;"></i>
                                <p class="mt-2 mb-0">Yükleniyor...</p>
                            </div>
                        </li>
                        <li><hr class="dropdown-divider my-2"></li>
                        <li>
                            <a class="dropdown-item text-center text-primary fw-bold py-2" href="{{ route('admin.rezervasyonlar.index') }}?date={{ date('Y-m-d') }}" style="background: #eff6ff; border-radius: 0 0 12px 12px;">
                                <i class="bi bi-arrow-right-circle me-2"></i> Tümünü Gör
                            </a>
                        </li>
                    </ul>
                </div>
                
                <div class="user-menu">
                    <div class="user-avatar">
                        <i class="bi bi-person-circle" style="font-size: 26px; color: #ffffff;"></i>
                    </div>
                    <div class="user-dropdown">
                        <div class="px-4 py-3 border-bottom" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%); color: white; border-radius: 12px 12px 0 0;">
                            <div class="d-flex align-items-center gap-3">
                                <div class="d-inline-flex align-items-center justify-content-center rounded-circle" style="width: 48px; height: 48px; background: rgba(255,255,255,0.2);">
                                    <i class="bi bi-person-circle" style="font-size: 28px; color: white;"></i>
                                </div>
                                <div>
                                    <p class="mb-0 fw-bold">{{ Auth::user()->name }}</p>
                                    <small style="opacity: 0.9; font-size: 12px;">{{ Auth::user()->phone }}</small>
                                </div>
                            </div>
                        </div>
                        <div class="py-2">
                            <a href="{{ route('admin.account.index') }}" class="d-block px-4 py-2 text-decoration-none text-dark" style="transition: all 0.2s; border-radius: 0;" onmouseover="this.style.background='#f8f9fa'" onmouseout="this.style.background='transparent'">
                                <i class="bi bi-person-badge me-2"></i> Hesap Ayarları
                            </a>
                            <a href="#" onclick="event.preventDefault(); openSettingsMenu();" class="d-block px-4 py-2 text-decoration-none text-dark" style="transition: all 0.2s; border-radius: 0;" onmouseover="this.style.background='#f8f9fa'" onmouseout="this.style.background='transparent'">
                                <i class="bi bi-gear me-2"></i> Ayarlar
                            </a>
                            <div class="border-top my-2"></div>
                            <form method="POST" action="{{ route('logout') }}" id="logoutForm">
                                @csrf
                                <a href="#" onclick="event.preventDefault(); document.getElementById('logoutForm').submit();" class="d-block px-4 py-2 text-decoration-none text-danger" style="transition: all 0.2s; border-radius: 0 0 12px 12px;" onmouseover="this.style.background='#fef2f2'" onmouseout="this.style.background='transparent'">
                                    <i class="bi bi-box-arrow-right me-2"></i> Çıkış Yap
                                </a>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Alt Katman: Sayfa Menüleri -->
        <div class="header-bottom">
            <div class="header-menu">
                @if(Auth::user()->isSuperAdmin())
                    <a href="{{ route('admin.superadmin.dashboard') }}" class="header-menu-item {{ request()->routeIs('admin.superadmin.dashboard') ? 'active' : '' }}">
                        <i class="bi bi-shield-check"></i>
                        <span>Süper Admin</span>
                    </a>
                    <a href="{{ route('admin.superadmin.users') }}" class="header-menu-item {{ request()->routeIs('admin.superadmin.users') ? 'active' : '' }}">
                        <i class="bi bi-people"></i>
                        <span>Kullanıcılar</span>
                    </a>
                    <a href="{{ route('admin.superadmin.packages.index') }}" class="header-menu-item {{ request()->routeIs('admin.superadmin.packages.*') ? 'active' : '' }}">
                        <i class="bi bi-box-seam"></i>
                        <span>Paketler</span>
                    </a>
                    <a href="{{ route('admin.superadmin.testimonials.index') }}" class="header-menu-item {{ request()->routeIs('admin.superadmin.testimonials.*') ? 'active' : '' }}">
                        <i class="bi bi-chat-quote"></i>
                        <span>Yorumlar</span>
                    </a>
                    <a href="{{ route('admin.superadmin.global-contract.index') }}" class="header-menu-item {{ request()->routeIs('admin.superadmin.global-contract.*') ? 'active' : '' }}">
                        <i class="bi bi-file-earmark-text"></i>
                        <span>Global Sözleşme</span>
                    </a>
                    <a href="{{ route('admin.superadmin.app-downloads') }}" class="header-menu-item {{ request()->routeIs('admin.superadmin.app-downloads') ? 'active' : '' }}">
                        <i class="bi bi-download"></i>
                        <span>Uygulama İndirmeleri</span>
                    </a>
                @else
                    <a href="{{ route('admin.dashboard') }}" class="header-menu-item {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}">
                        <i class="bi bi-house-door"></i>
                        <span>Anasayfa</span>
                    </a>
                    <a href="{{ route('admin.rezervasyonlar.index') }}" class="header-menu-item {{ request()->routeIs('admin.rezervasyonlar.*') ? 'active' : '' }}">
                        <i class="bi bi-list-ul"></i>
                        <span>Rezervasyonlar</span>
                    </a>
                    <a href="{{ route('admin.reservations.calendar') }}" class="header-menu-item {{ request()->routeIs('admin.reservations.calendar') ? 'active' : '' }}">
                        <i class="bi bi-calendar3"></i>
                        <span>Takvim</span>
                    </a>
                    <a href="{{ route('admin.customers.index') }}" class="header-menu-item {{ request()->routeIs('admin.customers.*') ? 'active' : '' }}">
                        <i class="bi bi-people"></i>
                        <span>Müşteriler</span>
                    </a>
                    <a href="{{ route('admin.accounting.cashbox') }}" class="header-menu-item {{ request()->routeIs('admin.accounting.cashbox') ? 'active' : '' }}">
                        <i class="bi bi-cash-coin"></i>
                        <span>KASA</span>
                    </a>
                    <a href="{{ route('admin.settings.invoices.index') }}" class="header-menu-item {{ request()->routeIs('admin.settings.invoices.*') ? 'active' : '' }}">
                        <i class="bi bi-receipt"></i>
                        <span>Faturalar</span>
                    </a>
                    <a href="{{ route('admin.settings.contracts.index') }}" class="header-menu-item {{ request()->routeIs('admin.settings.contracts.*') ? 'active' : '' }}">
                        <i class="bi bi-file-earmark-text"></i>
                        <span>Sözleşmeler</span>
                    </a>
                    <a href="{{ route('admin.help.faq') }}" class="header-menu-item {{ request()->routeIs('admin.help.*') ? 'active' : '' }}">
                        <i class="bi bi-question-circle"></i>
                        <span>Yardım</span>
                    </a>
                @endif
            </div>
        </div>
    </div>
    
    <!-- Mobile Menu Overlay -->
    <div class="mobile-menu-overlay" id="mobileMenuOverlay" onclick="closeMobileMenu()"></div>
    
    <!-- Mobile Menu Sidebar -->
    <div class="mobile-menu-sidebar" id="mobileMenuSidebar">
        <div class="mobile-menu-content" style="padding-top: 20px;">
            @if(Auth::user()->isSuperAdmin())
                <div class="mobile-menu-section">
                    <div class="mobile-menu-section-title">Süper Admin</div>
                    <a href="{{ route('admin.superadmin.dashboard') }}" class="mobile-menu-item {{ request()->routeIs('admin.superadmin.dashboard') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-shield-check"></i>
                        <span>Dashboard</span>
                    </a>
                    <a href="{{ route('admin.superadmin.users') }}" class="mobile-menu-item {{ request()->routeIs('admin.superadmin.users') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-people"></i>
                        <span>Kullanıcılar</span>
                    </a>
                    <a href="{{ route('admin.superadmin.packages.index') }}" class="mobile-menu-item {{ request()->routeIs('admin.superadmin.packages.*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-box-seam"></i>
                        <span>Paketler</span>
                    </a>
                    <a href="{{ route('admin.superadmin.testimonials.index') }}" class="mobile-menu-item {{ request()->routeIs('admin.superadmin.testimonials.*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-chat-quote"></i>
                        <span>Yorumlar</span>
                    </a>
                    <a href="{{ route('admin.superadmin.global-contract.index') }}" class="mobile-menu-item {{ request()->routeIs('admin.superadmin.global-contract.*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-file-earmark-text"></i>
                        <span>Global Sözleşme</span>
                    </a>
                    <a href="{{ route('admin.superadmin.app-downloads') }}" class="mobile-menu-item {{ request()->routeIs('admin.superadmin.app-downloads') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-download"></i>
                        <span>Uygulama İndirmeleri</span>
                    </a>
                </div>
            @else
                <!-- Desktop'taki ana menü sayfaları -->
                <div class="mobile-menu-section">
                    <a href="{{ route('admin.dashboard') }}" class="mobile-menu-item {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-house-door"></i>
                        <span>Anasayfa</span>
                    </a>
                    <a href="{{ route('admin.rezervasyonlar.index') }}" class="mobile-menu-item {{ request()->routeIs('admin.rezervasyonlar.*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-list-ul"></i>
                        <span>Rezervasyonlar</span>
                    </a>
                    <a href="{{ route('admin.reservations.calendar') }}" class="mobile-menu-item {{ request()->routeIs('admin.reservations.calendar') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-calendar3"></i>
                        <span>Takvim</span>
                    </a>
                    <a href="{{ route('admin.customers.index') }}" class="mobile-menu-item {{ request()->routeIs('admin.customers.*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-people"></i>
                        <span>Müşteriler</span>
                    </a>
                    <a href="{{ route('admin.accounting.cashbox') }}" class="mobile-menu-item {{ request()->routeIs('admin.accounting.cashbox') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-cash-coin"></i>
                        <span>Kasa</span>
                    </a>
                    <a href="{{ route('admin.settings.invoices.index') }}" class="mobile-menu-item {{ request()->routeIs('admin.settings.invoices.*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-receipt"></i>
                        <span>Faturalar</span>
                    </a>
                    <a href="{{ route('admin.settings.contracts.index') }}" class="mobile-menu-item {{ request()->routeIs('admin.settings.contracts.*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-file-earmark-text"></i>
                        <span>Sözleşmeler</span>
                    </a>
                    <a href="{{ route('admin.help.faq') }}" class="mobile-menu-item {{ request()->routeIs('admin.help.*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-question-circle"></i>
                        <span>Yardım</span>
                    </a>
                </div>
            @endif
            
            <div class="mobile-menu-section">
                <div class="mobile-menu-section-title">Hızlı İşlemler</div>
                @if(!Auth::user()->isSuperAdmin())
                    <a href="#" class="mobile-menu-item" onclick="event.preventDefault(); if(typeof openNewReservationModal === 'function') { openNewReservationModal(); closeMobileMenu(); } else { window.location.href='{{ route('admin.rezervasyonlar.index') }}'; closeMobileMenu(); }">
                        <i class="bi bi-plus-circle"></i>
                        <span>Yeni Rezervasyon</span>
                    </a>
                    <a href="#" class="mobile-menu-item" onclick="event.preventDefault(); openNewCustomerModal(); closeMobileMenu();">
                        <i class="bi bi-person-plus"></i>
                        <span>Yeni Müşteri</span>
                    </a>
                @endif
                <a href="{{ auth()->user()->isSuperAdmin() ? route('admin.settings.general') : route('admin.settings.membership') }}" class="mobile-menu-item" onclick="closeMobileMenu()">
                    <i class="bi bi-gear"></i>
                    <span>Ayarlar</span>
                </a>
            </div>
        </div>
    </div>

    <!-- Main Navbar - KALDIRILDI (menü header içine taşındı) -->

    <!-- Main Content -->
    <div class="main-content">
        <div class="content-wrapper">
            <!-- Session flash mesajları artık popup olarak gösteriliyor (aşağıda script ile) -->
            
            @if(isset($errors) && $errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif
            
            @yield('content')
        </div>
    </div>
    
    <!-- Settings Sidebar -->
    <div class="settings-sidebar" id="settingsSidebar">
        <div class="settings-sidebar-header">
            <h5><i class="bi bi-gear-fill me-2"></i> Ayarlar</h5>
        </div>
        <a href="{{ route('admin.settings.membership') }}" class="settings-sidebar-item {{ request()->routeIs('admin.settings.membership') ? 'active' : '' }}">
            <i class="bi bi-person-badge"></i> Üyelik Bilgilerim
        </a>
        <a href="{{ route('admin.settings.salons.index') }}" class="settings-sidebar-item {{ request()->routeIs('admin.settings.salons.*') ? 'active' : '' }}">
            <i class="bi bi-building"></i> Salon Yönetimi
        </a>
        <a href="{{ route('admin.settings.contracts.index') }}" class="settings-sidebar-item {{ request()->routeIs('admin.settings.contracts.*') ? 'active' : '' }}">
            <i class="bi bi-file-text"></i> Sözleşmeler
        </a>
        <a href="{{ route('admin.settings.invoices.index') }}" class="settings-sidebar-item {{ request()->routeIs('admin.settings.invoices.*') ? 'active' : '' }}">
            <i class="bi bi-receipt"></i> Faturalar
        </a>
        @if(auth()->user()->isSuperAdmin())
        <a href="{{ route('admin.settings.homepage') }}" class="settings-sidebar-item {{ request()->routeIs('admin.settings.homepage') ? 'active' : '' }}">
            <i class="bi bi-house"></i> Ana Sayfa Ayarları
        </a>
        <a href="{{ route('admin.settings.whatsapp-invoice') }}" class="settings-sidebar-item {{ request()->routeIs('admin.settings.whatsapp-invoice') ? 'active' : '' }}">
            <i class="bi bi-whatsapp"></i> WhatsApp & Fatura
        </a>
        @if(auth()->user()->isSuperAdmin())
        <a href="{{ route('admin.settings.general') }}" class="settings-sidebar-item {{ request()->routeIs('admin.settings.general') ? 'active' : '' }}">
            <i class="bi bi-gear"></i> Genel Ayarlar
        </a>
        @endif
        <a href="{{ route('admin.settings.sms') }}" class="settings-sidebar-item {{ request()->routeIs('admin.settings.sms') ? 'active' : '' }}">
            <i class="bi bi-chat-dots"></i> SMS Ayarları
        </a>
        @endif
    </div>
    
    <!-- Modals -->
    @include('partials.modals')
    @include('partials.modals-appointments-contacts')
    
    <!-- Özel Onay Kutusu - Bootstrap Modal KULLANMIYOR -->
    <div id="customConfirmBox" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 999999;">
        <!-- Backdrop -->
        <div id="customConfirmBackdrop" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5);"></div>
        <!-- Dialog -->
        <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); z-index: 1000000;">
            <div style="background: white; border-radius: 16px; box-shadow: 0 25px 50px rgba(0,0,0,0.25); min-width: 400px; max-width: 450px; overflow: hidden;">
                <div style="background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%); padding: 20px 24px;">
                    <div style="display: flex; align-items: center; gap: 16px;">
                        <div style="width: 50px; height: 50px; background: linear-gradient(135deg, #f59e0b 0%, #ef4444 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                            <i class="bi bi-exclamation-triangle-fill text-white" style="font-size: 24px;"></i>
                        </div>
                        <div style="flex: 1;">
                            <h5 style="margin: 0; color: #1f2937; font-weight: 600;">Onay Gerekli</h5>
                        </div>
                        <button type="button" id="customConfirmClose" style="background: none; border: none; font-size: 24px; color: #6b7280; cursor: pointer; padding: 0; line-height: 1;">&times;</button>
                    </div>
                </div>
                <div style="padding: 24px;">
                    <p id="customConfirmMessage" style="margin: 0; color: #4b5563; font-size: 15px;">Bu işlemi yapmak istediğinize emin misiniz?</p>
                </div>
                <div style="padding: 16px 24px; background: #f9fafb; display: flex; justify-content: flex-end; gap: 12px;">
                    <button type="button" id="customConfirmCancel" style="padding: 10px 20px; border: 1px solid #d1d5db; background: white; color: #374151; border-radius: 8px; font-weight: 500; cursor: pointer; display: flex; align-items: center; gap: 8px;">
                        <i class="bi bi-x-circle"></i> İptal
                    </button>
                    <button type="button" id="customConfirmOk" style="padding: 10px 20px; border: none; background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); color: white; border-radius: 8px; font-weight: 500; cursor: pointer; display: flex; align-items: center; gap: 8px;">
                        <i class="bi bi-check-circle"></i> Onayla
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Başarı/Hata/Bilgi Popup Kutusu -->
    <div id="customPopupBox" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 999998;">
        <!-- Backdrop -->
        <div id="customPopupBackdrop" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.4);"></div>
        <!-- Dialog -->
        <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); z-index: 999999;">
            <div style="background: white; border-radius: 16px; box-shadow: 0 25px 50px rgba(0,0,0,0.25); min-width: 400px; max-width: 450px; overflow: hidden;">
                <div id="customPopupHeader" style="padding: 20px 24px;">
                    <div style="display: flex; align-items: center; gap: 16px;">
                        <div id="customPopupIcon" style="width: 50px; height: 50px; border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                            <i id="customPopupIconClass" class="text-white" style="font-size: 24px;"></i>
                        </div>
                        <div style="flex: 1;">
                            <h5 id="customPopupTitle" style="margin: 0; color: #1f2937; font-weight: 600;"></h5>
                        </div>
                        <button type="button" id="customPopupClose" style="background: none; border: none; font-size: 24px; color: #6b7280; cursor: pointer; padding: 0; line-height: 1;">&times;</button>
                    </div>
                </div>
                <div style="padding: 24px;">
                    <p id="customPopupMessage" style="margin: 0; color: #4b5563; font-size: 15px; line-height: 1.6;"></p>
                </div>
                <div style="padding: 16px 24px; background: #f9fafb; display: flex; justify-content: flex-end;">
                    <button type="button" id="customPopupOk" style="padding: 10px 24px; border: none; border-radius: 8px; font-weight: 500; cursor: pointer; display: flex; align-items: center; gap: 8px; color: white;">
                        <i class="bi bi-check-circle"></i> Tamam
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Rezervasyon Detay Modal -->
    <div class="modal fade" id="reservationDetailModal" tabindex="-1" aria-labelledby="reservationDetailModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header bg-light">
                    <h5 class="modal-title text-dark" id="reservationDetailModalLabel">
                        <i class="bi bi-file-text"></i> Rezervasyon Dökümanı
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="reservationDetailContent" style="max-height: 70vh; overflow-y: auto;">
                    <div class="text-center py-5">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Yükleniyor...</span>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                    <button type="button" class="btn btn-primary" id="confirmReservationBtn" onclick="confirmReservation()" style="display: none;">
                        <i class="bi bi-check-circle"></i> Onayla
                    </button>
                    <button type="button" class="btn btn-success" id="completeReservationBtn" onclick="completeReservation()" style="display: none;">
                        <i class="bi bi-check2-all"></i> Onayla ve Bitir
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Session Flash Mesajları için Popup -->
    @if(session('success'))
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                if (typeof showToast === 'function') {
                    showToast('success', '{{ session('success') }}');
                } else if (typeof showPopup === 'function') {
                    showPopup('success', '{{ session('success') }}');
                }
            }, 300);
        });
        </script>
    @endif
    
    @if(session('error'))
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                if (typeof showToast === 'function') {
                    showToast('error', '{{ session('error') }}');
                } else if (typeof showPopup === 'function') {
                    showPopup('error', '{{ session('error') }}');
                }
            }, 300);
        });
        </script>
    @endif
    
    @if(session('warning'))
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                if (typeof showToast === 'function') {
                    showToast('warning', '{{ session('warning') }}');
                } else if (typeof showPopup === 'function') {
                    showPopup('warning', '{{ session('warning') }}');
                }
            }, 300);
        });
        </script>
    @endif
    
    @if(session('info'))
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                if (typeof showToast === 'function') {
                    showToast('info', '{{ session('info') }}');
                } else if (typeof showPopup === 'function') {
                    showPopup('info', '{{ session('info') }}');
                }
            }, 300);
        });
        </script>
    @endif
    
    @if(session('sms_warning'))
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                const smsWarningModal = new bootstrap.Modal(document.getElementById('smsBalanceWarningModal'));
                smsWarningModal.show();
            }, 500);
        });
        </script>
    @endif
    
    <script>
    let currentReservationId = null;
    
    function openReservationDetailModal(reservationId) {
        currentReservationId = reservationId;
        const modal = new bootstrap.Modal(document.getElementById('reservationDetailModal'));
        modal.show();
        
        // İçeriği yükle
        loadReservationDetails(reservationId);
    }
    
    function loadReservationDetails(reservationId) {
        const content = document.getElementById('reservationDetailContent');
        content.innerHTML = '<div class="text-center py-5"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Yükleniyor...</span></div></div>';
        
        const url = '{{ route("admin.rezervasyonlar.show", ":id") }}'.replace(':id', reservationId);
        fetch(url, {
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || ''
            }
        })
        .then(response => {
            if (!response.ok) {
                return response.json().then(err => {
                    throw new Error(err.message || err.error || 'HTTP ' + response.status);
                });
            }
            return response.json();
        })
        .then(data => {
            if (!data || !data.reservation) {
                throw new Error('Rezervasyon verisi alınamadı');
            }
            const reservation = data.reservation;
            const customer = data.customer;
            const salon = data.salon;
            const items = data.items || [];
            
            let statusBadge = '';
            if (reservation.status == 'open') {
                statusBadge = '<span class="badge bg-warning">Açık</span>';
            } else if (reservation.status == 'confirmed') {
                statusBadge = '<span class="badge bg-success">Onaylandı</span>';
            } else if (reservation.status == 'cancelled') {
                statusBadge = '<span class="badge bg-danger">İptal</span>';
            } else if (reservation.status == 'completed') {
                statusBadge = '<span class="badge bg-info">Tamamlandı</span>';
            }
            
            let itemsHtml = '';
            if (items.length > 0) {
                items.forEach((item, index) => {
                    itemsHtml += `
                        <tr>
                            <td>${index + 1}</td>
                            <td>${item.name}</td>
                            <td>${item.quantity}</td>
                            <td>${parseFloat(item.price).toFixed(2)} ₺</td>
                            <td>${parseFloat(item.total).toFixed(2)} ₺</td>
                        </tr>
                    `;
                });
            } else {
                itemsHtml = '<tr><td colspan="5" class="text-center text-muted">Kalem bulunamadı</td></tr>';
            }
            
            const html = `
                <div class="card border-0 shadow-sm mb-4" style="background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);">
                    <div class="card-body p-4">
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <h6 class="text-primary mb-3"><i class="bi bi-person-circle me-2"></i>Müşteri Bilgileri</h6>
                                    <div class="ps-3">
                                        <p class="mb-2"><strong>Ad Soyad:</strong> ${customer.name || '-'}</p>
                                        <p class="mb-2"><strong>Telefon:</strong> ${customer.phone || '-'}</p>
                                        <p class="mb-2"><strong>E-posta:</strong> ${customer.email || '-'}</p>
                                        ${customer.address ? `<p class="mb-0"><strong>Adres:</strong> ${customer.address}</p>` : ''}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <h6 class="text-primary mb-3"><i class="bi bi-calendar-event me-2"></i>Rezervasyon Bilgileri</h6>
                                    <div class="ps-3">
                                        <p class="mb-2"><strong>Rezervasyon No:</strong> #${reservation.id}</p>
                                        <p class="mb-2"><strong>Tarih:</strong> ${new Date(reservation.date).toLocaleDateString('tr-TR', { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' })}</p>
                                        <p class="mb-2"><strong>Saat:</strong> ${reservation.start_time} - ${reservation.end_time}</p>
                                        <p class="mb-2"><strong>Salon:</strong> ${salon.name || '-'}</p>
                                        <p class="mb-2"><strong>Misafir Sayısı:</strong> ${reservation.guest_count} kişi</p>
                                        <p class="mb-0"><strong>Durum:</strong> ${statusBadge}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header border-0" style="background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);">
                        <h6 class="mb-0 text-white"><i class="bi bi-receipt me-2"></i>Fatura Kalemleri</h6>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th style="width: 5%;" class="text-center">#</th>
                                        <th style="width: 45%;">Kalem</th>
                                        <th style="width: 15%;" class="text-center">Miktar</th>
                                        <th style="width: 17.5%;" class="text-end">Birim Fiyat</th>
                                        <th style="width: 17.5%;" class="text-end">Toplam</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    ${itemsHtml}
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        ${reservation.notes ? `
                        <div class="card border-0 shadow-sm">
                            <div class="card-header border-0" style="background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);">
                                <h6 class="mb-0 text-white"><i class="bi bi-sticky me-2"></i>Notlar</h6>
                            </div>
                            <div class="card-body">
                                <p class="mb-0 text-muted">${reservation.notes}</p>
                            </div>
                        </div>
                        ` : ''}
                    </div>
                    <div class="col-md-6">
                        <div class="card border-0 shadow-sm" style="background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);">
                            <div class="card-header border-0" style="background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);">
                                <h6 class="mb-0 text-white"><i class="bi bi-calculator me-2"></i>Fiyat Özeti</h6>
                            </div>
                            <div class="card-body">
                                <div class="d-flex justify-content-between mb-3">
                                    <span class="text-muted">Toplam Tutar:</span>
                                    <strong class="text-primary" style="font-size: 18px;">${parseFloat(data.total_price).toFixed(2)} ₺</strong>
                                </div>
                                <div class="d-flex justify-content-between mb-3">
                                    <span class="text-muted">Alınan Kapora:</span>
                                    <span class="text-success">${parseFloat(data.deposit_paid).toFixed(2)} ₺</span>
                                </div>
                                <hr>
                                <div class="d-flex justify-content-between">
                                    <strong>Kalan Ödeme:</strong>
                                    <strong class="${data.remaining_amount > 0 ? 'text-danger' : 'text-success'}" style="font-size: 18px;">${parseFloat(data.remaining_amount).toFixed(2)} ₺</strong>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            `;
            
            content.innerHTML = html;
            
            // Buton görünürlüğünü ayarla
            const confirmBtn = document.getElementById('confirmReservationBtn');
            const completeBtn = document.getElementById('completeReservationBtn');
            
            if (reservation.status == 'open') {
                confirmBtn.style.display = 'inline-block';
                completeBtn.style.display = 'inline-block';
            } else if (reservation.status == 'confirmed') {
                confirmBtn.style.display = 'none';
                completeBtn.style.display = 'inline-block';
            } else {
                confirmBtn.style.display = 'none';
                completeBtn.style.display = 'none';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            const errorMessage = error.message || 'Rezervasyon bilgileri yüklenirken bir hata oluştu.';
            content.innerHTML = '<div class="alert alert-danger"><i class="bi bi-exclamation-triangle"></i> <strong>Hata:</strong> ' + errorMessage + '</div>';
        });
    }
    
    async function confirmReservation() {
        if (!currentReservationId) return;
        
        const confirmed = await customConfirm('Bu rezervasyonu onaylamak istediğinize emin misiniz?');
        if (!confirmed) {
            return;
        }
        
        const btn = document.getElementById('confirmReservationBtn');
        btn.disabled = true;
        btn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>İşleniyor...';
        
        fetch(`{{ url('admin/rezervasyonlar') }}/${currentReservationId}/onayla`, {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                bootstrap.Modal.getInstance(document.getElementById('reservationDetailModal')).hide();
                window.location.reload();
            } else {
                alert('Bir hata oluştu: ' + (data.message || 'Bilinmeyen hata'));
                btn.disabled = false;
                btn.innerHTML = '<i class="bi bi-check-circle"></i> Onayla';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Rezervasyon onaylanırken bir hata oluştu.');
            btn.disabled = false;
            btn.innerHTML = '<i class="bi bi-check-circle"></i> Onayla';
        });
    }
    
    async function completeReservation() {
        if (!currentReservationId) return;
        
        const confirmed = await customConfirm('Bu rezervasyonu tamamlamak istediğinize emin misiniz?');
        if (!confirmed) {
            return;
        }
        
        const btn = document.getElementById('completeReservationBtn');
        btn.disabled = true;
        btn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>İşleniyor...';
        
        fetch(`{{ url('admin/rezervasyonlar') }}/${currentReservationId}/tamamla`, {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                bootstrap.Modal.getInstance(document.getElementById('reservationDetailModal')).hide();
                window.location.reload();
            } else {
                alert('Bir hata oluştu: ' + (data.message || 'Bilinmeyen hata'));
                btn.disabled = false;
                btn.innerHTML = '<i class="bi bi-check2-all"></i> Onayla ve Bitir';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Rezervasyon tamamlanırken bir hata oluştu.');
            btn.disabled = false;
            btn.innerHTML = '<i class="bi bi-check2-all"></i> Onayla ve Bitir';
        });
    }
    </script>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Özel Confirm Dialog Sistemi - Bootstrap Modal KULLANMIYOR
        let confirmResolve = null;
        
        function customConfirm(message) {
            return new Promise((resolve) => {
                confirmResolve = resolve;
                
                const box = document.getElementById('customConfirmBox');
                const messageEl = document.getElementById('customConfirmMessage');
                
                if (messageEl) {
                    messageEl.textContent = message || 'Bu işlemi yapmak istediğinize emin misiniz?';
                }
                
                // Kutuyu göster
                box.style.display = 'block';
                document.body.style.overflow = 'hidden';
            });
        }
        
        function hideConfirmBox() {
            const box = document.getElementById('customConfirmBox');
            box.style.display = 'none';
            document.body.style.overflow = '';
        }
        
        // Popup mesaj göster (başarı, hata, bilgi)
        function showPopup(type, message, title = null) {
            const box = document.getElementById('customPopupBox');
            const icon = document.getElementById('customPopupIcon');
            const iconClass = document.getElementById('customPopupIconClass');
            const titleEl = document.getElementById('customPopupTitle');
            const messageEl = document.getElementById('customPopupMessage');
            const header = document.getElementById('customPopupHeader');
            const okBtn = document.getElementById('customPopupOk');
            
            // Tip'e göre renk ve ikon ayarla
            let bgColor, iconBg, iconName, defaultTitle;
            if (type === 'success') {
                bgColor = 'linear-gradient(135deg, #10b981 0%, #059669 100%)';
                iconBg = 'linear-gradient(135deg, #10b981 0%, #059669 100%)';
                iconName = 'bi-check-circle-fill';
                defaultTitle = 'Başarılı';
            } else if (type === 'error') {
                bgColor = 'linear-gradient(135deg, #ef4444 0%, #dc2626 100%)';
                iconBg = 'linear-gradient(135deg, #ef4444 0%, #dc2626 100%)';
                iconName = 'bi-x-circle-fill';
                defaultTitle = 'Hata';
            } else if (type === 'warning') {
                bgColor = 'linear-gradient(135deg, #f59e0b 0%, #d97706 100%)';
                iconBg = 'linear-gradient(135deg, #f59e0b 0%, #d97706 100%)';
                iconName = 'bi-exclamation-triangle-fill';
                defaultTitle = 'Uyarı';
            } else {
                bgColor = 'linear-gradient(135deg, #3b82f6 0%, #2563eb 100%)';
                iconBg = 'linear-gradient(135deg, #3b82f6 0%, #2563eb 100%)';
                iconName = 'bi-info-circle-fill';
                defaultTitle = 'Bilgi';
            }
            
            header.style.background = bgColor;
            icon.style.background = iconBg;
            iconClass.className = iconName + ' text-white';
            titleEl.textContent = title || defaultTitle;
            titleEl.style.color = 'white';
            messageEl.textContent = message;
            okBtn.style.background = iconBg;
            
            box.style.display = 'block';
            document.body.style.overflow = 'hidden';
            
            // Otomatik kapanma (5 saniye)
            setTimeout(() => {
                hidePopup();
            }, 5000);
        }
        
        function hidePopup() {
            const box = document.getElementById('customPopupBox');
            box.style.display = 'none';
            document.body.style.overflow = '';
        }
        
        // Global showToast fonksiyonunu popup'a yönlendir
        window.showToast = function(type, message) {
            showPopup(type, message);
        };
        
        // Event listener'ları ekle
        document.addEventListener('DOMContentLoaded', function() {
            const okBtn = document.getElementById('customConfirmOk');
            const cancelBtn = document.getElementById('customConfirmCancel');
            const closeBtn = document.getElementById('customConfirmClose');
            const backdrop = document.getElementById('customConfirmBackdrop');
            
            if (okBtn) {
                okBtn.addEventListener('click', function() {
                    if (confirmResolve) {
                        confirmResolve(true);
                        confirmResolve = null;
                    }
                    hideConfirmBox();
                });
            }
            
            if (cancelBtn) {
                cancelBtn.addEventListener('click', function() {
                    if (confirmResolve) {
                        confirmResolve(false);
                        confirmResolve = null;
                    }
                    hideConfirmBox();
                });
            }
            
            if (closeBtn) {
                closeBtn.addEventListener('click', function() {
                    if (confirmResolve) {
                        confirmResolve(false);
                        confirmResolve = null;
                    }
                    hideConfirmBox();
                });
            }
            
            // Backdrop'a tıklanınca kapat
            if (backdrop) {
                backdrop.addEventListener('click', function() {
                    if (confirmResolve) {
                        confirmResolve(false);
                        confirmResolve = null;
                    }
                    hideConfirmBox();
                });
            }
            
            // Popup event listener'ları
            const popupOk = document.getElementById('customPopupOk');
            const popupClose = document.getElementById('customPopupClose');
            const popupBackdrop = document.getElementById('customPopupBackdrop');
            
            if (popupOk) {
                popupOk.addEventListener('click', function() {
                    hidePopup();
                });
            }
            
            if (popupClose) {
                popupClose.addEventListener('click', function() {
                    hidePopup();
                });
            }
            
            if (popupBackdrop) {
                popupBackdrop.addEventListener('click', function() {
                    hidePopup();
                });
            }
            
            // Escape tuşuna basılınca kapat
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    const popupBox = document.getElementById('customPopupBox');
                    if (popupBox && popupBox.style.display !== 'none') {
                        hidePopup();
                        return;
                    }
                    const box = document.getElementById('customConfirmBox');
                    if (box && box.style.display === 'block') {
                        if (confirmResolve) {
                            confirmResolve(false);
                            confirmResolve = null;
                        }
                        hideConfirmBox();
                    }
                }
            });
            
            // Form submit'lerdeki confirm'leri handle et
            document.querySelectorAll('.delete-form').forEach(form => {
                form.addEventListener('submit', async function(e) {
                    e.preventDefault();
                    const message = this.getAttribute('data-message') || 'Bu kaydı silmek istediğinize emin misiniz?';
                    const confirmed = await customConfirm(message);
                    if (confirmed) {
                        this.submit();
                    }
                });
            });
        });
        
        // Chrome'un varsayılan confirm'ini override et (global)
        // Not: customConfirm async bir Promise döndürür, bu yüzden window.confirm'i override etmek
        // doğru çalışmayabilir. Bunun yerine customConfirm kullanılmalı.
        window.originalConfirm = window.confirm;
        // window.confirm override edilmiyor çünkü async/sync uyumsuzluğu var
        
        // Global Search Functionality
        let searchTimeout;
        const searchInput = document.getElementById('globalSearch');
        const searchResults = document.getElementById('searchResults');

        if (searchInput && searchResults) {
            searchInput.addEventListener('input', function() {
                clearTimeout(searchTimeout);
                const query = this.value.trim();

                if (query.length < 2) {
                    searchResults.classList.remove('show');
                    return;
                }

                searchTimeout = setTimeout(() => {
                    fetch(`{{ route('admin.search') }}?q=${encodeURIComponent(query)}`, {
                        method: 'GET',
                        headers: {
                            'Accept': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        credentials: 'same-origin'
                    })
                        .then(response => {
                            if (!response.ok) {
                                throw new Error('Arama isteği başarısız: ' + response.status);
                            }
                            return response.json();
                        })
                        .then(data => {
                            displaySearchResults(data);
                        })
                        .catch(error => {
                            console.error('Arama hatası:', error);
                            if (searchResults) {
                                searchResults.innerHTML = '<div class="search-result-item"><div class="text-center text-danger w-100">Arama sırasında bir hata oluştu</div></div>';
                                searchResults.classList.add('show');
                            }
                        });
                }, 300);
            });
            
            searchInput.addEventListener('focus', function() {
                if (this.value.trim().length >= 2 && searchResults.innerHTML.trim() !== '') {
                    searchResults.classList.add('show');
                }
            });
        }
        
        function displaySearchResults(data) {
            let html = '';
            let hasResults = false;
            let currentCustomerId = null;

            // Müşteriler ve Rezervasyonları
            if (data.customers && data.customers.length > 0) {
                hasResults = true;
                
                data.customers.forEach(item => {
                    if (item.is_customer) {
                        // Müşteri başlığı
                        html += `
                            <div class="search-customer-header">
                                <a href="${item.url}" class="search-result-item customer-item">
                                    <div class="search-result-icon" style="background: linear-gradient(135deg, #2563eb 0%, #3b82f6 100%); color: white;">
                                        <i class="bi ${item.icon}"></i>
                                    </div>
                                    <div class="search-result-content">
                                        <div class="search-result-title fw-bold">${item.title}</div>
                                        <div class="search-result-subtitle">${item.subtitle || ''}</div>
                                    </div>
                                    <div class="search-result-type badge bg-primary">${item.type}</div>
                                </a>
                            </div>
                        `;
                        currentCustomerId = item.id;
                    } else {
                        // Rezervasyon (müşterinin altında)
                        let statusClass = 'bg-secondary';
                        if (item.type === 'Açık') statusClass = 'bg-warning text-dark';
                        else if (item.type === 'Onaylı') statusClass = 'bg-success';
                        else if (item.type === 'İptal') statusClass = 'bg-danger';
                        else if (item.type === 'Tamamlandı') statusClass = 'bg-info';
                        
                        html += `
                            <a href="${item.url}" class="search-result-item reservation-item" style="padding-left: 50px; background: #f8fafc;">
                                <div class="search-result-icon" style="background: #e2e8f0; color: #64748b; width: 32px; height: 32px; font-size: 14px;">
                                    <i class="bi ${item.icon}"></i>
                                </div>
                                <div class="search-result-content">
                                    <div class="search-result-title" style="font-size: 13px;">${item.title}</div>
                                </div>
                                <div class="search-result-type badge ${statusClass}" style="font-size: 10px;">${item.type}</div>
                            </a>
                        `;
                    }
                });
            }

            if (!hasResults) {
                html = '<div class="search-result-item"><div class="text-center text-muted w-100 py-3"><i class="bi bi-search me-2"></i>Sonuç bulunamadı</div></div>';
            }

            if (searchResults) {
                searchResults.innerHTML = html;
                searchResults.classList.add('show');
            }
        }

        // Close search results when clicking outside
        if (searchInput && searchResults) {
            document.addEventListener('click', function(event) {
                if (!searchInput.contains(event.target) && !searchResults.contains(event.target)) {
                    searchResults.classList.remove('show');
                }
            });
        }

        // Professional Navbar Dropdown System
        (function() {
            'use strict';
            
            const dropdowns = [];
            let closeTimer = null;
            let scrollPosition = window.pageYOffset || document.documentElement.scrollTop;

            function init() {
                const dropdownElements = document.querySelectorAll('.nav-dropdown');
                
                dropdownElements.forEach((dropdown) => {
                    const menu = dropdown.querySelector('.nav-dropdown-menu');
                    if (!menu) return;

                    const dropdownObj = {
                        element: dropdown,
                        menu: menu,
                        timer: null
                    };
                    
                    dropdowns.push(dropdownObj);

                    // Open dropdown
                    function open() {
                        clearAllTimers();
                        closeAll();
                        dropdown.classList.add('is-active');
                        menu.classList.add('is-visible');
                    }

                    // Close dropdown
                    function close() {
                        dropdown.classList.remove('is-active');
                        menu.classList.remove('is-visible');
                    }

                    // Schedule close
                    function scheduleClose() {
                        clearTimer(dropdownObj);
                        dropdownObj.timer = setTimeout(close, 200);
                    }

                    // Cancel scheduled close
                    function cancelClose() {
                        clearTimer(dropdownObj);
                    }

                    // Mouse enter on dropdown
                    dropdown.addEventListener('mouseenter', (e) => {
                        cancelClose();
                        open();
                    });

                    // Mouse leave from dropdown
                    dropdown.addEventListener('mouseleave', (e) => {
                        const relatedTarget = e.relatedTarget;
                        if (relatedTarget && (dropdown.contains(relatedTarget) || menu.contains(relatedTarget))) {
                            return;
                        }
                        scheduleClose();
                    });

                    // Mouse enter on menu
                    menu.addEventListener('mouseenter', () => {
                        cancelClose();
                        open();
                    });

                    // Mouse leave from menu
                    menu.addEventListener('mouseleave', (e) => {
                        const relatedTarget = e.relatedTarget;
                        if (relatedTarget && dropdown.contains(relatedTarget)) {
                            return;
                        }
                        scheduleClose();
                    });
                });
            }

            function clearTimer(dropdownObj) {
                if (dropdownObj.timer) {
                    clearTimeout(dropdownObj.timer);
                    dropdownObj.timer = null;
                }
            }

            function clearAllTimers() {
                dropdowns.forEach(clearTimer);
            }

            function closeAll() {
                dropdowns.forEach((obj) => {
                    obj.element.classList.remove('is-active');
                    obj.menu.classList.remove('is-visible');
                    clearTimer(obj);
                });
            }

            // Close on scroll - IMMEDIATE
            window.addEventListener('scroll', () => {
                const currentScroll = window.pageYOffset || document.documentElement.scrollTop;
                if (Math.abs(currentScroll - scrollPosition) > 1) {
                    closeAll();
                }
                scrollPosition = currentScroll;
            }, { passive: true });

            // Close on click outside
            document.addEventListener('click', (e) => {
                let inside = false;
                dropdowns.forEach((obj) => {
                    if (obj.element.contains(e.target)) {
                        inside = true;
                    }
                });
                if (!inside) {
                    closeAll();
                }
            });

            // Initialize
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', init);
            } else {
                init();
            }
        })();

        // User menu dropdown management - Tıklama ile açılır
        document.addEventListener('DOMContentLoaded', function() {
            const userMenu = document.querySelector('.user-menu');
            const userAvatar = document.querySelector('.user-menu .user-avatar');
            const userDropdown = document.querySelector('.user-dropdown');
            
            if (!userMenu || !userDropdown || !userAvatar) return;
            
            function showDropdown() {
                userDropdown.classList.add('show');
                // Fixed position için konum hesapla
                const avatarRect = userAvatar.getBoundingClientRect();
                const headerTopHeight = 60;
                userDropdown.style.top = (headerTopHeight + 8) + 'px';
                userDropdown.style.right = (window.innerWidth - avatarRect.right) + 'px';
                userDropdown.style.position = 'fixed';
                userDropdown.style.zIndex = '100004';
            }
            
            function hideDropdown() {
                userDropdown.classList.remove('show');
            }
            
            function toggleDropdown(e) {
                e.stopPropagation();
                if (userDropdown.classList.contains('show')) {
                    hideDropdown();
                } else {
                    showDropdown();
                }
            }
            
            // Avatar'a tıklayınca aç/kapat
            userAvatar.addEventListener('click', toggleDropdown);
            
            // Sayfa herhangi bir yerine tıklayınca kapat
            document.addEventListener('click', function(e) {
                if (!userMenu.contains(e.target)) {
                    hideDropdown();
                }
            });
            
            // Dropdown içine tıklayınca kapanmasın (linkler hariç)
            userDropdown.addEventListener('click', function(e) {
                // Eğer tıklanan bir link ise normal davransın
                if (e.target.tagName === 'A' || e.target.closest('a')) {
                    return;
                }
                e.stopPropagation();
            });
            
            // Window resize ve scroll'da pozisyonu güncelle
            function updateDropdownPosition() {
                if (userDropdown.classList.contains('show')) {
                    const avatarRect = userAvatar.getBoundingClientRect();
                    const headerTopHeight = 60;
                    userDropdown.style.top = (headerTopHeight + 8) + 'px';
                    userDropdown.style.right = (window.innerWidth - avatarRect.right) + 'px';
                }
            }
            
            window.addEventListener('resize', updateDropdownPosition);
            window.addEventListener('scroll', updateDropdownPosition);
            
            // ESC tuşu ile kapat
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    hideDropdown();
                }
            });
        });

        // Bugünkü rezervasyonlar dropdown'ı için pozisyon düzeltmesi
        document.addEventListener('DOMContentLoaded', function() {
            const headerTopHeight = 60;
            
            const todayReservationsButton = document.getElementById('todayReservationsBtn');
            const todayReservationsMenu = document.getElementById('todayReservationsMenu');
            
            // Bugünkü rezervasyonlar dropdown pozisyon güncelleme fonksiyonu
            const updateTodayReservationsPosition = function() {
                if (todayReservationsButton && todayReservationsMenu) {
                    const buttonRect = todayReservationsButton.getBoundingClientRect();
                    // Düğmenin hemen altına hizala
                    const topPos = buttonRect.bottom + 5;
                    const rightPos = window.innerWidth - buttonRect.right;
                    
                    todayReservationsMenu.style.cssText = `
                        position: fixed !important;
                        top: ${topPos}px !important;
                        right: ${rightPos}px !important;
                        left: auto !important;
                        transform: none !important;
                        z-index: 999999 !important;
                        min-width: 450px;
                        max-width: 500px;
                        background: white !important;
                        box-shadow: 0 10px 40px rgba(0,0,0,0.2) !important;
                        border-radius: 12px !important;
                    `;
                }
            };
            
            if (todayReservationsButton && todayReservationsMenu) {
                // Dropdown açıldığında pozisyonu ayarla ve veriyi göster
                todayReservationsButton.addEventListener('click', function() {
                    setTimeout(updateTodayReservationsPosition, 10);
                    setTimeout(updateTodayReservationsPosition, 50);
                    setTimeout(updateTodayReservationsPosition, 100);
                    // Veriyi göster veya yükle
                    setTimeout(showTodayReservations, 50);
                });
                
                // Bootstrap event'leri
                const dropdownParent = todayReservationsButton.closest('.dropdown');
                if (dropdownParent) {
                    dropdownParent.addEventListener('shown.bs.dropdown', function() {
                        updateTodayReservationsPosition();
                        showTodayReservations();
                    });
                }
                
                // Scroll ve resize'da pozisyonu güncelle
                window.addEventListener('scroll', function() {
                    if (todayReservationsMenu.classList.contains('show')) {
                        updateTodayReservationsPosition();
                    }
                });
                
                window.addEventListener('resize', function() {
                    if (todayReservationsMenu.classList.contains('show')) {
                        updateTodayReservationsPosition();
                    }
                });
            }
            
        });
        
        // Settings menu functions
        function openSettingsMenu() {
            // Kullanıcı tipine göre ayarlar sayfasına yönlendir
            @if(auth()->user()->isSuperAdmin())
                window.location.href = "{{ route('admin.settings.general') }}";
            @else
                window.location.href = "{{ route('admin.settings.membership') }}";
            @endif
        }
        
        // Mobile Menu Functions
        function toggleMobileMenu() {
            const sidebar = document.getElementById('mobileMenuSidebar');
            const overlay = document.getElementById('mobileMenuOverlay');
            const toggle = document.getElementById('mobileMenuToggle');
            
            if (sidebar && overlay && toggle) {
                sidebar.classList.toggle('active');
                overlay.classList.toggle('active');
                toggle.classList.toggle('active');
                
                // Body scroll lock
                if (sidebar.classList.contains('active')) {
                    document.body.style.overflow = 'hidden';
                } else {
                    document.body.style.overflow = '';
                }
            }
        }
        
        function closeMobileMenu() {
            const sidebar = document.getElementById('mobileMenuSidebar');
            const overlay = document.getElementById('mobileMenuOverlay');
            const toggle = document.getElementById('mobileMenuToggle');
            
            if (sidebar && overlay && toggle) {
                sidebar.classList.remove('active');
                overlay.classList.remove('active');
                toggle.classList.remove('active');
                document.body.style.overflow = '';
            }
        }
        
        // Close mobile menu on escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeMobileMenu();
            }
        });
        
        // Close mobile menu when clicking outside
        document.addEventListener('click', function(e) {
            const sidebar = document.getElementById('mobileMenuSidebar');
            const overlay = document.getElementById('mobileMenuOverlay');
            
            if (sidebar && overlay && 
                !sidebar.contains(e.target) && 
                !e.target.closest('#mobileMenuToggle') &&
                sidebar.classList.contains('active')) {
                closeMobileMenu();
            }
        });

        function closeSettingsMenu() {
            // Ayarlar sayfasından çık - dashboard'a yönlendir
            window.location.href = "{{ route('admin.dashboard') }}";
        }
        
        // Ayarlar sayfalarında sidebar otomatik açık olsun (PHP ile body class zaten ekleniyor)
        document.addEventListener('DOMContentLoaded', function() {
            // PHP'den gelen settings-page class'ı varsa, sidebar otomatik açık olacak (CSS ile)
            // Ekstra bir işlem yapmaya gerek yok, CSS zaten hallediyor
        });
        
        // Modal fonksiyonlarını global scope'a ekle (eğer modals.blade.php'de tanımlı değilse)
        
        // Global fonksiyonları tanımla
        if (typeof openNewCustomerModal === 'undefined') {
            window.openNewCustomerModal = function() {
                const modalElement = document.getElementById('newCustomerModal');
                if (modalElement) {
                    const modal = new bootstrap.Modal(modalElement);
                    modal.show();
                } else {
                    console.error('newCustomerModal bulunamadı');
                }
            };
        }
        
        // submitCustomerForm fonksiyonunun tanımlı olduğundan emin ol
        if (typeof submitCustomerForm === 'undefined') {
            window.submitCustomerForm = function() {
                console.log('submitCustomerForm fallback - form normal submit kullanıyor');
            };
        }
        
        // Bugünkü rezervasyonları yükle
        let todayReservationsData = null;
        let todayReservationsLoading = false;
        
        function loadTodayReservations(showLoading = false) {
            // Eğer zaten yükleniyorsa, tekrar yükleme
            if (todayReservationsLoading) {
                return;
            }
            
            const list = document.getElementById('todayReservationsList');
            const countBadge = document.getElementById('todayReservationsCount');
            const badge = document.getElementById('todayReservationsBadge');
            
            // Loading göster
            if (showLoading && list) {
                list.innerHTML = '<div class="dropdown-item text-center text-muted py-4"><i class="bi bi-hourglass-split" style="font-size: 24px; opacity: 0.5;"></i><p class="mt-2 mb-0">Yükleniyor...</p></div>';
            }
            
            todayReservationsLoading = true;
            
            fetch('{{ route("admin.notifications.today") }}', {
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                }
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.json();
            })
            .then(data => {
                todayReservationsData = data;
                const reservations = data.reservations || [];
                const count = data.count || 0;
                
                if (badge) {
                    badge.textContent = count;
                    badge.style.display = count > 0 ? 'block' : 'none';
                }
                
                if (countBadge) {
                    countBadge.textContent = count;
                }
                
                if (list) {
                    if (count > 0) {
                        let html = '';
                        reservations.slice(0, 8).forEach(reservation => {
                            const customer = reservation.customer?.name || 'Müşteri';
                            const salon = reservation.salon?.name || 'Salon';
                            let statusClass = 'info';
                            let statusText = 'Açık';
                            
                            if (reservation.status === 'confirmed') {
                                statusClass = 'success';
                                statusText = 'Onaylandı';
                            } else if (reservation.status === 'open') {
                                statusClass = 'warning';
                                statusText = 'Açık';
                            } else if (reservation.status === 'completed') {
                                statusClass = 'info';
                                statusText = 'Tamamlandı';
                            }
                            
                            const totalPrice = reservation.total_price ? Number(reservation.total_price).toLocaleString('tr-TR') + ' ₺' : '-';
                            
                            html += `
                                <a class="dropdown-item py-3 px-4" href="{{ route('admin.rezervasyonlar.index') }}/${reservation.id}" style="border-bottom: 1px solid #f1f5f9; transition: all 0.2s;" onmouseover="this.style.background='#f8fafc'" onmouseout="this.style.background='transparent'">
                                    <div class="d-flex align-items-start gap-3">
                                        <div class="d-inline-flex align-items-center justify-content-center rounded-circle flex-shrink-0" style="width: 45px; height: 45px; background: linear-gradient(135deg, #eff6ff 0%, #dbeafe 100%);">
                                            <i class="bi bi-calendar-check text-primary" style="font-size: 20px;"></i>
                                        </div>
                                        <div class="flex-grow-1" style="min-width: 0;">
                                            <div class="d-flex justify-content-between align-items-start mb-1">
                                                <div class="fw-bold text-dark" style="font-size: 14px;">${customer}</div>
                                                <span class="badge bg-${statusClass} flex-shrink-0" style="font-size: 11px; padding: 4px 10px;">${statusText}</span>
                                            </div>
                                            <div class="d-flex flex-wrap gap-2 mb-1">
                                                <span class="text-muted" style="font-size: 12px;"><i class="bi bi-building me-1"></i>${salon}</span>
                                                <span class="text-muted" style="font-size: 12px;"><i class="bi bi-clock me-1"></i>${reservation.start_time} - ${reservation.end_time || ''}</span>
                                            </div>
                                            <div class="text-primary fw-semibold" style="font-size: 13px;"><i class="bi bi-currency-lira me-1"></i>${totalPrice}</div>
                                        </div>
                                    </div>
                                </a>
                            `;
                        });
                        list.innerHTML = html;
                    } else {
                        list.innerHTML = '<div class="dropdown-item text-center text-muted py-5"><i class="bi bi-calendar-x" style="font-size: 32px; opacity: 0.3;"></i><p class="mt-3 mb-0">Bugün rezervasyon yok</p></div>';
                    }
                }
                
                todayReservationsLoading = false;
            })
            .catch(error => {
                console.error('Bugünkü rezervasyonlar yüklenemedi:', error);
                todayReservationsLoading = false;
                
                // Hata durumunda kullanıcıya bilgi ver
                if (list) {
                    list.innerHTML = '<div class="dropdown-item text-center text-danger py-4"><i class="bi bi-exclamation-triangle" style="font-size: 24px;"></i><p class="mt-2 mb-0">Yüklenirken hata oluştu</p><button class="btn btn-sm btn-primary mt-2" onclick="loadTodayReservations(true)">Tekrar Dene</button></div>';
                }
            });
        }
        
        // Dropdown açıldığında veriyi göster veya yükle
        function showTodayReservations() {
            const list = document.getElementById('todayReservationsList');
            if (!list) return;
            
            // Eğer veri yüklüyse göster
            if (todayReservationsData) {
                const reservations = todayReservationsData.reservations || [];
                const count = todayReservationsData.count || 0;
                
                if (count > 0) {
                    let html = '';
                    reservations.slice(0, 8).forEach(reservation => {
                        const customer = reservation.customer?.name || 'Müşteri';
                        const salon = reservation.salon?.name || 'Salon';
                        let statusClass = 'info';
                        let statusText = 'Açık';
                        
                        if (reservation.status === 'confirmed') {
                            statusClass = 'success';
                            statusText = 'Onaylandı';
                        } else if (reservation.status === 'open') {
                            statusClass = 'warning';
                            statusText = 'Açık';
                        } else if (reservation.status === 'completed') {
                            statusClass = 'info';
                            statusText = 'Tamamlandı';
                        }
                        
                        const totalPrice = reservation.total_price ? Number(reservation.total_price).toLocaleString('tr-TR') + ' ₺' : '-';
                        
                        html += `
                            <a class="dropdown-item py-3 px-4" href="{{ route('admin.rezervasyonlar.index') }}/${reservation.id}" style="border-bottom: 1px solid #f1f5f9; transition: all 0.2s;" onmouseover="this.style.background='#f8fafc'" onmouseout="this.style.background='transparent'">
                                <div class="d-flex align-items-start gap-3">
                                    <div class="d-inline-flex align-items-center justify-content-center rounded-circle flex-shrink-0" style="width: 45px; height: 45px; background: linear-gradient(135deg, #eff6ff 0%, #dbeafe 100%);">
                                        <i class="bi bi-calendar-check text-primary" style="font-size: 20px;"></i>
                                    </div>
                                    <div class="flex-grow-1" style="min-width: 0;">
                                        <div class="d-flex justify-content-between align-items-start mb-1">
                                            <div class="fw-bold text-dark" style="font-size: 14px;">${customer}</div>
                                            <span class="badge bg-${statusClass} flex-shrink-0" style="font-size: 11px; padding: 4px 10px;">${statusText}</span>
                                        </div>
                                        <div class="d-flex flex-wrap gap-2 mb-1">
                                            <span class="text-muted" style="font-size: 12px;"><i class="bi bi-building me-1"></i>${salon}</span>
                                            <span class="text-muted" style="font-size: 12px;"><i class="bi bi-clock me-1"></i>${reservation.start_time} - ${reservation.end_time || ''}</span>
                                        </div>
                                        <div class="text-primary fw-semibold" style="font-size: 13px;"><i class="bi bi-currency-lira me-1"></i>${totalPrice}</div>
                                    </div>
                                </div>
                            </a>
                        `;
                    });
                    list.innerHTML = html;
                } else {
                    list.innerHTML = '<div class="dropdown-item text-center text-muted py-5"><i class="bi bi-calendar-x" style="font-size: 32px; opacity: 0.3;"></i><p class="mt-3 mb-0">Bugün rezervasyon yok</p></div>';
                }
            } else {
                // Veri yoksa yükle
                loadTodayReservations(true);
            }
        }
        
        // Sayfa yüklendiğinde bugünkü rezervasyonları yükle
        document.addEventListener('DOMContentLoaded', function() {
            loadTodayReservations();
            // Her 30 saniyede bir güncelle
            setInterval(loadTodayReservations, 30000);
        });
        
        // Yaklaşan rezervasyon bildirimleri
        let shownNotifications = JSON.parse(localStorage.getItem('shownReservationNotifications') || '[]');
        let notificationSound = null;
        let soundEnabled = false;
        
        // Ses dosyasını önceden yükle
        function initNotificationSound() {
            if (!notificationSound) {
                try {
                    // Önce public klasöründen dene
                    const soundUrl = '{{ asset("notf.mp3") }}';
                    notificationSound = new Audio(soundUrl);
                    
                    notificationSound.onerror = function() {
                        console.log('Public klasöründen ses yüklenemedi, storage\'dan deneniyor...');
                        try {
                            // Public'te bulamazsa storage linkinden dene
                            const storageUrl = '{{ asset("storage/notf.mp3") }}';
                            notificationSound = new Audio(storageUrl);
                            notificationSound.onerror = function() {
                                console.error('Bildirim sesi hiçbir yerde bulunamadı');
                                notificationSound = null;
                            };
                            notificationSound.oncanplaythrough = function() {
                                console.log('Bildirim sesi storage\'dan yüklendi');
                                notificationSound.volume = 0.7;
                                notificationSound.load();
                            };
                            if (notificationSound) {
                                notificationSound.volume = 0.7;
                                notificationSound.load();
                            }
                        } catch (e) {
                            console.error('Bildirim sesi yüklenemedi:', e);
                            notificationSound = null;
                        }
                    };
                    
                    notificationSound.oncanplaythrough = function() {
                        console.log('Bildirim sesi public klasöründen yüklendi');
                        notificationSound.volume = 0.7;
                    };
                    
                    if (notificationSound) {
                        notificationSound.volume = 0.7;
                        notificationSound.preload = 'auto';
                        notificationSound.load();
                    }
                } catch (e) {
                    console.error('Bildirim sesi yüklenemedi:', e);
                    notificationSound = null;
                }
            }
        }
        
        // Sayfa yüklendiğinde ses dosyasını hazırla
        document.addEventListener('DOMContentLoaded', initNotificationSound);
        
        // Kullanıcı sayfayla etkileşime girdiğinde sesi aktif et
        document.addEventListener('click', function() {
            if (!soundEnabled) {
                soundEnabled = true;
                // Sesi sessiz çal (tarayıcı izni için)
                if (notificationSound) {
                    notificationSound.volume = 0;
                    notificationSound.play().then(() => {
                        notificationSound.pause();
                        notificationSound.currentTime = 0;
                        notificationSound.volume = 0.7;
                    }).catch(() => {});
                }
            }
        }, { once: true });
        
        // Bildirim sesi çal
        function playNotificationSound() {
            if (notificationSound && soundEnabled) {
                try {
                    notificationSound.currentTime = 0;
                    const playPromise = notificationSound.play();
                    if (playPromise !== undefined) {
                        playPromise.then(() => {
                            console.log('Bildirim sesi çalındı');
                        }).catch(e => {
                            console.error('Ses çalınamadı:', e);
                            // Ses çalınamazsa tekrar yükle ve dene
                            if (notificationSound) {
                                notificationSound.load();
                                notificationSound.play().catch(err => {
                                    console.error('Ses tekrar çalınamadı:', err);
                                });
                            }
                        });
                    }
                } catch (e) {
                    console.error('Ses çalma hatası:', e);
                }
            } else {
                if (!notificationSound) {
                    console.warn('Bildirim sesi yüklenmemiş');
                }
                if (!soundEnabled) {
                    console.warn('Ses etkinleştirilmemiş');
                }
            }
        }
        
        function checkUpcomingReservations() {
            fetch('{{ route("admin.notifications.upcoming") }}', {
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || ''
                }
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error('HTTP ' + response.status);
                }
                return response.json();
            })
            .then(data => {
                if (!data || !data.reservations || data.reservations.length === 0) {
                    return;
                }
                
                const now = new Date();
                
                data.reservations.forEach(reservation => {
                    if (reservation.status === 'cancelled' || reservation.status === 'completed') {
                        return;
                    }
                    
                    try {
                        // Tarih ve saat formatını düzelt
                        let reservationDateTime;
                        if (reservation.date && reservation.start_time) {
                            // Tarih formatı: YYYY-MM-DD, saat formatı: HH:MM
                            const dateStr = reservation.date;
                            const timeStr = reservation.start_time;
                            reservationDateTime = new Date(dateStr + 'T' + timeStr + ':00');
                        } else {
                            return;
                        }
                        
                        if (isNaN(reservationDateTime.getTime())) {
                            console.error('Geçersiz tarih/saat:', reservation.date, reservation.start_time);
                            return;
                        }
                        
                        const reservationId = reservation.id;
                        const timeDiff = Math.floor((reservationDateTime - now) / 1000 / 60); // Dakika cinsinden
                        
                        // 1 saat kala bildirim (60 dakika ile 30 dakika arası)
                        const oneHourKey = `reservation_${reservationId}_1hour`;
                        if (timeDiff <= 60 && timeDiff > 30 && !shownNotifications.includes(oneHourKey)) {
                            console.log('1 saat kala bildirim gösteriliyor:', reservation);
                            showReservationNotification(reservation, '1 saat', oneHourKey);
                        }
                        
                        // 30 dakika kala bildirim (30 dakika ile 0 dakika arası)
                        const thirtyMinKey = `reservation_${reservationId}_30min`;
                        if (timeDiff <= 30 && timeDiff > 0 && !shownNotifications.includes(thirtyMinKey)) {
                            console.log('30 dakika kala bildirim gösteriliyor:', reservation);
                            showReservationNotification(reservation, '30 dakika', thirtyMinKey);
                        }
                    } catch (error) {
                        console.error('Rezervasyon işlenirken hata:', error, reservation);
                    }
                });
            })
            .catch(error => {
                console.error('Yaklaşan rezervasyonlar kontrol edilemedi:', error);
            });
        }
        
        function showReservationNotification(reservation, timeText, notificationKey) {
            // Bildirimi gösterildi olarak işaretle
            shownNotifications.push(notificationKey);
            localStorage.setItem('shownReservationNotifications', JSON.stringify(shownNotifications));
            
            // Bildirim sesi çal
            playNotificationSound();
            
            // Bildirim HTML'i oluştur
            const notificationHtml = `
                <div class="reservation-notification" data-key="${notificationKey}" style="
                    position: fixed;
                    top: 80px;
                    right: 20px;
                    background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
                    border-radius: 16px;
                    box-shadow: 0 10px 40px rgba(0,0,0,0.15), 0 0 0 1px rgba(245, 158, 11, 0.3);
                    padding: 24px;
                    min-width: 360px;
                    max-width: 420px;
                    z-index: 100010;
                    border-left: 5px solid #f59e0b;
                    animation: slideInRight 0.4s ease-out;
                ">
                    <div class="d-flex justify-content-between align-items-start">
                        <div class="flex-grow-1">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <div style="width: 40px; height: 40px; background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                                    <i class="bi bi-bell-fill text-warning" style="font-size: 18px;"></i>
                                </div>
                                <strong class="text-dark" style="font-size: 16px;">⏰ Yaklaşan Rezervasyon</strong>
                            </div>
                            <p class="mb-1 text-muted" style="font-size: 14px;">
                                <strong>${reservation.customer?.name || 'Müşteri'}</strong> - ${reservation.salon?.name || 'Salon'}
                            </p>
                            <p class="mb-0 text-muted" style="font-size: 13px;">
                                <i class="bi bi-calendar3"></i> ${new Date(reservation.date).toLocaleDateString('tr-TR')} 
                                <i class="bi bi-clock ms-2"></i> ${reservation.start_time}
                            </p>
                            <p class="mb-0 mt-1">
                                <span class="badge bg-warning">${timeText} kaldı</span>
                            </p>
                            <a href="{{ route('admin.rezervasyonlar.index') }}/${reservation.id}" class="btn btn-sm btn-primary mt-2" style="font-size: 12px;">
                                <i class="bi bi-eye"></i> Detayları Gör
                            </a>
                        </div>
                        <button type="button" class="btn-close" onclick="closeNotification('${notificationKey}')" style="margin-left: 10px;"></button>
                    </div>
                </div>
            `;
            
            // Bildirimi ekle
            document.body.insertAdjacentHTML('beforeend', notificationHtml);
        }
        
        function closeNotification(key) {
            const notification = document.querySelector(`.reservation-notification[data-key="${key}"]`);
            if (notification) {
                notification.style.animation = 'slideOutRight 0.3s ease-out';
                setTimeout(() => {
                    notification.remove();
                }, 300);
            }
        }
        
        // Her 30 saniyede bir yaklaşan rezervasyonları kontrol et
        setInterval(checkUpcomingReservations, 30000);
        // Sayfa yüklendiğinde de kontrol et
        document.addEventListener('DOMContentLoaded', function() {
            // İlk kontrolü 2 saniye sonra yap
            setTimeout(checkUpcomingReservations, 2000);
            // Sonra her 30 saniyede bir kontrol et (zaten setInterval var ama emin olmak için)
        });
        
        // Sayfa görünür olduğunda da kontrol et (tab değiştiğinde)
        document.addEventListener('visibilitychange', function() {
            if (!document.hidden) {
                setTimeout(checkUpcomingReservations, 1000);
            }
        });
        
        // Animasyonlar
        const style = document.createElement('style');
        style.textContent = `
            @keyframes slideInRight {
                from {
                    transform: translateX(400px);
                    opacity: 0;
                }
                to {
                    transform: translateX(0);
                    opacity: 1;
                }
            }
            @keyframes slideOutRight {
                from {
                    transform: translateX(0);
                    opacity: 1;
                }
                to {
                    transform: translateX(400px);
                    opacity: 0;
                }
            }
        `;
        document.head.appendChild(style);
    </script>
    
    <!-- Lisans Süresi Dolmuş Popup -->
    @auth
        @if(!Auth::user()->isSuperAdmin() && !Auth::user()->hasValidLicense())
            <div class="modal fade" id="licenseExpiredModal" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false" aria-labelledby="licenseExpiredModalLabel" aria-hidden="false">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content" style="border-radius: 20px; border: none; box-shadow: 0 10px 40px rgba(0,0,0,0.2);">
                        <div class="modal-header border-0" style="background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); border-radius: 20px 20px 0 0; padding: 24px;">
                            <div class="w-100 text-center">
                                <i class="bi bi-exclamation-triangle-fill text-white" style="font-size: 48px;"></i>
                                <h4 class="modal-title text-white mt-3 mb-0" id="licenseExpiredModalLabel">Lisans Süresi Doldu</h4>
                            </div>
                        </div>
                        <div class="modal-body text-center" style="padding: 32px;">
                            <p class="text-muted mb-4" style="font-size: 16px;">
                                Panel kullanımınız için lisansınızı yenilemeniz gerekmektedir.
                            </p>
                            <div class="d-flex gap-3 justify-content-center">
                                <a href="{{ env('LISANSYENILE', '#') }}" target="_blank" class="btn btn-primary btn-lg px-4" style="border-radius: 12px; font-weight: 600;">
                                    <i class="bi bi-arrow-clockwise me-2"></i> Lisansı Yenile
                                </a>
                                <form method="POST" action="{{ route('logout') }}" class="d-inline">
                                    @csrf
                                    <button type="submit" class="btn btn-outline-secondary btn-lg px-4" style="border-radius: 12px; font-weight: 600;">
                                        <i class="bi bi-box-arrow-right me-2"></i> Çıkış Yap
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    const licenseModal = new bootstrap.Modal(document.getElementById('licenseExpiredModal'));
                    licenseModal.show();
                });
            </script>
        @endif
    @endauth
    
    <!-- SMS BAKİYE UYARI MODAL -->
    <div class="modal fade" id="smsBalanceWarningModal" tabindex="-1" aria-hidden="true" data-bs-backdrop="static">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content" style="border-radius: 16px; overflow: hidden; box-shadow: 0 20px 60px rgba(0,0,0,0.3);">
                <div class="modal-header border-0" style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); padding: 20px 24px;">
                    <div class="d-flex align-items-center gap-3">
                        <div style="width: 48px; height: 48px; background: rgba(255,255,255,0.2); border-radius: 12px; display: flex; align-items: center; justify-content: center;">
                            <i class="bi bi-exclamation-triangle-fill text-white" style="font-size: 24px;"></i>
                        </div>
                        <h5 class="modal-title text-white fw-bold mb-0" style="font-size: 1.25rem;">
                            SMS Bakiyesi Kalmadı
                        </h5>
                    </div>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4" style="background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);">
                    <div class="d-flex align-items-start gap-3">
                        <i class="bi bi-phone text-warning" style="font-size: 2rem; flex-shrink: 0; margin-top: 4px;"></i>
                        <div>
                            <p class="mb-2 fw-bold text-dark" style="font-size: 1.1rem;">
                                SMS bakiyeniz kalmamıştır!
                            </p>
                            <p class="mb-2 text-muted" style="font-size: 0.95rem;">
                                @if(session('sms_warning'))
                                    {{ session('sms_warning') }}
                                @else
                                    İşlem başarıyla tamamlandı ancak SMS gönderilemedi.
                                @endif
                            </p>
                            <p class="mb-0 text-muted" style="font-size: 0.95rem;">
                                SMS göndermek için lütfen SMS paketi satın alın.
                            </p>
                        </div>
                    </div>
                </div>
                <div class="modal-footer border-0" style="background: #ffffff; padding: 16px 24px;">
                    <button type="button" class="btn btn-secondary px-4" data-bs-dismiss="modal">
                        <i class="bi bi-x-circle me-2"></i>Kapat
                    </button>
                    <a href="{{ route('admin.sms-packages.index') }}" class="btn btn-primary px-4">
                        <i class="bi bi-credit-card me-2"></i>SMS Paketi Satın Al
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    @yield('scripts')
    @stack('scripts')
    
    <!-- AOS Animation Library -->
    <!-- AOS animasyonları devre dışı bırakıldı -->
    <script>
        // Tüm animasyonlar devre dışı
        document.addEventListener('DOMContentLoaded', function() {
            // Tüm data-aos attribute'larını kaldır
            document.querySelectorAll('[data-aos]').forEach(el => {
                el.removeAttribute('data-aos');
                el.removeAttribute('data-aos-delay');
                el.removeAttribute('data-aos-duration');
                el.removeAttribute('data-aos-easing');
            });
        });
    </script>
</body>
</html>

