<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Customer;
use App\Models\Reservation;
use Illuminate\Http\Request;

class CustomerAccountController extends Controller
{
    public function index()
    {
        $user = auth()->user();
        $query = Customer::withCount('reservations');
        
        // Rezervasyoncu ise sadece kendi müşterilerini göster
        if ($user->role === 'rezervasyoncu') {
            $query->where('created_by', $user->id);
        }
        
        $customers = $query->orderBy('name')->paginate(20);

        return view('admin.accounting.customers', compact('customers'));
    }

    public function show($id)
    {
        $user = auth()->user();
        $query = Customer::query();
        
        // Rezervasyoncu ise sadece kendi müşterisini görebilir
        if ($user->role === 'rezervasyoncu') {
            $query->where('created_by', $user->id);
        }
        
        $customer = $query->findOrFail($id);
        
        $reservationQuery = Reservation::where('customer_id', $id);
        
        // Rezervasyoncu ise sadece kendi rezervasyonlarını göster
        if ($user->role === 'rezervasyoncu') {
            $reservationQuery->where('created_by', $user->id);
        }
        
        $reservations = $reservationQuery->orderBy('date', 'desc')->get();

        $totalAmount = $reservations->sum('total_price');
        $totalPaid = $reservations->sum('deposit_paid');
        $totalRemaining = $reservations->sum('remaining_amount');

        return view('admin.accounting.customer-detail', compact('customer', 'reservations', 'totalAmount', 'totalPaid', 'totalRemaining'));
    }
}

