<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Extra;
use Illuminate\Http\Request;

class ExtraController extends Controller
{
    public function index()
    {
        $extras = Extra::orderBy('name')->get();
        return view('admin.settings.extras.index', compact('extras'));
    }

    public function create()
    {
        return view('admin.settings.extras.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'price' => 'required|numeric|min:0',
            'is_active' => 'boolean',
        ]);

        Extra::create($validated);

        return redirect()->route('admin.settings.extras.index')
            ->with('success', 'Extra oluşturuldu.');
    }

    public function edit($id)
    {
        $extra = Extra::findOrFail($id);
        return view('admin.settings.extras.edit', compact('extra'));
    }

    public function update(Request $request, $id)
    {
        $extra = Extra::findOrFail($id);

        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'price' => 'required|numeric|min:0',
            'is_active' => 'boolean',
        ]);

        $extra->update($validated);

        return redirect()->route('admin.settings.extras.index')
            ->with('success', 'Extra güncellendi.');
    }

    public function destroy($id)
    {
        $extra = Extra::findOrFail($id);
        $extra->delete();

        return redirect()->route('admin.settings.extras.index')
            ->with('success', 'Extra silindi.');
    }
}

