<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class HelpController extends Controller
{
    public function faq()
    {
        return view('admin.help.faq');
    }

    public function support()
    {
        return view('admin.help.support');
    }

    public function submitSupport(Request $request)
    {
        $request->validate([
            'subject' => 'required|string|max:255',
            'message' => 'required|string',
        ]);

        // Dummy - gerçek uygulamada email gönderilebilir
        return redirect()->back()->with('success', 'Destek talebiniz alındı.');
    }
}

