<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Reservation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class ReportController extends Controller
{
    public function monthlyReservations(Request $request)
    {
        $month = $request->get('month', now()->format('Y-m'));
        $reservations = Reservation::whereYear('date', substr($month, 0, 4))
            ->whereMonth('date', substr($month, 5, 2))
            ->with(['customer', 'salon'])
            ->get();

        return view('admin.reports.monthly-reservations', compact('reservations', 'month'));
    }

    public function monthlyRevenue(Request $request)
    {
        $user = Auth::user();
        $month = $request->get('month', now()->format('Y-m'));
        
        $query = Reservation::whereYear('date', substr($month, 0, 4))
            ->whereMonth('date', substr($month, 5, 2))
            ->where('status', '!=', 'cancelled');
        
        // Rezervasyoncu ise sadece kendi rezervasyonlarını göster
        if ($user->role === 'rezervasyoncu' || $user->role === 'admin') {
            $query->where('created_by', $user->id);
        }
        
        $revenue = (clone $query)->sum('total_price');
        $reservations = $query->get();

        return view('admin.reports.monthly-revenue', compact('revenue', 'reservations', 'month'));
    }

    public function weekly(Request $request)
    {
        $user = Auth::user();
        $startDate = $request->get('start_date', now()->startOfWeek()->format('Y-m-d'));
        $endDate = $request->get('end_date', now()->endOfWeek()->format('Y-m-d'));

        $query = Reservation::whereBetween('date', [$startDate, $endDate])
            ->with(['customer', 'salon']);
        
        // Rezervasyoncu ise sadece kendi rezervasyonlarını göster
        if ($user->role === 'rezervasyoncu' || $user->role === 'admin') {
            $query->where('created_by', $user->id);
        }
        
        $reservations = $query->get();

        return view('admin.reports.weekly', compact('reservations', 'startDate', 'endDate'));
    }
}

