@extends('layouts.admin')

@section('title', 'Hesap Yönetimi')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Hesap Yönetimi</li>
@endsection

@section('content')
    <h2 class="mb-4 p-3 rounded" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%); color: white;">
        <i class="bi bi-person-circle"></i> Hesap Yönetimi
    </h2>
    
    <div class="card">
        <div class="card-header bg-primary text-white border-0">
            <h5 class="mb-0"><i class="bi bi-person"></i> Üyelik Bilgileri</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.account.update') }}">
                @csrf
                @method('PUT')
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label">Ad Soyad *</label>
                        <input type="text" name="name" class="form-control" value="{{ $user->name }}" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">E-posta *</label>
                        <input type="email" name="email" class="form-control" value="{{ $user->email }}" required>
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label">Telefon Numarası *</label>
                        <input type="tel" name="phone" class="form-control" value="{{ $user->phone }}" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Rol</label>
                        <input type="text" class="form-control" value="{{ $user->role === 'super_admin' ? 'Süper Admin' : ($user->role === 'admin' ? 'Rezervasyoncu' : ucfirst($user->role)) }}" readonly>
                    </div>
                </div>
                
                <hr>
                
                <h5 class="mb-3">Şifre Değiştir</h5>
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label">Yeni Şifre</label>
                        <input type="password" name="password" class="form-control">
                        <small class="text-muted">Boş bırakılırsa şifre değiştirilmez.</small>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Yeni Şifre (Tekrar)</label>
                        <input type="password" name="password_confirmation" class="form-control">
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary">Güncelle</button>
            </form>
        </div>
    </div>
    
    <!-- Hesap Silme Bölümü -->
    <div class="card mt-4 border-danger">
        <div class="card-header bg-danger text-white">
            <h5 class="mb-0"><i class="bi bi-exclamation-triangle"></i> Hesabı Sil</h5>
        </div>
        <div class="card-body">
            <div class="alert alert-warning">
                <i class="bi bi-info-circle"></i> <strong>Dikkat!</strong> Bu işlem geri alınamaz. Hesabınız ve tüm verileriniz kalıcı olarak silinecektir.
            </div>
            
            <form method="POST" action="{{ route('admin.account.destroy') }}" id="deleteAccountForm">
                @csrf
                @method('DELETE')
                
                <div class="mb-3">
                    <label for="delete_password" class="form-label">Şifre Doğrulama <span class="text-danger">*</span></label>
                    <input type="password" class="form-control" id="delete_password" name="password" required placeholder="Hesap şifrenizi giriniz">
                </div>
                
                <div class="mb-3">
                    <label for="delete_phone" class="form-label">Telefon Numarası</label>
                    <div class="input-group">
                        <input type="tel" class="form-control" id="delete_phone" value="{{ $user->phone }}" readonly>
                        <button type="button" class="btn btn-outline-danger" id="sendDeleteOtpBtn" onclick="sendDeleteOtp()">
                            <i class="bi bi-send"></i> Kod Gönder
                        </button>
                    </div>
                    <small class="text-muted" id="deleteOtpStatus"></small>
                </div>
                
                <div class="mb-3" id="deleteOtpField" style="display: none;">
                    <label for="delete_otp_code" class="form-label">Doğrulama Kodu <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="delete_otp_code" name="otp_code" maxlength="6" placeholder="6 haneli kod" required>
                    <small class="text-muted">Telefonunuza gönderilen 6 haneli kodu giriniz.</small>
                    @error('otp_code')
                        <div class="text-danger small">{{ $message }}</div>
                    @enderror
                </div>
                
                <button type="button" class="btn btn-danger" onclick="confirmDelete()">
                    <i class="bi bi-trash"></i> Hesabı Kalıcı Olarak Sil
                </button>
            </form>
        </div>
    </div>
    
    <!-- Silme Onay Modalı -->
    <div class="modal fade" id="confirmDeleteModal" tabindex="-1" aria-labelledby="confirmDeleteModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title" id="confirmDeleteModalLabel">
                        <i class="bi bi-exclamation-triangle"></i> Son Onay
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p class="mb-3">
                        <strong>Hesabınızı silmek istediğinize emin misiniz?</strong>
                    </p>
                    <div class="alert alert-danger mb-0">
                        <i class="bi bi-info-circle"></i> Bu işlem geri alınamaz! Tüm verileriniz kalıcı olarak silinecektir.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="bi bi-x"></i> İptal
                    </button>
                    <button type="button" class="btn btn-danger" onclick="submitDeleteForm()">
                        <i class="bi bi-trash"></i> Evet, Hesabı Sil
                    </button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script>
    // OTP gönderme fonksiyonu
    function sendDeleteOtp() {
        const sendBtn = document.getElementById('sendDeleteOtpBtn');
        const otpStatus = document.getElementById('deleteOtpStatus');
        const otpField = document.getElementById('deleteOtpField');
        
        // Butonu devre dışı bırak
        sendBtn.disabled = true;
        sendBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Gönderiliyor...';
        otpStatus.textContent = '';
        
        // AJAX isteği
        fetch('{{ route("admin.account.send-delete-otp") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                otpStatus.textContent = 'Doğrulama kodu gönderildi. Lütfen telefonunuzu kontrol edin.';
                otpStatus.className = 'text-success';
                otpField.style.display = 'block';
                document.getElementById('delete_otp_code').focus();
                
                // 60 saniye geri sayım
                let countdown = 60;
                const interval = setInterval(() => {
                    countdown--;
                    sendBtn.innerHTML = `<i class="bi bi-clock"></i> Tekrar Gönder (${countdown}s)`;
                    if (countdown <= 0) {
                        clearInterval(interval);
                        sendBtn.disabled = false;
                        sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
                    }
                }, 1000);
            } else {
                otpStatus.textContent = data.message || 'OTP gönderilemedi.';
                otpStatus.className = 'text-danger';
                sendBtn.disabled = false;
                sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            otpStatus.textContent = 'Bir hata oluştu.';
            otpStatus.className = 'text-danger';
            sendBtn.disabled = false;
            sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
        });
    }
    
    // OTP kodu sadece rakam girişi
    document.getElementById('delete_otp_code')?.addEventListener('input', function(e) {
        this.value = this.value.replace(/[^0-9]/g, '');
    });
    
    // Silme onayı
    function confirmDelete() {
        const form = document.getElementById('deleteAccountForm');
        const password = document.getElementById('delete_password').value;
        const otpCode = document.getElementById('delete_otp_code').value;
        
        if (!password) {
            alert('Lütfen şifrenizi giriniz.');
            return;
        }
        
        if (!otpCode || otpCode.length !== 6) {
            alert('Lütfen 6 haneli doğrulama kodunu giriniz.');
            return;
        }
        
        const modal = new bootstrap.Modal(document.getElementById('confirmDeleteModal'));
        modal.show();
    }
    
    // Form gönderme
    function submitDeleteForm() {
        document.getElementById('deleteAccountForm').submit();
    }
</script>
@endsection

