@extends('layouts.admin')

@section('title', 'Kalan Bakiyeler')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Kalan Bakiyeler</li>
@endsection

@section('content')
    <h2 class="mb-4">Kalan Bakiyeler</h2>
    
    <div class="card shadow-sm">
        <div class="card-header bg-danger text-white">
            <h5 class="mb-0"><i class="bi bi-exclamation-triangle"></i> Kalan Bakiyeler</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Rezervasyon Kodu</th>
                            <th>Müşteri</th>
                            <th>Tarih</th>
                            <th>Toplam Tutar</th>
                            <th>Ödenen</th>
                            <th>Kalan Bakiye</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($reservations as $reservation)
                            <tr>
                                <td>{{ $reservation->code }}</td>
                                <td>{{ $reservation->customer->name }}</td>
                                <td>{{ $reservation->date->format('d.m.Y') }}</td>
                                <td>{{ number_format($reservation->total_price, 2, ',', '.') }} ₺</td>
                                <td class="text-success">{{ number_format($reservation->deposit_paid ?? 0, 2, ',', '.') }} ₺</td>
                                <td><strong class="text-danger">{{ number_format($reservation->remaining_amount ?? 0, 2, ',', '.') }} ₺</strong></td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center">Kalan bakiye bulunamadı.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="mt-3">
                {{ $reservations->links() }}
            </div>
        </div>
    </div>
@endsection

