@extends('layouts.admin')

@section('title', 'Cariler')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Cariler</li>
@endsection

@section('content')
    <h2 class="mb-4">Cariler</h2>
    
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-people"></i> Cari Hesaplar</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Müşteri Adı</th>
                            <th>Telefon</th>
                            <th>E-posta</th>
                            <th>Rezervasyon Sayısı</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($customers as $customer)
                            <tr>
                                <td><strong>{{ $customer->name }}</strong></td>
                                <td>{{ $customer->phone }}</td>
                                <td>{{ $customer->email }}</td>
                                <td><span class="badge bg-info">{{ $customer->reservations_count }}</span></td>
                                <td>
                                    <a href="{{ route('admin.accounting.customer-detail', $customer->id) }}" class="btn btn-sm btn-info">
                                        <i class="bi bi-eye"></i> Detay
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center">Cari bulunamadı.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="mt-3">
                {{ $customers->links() }}
            </div>
        </div>
    </div>
@endsection

