@extends('layouts.admin')

@section('title', 'Rezervasyon Gelirleri')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Rezervasyon Gelirleri</li>
@endsection

@section('content')
    <h2 class="mb-4">Rezervasyon Gelirleri</h2>
    
    <div class="card shadow-sm">
        <div class="card-header bg-success text-white">
            <h5 class="mb-0"><i class="bi bi-cash-coin"></i> Rezervasyon Gelirleri</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Rezervasyon Kodu</th>
                            <th>Müşteri</th>
                            <th>Tarih</th>
                            <th>Salon</th>
                            <th>Toplam Tutar</th>
                            <th>Ödenen</th>
                            <th>Kalan</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($reservations as $reservation)
                            <tr>
                                <td>{{ $reservation->code }}</td>
                                <td>{{ $reservation->customer->name }}</td>
                                <td>{{ $reservation->date->format('d.m.Y') }}</td>
                                <td>{{ $reservation->salon->name }}</td>
                                <td><strong>{{ number_format($reservation->total_price, 2) }} ₺</strong></td>
                                <td class="text-success">{{ number_format($reservation->deposit_paid, 2) }} ₺</td>
                                <td class="text-danger">{{ number_format($reservation->remaining_amount, 2) }} ₺</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center">Rezervasyon bulunamadı.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="mt-3">
                {{ $reservations->links() }}
            </div>
        </div>
    </div>
@endsection

