@extends('layouts.admin')

@section('title', 'Randevu Düzenle')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.appointments.index') }}">Randevu Yönetimi</a></li>
    <li class="breadcrumb-item active">Düzenle</li>
@endsection

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Randevu Düzenle</h2>
        <a href="{{ route('admin.appointments.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Geri
        </a>
    </div>
    
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-pencil-square"></i> Randevu Bilgileri</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.appointments.update', $appointment->id) }}">
                @csrf
                @method('PUT')
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Müşteri</label>
                        <select name="customer_id" class="form-select form-select-lg">
                            <option value="">Seçiniz</option>
                            @foreach($customers as $customer)
                                <option value="{{ $customer->id }}" {{ old('customer_id', $appointment->customer_id) == $customer->id ? 'selected' : '' }}>
                                    {{ $customer->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Atanan Kullanıcı</label>
                        <select name="assigned_user_id" class="form-select form-select-lg">
                            <option value="">Seçiniz</option>
                            @foreach($users as $user)
                                <option value="{{ $user->id }}" {{ old('assigned_user_id', $appointment->assigned_user_id) == $user->id ? 'selected' : '' }}>
                                    {{ $user->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label class="form-label fw-bold">Tarih *</label>
                        <input type="date" name="date" class="form-control form-control-lg" value="{{ old('date', $appointment->date->format('Y-m-d')) }}" required>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label fw-bold">Başlangıç Saati *</label>
                        <input type="time" name="start_time" class="form-control form-control-lg" value="{{ old('start_time', $appointment->start_time) }}" required>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label fw-bold">Bitiş Saati *</label>
                        <input type="time" name="end_time" class="form-control form-control-lg" value="{{ old('end_time', $appointment->end_time) }}" required>
                    </div>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Konu *</label>
                    <input type="text" name="subject" class="form-control form-control-lg" value="{{ old('subject', $appointment->subject) }}" required>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Durum *</label>
                    <select name="status" class="form-select form-select-lg" required>
                        <option value="pending" {{ old('status', $appointment->status) == 'pending' ? 'selected' : '' }}>Beklemede</option>
                        <option value="approved" {{ old('status', $appointment->status) == 'approved' ? 'selected' : '' }}>Onaylandı</option>
                        <option value="cancelled" {{ old('status', $appointment->status) == 'cancelled' ? 'selected' : '' }}>İptal</option>
                    </select>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Notlar</label>
                    <textarea name="notes" class="form-control" rows="4">{{ old('notes', $appointment->notes) }}</textarea>
                </div>
                
                <div class="d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.appointments.index') }}" class="btn btn-lg btn-secondary">
                        <i class="bi bi-x-circle"></i> İptal
                    </a>
                    <button type="submit" class="btn btn-lg btn-primary">
                        <i class="bi bi-check-circle"></i> Güncelle
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection

