@extends('layouts.admin')

@section('title', 'Randevu Yönetimi')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Randevu Yönetimi</li>
@endsection

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Randevu Yönetimi</h2>
        <button type="button" class="btn btn-primary" onclick="openNewAppointmentModal()">
            <i class="bi bi-plus-circle"></i> Yeni Randevu
        </button>
    </div>
    
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Tarih</th>
                            <th>Saat</th>
                            <th>Konu</th>
                            <th>Müşteri</th>
                            <th>Durum</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($appointments as $appointment)
                            <tr>
                                <td>{{ $appointment->date->format('d.m.Y') }}</td>
                                <td>{{ $appointment->start_time }} - {{ $appointment->end_time }}</td>
                                <td>{{ $appointment->subject }}</td>
                                <td>{{ $appointment->customer->name ?? '-' }}</td>
                                <td>
                                    @if($appointment->status == 'pending')
                                        <span class="badge bg-warning">Beklemede</span>
                                    @elseif($appointment->status == 'approved')
                                        <span class="badge bg-success">Onaylandı</span>
                                    @else
                                        <span class="badge bg-danger">İptal</span>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('admin.appointments.edit', $appointment->id) }}" class="btn btn-sm btn-warning">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <form action="{{ route('admin.appointments.destroy', $appointment->id) }}" method="POST" class="d-inline delete-form" data-message="Bu randevuyu silmek istediğinize emin misiniz?">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center">Randevu bulunamadı.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="mt-3">
                {{ $appointments->links() }}
            </div>
        </div>
    </div>
@endsection

