@extends('layouts.admin')

@section('title', 'Yeni Kişi Ekle')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.contacts.index') }}">Telefon Rehberi</a></li>
    <li class="breadcrumb-item active">Yeni Kişi</li>
@endsection

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Yeni Kişi Ekle</h2>
        <a href="{{ route('admin.contacts.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Geri
        </a>
    </div>
    
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-person-plus"></i> Kişi Bilgileri</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.contacts.store') }}">
                @csrf
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Ad Soyad *</label>
                        <input type="text" name="name" class="form-control form-control-lg" value="{{ old('name') }}" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Tip *</label>
                        <select name="type" class="form-select form-select-lg" required>
                            <option value="customer" {{ old('type') == 'customer' ? 'selected' : '' }}>Müşteri</option>
                            <option value="supplier" {{ old('type') == 'supplier' ? 'selected' : '' }}>Tedarikçi</option>
                            <option value="other" {{ old('type') == 'other' ? 'selected' : '' }}>Diğer</option>
                        </select>
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Telefon</label>
                        <input type="text" name="phone" class="form-control form-control-lg" value="{{ old('phone') }}">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-bold">E-posta</label>
                        <input type="email" name="email" class="form-control form-control-lg" value="{{ old('email') }}">
                    </div>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Notlar</label>
                    <textarea name="notes" class="form-control" rows="4">{{ old('notes') }}</textarea>
                </div>
                
                <div class="d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.contacts.index') }}" class="btn btn-lg btn-secondary">
                        <i class="bi bi-x-circle"></i> İptal
                    </a>
                    <button type="submit" class="btn btn-lg btn-primary">
                        <i class="bi bi-check-circle"></i> Kaydet
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection

