@extends('layouts.admin')

@section('title', 'Telefon Rehberi')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Telefon Rehberi</li>
@endsection

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Telefon Rehberi</h2>
        <button type="button" class="btn btn-primary" onclick="openNewContactModal()">
            <i class="bi bi-plus-circle"></i> Yeni Kişi Ekle
        </button>
    </div>
    
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Ad</th>
                            <th>Telefon</th>
                            <th>E-posta</th>
                            <th>Tip</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($contacts as $contact)
                            <tr>
                                <td>{{ $contact->name }}</td>
                                <td>{{ $contact->phone }}</td>
                                <td>{{ $contact->email }}</td>
                                <td>
                                    @if($contact->type == 'customer')
                                        <span class="badge bg-primary">Müşteri</span>
                                    @elseif($contact->type == 'supplier')
                                        <span class="badge bg-success">Tedarikçi</span>
                                    @else
                                        <span class="badge bg-secondary">Diğer</span>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('admin.contacts.edit', $contact->id) }}" class="btn btn-sm btn-warning">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <form action="{{ route('admin.contacts.destroy', $contact->id) }}" method="POST" class="d-inline delete-form" data-message="Bu kişiyi silmek istediğinize emin misiniz?">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center">Kişi bulunamadı.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="mt-3">
                {{ $contacts->links() }}
            </div>
        </div>
    </div>
@endsection

