<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Rezervasyon Sözleşmesi - {{ $reservation->code ?? $reservation->id }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'dejavu sans', Arial, sans-serif;
            font-size: 11px;
            color: #1e293b;
            background: white;
            padding: 30px;
            line-height: 1.7;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 3px solid #1e40af;
        }
        .logo {
            max-width: 150px;
            max-height: 70px;
            object-fit: contain;
        }
        .address {
            font-size: 10px;
            color: #475569;
            margin-top: 8px;
            line-height: 1.5;
        }
        .contract-title {
            font-size: 22px;
            font-weight: bold;
            color: #1e40af;
            text-align: center;
            margin: 25px 0;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        .contract-subtitle {
            font-size: 13px;
            color: #64748b;
            text-align: center;
            margin-bottom: 30px;
            font-style: italic;
        }
        .section {
            margin-bottom: 25px;
        }
        .section-title {
            font-size: 13px;
            font-weight: bold;
            color: #1e40af;
            margin-bottom: 12px;
            padding-bottom: 5px;
            border-bottom: 2px solid #e2e8f0;
        }
        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin: 15px 0;
            font-size: 11px;
        }
        .info-table td {
            padding: 8px 12px;
            border: 1px solid #e2e8f0;
        }
        .info-table td:first-child {
            background-color: #f1f5f9;
            font-weight: 600;
            width: 35%;
            color: #475569;
        }
        .info-table td:last-child {
            background-color: #ffffff;
            color: #1e293b;
        }
        .terms-section {
            background-color: #f8fafc;
            padding: 15px;
            border-left: 4px solid #1e40af;
            margin: 20px 0;
            border-radius: 4px;
        }
        .terms-list {
            margin-left: 20px;
            margin-top: 10px;
        }
        .terms-list li {
            margin-bottom: 8px;
            line-height: 1.6;
        }
        .price-box {
            background: linear-gradient(135deg, #eff6ff 0%, #dbeafe 100%);
            padding: 15px;
            border-radius: 6px;
            margin: 20px 0;
            border: 2px solid #3b82f6;
        }
        .price-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
            font-size: 11px;
        }
        .price-row:last-child {
            margin-bottom: 0;
            margin-top: 10px;
            padding-top: 10px;
            border-top: 2px solid #3b82f6;
            font-weight: bold;
            font-size: 13px;
        }
        .signature-section {
            margin-top: 50px;
            display: flex;
            justify-content: space-between;
            page-break-inside: avoid;
        }
        .signature-box {
            width: 45%;
            text-align: center;
        }
        .signature-line {
            border-top: 2px solid #1e293b;
            margin-top: 60px;
            padding-top: 8px;
            font-size: 10px;
        }
        .signature-name {
            font-weight: bold;
            margin-bottom: 5px;
            color: #1e293b;
        }
        .signature-label {
            color: #64748b;
            font-size: 9px;
        }
        .footer-note {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #e2e8f0;
            font-size: 9px;
            color: #64748b;
            text-align: center;
            font-style: italic;
        }
        .highlight {
            background-color: #fef3c7;
            padding: 2px 4px;
            border-radius: 3px;
            font-weight: 600;
        }
    </style>
</head>
<body>
    <div class="header">
        <div>
            @if(isset($logo) && $logo)
                <img src="{{ public_path('storage/' . $logo) }}" alt="Logo" class="logo">
            @endif
            @if(isset($address) && $address)
                <div class="address">{{ $address }}</div>
            @endif
        </div>
        <div style="text-align: right;">
            <div style="font-size: 10px; color: #64748b; margin-bottom: 5px;">
                Sözleşme Tarihi
            </div>
            <div style="font-size: 12px; font-weight: 600; color: #1e293b;">
                {{ now()->format('d.m.Y') }}
            </div>
        </div>
    </div>
    
    <div class="contract-title">REZERVASYON SÖZLEŞMESİ</div>
    <div class="contract-subtitle">{{ $reservation->salon->name }} - Rezervasyon Anlaşması</div>
    
    <div class="section">
        <div class="section-title">1. TARAFLAR</div>
        <table class="info-table">
            <tr>
                <td>İşletme Adı:</td>
                <td><strong>{{ $reservation->salon->name }}</strong></td>
            </tr>
            @if(isset($address) && $address)
            <tr>
                <td>İşletme Adresi:</td>
                <td>{{ $address }}</td>
            </tr>
            @endif
            <tr>
                <td>Müşteri Adı:</td>
                <td><strong>{{ $reservation->customer->name }}</strong></td>
            </tr>
            @if($reservation->customer->phone)
            <tr>
                <td>Müşteri Telefonu:</td>
                <td>{{ $reservation->customer->phone }}</td>
            </tr>
            @endif
        </table>
    </div>
    
    <div class="section">
        <div class="section-title">2. REZERVASYON BİLGİLERİ</div>
        <table class="info-table">
            <tr>
                <td>Rezervasyon Kodu:</td>
                <td><span class="highlight">{{ $reservation->code ?? 'REZ-' . $reservation->id }}</span></td>
            </tr>
            <tr>
                <td>Rezervasyon Tarihi:</td>
                <td><strong>{{ $reservation->date->format('d.m.Y') }}</strong></td>
            </tr>
            <tr>
                <td>Rezervasyon Saati:</td>
                <td><strong>{{ $reservation->start_time }} - {{ $reservation->end_time }}</strong></td>
            </tr>
            <tr>
                <td>Salon:</td>
                <td><strong>{{ $reservation->salon->name }}</strong></td>
            </tr>
            @if($reservation->salon->address)
            <tr>
                <td>Salon Adresi:</td>
                <td>{{ $reservation->salon->address }}</td>
            </tr>
            @endif
            <tr>
                <td>Misafir Sayısı:</td>
                <td><strong>{{ $reservation->guest_count ?? 1 }} kişi</strong></td>
            </tr>
        </table>
    </div>
    
    <div class="section">
        <div class="section-title">3. FİYAT BİLGİLERİ</div>
        <div class="price-box">
            <div class="price-row">
                <span>Toplam Tutar:</span>
                <span>{{ number_format($reservation->total_price, 2, ',', '.') }} ₺</span>
            </div>
            <div class="price-row">
                <span>Alınan Kapora:</span>
                <span style="color: #059669;">{{ number_format($reservation->deposit_paid ?? 0, 2, ',', '.') }} ₺</span>
            </div>
            <div class="price-row">
                <span>Kalan Ödeme:</span>
                <span style="color: #dc2626;">{{ number_format($reservation->remaining_amount ?? ($reservation->total_price - ($reservation->deposit_paid ?? 0)), 2, ',', '.') }} ₺</span>
            </div>
        </div>
    </div>
    
    <div class="section">
        <div class="section-title">4. ŞARTLAR VE KOŞULLAR</div>
        <div class="terms-section">
            <ol class="terms-list">
                <li><strong>Rezervasyon Onayı:</strong> Bu sözleşme, {{ $reservation->salon->name }} ile {{ $reservation->customer->name }} arasında yapılmış olup, taraflar yukarıda belirtilen rezervasyon koşullarını kabul etmişlerdir.</li>
                
                <li><strong>Ödeme Koşulları:</strong> Rezervasyon için belirtilen kapora tutarı ödenmiştir. Kalan tutar, rezervasyon gününde veya belirlenen tarihte ödenecektir.</li>
                
                <li><strong>İptal ve İade Koşulları:</strong>
                    <ul style="margin-left: 20px; margin-top: 5px;">
                        <li>Rezervasyon iptali en az <strong>48 saat</strong> önceden yapılmalıdır.</li>
                        <li>48 saatten önce yapılan iptallerde kapora tutarı iade edilir.</li>
                        <li>48 saatten sonra yapılan iptallerde kapora iade edilmez.</li>
                        <li>Rezervasyon saatinde gelinmemesi durumunda kapora iade edilmez ve rezervasyon iptal sayılır.</li>
                    </ul>
                </li>
                
                <li><strong>Değişiklik Koşulları:</strong> Rezervasyon tarih ve saat değişiklikleri, en az 24 saat önceden bildirilmesi halinde mümkündür. Değişiklik talepleri, salon müsaitliğine bağlıdır.</li>
                
                <li><strong>Sorumluluklar:</strong>
                    <ul style="margin-left: 20px; margin-top: 5px;">
                        <li>Müşteri, rezervasyon saatinde salonda bulunmakla yükümlüdür.</li>
                        <li>İşletme, rezervasyon saatinde salonu hazır bulundurmakla yükümlüdür.</li>
                        <li>Salon içinde oluşabilecek hasarlardan müşteri sorumludur.</li>
                    </ul>
                </li>
                
                <li><strong>Diğer Hükümler:</strong> Bu sözleşmede belirtilmeyen konularda, taraflar karşılıklı anlaşma ile çözüm bulacaktır. Anlaşmazlık durumunda ilgili mevzuat hükümleri geçerlidir.</li>
            </ol>
        </div>
    </div>
    
    <div class="section">
        <div class="section-title">5. KABUL VE ONAY</div>
        <p style="margin-top: 10px; text-align: justify;">
            Yukarıda belirtilen tüm koşulları okudum, anladım ve kabul ediyorum. Bu sözleşme, taraflar arasında yapılmış olup, yukarıdaki koşulları kabul ettiğimizi gösterir.
        </p>
    </div>
    
    <div class="signature-section">
        <div class="signature-box">
            <div class="signature-line">
                <div class="signature-name">{{ $reservation->customer->name }}</div>
                <div class="signature-label">Müşteri İmzası</div>
            </div>
        </div>
        <div class="signature-box">
            <div class="signature-line">
                <div class="signature-name">{{ $reservation->salon->name }}</div>
                <div class="signature-label">İşletme İmzası / Mühür</div>
            </div>
        </div>
    </div>
    
    <div class="footer-note">
        Bu sözleşme {{ now()->format('d.m.Y H:i') }} tarihinde oluşturulmuştur. Rezervasyon Kodu: {{ $reservation->code ?? 'REZ-' . $reservation->id }}
    </div>
</body>
</html>
