@extends('layouts.admin')

@section('content')
@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show">
        <i class="bi bi-exclamation-circle"></i> {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

@if(isset($error))
    <div class="alert alert-danger alert-dismissible fade show">
        <i class="bi bi-exclamation-circle"></i> {{ $error }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<div class="container-fluid">
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4 gap-2">
        <div>
            <h2 class="fw-bold mb-2" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text;">
                <i class="bi bi-people me-2"></i> Müşteriler
            </h2>
        </div>
        <button type="button" onclick="openNewCustomerModal()" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Yeni Müşteri Ekle
        </button>
    </div>

    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="{{ route('admin.customers.index') }}" class="row g-3">
                <div class="col-md-8">
                    <input type="text" name="search" class="form-control" placeholder="İsim, Telefon veya Email ile ara..." value="{{ request('search') }}">
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="bi bi-search"></i> Ara
                    </button>
                </div>
                <div class="col-md-2">
                    <a href="{{ route('admin.customers.index') }}" class="btn btn-secondary w-100">
                        <i class="bi bi-x-circle"></i> Temizle
                    </a>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-header border-0 d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);">
            <h5 class="mb-0 text-white"><i class="bi bi-list-ul me-2"></i>Müşteri Listesi</h5>
            <form method="GET" action="{{ route('admin.customers.index') }}" class="d-inline-flex align-items-center gap-2">
                @foreach(request()->except('sort', 'page') as $key => $value)
                    <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                @endforeach
                <label class="form-label mb-0 small text-white-50">Sırala:</label>
                <select name="sort" class="form-select form-select-sm" style="width: auto; min-width: 150px; background: rgba(255,255,255,0.2); border: 1px solid rgba(255,255,255,0.3); color: white;" onchange="this.form.submit()">
                    <option value="name_asc" {{ request('sort', 'name_asc') == 'name_asc' ? 'selected' : '' }} style="background: #2563eb; color: white;">A-Z (İsim)</option>
                    <option value="created_desc" {{ request('sort') == 'created_desc' ? 'selected' : '' }} style="background: #2563eb; color: white;">Yeniden Eskiye</option>
                </select>
            </form>
        </div>
        <div class="card-body p-0">
            <!-- Desktop Table -->
            <div class="table-responsive d-none d-md-block">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>Müşteri</th>
                            <th>Kalan Bakiye</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($customers as $index => $customer)
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center gap-3">
                                        <div class="customer-avatar" style="width: 56px; height: 56px; border-radius: 50%; background: linear-gradient(135deg, {{ $customer->avatar_color }} 0%, {{ $customer->avatar_color }}dd 100%); display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 20px; flex-shrink: 0; box-shadow: 0 4px 16px rgba(0,0,0,0.2); transition: all 0.3s ease;">
                                            {{ $customer->initials }}
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="fw-bold text-dark" style="font-size: 16px; margin-bottom: 4px;">{{ $customer->name }}</div>
                                            @if($customer->phone)
                                                <div class="text-muted" style="font-size: 14px;">
                                                    <i class="bi bi-telephone me-1"></i>{{ $customer->phone }}
                                                </div>
                                            @else
                                                <div class="text-muted" style="font-size: 14px;">
                                                    <i class="bi bi-telephone me-1"></i>Telefon yok
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    @php
                                        $balance = $customer->balance ?? 0;
                                    @endphp
                                    @if($balance > 0)
                                        <span class="badge bg-warning text-dark">{{ number_format($balance, 2, ',', '.') }} ₺</span>
                                    @elseif($balance < 0)
                                        <span class="badge bg-info">{{ number_format(abs($balance), 2, ',', '.') }} ₺</span>
                                    @else
                                        <span class="badge bg-success">0,00 ₺</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('admin.customers.show', $customer->id) }}" class="btn btn-sm btn-info">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.customers.edit', $customer->id) }}" class="btn btn-sm btn-primary">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <button type="button" class="btn btn-sm btn-danger" onclick="confirmDelete({{ $customer->id }}, '{{ $customer->name }}')">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="3" class="text-center text-muted py-5">
                                    <i class="bi bi-inbox" style="font-size: 48px; display: block; margin-bottom: 16px; opacity: 0.5;"></i>
                                    <p class="mb-0">Henüz müşteri eklenmemiş.</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <!-- Mobile Cards -->
            <div class="d-md-none">
                @forelse($customers as $index => $customer)
                    @php
                        $balance = $customer->balance ?? 0;
                    @endphp
                    <div class="card mb-3 mx-3 mt-3 border-start border-4" style="border-left-color: {{ $customer->avatar_color ?? '#2563eb' }};">
                        <div class="card-body">
                            <div class="d-flex align-items-start gap-3 mb-3">
                                <div class="customer-avatar" style="width: 56px; height: 56px; border-radius: 50%; background: linear-gradient(135deg, {{ $customer->avatar_color }} 0%, {{ $customer->avatar_color }}dd 100%); display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 20px; flex-shrink: 0; box-shadow: 0 4px 16px rgba(0,0,0,0.2);">
                                    {{ $customer->initials }}
                                </div>
                                <div class="flex-grow-1">
                                    <h6 class="fw-bold mb-1">{{ $customer->name }}</h6>
                                    @if($customer->phone)
                                        <small class="text-muted d-block">
                                            <i class="bi bi-telephone me-1"></i>{{ $customer->phone }}
                                        </small>
                                    @else
                                        <small class="text-muted d-block">
                                            <i class="bi bi-telephone me-1"></i>Telefon yok
                                        </small>
                                    @endif
                                </div>
                            </div>
                            
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <span class="text-muted small">Kalan Bakiye:</span>
                                @if($balance > 0)
                                    <span class="badge bg-warning text-dark">{{ number_format($balance, 2, ',', '.') }} ₺</span>
                                @elseif($balance < 0)
                                    <span class="badge bg-info">{{ number_format(abs($balance), 2, ',', '.') }} ₺</span>
                                @else
                                    <span class="badge bg-success">0,00 ₺</span>
                                @endif
                            </div>
                            
                            <div class="d-flex gap-2">
                                <a href="{{ route('admin.customers.show', $customer->id) }}" class="btn btn-sm btn-info flex-fill">
                                    <i class="bi bi-eye"></i> Görüntüle
                                </a>
                                <a href="{{ route('admin.customers.edit', $customer->id) }}" class="btn btn-sm btn-primary">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <button type="button" class="btn btn-sm btn-danger" onclick="confirmDelete({{ $customer->id }}, '{{ $customer->name }}')">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="text-center py-5 px-3">
                        <i class="bi bi-inbox" style="font-size: 48px; display: block; margin-bottom: 16px; opacity: 0.5;"></i>
                        <p class="mb-0">Henüz müşteri eklenmemiş.</p>
                    </div>
                @endforelse
            </div>

            <div class="mt-3 px-3 pb-3">
                {{ $customers->links() }}
            </div>
        </div>
    </div>
</div>

<!-- Silme Onay Modalı -->
<div class="modal fade" id="deleteConfirmModal" tabindex="-1" aria-labelledby="deleteConfirmModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title" id="deleteConfirmModalLabel">
                    <i class="bi bi-exclamation-triangle"></i> Müşteri Silme Onayı
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p id="deleteConfirmMessage" class="mb-3"></p>
                <div class="alert alert-warning mb-0">
                    <i class="bi bi-info-circle"></i> Bu işlem geri alınamaz! Müşterinin tüm verileri silinecektir.
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="bi bi-x"></i> İptal
                </button>
                <form id="deleteConfirmForm" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">
                        <i class="bi bi-trash"></i> Evet, Sil
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
function confirmDelete(id, name) {
    const modalElement = document.getElementById('deleteConfirmModal');
    if (!modalElement) {
        console.error('deleteConfirmModal bulunamadı');
        return;
    }
    
    const modal = new bootstrap.Modal(modalElement);
    const form = document.getElementById('deleteConfirmForm');
    const message = document.getElementById('deleteConfirmMessage');
    
    message.textContent = `"${name}" adlı müşteriyi silmek istediğinizden emin misiniz?`;
    form.action = `{{ url('admin/musteriler') }}/${id}`;
    
    modal.show();
}
</script>
@endpush
@endsection

