@extends('layouts.admin')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="fw-bold text-primary">
            <i class="bi bi-person"></i> Müşteri Detayı: {{ $customer->name }}
        </h2>
        <div class="d-flex gap-2">
            <button type="button" class="btn btn-success" onclick="openCustomerPaymentModal()">
                <i class="bi bi-cash-coin"></i> Ödeme Yap
            </button>
            <a href="{{ route('admin.customers.edit', $customer->id) }}" class="btn btn-primary">
                <i class="bi bi-pencil"></i> Düzenle
            </a>
            <a href="{{ route('admin.customers.index') }}" class="btn btn-secondary">
                <i class="bi bi-arrow-left"></i> Geri Dön
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="card shadow-sm mb-4">
                <div class="card-body text-center">
                    <div class="customer-avatar mx-auto mb-3" style="width: 100px; height: 100px; border-radius: 50%; background: {{ $customer->avatar_color }}; display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 36px; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">
                        {{ $customer->initials }}
                    </div>
                    <h4 class="card-title mb-3">{{ $customer->name }}</h4>
                    <hr>
                    <div class="text-start">
                    <p><strong>İsim:</strong> {{ $customer->name }}</p>
                    <p><strong>Telefon:</strong> {{ $customer->phone ?? '-' }}</p>
                    <p><strong>Email:</strong> {{ $customer->email ?? '-' }}</p>
                    <p><strong>Bakiye:</strong> 
                        @if($customer->balance > 0)
                            <span class="badge bg-warning text-dark">{{ number_format($customer->balance, 2, ',', '.') }} ₺</span>
                        @elseif($customer->balance < 0)
                            <span class="badge bg-info">{{ number_format(abs($customer->balance), 2, ',', '.') }} ₺</span>
                        @else
                            <span class="badge bg-success">0,00 ₺</span>
                        @endif
                    </p>
                    @if($customer->birth_date)
                        <p><strong>Doğum Tarihi:</strong> {{ $customer->birth_date->format('d.m.Y') }}</p>
                    @endif
                    @if($customer->address)
                        <p><strong>Adres:</strong> {{ $customer->address }}</p>
                    @endif
                    </div>
                    @if($customer->notes)
                        <p><strong>Notlar:</strong> {{ $customer->notes }}</p>
                    @endif
                </div>
            </div>

            <div class="card shadow-sm mb-4">
                <div class="card-body">
                    <h5 class="card-title">İstatistikler</h5>
                    <hr>
                    <p><strong>Toplam Rezervasyon:</strong> <span class="badge bg-primary">{{ $totalReservations }}</span></p>
                    <p><strong>Toplam Tutar:</strong> <span class="badge bg-success">{{ number_format($totalAmount, 2, ',', '.') }} ₺</span></p>
                    <p><strong>Ödenen:</strong> <span class="badge bg-info">{{ number_format($totalPaid, 2, ',', '.') }} ₺</span></p>
                    <p><strong>Kalan:</strong> <span class="badge bg-warning">{{ number_format($totalRemaining, 2, ',', '.') }} ₺</span></p>
                </div>
            </div>

            <div class="card shadow-sm">
                <div class="card-body">
                    <h5 class="card-title">Kalan Bakiyeler</h5>
                    <hr>
                    @php
                        $reservationsWithBalance = $customer->reservations->filter(function($r) {
                            return $r->remaining_amount > 0 && $r->status != 'cancelled';
                        });
                    @endphp
                    @if($reservationsWithBalance->count() > 0)
                        <div class="list-group">
                            @foreach($reservationsWithBalance as $reservation)
                                <div class="list-group-item d-flex justify-content-between align-items-center">
                                    <div>
                                        <strong>{{ $reservation->date->format('d.m.Y') }}</strong> - {{ $reservation->salon->name ?? '-' }}
                                        <br>
                                        <small class="text-muted">{{ $reservation->start_time }} - {{ $reservation->end_time }}</small>
                                    </div>
                                    <span class="badge bg-warning">{{ number_format($reservation->remaining_amount, 2, ',', '.') }} ₺</span>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <p class="text-muted mb-0">Kalan bakiye bulunmamaktadır.</p>
                    @endif
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5 class="card-title">Rezervasyonlar</h5>
                    <hr>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Tarih</th>
                                    <th>Salon</th>
                                    <th>Menü</th>
                                    <th>Tutar</th>
                                    <th>Ödenen</th>
                                    <th>Durum</th>
                                    <th>İşlem</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($customer->reservations as $reservation)
                                    <tr>
                                        <td>{{ $reservation->date->format('d.m.Y') }}</td>
                                        <td>{{ $reservation->salon->name ?? '-' }}</td>
                                        <td>{{ $reservation->menu->name ?? '-' }}</td>
                                        <td>{{ number_format($reservation->total_price, 2, ',', '.') }} ₺</td>
                                        <td>{{ number_format($reservation->deposit_paid, 2, ',', '.') }} ₺</td>
                                        <td>
                                            @if($reservation->status == 'confirmed')
                                                <span class="badge bg-success">Onaylandı</span>
                                            @elseif($reservation->status == 'open')
                                                <span class="badge bg-warning">Açık</span>
                                            @elseif($reservation->status == 'cancelled')
                                                <span class="badge bg-danger">İptal</span>
                                            @else
                                                <span class="badge bg-info">Tamamlandı</span>
                                            @endif
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.rezervasyonlar.show', $reservation->id) }}" class="btn btn-sm btn-info">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center text-muted py-4">
                                            <i class="bi bi-inbox"></i> Henüz rezervasyon yok.
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Müşteri Hesap Bordosu -->
            <div class="card shadow-sm mt-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="card-title mb-0">
                            <i class="bi bi-receipt"></i> Hesap Bordosu
                        </h5>
                        <div>
                            @php
                                $totalIncome = $transactions->where('type', 'income')->sum('amount');
                                $totalExpense = $transactions->where('type', 'expense')->sum('amount');
                            @endphp
                            <span class="badge bg-success me-2">Toplam Tahsilat: {{ number_format($totalIncome, 2, ',', '.') }} ₺</span>
                            <span class="badge bg-danger">Toplam Gider: {{ number_format($totalExpense, 2, ',', '.') }} ₺</span>
                        </div>
                    </div>
                    <hr>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Tarih</th>
                                    <th>Açıklama</th>
                                    <th>Tür</th>
                                    <th>Tutar</th>
                                    <th>Kalan Borç</th>
                                    <th>Bakiye Etkisi</th>
                                    <th>Rezervasyon</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($transactions as $transaction)
                                    <tr>
                                        <td>{{ $transaction->date ? \Carbon\Carbon::parse($transaction->date)->format('d.m.Y') : ($transaction->created_at ? $transaction->created_at->format('d.m.Y') : '-') }}</td>
                                        <td>{{ $transaction->description ?? '-' }}</td>
                                        <td>
                                            @if($transaction->type == 'income')
                                                <span class="badge bg-success">
                                                    <i class="bi bi-arrow-down-circle"></i> Tahsilat
                                                </span>
                                            @elseif($transaction->type == 'expense')
                                                <span class="badge bg-danger">
                                                    <i class="bi bi-arrow-up-circle"></i> Gider
                                                </span>
                                            @else
                                                <span class="badge bg-info">{{ ucfirst($transaction->type) }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <strong>{{ number_format($transaction->amount, 2, ',', '.') }} ₺</strong>
                                        </td>
                                        <td>
                                            @if($transaction->type == 'income' && isset($transaction->remaining_debt_after))
                                                <span class="badge bg-warning text-dark">
                                                    <i class="bi bi-cash-coin"></i> {{ number_format($transaction->remaining_debt_after, 2, ',', '.') }} ₺
                                                </span>
                                                <br>
                                                <small class="text-muted"><i class="bi bi-info-circle"></i> Bu ödemeden sonra kalan borç</small>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($transaction->type == 'income')
                                                <span class="text-success"><i class="bi bi-dash-circle"></i> Borç düştü</span>
                                            @else
                                                <span class="text-danger"><i class="bi bi-plus-circle"></i> Borç eklendi</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($transaction->reservation)
                                                <a href="{{ route('admin.rezervasyonlar.show', $transaction->reservation_id) }}" class="btn btn-sm btn-outline-primary">
                                                    <i class="bi bi-eye"></i> Görüntüle
                                                </a>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center text-muted py-4">
                                            <i class="bi bi-inbox"></i> Henüz işlem kaydı bulunmamaktadır.
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Müşteri Ödeme Modal -->
<div class="modal fade" id="customerPaymentModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title"><i class="bi bi-cash-coin"></i> Müşteriye Ödeme Ekle</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.accounting.cashbox.income.store') }}" method="POST">
                @csrf
                <input type="hidden" name="customer_id" value="{{ $customer->id }}">
                <div class="modal-body">
                    <div class="alert alert-info">
                        <strong>Müşteri:</strong> {{ $customer->name }}<br>
                        <strong>Kalan Bakiye:</strong> {{ number_format($totalRemaining, 2, ',', '.') }} ₺
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Ödeme Tutarı <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <input type="number" name="amount" id="customerPaymentAmount" class="form-control" step="0.01" min="0" value="{{ $totalRemaining > 0 ? $totalRemaining : 0 }}" required>
                            <span class="input-group-text">₺</span>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Tarih <span class="text-danger">*</span></label>
                        <input type="date" name="date" class="form-control" value="{{ date('Y-m-d') }}" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Açıklama</label>
                        <input type="text" name="description" class="form-control" value="Müşteri Ödemesi - {{ $customer->name }}">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-success">
                        <i class="bi bi-check-circle"></i> Ödemeyi Kaydet
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function openCustomerPaymentModal() {
    const modal = new bootstrap.Modal(document.getElementById('customerPaymentModal'));
    modal.show();
}
</script>
@endpush

