@extends('layouts.admin')

@section('title', 'Dashboard')

@section('content')
<!-- Loading Skeleton -->
<div id="dashboardLoader" class="dashboard-loader">
    <div class="loader-content">
        <div class="loader-spinner">
            <div class="spinner-ring"></div>
        </div>
        <p class="loader-text">Anasayfa yükleniyor...</p>
    </div>
</div>

<!-- Dashboard Content -->
<div id="dashboardContent" style="display: none; position: relative; z-index: 1;">

<!-- Modern Header Section -->
<div class="dashboard-header mb-4">
    <div class="row align-items-center">
        <div class="col-12 col-md-8">
            <div class="d-flex align-items-center gap-3">
                @php
                    $hour = \Carbon\Carbon::now()->setTimezone('Europe/Istanbul')->hour;
                    if ($hour >= 5 && $hour < 12) {
                        $greeting = 'Günaydın';
                        $icon = 'bi bi-sunrise';
                        $gradient = 'linear-gradient(135deg, #f093fb 0%, #f5576c 100%)';
                    } elseif ($hour >= 12 && $hour < 17) {
                        $greeting = 'Tünaydın';
                        $icon = 'bi bi-sun';
                        $gradient = 'linear-gradient(135deg, #4facfe 0%, #00f2fe 100%)';
                    } elseif ($hour >= 17 && $hour < 22) {
                        $greeting = 'İyi Akşamlar';
                        $icon = 'bi bi-moon';
                        $gradient = 'linear-gradient(135deg, #2563eb 0%, #1e40af 100%)';
                    } else {
                        $greeting = 'İyi Geceler';
                        $icon = 'bi bi-moon-stars';
                        $gradient = 'linear-gradient(135deg, #1e3c72 0%, #2a5298 100%)';
                    }
                @endphp
                <div class="greeting-icon" style="background: {{ $gradient }};">
                    <i class="{{ $icon }}"></i>
                </div>
                <div>
                    <h1 class="dashboard-title">{{ $greeting }}, <span class="highlight-name">{{ Auth::user()->name }}</span>!</h1>
                    <p class="dashboard-subtitle">
                        <i class="bi bi-calendar3 me-1"></i>
                        {{ \Carbon\Carbon::now()->setTimezone('Europe/Istanbul')->locale('tr')->isoFormat('D MMMM YYYY, dddd') }}
                    </p>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-4 mt-3 mt-md-0">
            <div class="quick-actions-header">
                <a href="{{ route('admin.rezervasyonlar.index') }}" class="quick-action-btn glass-effect">
                    <i class="bi bi-calendar-check"></i>
                    <span>Rezervasyonlar</span>
                </a>
                <button type="button" id="newReservationBtn" class="quick-action-btn btn-new-reservation">
                    <i class="bi bi-plus-circle"></i>
                    <span>Yeni Rezervasyon</span>
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Hızlı Erişim - Kompakt Kısayollar -->
<div class="dashboard-card mb-4">
    <div class="card-header-modern">
        <h5 class="card-title-modern">
            <i class="bi bi-lightning-charge me-2"></i>
            Hızlı Erişim
        </h5>
    </div>
    <div class="card-body-modern py-3">
        <div class="row g-2 quick-access-row" style="display: flex !important; flex-wrap: wrap !important; flex-direction: row !important; margin-left: -4px !important; margin-right: -4px !important;">
            <div class="col-6 col-md-4 col-lg-2 quick-access-item" style="flex: 0 0 50% !important; max-width: 50% !important; width: 50% !important; padding-left: 4px !important; padding-right: 4px !important; box-sizing: border-box !important;">
                <a href="{{ route('admin.rezervasyonlar.index') }}" class="text-decoration-none">
                    <div class="quick-access-card-compact" style="cursor: pointer;">
                        <div class="quick-access-icon-compact" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);">
                            <i class="bi bi-calendar-check"></i>
                        </div>
                        <div class="quick-access-label-compact">Rezervasyonlar</div>
                    </div>
                </a>
            </div>
            <div class="col-6 col-md-4 col-lg-2 quick-access-item" style="flex: 0 0 50% !important; max-width: 50% !important; width: 50% !important; padding-left: 4px !important; padding-right: 4px !important; box-sizing: border-box !important;">
                <a href="{{ route('admin.reservations.calendar') }}" class="text-decoration-none">
                    <div class="quick-access-card-compact" style="cursor: pointer;">
                        <div class="quick-access-icon-compact" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%);">
                            <i class="bi bi-calendar-heart"></i>
                        </div>
                        <div class="quick-access-label-compact">Takvim</div>
                    </div>
                </a>
            </div>
            <div class="col-6 col-md-4 col-lg-2 quick-access-item" style="flex: 0 0 50% !important; max-width: 50% !important; width: 50% !important; padding-left: 4px !important; padding-right: 4px !important; box-sizing: border-box !important;">
                <a href="{{ route('admin.customers.index') }}" class="text-decoration-none">
                    <div class="quick-access-card-compact" style="cursor: pointer;">
                        <div class="quick-access-icon-compact" style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);">
                            <i class="bi bi-people"></i>
                        </div>
                        <div class="quick-access-label-compact">Müşteriler</div>
                    </div>
                </a>
            </div>
            <div class="col-6 col-md-4 col-lg-2 quick-access-item" style="flex: 0 0 50% !important; max-width: 50% !important; width: 50% !important; padding-left: 4px !important; padding-right: 4px !important; box-sizing: border-box !important;">
                <a href="{{ route('admin.accounting.cashbox') }}" class="text-decoration-none">
                    <div class="quick-access-card-compact" style="cursor: pointer;">
                        <div class="quick-access-icon-compact" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);">
                            <i class="bi bi-cash-stack"></i>
                        </div>
                        <div class="quick-access-label-compact">Kasa</div>
                    </div>
                </a>
            </div>
            <div class="col-6 col-md-4 col-lg-2 quick-access-item" style="flex: 0 0 50% !important; max-width: 50% !important; width: 50% !important; padding-left: 4px !important; padding-right: 4px !important; box-sizing: border-box !important;">
                <a href="{{ route('admin.settings.general') }}" class="text-decoration-none">
                    <div class="quick-access-card-compact" style="cursor: pointer;">
                        <div class="quick-access-icon-compact" style="background: linear-gradient(135deg, #06b6d4 0%, #0891b2 100%);">
                            <i class="bi bi-gear"></i>
                        </div>
                        <div class="quick-access-label-compact">Ayarlar</div>
                    </div>
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Tüm Metrikler - 4x2 Grid (Üstte 4, Altta 4) -->
<div class="row g-3 mb-4">
    <!-- Üst Satır -->
    <div class="col-6 col-md-3 col-lg-3">
        <a href="{{ route('admin.rezervasyonlar.index') }}" class="text-decoration-none">
            <div class="metric-card metric-primary glass-card">
                <div class="metric-icon">
                    <i class="bi bi-calendar-check"></i>
                </div>
                <div class="metric-content">
                    <div class="metric-value">{{ number_format($stats['total_reservations'] ?? 0, 0, ',', '.') }}</div>
                    <div class="metric-label">Toplam Rezervasyon</div>
                    <div class="metric-trend positive">
                        <i class="bi bi-arrow-up"></i>
                        <span>+{{ round(($stats['total_reservations'] ?? 0) * 0.08) }}%</span>
                    </div>
                </div>
            </div>
        </a>
    </div>
    
    <div class="col-6 col-md-3 col-lg-3">
        <a href="{{ route('admin.rezervasyonlar.index') }}" class="text-decoration-none">
            <div class="metric-card metric-success glass-card">
                <div class="metric-icon">
                    <i class="bi bi-calendar-day"></i>
                </div>
                <div class="metric-content">
                    <div class="metric-value">{{ number_format($stats['today_count'] ?? 0, 0, ',', '.') }}</div>
                    <div class="metric-label">Bugünkü Rezervasyon</div>
                    <div class="metric-trend neutral">
                        <i class="bi bi-calendar3"></i>
                        <span>Bugün</span>
                    </div>
                </div>
            </div>
        </a>
    </div>
    
    <div class="col-6 col-md-3 col-lg-3">
        <a href="{{ route('admin.accounting.cashbox') }}" class="text-decoration-none">
            <div class="metric-card metric-info glass-card">
                <div class="metric-icon">
                    <i class="bi bi-cash-coin"></i>
                </div>
                <div class="metric-content">
                    <div class="metric-value">{{ format_currency($monthlyRevenue ?? $stats['month_revenue'] ?? 0, 0) }}</div>
                    <div class="metric-label">Aylık Gelir</div>
                    <div class="metric-trend neutral">
                        <i class="bi bi-calendar-month"></i>
                        <span>Bu Ay</span>
                    </div>
                </div>
            </div>
        </a>
    </div>
    
    <div class="col-6 col-md-3 col-lg-3">
        <a href="{{ route('admin.accounting.cashbox') }}" class="text-decoration-none">
            <div class="metric-card metric-warning glass-card">
                <div class="metric-icon">
                    <i class="bi bi-wallet2"></i>
                </div>
                <div class="metric-content">
                    <div class="metric-value">{{ format_currency($cashBalance ?? 0, 0) }}</div>
                    <div class="metric-label">Kasa Bakiyesi</div>
                    @if(($todayIncome ?? 0) > 0 || ($todayExpense ?? 0) > 0)
                    <div class="metric-sub-info">
                        <span class="income"><i class="bi bi-arrow-up"></i> {{ format_currency($todayIncome ?? 0, 0) }}</span>
                        <span class="expense"><i class="bi bi-arrow-down"></i> {{ format_currency($todayExpense ?? 0, 0) }}</span>
                    </div>
                    @endif
                </div>
            </div>
        </a>
    </div>
    
    <!-- Alt Satır -->
    <div class="col-6 col-md-3 col-lg-3">
        <a href="{{ route('admin.customers.index') }}" class="text-decoration-none">
            <div class="metric-card metric-primary glass-card">
                <div class="metric-icon">
                    <i class="bi bi-people"></i>
                </div>
                <div class="metric-content">
                    <div class="metric-value">{{ number_format($totalCustomers ?? 0, 0, ',', '.') }}</div>
                    <div class="metric-label">Toplam Müşteri</div>
                    <div class="metric-trend neutral">
                        <i class="bi bi-people"></i>
                        <span>Müşteri</span>
                    </div>
                </div>
            </div>
        </a>
    </div>
    
    <div class="col-6 col-md-3 col-lg-3">
        <a href="{{ route('admin.accounting.cashbox') }}" class="text-decoration-none">
            <div class="metric-card metric-info glass-card">
                <div class="metric-icon">
                    <i class="bi bi-cash-stack"></i>
                </div>
                <div class="metric-content">
                    <div class="metric-value">{{ format_currency($totalRevenue ?? 0, 0) }}</div>
                    <div class="metric-label">Toplam Gelir</div>
                    <div class="metric-trend neutral">
                        <i class="bi bi-cash-stack"></i>
                        <span>Toplam</span>
                    </div>
                </div>
            </div>
        </a>
    </div>
    
    <div class="col-6 col-md-3 col-lg-3">
        <a href="{{ route('admin.rezervasyonlar.index') }}" class="text-decoration-none">
            <div class="metric-card metric-primary glass-card">
                <div class="metric-icon">
                    <i class="bi bi-graph-up"></i>
                </div>
                <div class="metric-content">
                    @php
                        $reservationCount = $stats['total_reservations'] ?? 0;
                        $customerCount = $totalCustomers ?? 0;
                        if ($customerCount > 0 && $reservationCount > 0) {
                            $avgReservationsPerCustomer = $reservationCount / $customerCount;
                            if ($avgReservationsPerCustomer <= 0 || $avgReservationsPerCustomer == 1.0) {
                                $avgReservationsPerCustomer = null;
                            }
                        } else {
                            $avgReservationsPerCustomer = null;
                        }
                    @endphp
                    <div class="metric-value">
                        @if($avgReservationsPerCustomer !== null && $avgReservationsPerCustomer > 0)
                            {{ number_format($avgReservationsPerCustomer, 1, ',', '.') }}
                        @else
                            0
                        @endif
                    </div>
                    <div class="metric-label">Ortalama Rezervasyon</div>
                    <div class="metric-trend neutral">
                        <i class="bi bi-graph-up"></i>
                        <span>Ortalama</span>
                    </div>
                </div>
            </div>
        </a>
    </div>
    
    <div class="col-6 col-md-3 col-lg-3">
        <a href="{{ route('admin.rezervasyonlar.index', ['status' => 'open']) }}" class="text-decoration-none">
            <div class="metric-card metric-warning glass-card">
                <div class="metric-icon">
                    <i class="bi bi-clock-history"></i>
                </div>
                <div class="metric-content">
                    <div class="metric-value">{{ format_currency($pendingPayments ?? 0, 0) }}</div>
                    <div class="metric-label">Bekleyen Ödemeler</div>
                    <div class="metric-trend warning">
                        <i class="bi bi-clock-history"></i>
                        <span>Bekliyor</span>
                    </div>
                </div>
            </div>
        </a>
    </div>
</div>

<!-- Ana İçerik Bölümü -->
<div class="row g-4">
    <!-- Sol Kolon - Grafikler ve İstatistikler -->
    <div class="col-12 col-lg-8 col-xl-8">
        <!-- Rezervasyon Tablosu -->
        <a href="{{ route('admin.rezervasyonlar.index') }}" class="text-decoration-none">
            <div class="dashboard-card mb-4 card-primary">
            <div class="card-header-modern">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="card-title-modern">
                            <i class="bi bi-table me-2"></i>
                            Rezervasyon Tablosu
                        </h5>
                        <p class="card-subtitle-modern">Son 12 ay rezervasyon istatistikleri</p>
                    </div>
                    <div class="period-selector">
                            <button type="button" class="period-btn" onclick="changePeriod('1D'); event.stopPropagation();">Gün</button>
                            <button type="button" class="period-btn" onclick="changePeriod('1W'); event.stopPropagation();">Hafta</button>
                            <button type="button" class="period-btn active" onclick="changePeriod('1M'); event.stopPropagation();">Ay</button>
                            <button type="button" class="period-btn" onclick="changePeriod('1Y'); event.stopPropagation();">Yıl</button>
                    </div>
                </div>
            </div>
            <div class="card-body-modern">
                <div class="chart-container">
                    <canvas id="statisticsChart"></canvas>
                </div>
                <div class="chart-summary">
                    <div class="summary-item">
                        <div class="summary-value">{{ $stats['total_reservations'] ?? 0 }}</div>
                        <div class="summary-label">Toplam</div>
                    </div>
                    <div class="summary-item">
                        <div class="summary-value">{{ $stats['confirmed_count'] ?? 0 }}</div>
                        <div class="summary-label">Onaylanan</div>
                    </div>
                    <div class="summary-item">
                        <div class="summary-value">{{ $stats['open_count'] ?? 0 }}</div>
                        <div class="summary-label">Açık</div>
                    </div>
                </div>
            </div>
        </div>
        </a>

        <!-- Gelir Tablosu (Aylık) - Genişletilmiş -->
        <div class="row g-4 mb-4">
            <div class="col-12">
                <a href="{{ route('admin.accounting.cashbox') }}" class="text-decoration-none">
                    <div class="dashboard-card h-100 card-info">
                    <div class="card-header-modern">
                        <h5 class="card-title-modern">
                            <i class="bi bi-table me-2"></i>
                            Gelir Tablosu (Aylık)
                        </h5>
                        <p class="card-subtitle-modern">Son 30 gün gelir analizi</p>
                    </div>
                    <div class="card-body-modern">
                        <div class="chart-container-small">
                            <canvas id="revenueChart"></canvas>
                        </div>
                    </div>
                </div>
                </a>
            </div>
            </div>
            
        <!-- Gelir Tablosu (Haftalık) -->
        <div class="row g-4 mb-4">
            <div class="col-12">
                <a href="{{ route('admin.accounting.cashbox') }}" class="text-decoration-none">
                    <div class="dashboard-card h-100 card-green">
                        <div class="card-header-modern">
                            <h5 class="card-title-modern">
                                <i class="bi bi-table me-2"></i>
                                Gelir Tablosu (Haftalık)
                            </h5>
                            <p class="card-subtitle-modern">Son 7 gün detaylı analiz</p>
                        </div>
                        <div class="card-body-modern">
                            <div class="chart-container-small">
                                <canvas id="revenueAreaChart"></canvas>
                    </div>
                </div>
                    </div>
                </a>
            </div>
        </div>
        
        <!-- Revenue & Comparison Row -->
        <div class="row g-4 mb-4">
            <div class="col-12 col-md-6">
                <a href="{{ route('admin.customers.index') }}" class="text-decoration-none">
                    <div class="dashboard-card h-100 card-pink">
                    <div class="card-header-modern">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                        <h5 class="card-title-modern">
                                        <i class="bi bi-trophy me-2"></i>
                                        En Çok Rezervasyon
                        </h5>
                                    <p class="card-subtitle-modern">Top 5 müşteri</p>
                    </div>
                                <span class="view-all-link no-double-arrow">Tümü →</span>
                                </div>
                                </div>
                        <div class="card-body-modern">
                            <div class="top-customers-list">
                                @if(($topCustomers ?? collect([]))->count() > 0)
                                    @foreach($topCustomers->take(5) as $index => $item)
                                        <a href="{{ route('admin.customers.show', $item['customer']->id ?? 0) }}" class="text-decoration-none" onclick="event.stopPropagation();">
                                            <div class="customer-item">
                                                <div class="customer-rank">{{ $index + 1 }}</div>
                                                <div class="customer-info">
                                                    <div class="customer-name">{{ $item['customer']->name ?? 'Müşteri' }}</div>
                                                    <div class="customer-stats">
                                                        <span><i class="bi bi-calendar-check"></i> {{ $item['reservation_count'] }} rezervasyon</span>
                                                        <span><i class="bi bi-cash"></i> {{ format_currency($item['total_spent'] ?? 0, 0) }}</span>
                            </div>
                                </div>
                                </div>
                                        </a>
                                    @endforeach
                                @else
                                    <div class="empty-state">
                                        <i class="bi bi-people"></i>
                                        <p>Henüz veri yok</p>
                            </div>
                                @endif
                                </div>
                                </div>
                            </div>
                </a>
            </div>
            
            <div class="col-12 col-md-6">
                <a href="{{ route('admin.rezervasyonlar.index') }}" class="text-decoration-none">
                    <div class="dashboard-card h-100 card-primary">
                        <div class="card-header-modern">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="card-title-modern">
                                        <i class="bi bi-calendar-event me-2"></i>
                                        En Yakın Rezervasyon
                                    </h5>
                                    <p class="card-subtitle-modern">Yaklaşan randevular</p>
                                </div>
                                <span class="view-all-link no-double-arrow">Tümü →</span>
                            </div>
                        </div>
                        <div class="card-body-modern">
                            <div class="reservations-list">
                                @if(($upcomingReservations ?? collect([]))->count() > 0)
                                    @foreach($upcomingReservations->take(5) as $reservation)
                                        <a href="{{ route('admin.rezervasyonlar.show', $reservation->id) }}" class="reservation-item" onclick="event.stopPropagation();">
                                            <div class="reservation-icon">
                                                <i class="bi bi-calendar-check"></i>
                                            </div>
                                            <div class="reservation-info">
                                                <div class="reservation-name">{{ $reservation->customer->name ?? 'Müşteri' }}</div>
                                                <div class="reservation-details">
                                                    <span><i class="bi bi-calendar3"></i> {{ $reservation->date ? $reservation->date->format('d.m.Y') : '-' }}</span>
                                                    <span><i class="bi bi-clock"></i> {{ $reservation->start_time ?? '-' }}</span>
                                                </div>
                                            </div>
                                        </a>
                                    @endforeach
                                @else
                                    <div class="empty-state">
                                        <i class="bi bi-calendar-x"></i>
                                        <p>Yaklaşan rezervasyon yok</p>
                            </div>
                                @endif
                                </div>
                                </div>
                            </div>
                </a>
            </div>
        </div>

        <!-- Weekly Summary & Aylık Karşılaştırma -->
        <div class="row g-4 mb-4">
            <div class="col-12 col-md-6">
                <a href="{{ route('admin.rezervasyonlar.index') }}" class="text-decoration-none">
                    <div class="dashboard-card h-100 card-success">
                    <div class="card-header-modern">
                        <h5 class="card-title-modern">
                            <i class="bi bi-calendar-week me-2"></i>
                            Haftalık Özet
                        </h5>
                        <p class="card-subtitle-modern">Bu hafta performansı</p>
                    </div>
                    <div class="card-body-modern">
                        <div class="summary-stats">
                            <div class="summary-stat-item">
                                <div class="stat-icon yellow">
                                    <i class="bi bi-calendar-check"></i>
                                </div>
                                <div class="stat-content">
                                        <div class="stat-value">{{ number_format($weeklyReservations ?? 0, 0, ',', '.') }}</div>
                                    <div class="stat-label">Bu Hafta Rezervasyon</div>
                                </div>
                            </div>
                            <div class="summary-stat-item">
                                <div class="stat-icon green">
                                    <i class="bi bi-cash-coin"></i>
                                </div>
                                <div class="stat-content">
                                        <div class="stat-value">{{ format_currency($weeklyRevenue ?? 0, 0) }}</div>
                                    <div class="stat-label">Bu Hafta Gelir</div>
                                </div>
                            </div>
                            <div class="summary-stat-item">
                                <div class="stat-icon blue">
                                    <i class="bi bi-graph-up-arrow"></i>
                                </div>
                                <div class="stat-content">
                                    <div class="stat-value">+{{ round((($weeklyReservations ?? 0) / max(($lastWeekReservations ?? 1), 1) - 1) * 100) }}%</div>
                                    <div class="stat-label">Geçen Haftaya Göre</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                </a>
            </div>
            
            <div class="col-12 col-md-6">
                <div class="dashboard-card h-100 card-warning">
                    <div class="card-header-modern">
                                <h5 class="card-title-modern">
                            <i class="bi bi-bar-chart me-2"></i>
                            Aylık Karşılaştırma
                                </h5>
                        <p class="card-subtitle-modern">Bu ay vs geçen ay</p>
                            </div>
                    <div class="card-body-modern">
                        <div class="comparison-list">
                            <div class="comparison-item">
                                <div class="comparison-info">
                                    <span class="comparison-label">Bu Ay Gelir</span>
                                    <span class="comparison-value">{{ format_currency($monthlyRevenue ?? 0, 0) }}</span>
                        </div>
                                <div class="comparison-icon positive">
                                    <i class="bi bi-arrow-up-circle"></i>
                                </div>
                            </div>
                            <div class="comparison-item">
                                <div class="comparison-info">
                                    <span class="comparison-label">Geçen Ay Gelir</span>
                                    <span class="comparison-value">{{ format_currency($lastMonthRevenue ?? 0, 0) }}</span>
                                </div>
                                <div class="comparison-icon neutral">
                                    <i class="bi bi-calendar-month"></i>
                                </div>
                            </div>
                            <div class="comparison-item">
                                <div class="comparison-info">
                                    <span class="comparison-label">Bu Ay Rezervasyon</span>
                                    <span class="comparison-value">{{ $monthlyReservations ?? 0 }}</span>
                                </div>
                                <div class="comparison-icon positive">
                                    <i class="bi bi-calendar-check"></i>
                                </div>
                            </div>
                            <div class="comparison-item">
                                <div class="comparison-info">
                                    <span class="comparison-label">Geçen Ay Rezervasyon</span>
                                    <span class="comparison-value">{{ $lastMonthReservations ?? 0 }}</span>
                                </div>
                                <div class="comparison-icon neutral">
                                    <i class="bi bi-calendar"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Detailed Statistics Table -->
        <div class="row g-4 mb-4">
            <div class="col-12">
                <a href="{{ route('admin.rezervasyonlar.index') }}" class="text-decoration-none">
                    <div class="dashboard-card card-orange">
                        <div class="card-header-modern">
                            <h5 class="card-title-modern">
                                <i class="bi bi-table me-2"></i>
                                Detaylı İstatistik Tablosu
                            </h5>
                            <p class="card-subtitle-modern">Tüm metriklerin karşılaştırmalı görünümü</p>
                        </div>
                    <div class="card-body-modern">
                        <div class="table-responsive" style="overflow-x: auto; -webkit-overflow-scrolling: touch; display: block; width: 100%;">
                            <table class="table table-modern" style="min-width: 100%; width: 100%;">
                                <thead>
                                    <tr>
                                        <th>Metrik</th>
                                        <th>Bugün</th>
                                        <th>Bu Hafta</th>
                                        <th>Bu Ay</th>
                                        <th>Toplam</th>
                                        <th>Trend</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr class="table-row-link" onclick="window.location.href='{{ route('admin.rezervasyonlar.index') }}'">
                                        <td data-label="Metrik"><i class="bi bi-calendar-check me-2"></i>Rezervasyon</td>
                                        <td data-label="Bugün">{{ $stats['today_count'] ?? 0 }}</td>
                                        <td data-label="Bu Hafta">{{ $weeklyReservations ?? 0 }}</td>
                                        <td data-label="Bu Ay">{{ $monthlyReservations ?? 0 }}</td>
                                        <td data-label="Toplam">{{ $stats['total_reservations'] ?? 0 }}</td>
                                        <td data-label="Trend"><span class="trend-badge positive"><i class="bi bi-arrow-up"></i> +12%</span></td>
                                    </tr>
                                    <tr class="table-row-link" onclick="window.location.href='{{ route('admin.accounting.cashbox') }}'">
                                        <td data-label="Metrik"><i class="bi bi-cash-coin me-2"></i>Gelir</td>
                                        <td data-label="Bugün">{{ format_currency(($todayIncome ?? 0), 0) }}</td>
                                        <td data-label="Bu Hafta">{{ format_currency($weeklyRevenue ?? 0, 0) }}</td>
                                        <td data-label="Bu Ay">{{ format_currency($monthlyRevenue ?? 0, 0) }}</td>
                                        <td data-label="Toplam">{{ format_currency($totalRevenue ?? 0, 0) }}</td>
                                        <td data-label="Trend"><span class="trend-badge positive"><i class="bi bi-arrow-up"></i> +8%</span></td>
                                    </tr>
                                    <tr class="table-row-link" onclick="window.location.href='{{ route('admin.customers.index') }}'">
                                        <td data-label="Metrik"><i class="bi bi-people me-2"></i>Müşteri</td>
                                        <td data-label="Bugün">-</td>
                                        <td data-label="Bu Hafta">-</td>
                                        <td data-label="Bu Ay">-</td>
                                        <td data-label="Toplam">{{ $totalCustomers ?? 0 }}</td>
                                        <td data-label="Trend"><span class="trend-badge neutral"><i class="bi bi-dash"></i> -</span></td>
                                    </tr>
                                    <tr class="table-row-link" onclick="window.location.href='{{ route('admin.rezervasyonlar.index', ['status' => 'confirmed']) }}'">
                                        <td data-label="Metrik"><i class="bi bi-check-circle me-2"></i>Onaylanan</td>
                                        <td data-label="Bugün">-</td>
                                        <td data-label="Bu Hafta">-</td>
                                        <td data-label="Bu Ay">-</td>
                                        <td data-label="Toplam">{{ $stats['confirmed_count'] ?? 0 }}</td>
                                        <td data-label="Trend"><span class="trend-badge positive"><i class="bi bi-arrow-up"></i> +5%</span></td>
                                    </tr>
                                    <tr class="table-row-link" onclick="window.location.href='{{ route('admin.rezervasyonlar.index', ['status' => 'open']) }}'">
                                        <td data-label="Metrik"><i class="bi bi-hourglass me-2"></i>Açık</td>
                                        <td data-label="Bugün">-</td>
                                        <td data-label="Bu Hafta">-</td>
                                        <td data-label="Bu Ay">-</td>
                                        <td data-label="Toplam">{{ $stats['open_count'] ?? 0 }}</td>
                                        <td data-label="Trend"><span class="trend-badge warning"><i class="bi bi-arrow-down"></i> -3%</span></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Right Column - Quick Actions & Lists -->
    <div class="col-12 col-lg-4 col-xl-4">
        <!-- Quick Actions -->
        <div class="dashboard-card mb-4 quick-actions-card">
            <div class="card-header-modern">
                <h5 class="card-title-modern">
                    <i class="bi bi-lightning-charge me-2"></i>
                    Hızlı İşlemler
                </h5>
            </div>
            <div class="card-body-modern">
                <div class="quick-actions-list">
                    <button type="button" onclick="if(typeof window.openNewReservationModal === 'function') { window.openNewReservationModal(); } else { window.location.href='{{ route('admin.rezervasyonlar.index') }}'; }" class="quick-action-item">
                        <div class="action-icon primary">
                            <i class="bi bi-plus-circle"></i>
                        </div>
                        <div class="action-content">
                            <div class="action-title">Yeni Rezervasyon</div>
                            <div class="action-desc">Hızlı rezervasyon oluştur</div>
                        </div>
                        <i class="bi bi-chevron-right action-arrow"></i>
                    </button>
                    <button type="button" onclick="if(typeof window.openNewCustomerModal === 'function') { window.openNewCustomerModal(); } else { window.location.href='{{ route('admin.customers.index') }}'; }" class="quick-action-item">
                        <div class="action-icon success">
                            <i class="bi bi-person-plus"></i>
                        </div>
                        <div class="action-content">
                            <div class="action-title">Yeni Müşteri</div>
                            <div class="action-desc">Müşteri ekle</div>
                        </div>
                        <i class="bi bi-chevron-right action-arrow"></i>
                    </button>
                    <button type="button" onclick="window.location.href='{{ route('admin.accounting.cashbox') }}';" class="quick-action-item">
                        <div class="action-icon warning">
                            <i class="bi bi-cash-coin"></i>
                        </div>
                        <div class="action-content">
                            <div class="action-title">Gelir/Gider</div>
                            <div class="action-desc">Finansal işlem</div>
                        </div>
                        <i class="bi bi-chevron-right action-arrow"></i>
                    </button>
                </div>
            </div>
        </div>


        <!-- Performans İstatistikleri - Dikey -->
        <div class="dashboard-card mb-4 card-yellow">
            <div class="card-header-modern">
                        <h5 class="card-title-modern">
                    <i class="bi bi-speedometer2 me-2"></i>
                    Performans İstatistikleri
                        </h5>
                <p class="card-subtitle-modern">Detaylı analiz ve öngörüler</p>
                    </div>
            <div class="card-body-modern">
                <div class="d-flex flex-column gap-3">
                    <div class="performance-stat">
                        <div class="performance-icon" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);">
                            <i class="bi bi-calendar-check"></i>
                </div>
                        <div class="performance-content">
                            @php
                                $now = \Carbon\Carbon::now()->setTimezone('Europe/Istanbul');
                                $startOfYear = $now->copy()->startOfYear();
                                $daysSinceStartOfYear = max($now->diffInDays($startOfYear), 1);
                                $avgReservationsPerDay = ($stats['total_reservations'] ?? 0) / $daysSinceStartOfYear;
                                $avgReservationsPerDayRounded = round($avgReservationsPerDay);
                            @endphp
                            <div class="performance-value">{{ number_format($avgReservationsPerDayRounded, 0, ',', '.') }} /gün</div>
                            <div class="performance-label">Günlük Ortalama</div>
            </div>
                </div>
                    <div class="performance-stat">
                        <div class="performance-icon" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);">
                            <i class="bi bi-percent"></i>
                    </div>
                        <div class="performance-content">
                            <div class="performance-value">{{ round((($stats['confirmed_count'] ?? 0) / max(($stats['total_reservations'] ?? 1), 1)) * 100) }}%</div>
                            <div class="performance-label">Onay Oranı</div>
                    </div>
                    </div>
                    <div class="performance-stat">
                        <div class="performance-icon" style="background: linear-gradient(135deg, #f59e0b 0%, #f97316 100%);">
                            <i class="bi bi-clock"></i>
                </div>
                        <div class="performance-content">
                            <div class="performance-value">{{ format_currency($averageReservationAmount ?? 0, 0) }}</div>
                            <div class="performance-label">Ortalama Tutar</div>
            </div>
        </div>
                    <div class="performance-stat">
                        <div class="performance-icon" style="background: linear-gradient(135deg, #ec4899 0%, #f472b6 100%);">
                            <i class="bi bi-people-fill"></i>
                        </div>
                        <div class="performance-content">
                            @php
                                $customerReservationRatio = ($stats['total_reservations'] ?? 0) > 0 ? (($totalCustomers ?? 0) / ($stats['total_reservations'] ?? 1)) : 0;
                                $customerReservationRatioRounded = round($customerReservationRatio);
                            @endphp
                            <div class="performance-value">{{ number_format($customerReservationRatioRounded, 0, ',', '.') }}</div>
                            <div class="performance-label">Müşteri/Rezervasyon</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Upcoming Reservations -->
        <a href="{{ route('admin.rezervasyonlar.index') }}" class="text-decoration-none">
            <div class="dashboard-card mb-4 card-primary">
            <div class="card-header-modern">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="card-title-modern">
                            <i class="bi bi-calendar-event me-2"></i>
                            Yaklaşan Rezervasyonlar
                        </h5>
                        <p class="card-subtitle-modern">Sonraki randevular</p>
                    </div>
                        <span class="view-all-link">Tümü →</span>
                </div>
            </div>
            <div class="card-body-modern">
                <div class="reservations-list">
                    @if(($upcomingReservations ?? collect([]))->count() > 0)
                        @foreach($upcomingReservations->take(5) as $reservation)
                                <a href="{{ route('admin.rezervasyonlar.show', $reservation->id) }}" class="reservation-item" onclick="event.stopPropagation();">
                                <div class="reservation-icon">
                                    <i class="bi bi-calendar-check"></i>
                                </div>
                                <div class="reservation-info">
                                    <div class="reservation-name">{{ $reservation->customer->name ?? 'Müşteri' }}</div>
                                    <div class="reservation-details">
                                        <span><i class="bi bi-calendar3"></i> {{ $reservation->date ? $reservation->date->format('d.m.Y') : '-' }}</span>
                                        <span><i class="bi bi-clock"></i> {{ $reservation->start_time ?? '-' }}</span>
                                    </div>
                                </div>
                            </a>
                        @endforeach
                    @else
                        <div class="empty-state">
                            <i class="bi bi-calendar-x"></i>
                            <p>Yaklaşan rezervasyon yok</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
        </a>

        <!-- Recent Reservations -->
        @if(($recent_reservations ?? collect([]))->count() > 0)
        <a href="{{ route('admin.rezervasyonlar.index') }}" class="text-decoration-none">
            <div class="dashboard-card mb-4 card-purple">
            <div class="card-header-modern">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="card-title-modern">
                            <i class="bi bi-clock-history me-2"></i>
                            Son Rezervasyonlar
                        </h5>
                        <p class="card-subtitle-modern">En son eklenenler</p>
                    </div>
                        <span class="view-all-link">Tümü →</span>
                </div>
            </div>
            <div class="card-body-modern">
                <div class="reservations-list">
                    @foreach($recent_reservations->take(5) as $reservation)
                        <a href="{{ route('admin.rezervasyonlar.show', $reservation->id) }}" class="reservation-item" onclick="event.stopPropagation();">
                            <div class="reservation-icon">
                                <i class="bi bi-receipt"></i>
                            </div>
                            <div class="reservation-info">
                                <div class="reservation-name">{{ $reservation->customer->name ?? 'Müşteri' }}</div>
                                <div class="reservation-details">
                                    <span><i class="bi bi-calendar3"></i> {{ $reservation->date ? $reservation->date->format('d.m.Y') : '-' }}</span>
                                    <span class="reservation-badge status-{{ $reservation->status }}">
                                        @if($reservation->status == 'confirmed') Onaylı
                                        @elseif($reservation->status == 'open') Açık
                                        @elseif($reservation->status == 'cancelled') İptal
                                        @else Tamamlandı
                                        @endif
                                    </span>
                                </div>
                            </div>
                        </a>
                    @endforeach
                </div>
            </div>
        </div>
        </a>
        @endif
        
        <!-- Quick Stats -->
        <div class="dashboard-card mb-4 card-pink">
            <div class="card-header-modern">
                <h5 class="card-title-modern">
                    <i class="bi bi-bar-chart-line me-2"></i>
                    Hızlı İstatistikler
                </h5>
                <p class="card-subtitle-modern">Önemli metrikler</p>
            </div>
            <div class="card-body-modern">
                <div class="quick-stats-grid">
                    <a href="{{ route('admin.rezervasyonlar.index', ['status' => 'cancelled']) }}" class="text-decoration-none">
                    <div class="quick-stat-item">
                        <div class="quick-stat-icon" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);">
                            <i class="bi bi-calendar-x"></i>
                        </div>
                        <div class="quick-stat-content">
                            <div class="quick-stat-value">{{ $stats['cancelled_count'] ?? 0 }}</div>
                            <div class="quick-stat-label">İptal Edilen</div>
                        </div>
                    </div>
                    </a>
                    <a href="{{ route('admin.rezervasyonlar.index', ['status' => 'completed']) }}" class="text-decoration-none">
                    <div class="quick-stat-item">
                        <div class="quick-stat-icon" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);">
                            <i class="bi bi-check-circle"></i>
                        </div>
                        <div class="quick-stat-content">
                            <div class="quick-stat-value">{{ $stats['completed_count'] ?? 0 }}</div>
                            <div class="quick-stat-label">Tamamlanan</div>
                        </div>
                    </div>
                    </a>
                    <a href="{{ route('admin.rezervasyonlar.index', ['status' => 'open']) }}" class="text-decoration-none">
                    <div class="quick-stat-item">
                        <div class="quick-stat-icon" style="background: linear-gradient(135deg, #f59e0b 0%, #f97316 100%);">
                            <i class="bi bi-hourglass-split"></i>
                        </div>
                        <div class="quick-stat-content">
                            <div class="quick-stat-value">{{ $stats['open_count'] ?? 0 }}</div>
                            <div class="quick-stat-label">Bekleyen</div>
                        </div>
                    </div>
                    </a>
                    <a href="{{ route('admin.rezervasyonlar.index', ['status' => 'confirmed']) }}" class="text-decoration-none">
                    <div class="quick-stat-item">
                        <div class="quick-stat-icon" style="background: linear-gradient(135deg, #ec4899 0%, #f472b6 100%);">
                            <i class="bi bi-star-fill"></i>
                        </div>
                        <div class="quick-stat-content">
                                @php
                                    $totalReservations = $stats['total_reservations'] ?? 0;
                                    $confirmedCount = $stats['confirmed_count'] ?? 0;
                                    $successRate = $totalReservations > 0 ? ($confirmedCount / $totalReservations) * 100 : 0;
                                @endphp
                                <div class="quick-stat-value">{{ number_format($successRate, 1, ',', '.') }}%</div>
                            <div class="quick-stat-label">Başarı Oranı</div>
                        </div>
                    </div>
                    </a>
                </div>
            </div>
        </div>

        <!-- Revenue Summary Card -->
        <a href="{{ route('admin.accounting.cashbox') }}" class="text-decoration-none">
            <div class="dashboard-card mb-4 card-green">
                <div class="card-header-modern">
                    <h5 class="card-title-modern">
                        <i class="bi bi-cash-stack me-2"></i>
                        Gelir Özeti
                    </h5>
                    <p class="card-subtitle-modern">Toplam gelir bilgileri</p>
    </div>
                <div class="card-body-modern">
                    <div class="revenue-summary">
                        <div class="revenue-summary-item">
                            <div class="revenue-label">Toplam Gelir</div>
                            <div class="revenue-value">{{ format_currency($totalRevenue ?? 0, 0) }}</div>
                        </div>
                        <div class="revenue-summary-item">
                            <div class="revenue-label">Bu Ay Gelir</div>
                            <div class="revenue-value">{{ format_currency($monthlyRevenue ?? 0, 0) }}</div>
                        </div>
                        <div class="revenue-summary-item">
                            <div class="revenue-label">Bu Hafta Gelir</div>
                            <div class="revenue-value">{{ format_currency($weeklyRevenue ?? 0, 0) }}</div>
                        </div>
                        <a href="{{ route('admin.rezervasyonlar.index', ['status' => 'open']) }}" class="text-decoration-none revenue-summary-item" onclick="event.stopPropagation();">
                            <div class="revenue-label">Bekleyen Ödemeler</div>
                            <div class="revenue-value pending">{{ format_currency($pendingPayments ?? 0, 0) }}</div>
                        </a>
                    </div>
                </div>
            </div>
        </a>

        <!-- Activity Summary Card -->
        <a href="{{ route('admin.dashboard') }}" class="text-decoration-none">
            <div class="dashboard-card mb-4 card-blue">
                <div class="card-header-modern">
                <h5 class="card-title-modern">
                    <i class="bi bi-activity me-2"></i>
                    Aktivite Özeti
                </h5>
                <p class="card-subtitle-modern">Son 30 gün aktivite</p>
            </div>
            <div class="card-body-modern">
                <div class="activity-summary">
                    <div class="activity-item">
                        <div class="activity-icon" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);">
                            <i class="bi bi-calendar-check"></i>
                        </div>
                        <div class="activity-content">
                            <div class="activity-value">{{ $monthlyReservations ?? 0 }}</div>
                            <div class="activity-label">Bu Ay Rezervasyon</div>
                        </div>
                    </div>
                    <div class="activity-item">
                        <div class="activity-icon" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%);">
                            <i class="bi bi-people"></i>
                        </div>
                        <div class="activity-content">
                            <div class="activity-value">{{ $totalCustomers ?? 0 }}</div>
                            <div class="activity-label">Toplam Müşteri</div>
                        </div>
                    </div>
                    <div class="activity-item">
                        <div class="activity-icon" style="background: linear-gradient(135deg, #f59e0b 0%, #f97316 100%);">
                            <i class="bi bi-graph-up-arrow"></i>
                        </div>
                        <div class="activity-content">
                            @php
                                $growthRate = $lastMonthReservations > 0 ? (($monthlyReservations - $lastMonthReservations) / $lastMonthReservations) * 100 : 0;
                            @endphp
                            <div class="activity-value {{ $growthRate >= 0 ? 'positive' : 'negative' }}">
                                {{ $growthRate >= 0 ? '+' : '' }}{{ number_format($growthRate, 1, ',', '.') }}%
                            </div>
                            <div class="activity-label">Aylık Büyüme</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </a>

    </div>
</div>
</div>
<!-- End Dashboard Content -->

<!-- Setup Wizard Modal -->
@if($showSetupWizard ?? false)
<div class="modal fade" id="setupWizardModal" tabindex="-1" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content border-0" style="border-radius: 24px; overflow: hidden;">
            <div class="modal-header border-0 pb-0" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%); padding: 40px 40px 30px;">
                <div class="text-center w-100">
                    <div class="mb-3">
                        <div class="d-inline-flex align-items-center justify-content-center rounded-circle" style="width: 80px; height: 80px; background: rgba(255,255,255,0.2); backdrop-filter: blur(10px);">
                            <i class="bi bi-rocket-takeoff text-white" style="font-size: 40px;"></i>
                        </div>
                    </div>
                    <h3 class="text-white fw-bold mb-2">Hoş Geldiniz! 🎉</h3>
                    <p class="text-white-50 mb-0">Hesabınızı kullanmaya başlamak için ilk salonunuzu oluşturun.</p>
                </div>
            </div>
            <div class="modal-body p-4">
                <form id="setupWizardForm" method="POST" action="{{ route('admin.salons.store') }}">
                    <input type="hidden" name="is_setup_wizard" value="1">
                    @csrf
                    
                    <div class="mb-4">
                        <label class="form-label fw-bold text-dark">
                            <i class="bi bi-building me-2 text-primary"></i>Salon Adı <span class="text-danger">*</span>
                        </label>
                        <input type="text" name="name" id="setupSalonName" class="form-control form-control-lg" placeholder="Örn: Düğün Salonu, Grand Balo Salonu" required style="border-radius: 12px;">
                        <small class="text-muted">İşletmenizin veya salonunuzun adını girin.</small>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-4">
                            <label class="form-label fw-bold text-dark">
                                <i class="bi bi-telephone me-2 text-primary"></i>Telefon Numarası <span class="text-danger">*</span>
                            </label>
                            <input type="text" name="phone" id="setupSalonPhone" class="form-control" placeholder="05XX XXX XX XX" required style="border-radius: 12px;">
                        </div>
                        <div class="col-md-6 mb-4">
                            <label class="form-label fw-bold text-dark">
                                <i class="bi bi-people me-2 text-primary"></i>Salon Kapasitesi <span class="text-danger">*</span>
                            </label>
                            <input type="number" name="capacity" id="setupSalonCapacity" class="form-control" placeholder="Örn: 500" min="1" required style="border-radius: 12px;">
                        </div>
                    </div>
                    
                    <div class="mb-4">
                        <label class="form-label fw-bold text-dark">
                            <i class="bi bi-geo-alt me-2 text-primary"></i>Adres <span class="text-danger">*</span>
                        </label>
                        <textarea name="address" id="setupSalonAddress" class="form-control" rows="2" placeholder="Salon adresi" required style="border-radius: 12px;"></textarea>
                    </div>
                    
                    <div class="mb-4">
                        <label class="form-label fw-bold text-dark">
                            <i class="bi bi-card-text me-2 text-primary"></i>Açıklama <span class="text-danger">*</span>
                        </label>
                        <textarea name="description" id="setupSalonDescription" class="form-control" rows="2" placeholder="Salonunuz hakkında kısa bilgi" required style="border-radius: 12px;"></textarea>
                    </div>
                    
                    <input type="hidden" name="is_active" value="1">
                    
                    <div class="alert alert-info border-0" style="border-radius: 12px; background: linear-gradient(135deg, #e0f2fe 0%, #bae6fd 100%);">
                        <div class="d-flex align-items-center">
                            <i class="bi bi-info-circle text-primary me-2" style="font-size: 20px;"></i>
                            <div>
                                <strong>Bilgi:</strong> Daha sonra Ayarlar > Salonlar bölümünden salonlarınızı düzenleyebilir ve yeni salonlar ekleyebilirsiniz.
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer border-0 pt-0 px-4 pb-4">
                <button type="button" class="btn btn-lg w-100" onclick="submitSetupWizard()" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%); color: white; border: none; border-radius: 12px; padding: 14px;">
                    <i class="bi bi-check-circle me-2"></i>Salonu Oluştur ve Başla
                </button>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const setupModal = new bootstrap.Modal(document.getElementById('setupWizardModal'));
    setupModal.show();
});

function submitSetupWizard() {
    const form = document.getElementById('setupWizardForm');
    const name = document.getElementById('setupSalonName').value.trim();
    const phone = document.getElementById('setupSalonPhone').value.trim();
    const capacity = document.getElementById('setupSalonCapacity').value.trim();
    const address = document.getElementById('setupSalonAddress').value.trim();
    const description = document.getElementById('setupSalonDescription').value.trim();
    
    if (!name || !phone || !capacity || !address || !description) {
        alert('Lütfen tüm alanları doldurun.');
        return;
    }
    
    form.submit();
}
</script>
@endif

<!-- YENİ REZERVASYON MODAL -->
@include('admin.reservations.partials.new-reservation-modal')

@endsection

@push('styles')
<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
<style>
/* TÜM METRİKLER TEK SATIRDA YAN YANA */
.metrics-row-single {
    display: flex !important;
    flex-wrap: nowrap !important;
    overflow-x: auto !important;
    -webkit-overflow-scrolling: touch !important;
}

.metrics-row-single > [class*="col-"] {
    flex: 0 0 auto !important;
    width: auto !important;
    min-width: 12.5% !important;
    max-width: 12.5% !important;
}

/* Desktop'ta 8 kart yan yana */
@media (min-width: 992px) {
    .metrics-row-single > .col-lg-1-5 {
        flex: 0 0 12.5% !important;
        max-width: 12.5% !important;
        width: 12.5% !important;
    }
}

/* Tablet'te 4 kart yan yana */
@media (min-width: 768px) and (max-width: 991px) {
    .metrics-row-single > .col-md-4 {
        flex: 0 0 25% !important;
        max-width: 25% !important;
        width: 25% !important;
    }
}

/* Mobilde 2 kart yan yana */
@media (max-width: 767px) {
    .metrics-row-single > .col-6 {
        flex: 0 0 50% !important;
        max-width: 50% !important;
        width: 50% !important;
        min-width: 50% !important;
    }
}

    /* Metrik kartları küçült - tek satır için - TÜMÜ AYNI BOY */
    .metrics-row-single .metric-card {
        padding: 12px !important;
        min-height: 100px !important;
        height: 100px !important;
        max-height: 100px !important;
        display: flex !important;
        align-items: center !important;
        gap: 10px !important;
        border-radius: 10px !important;
    }
    
    .metrics-row-single .metric-content {
        display: flex !important;
        flex-direction: column !important;
        justify-content: flex-start !important;
        flex: 1 !important;
        min-width: 0 !important;
    }
    
    .metrics-row-single .metric-value {
        margin-bottom: 4px !important;
    }
    
    .metrics-row-single .metric-label {
        margin-bottom: 4px !important;
    }
    
    .metrics-row-single .metric-trend {
        margin-top: auto !important;
    }
    
    .metrics-row-single .metric-sub-info {
        font-size: 9px !important;
        margin-top: 4px !important;
        line-height: 1.3 !important;
        display: flex !important;
        flex-direction: column !important;
        gap: 2px !important;
    }
    
    .metrics-row-single .metric-sub-info span {
        font-size: 9px !important;
        padding: 2px 4px !important;
        line-height: 1.2 !important;
    }
    
    .metrics-row-single .metric-icon {
        width: 36px !important;
        height: 36px !important;
        font-size: 16px !important;
        flex-shrink: 0 !important;
    }
    
    .metrics-row-single .metric-content {
        flex: 1 !important;
        min-width: 0 !important;
    }
    
    .metrics-row-single .metric-value {
        font-size: 14px !important;
        line-height: 1.2 !important;
        font-weight: 600 !important;
    }
    
    .metrics-row-single .metric-label {
        font-size: 9px !important;
        line-height: 1.2 !important;
        margin-top: 4px !important;
    }
    
    .metrics-row-single .metric-trend {
        font-size: 9px !important;
        margin-top: 6px !important;
    }
    
    .metrics-row-single .metric-sub-info {
        font-size: 8px !important;
        margin-top: 4px !important;
    }

/* Dashboard Loader */
.dashboard-loader {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 9999;
    backdrop-filter: blur(10px);
}

.loader-content {
    text-align: center;
}

.loader-spinner {
    display: flex;
    justify-content: center;
    align-items: center;
    margin-bottom: 24px;
}

.spinner-ring {
    width: 48px;
    height: 48px;
    border: 4px solid rgba(37, 99, 235, 0.2);
    border-top-color: #2563eb;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}

.loader-text {
    font-size: 16px;
    font-weight: 600;
    color: #475569;
    margin: 0;
    animation: pulse 2s ease-in-out infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.6; }
}

@keyframes iconFloat {
    0%, 100% { transform: translateY(0); }
    50% { transform: translateY(-8px); }
}

/* Smooth Scrolling */
html {
    scroll-behavior: smooth;
}

/* Arka plan animasyonu kaldırıldı */
.grid-pattern {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: 
        linear-gradient(rgba(102, 126, 234, 0.1) 1px, transparent 1px),
        linear-gradient(90deg, rgba(102, 126, 234, 0.1) 1px, transparent 1px);
    background-size: 50px 50px;
    animation: gridMove 20s linear infinite;
    opacity: 0.3;
}

@keyframes gridMove {
    0% {
        transform: translate(0, 0);
    }
    100% {
        transform: translate(50px, 50px);
    }
}

/* Dashboard Header */
.dashboard-header {
    padding: 24px 0;
    position: relative;
    z-index: 10;
}

/* ============================================
   YERLEŞİM DÜZENLEMELERİ - BAŞTAN SONA TAM DÜZELTME
   ============================================ */

/* Tüm Row'lar için Temel Düzenlemeler */
#dashboardContent .row {
    margin-left: 0 !important;
    margin-right: 0 !important;
    display: flex !important;
    flex-wrap: wrap !important;
}

#dashboardContent .row > [class*="col-"] {
    padding-left: 12px !important;
    padding-right: 12px !important;
    position: relative !important;
}

/* Ana İçerik Bölümü - İki Kolonlu Yapı */
#dashboardContent .row.g-4 {
    align-items: flex-start !important;
    display: flex !important;
    flex-wrap: wrap !important;
}

/* Sol Kolon (8/12) */
#dashboardContent .row.g-4 > [class*="col-lg-8"],
#dashboardContent .row.g-4 > [class*="col-xl-8"] {
    display: flex !important;
    flex-direction: column !important;
    gap: 0 !important;
    flex: 0 0 66.66666667% !important;
    max-width: 66.66666667% !important;
    width: 66.66666667% !important;
    float: left !important;
    order: 1 !important;
}

/* Sol Kolon İçindeki Elemanlar */
#dashboardContent .row.g-4 > [class*="col-lg-8"] > *,
#dashboardContent .row.g-4 > [class*="col-xl-8"] > * {
    width: 100% !important;
    margin-bottom: 1.5rem !important;
    flex-shrink: 0 !important;
}

#dashboardContent .row.g-4 > [class*="col-lg-8"] > *:last-child,
#dashboardContent .row.g-4 > [class*="col-xl-8"] > *:last-child {
    margin-bottom: 0 !important;
}

/* SAĞ KOLON (4/12) - KESIN SAĞDA - FLOAT RIGHT İLE */
#dashboardContent .row.g-4 > [class*="col-lg-4"],
#dashboardContent .row.g-4 > [class*="col-xl-4"] {
    display: block !important;
    position: relative !important;
    flex: 0 0 33.33333333% !important;
    max-width: 33.33333333% !important;
    width: 33.33333333% !important;
    float: right !important;
    clear: right !important;
    overflow: visible !important;
    margin: 0 !important;
    padding-left: 12px !important;
    padding-right: 12px !important;
    order: 2 !important;
}

/* SAĞ KOLON İÇİNDEKİ TÜM ELEMANLAR - ZORLA SIRALI - ÜSTTEN ALTA - KÜÇÜLTÜLMÜŞ */
#dashboardContent .row.g-4 > [class*="col-lg-4"] > *,
#dashboardContent .row.g-4 > [class*="col-xl-4"] > * {
    display: block !important;
    width: 100% !important;
    margin-bottom: 0.75rem !important;
    margin-top: 0 !important;
    margin-left: 0 !important;
    margin-right: 0 !important;
    position: relative !important;
    float: none !important;
    clear: both !important;
    flex: none !important;
    order: 0 !important;
    vertical-align: top !important;
}

/* İlk eleman */
#dashboardContent .row.g-4 > [class*="col-lg-4"] > *:first-child,
#dashboardContent .row.g-4 > [class*="col-xl-4"] > *:first-child {
    margin-top: 0 !important;
}

/* Son eleman */
#dashboardContent .row.g-4 > [class*="col-lg-4"] > *:last-child,
#dashboardContent .row.g-4 > [class*="col-xl-4"] > *:last-child {
    margin-bottom: 0 !important;
}

/* SAĞ KOLON İÇİNDEKİ LİNK'LER - KÜÇÜLTÜLMÜŞ */
#dashboardContent .row.g-4 > [class*="col-lg-4"] > a,
#dashboardContent .row.g-4 > [class*="col-xl-4"] > a {
    display: block !important;
    width: 100% !important;
    text-decoration: none !important;
    margin-bottom: 0.75rem !important;
    margin-top: 0 !important;
    margin-left: 0 !important;
    margin-right: 0 !important;
    position: relative !important;
    float: none !important;
    clear: both !important;
    flex: none !important;
    order: 0 !important;
    vertical-align: top !important;
}

#dashboardContent .row.g-4 > [class*="col-lg-4"] > a:first-child,
#dashboardContent .row.g-4 > [class*="col-xl-4"] > a:first-child {
    margin-top: 0 !important;
}

#dashboardContent .row.g-4 > [class*="col-lg-4"] > a:last-child,
#dashboardContent .row.g-4 > [class*="col-xl-4"] > a:last-child {
    margin-bottom: 0 !important;
}

/* Link İçindeki Kartlar */
#dashboardContent .row.g-4 > [class*="col-lg-4"] > a .dashboard-card,
#dashboardContent .row.g-4 > [class*="col-xl-4"] > a .dashboard-card {
    margin-bottom: 0 !important;
}

/* Spesifik Kartlar için - KESIN SIRALAMA - KÜÇÜLTÜLMÜŞ */
#dashboardContent .row.g-4 > [class*="col-lg-4"] .quick-actions-card,
#dashboardContent .row.g-4 > [class*="col-lg-4"] .card-blue,
#dashboardContent .row.g-4 > [class*="col-lg-4"] .card-primary,
#dashboardContent .row.g-4 > [class*="col-lg-4"] .card-purple,
#dashboardContent .row.g-4 > [class*="col-lg-4"] .card-pink,
#dashboardContent .row.g-4 > [class*="col-lg-4"] .card-green,
#dashboardContent .row.g-4 > [class*="col-lg-4"] .card-orange,
#dashboardContent .row.g-4 > [class*="col-xl-4"] .quick-actions-card,
#dashboardContent .row.g-4 > [class*="col-xl-4"] .card-blue,
#dashboardContent .row.g-4 > [class*="col-xl-4"] .card-primary,
#dashboardContent .row.g-4 > [class*="col-xl-4"] .card-purple,
#dashboardContent .row.g-4 > [class*="col-xl-4"] .card-pink,
#dashboardContent .row.g-4 > [class*="col-xl-4"] .card-green,
#dashboardContent .row.g-4 > [class*="col-xl-4"] .card-orange {
    display: block !important;
    width: 100% !important;
    margin-bottom: 0.75rem !important;
    margin-top: 0 !important;
    margin-left: 0 !important;
    margin-right: 0 !important;
    position: relative !important;
    float: none !important;
    clear: both !important;
    vertical-align: top !important;
}

/* SAĞ KOLON KARTLARI İÇİN KÜÇÜLTÜLMÜŞ PADDING VE FONT */
#dashboardContent .row.g-4 > [class*="col-lg-4"] .dashboard-card,
#dashboardContent .row.g-4 > [class*="col-xl-4"] .dashboard-card {
    padding: 0 !important;
}

#dashboardContent .row.g-4 > [class*="col-lg-4"] .card-header-modern,
#dashboardContent .row.g-4 > [class*="col-xl-4"] .card-header-modern {
    padding: 12px 16px !important;
}

#dashboardContent .row.g-4 > [class*="col-lg-4"] .card-body-modern,
#dashboardContent .row.g-4 > [class*="col-xl-4"] .card-body-modern {
    padding: 16px !important;
}

#dashboardContent .row.g-4 > [class*="col-lg-4"] .card-title-modern,
#dashboardContent .row.g-4 > [class*="col-xl-4"] .card-title-modern {
    font-size: 15px !important;
    margin-bottom: 2px !important;
}

#dashboardContent .row.g-4 > [class*="col-lg-4"] .card-subtitle-modern,
#dashboardContent .row.g-4 > [class*="col-xl-4"] .card-subtitle-modern {
    font-size: 11px !important;
    margin-top: 0 !important;
}

/* Chart container küçültme */
#dashboardContent .row.g-4 > [class*="col-lg-4"] .chart-container-small,
#dashboardContent .row.g-4 > [class*="col-xl-4"] .chart-container-small {
    height: 150px !important;
    padding: 10px !important;
}

/* Diğer Row'lar için Düzenlemeler */
#dashboardContent .row.g-3 {
    align-items: stretch !important;
}

#dashboardContent .row.g-3 > [class*="col-"] {
    display: flex !important;
    flex-direction: column !important;
}

#dashboardContent .row.g-2 {
    align-items: stretch !important;
}

/* Responsive Düzenlemeler */
@media (max-width: 991.98px) {
    /* SAĞ KOLON MOBİLDE TAM GENİŞLİK - ALT ALTA */
    #dashboardContent .row.g-4 > [class*="col-lg-4"],
    #dashboardContent .row.g-4 > [class*="col-xl-4"],
    #dashboardContent .row.g-4 > [class*="col-lg-8"],
    #dashboardContent .row.g-4 > [class*="col-xl-8"] {
        width: 100% !important;
        max-width: 100% !important;
        flex: 0 0 100% !important;
        float: none !important;
        clear: both !important;
        order: 0 !important;
        display: block !important;
        position: relative !important;
        padding-left: 0 !important;
        padding-right: 0 !important;
        margin-left: 0 !important;
        margin-right: 0 !important;
    }
    
    /* SAĞ KOLON MOBİLDE SOL KOLONDAN SONRA GELSİN */
    #dashboardContent .row.g-4 > [class*="col-lg-8"],
    #dashboardContent .row.g-4 > [class*="col-xl-8"] {
        order: 1 !important;
    }
    
    #dashboardContent .row.g-4 > [class*="col-lg-4"],
    #dashboardContent .row.g-4 > [class*="col-xl-4"] {
        order: 2 !important;
        margin-top: 1.5rem !important;
    }
    
    /* SAĞ KOLON İÇİNDEKİ ELEMANLAR MOBİLDE NORMAL */
    #dashboardContent .row.g-4 > [class*="col-lg-4"] > *,
    #dashboardContent .row.g-4 > [class*="col-xl-4"] > *,
    #dashboardContent .row.g-4 > [class*="col-lg-4"] > a,
    #dashboardContent .row.g-4 > [class*="col-xl-4"] > a {
        width: 100% !important;
        float: none !important;
        clear: both !important;
        display: block !important;
        margin-left: 0 !important;
        margin-right: 0 !important;
        order: 0 !important;
    }
    
    /* Tüm row'lar mobilde tam genişlik */
    #dashboardContent .row > [class*="col-md-6"],
    #dashboardContent .row > [class*="col-md-4"],
    #dashboardContent .row > [class*="col-md-8"] {
        width: 100% !important;
        flex: 0 0 100% !important;
        margin-bottom: 1rem !important;
    }
    
    /* Metrik kartları mobilde tam genişlik */
    #dashboardContent .row > [class*="col-6"] {
        width: 50% !important;
        flex: 0 0 50% !important;
    }
}

.greeting-icon {
    width: 72px;
    height: 72px;
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 32px;
    box-shadow: 0 12px 40px rgba(0,0,0,0.2), 0 0 0 0 rgba(102, 126, 234, 0.4);
    position: relative;
    overflow: hidden;
    transition: all 0.3s ease;
    animation: iconFloat 3s ease-in-out infinite, iconGlow 2s ease-in-out infinite;
    cursor: pointer;
}

.greeting-icon::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(255,255,255,0.3) 0%, transparent 70%);
    animation: iconRotate 3s linear infinite;
}

.greeting-icon:hover {
    transform: scale(1.1) rotate(5deg);
    box-shadow: 0 20px 60px rgba(102, 126, 234, 0.5), 0 0 40px rgba(102, 126, 234, 0.6);
}

@keyframes iconGlow {
    0%, 100% {
        box-shadow: 0 12px 40px rgba(0,0,0,0.2), 0 0 20px rgba(102, 126, 234, 0.4);
    }
    50% {
        box-shadow: 0 12px 40px rgba(0,0,0,0.2), 0 0 40px rgba(102, 126, 234, 0.8);
    }
}

@keyframes iconRotate {
    0% {
        transform: rotate(0deg);
    }
    100% {
        transform: rotate(360deg);
    }
}


.icon-glow {
    position: absolute;
    width: 100%;
    height: 100%;
    background: radial-gradient(circle, rgba(255,255,255,0.3) 0%, transparent 70%);
    animation: pulseGlow 2s ease-in-out infinite;
}


.dashboard-title {
    font-size: 32px;
    font-weight: 800;
    background: linear-gradient(135deg, #1e293b 0%, #475569 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    margin: 0;
    line-height: 1.2;
    letter-spacing: -0.5px;
}

.highlight-name {
    background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    position: relative;
}


.dashboard-subtitle {
    font-size: 14px;
    color: #64748b;
    margin: 4px 0 0 0;
    font-weight: 500;
}

.quick-actions-header {
    display: flex;
    gap: 12px;
    justify-content: flex-end;
}

.quick-action-btn {
    padding: 12px 24px;
    border-radius: 16px;
    border: none;
    background: rgba(241, 245, 249, 0.8);
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
    color: #475569;
    font-size: 14px;
    font-weight: 600;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    text-decoration: none;
    transition: box-shadow 0.2s ease;
    position: relative;
    overflow: hidden;
    border: 1px solid rgba(255, 255, 255, 0.3);
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);
}

.quick-action-btn::before {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    width: 0;
    height: 0;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.3);
    transform: translate(-50%, -50%);
    transition: width 0.6s, height 0.6s;
}

.quick-action-btn:hover::before {
    width: 300px;
    height: 300px;
}

.quick-action-btn:hover {
    background: rgba(226, 232, 240, 0.9);
    color: #334155;
}

.quick-action-btn.primary,
.quick-action-btn.btn-new-reservation {
    background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%) !important;
    color: white !important;
    border: 1px solid rgba(255, 255, 255, 0.2) !important;
    position: relative;
}

.quick-action-btn.primary:hover,
.quick-action-btn.btn-new-reservation:hover {
    background: linear-gradient(135deg, #1d4ed8 0%, #1e3a8a 100%) !important;
    box-shadow: 0 4px 16px rgba(37, 99, 235, 0.4) !important;
    color: white !important;
}


.glass-effect {
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
}

/* Metric Cards */
.metric-card {
    background: rgba(255, 255, 255, 0.85);
    backdrop-filter: blur(20px);
    -webkit-backdrop-filter: blur(20px);
    border-radius: 20px;
    padding: 24px;
    display: flex;
    align-items: center;
    gap: 20px;
    box-shadow: 0 8px 32px rgba(0,0,0,0.1), 0 0 0 1px rgba(255,255,255,0.5);
    border: 1px solid rgba(255, 255, 255, 0.3);
    min-height: 120px;
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    overflow: hidden;
    cursor: pointer;
    z-index: 5;
}

.metric-card::after {
    content: '';
    position: absolute;
    top: -50%;
    right: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(102, 126, 234, 0.1) 0%, transparent 70%);
    animation: cardGlow 3s ease-in-out infinite;
    pointer-events: none;
}

.metric-card:hover {
    transform: translateY(-8px) scale(1.03);
    box-shadow: 0 20px 60px rgba(0,0,0,0.15), 0 0 50px var(--metric-color);
    border-color: var(--metric-color);
}

.metric-card:hover::after {
    animation: cardGlow 1s ease-in-out infinite;
}

@keyframes cardGlow {
    0%, 100% {
        opacity: 0.3;
        transform: scale(0.8);
    }
    50% {
        opacity: 0.6;
        transform: scale(1.2);
    }
}

.metric-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 3px;
    background: var(--metric-color);
    opacity: 0;
    transition: opacity 0.3s ease;
}

.metric-card:hover::before {
    opacity: 1;
}

.glass-card {
    background: rgba(255, 255, 255, 0.7);
    backdrop-filter: blur(20px) saturate(180%);
    -webkit-backdrop-filter: blur(20px) saturate(180%);
}


.metric-card:hover {
    box-shadow: 0 8px 32px rgba(0,0,0,0.12);
}

.metric-primary { 
    --metric-color: #2563eb; 
    --metric-color-dark: #1e40af;
}
.metric-success { 
    --metric-color: #10b981; 
    --metric-color-dark: #059669;
}
.metric-info { 
    --metric-color: #3b82f6; 
    --metric-color-dark: #2563eb;
}
.metric-warning { 
    --metric-color: #f59e0b; 
    --metric-color-dark: #d97706;
}

.metric-icon {
    width: 60px;
    height: 60px;
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, var(--metric-color) 0%, var(--metric-color-dark, var(--metric-color)) 100%);
    color: white;
    font-size: 28px;
    flex-shrink: 0;
    position: relative;
    box-shadow: 0 8px 24px rgba(0,0,0,0.2), 0 0 0 0 rgba(102, 126, 234, 0.4);
    transition: all 0.3s ease;
    z-index: 1;
    cursor: pointer;
    overflow: hidden;
    animation: iconShadowPulse 3s ease-in-out infinite;
}

@keyframes iconShadowPulse {
    0%, 100% {
        box-shadow: 0 8px 24px rgba(0,0,0,0.2), 0 0 20px var(--metric-color, rgba(102, 126, 234, 0.4));
    }
    50% {
        box-shadow: 0 8px 24px rgba(0,0,0,0.2), 0 0 40px var(--metric-color, rgba(102, 126, 234, 0.8));
    }
}

.metric-icon::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(255,255,255,0.3) 0%, transparent 70%);
    animation: iconRotate 3s linear infinite;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.metric-icon:hover::before {
    opacity: 1;
}

.metric-icon::after {
    content: '';
    position: absolute;
    inset: -2px;
    border-radius: 16px;
    padding: 2px;
    background: linear-gradient(45deg, var(--metric-color), var(--metric-color-dark, var(--metric-color)));
    -webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
    -webkit-mask-composite: xor;
    mask-composite: exclude;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.metric-icon:hover::after {
    opacity: 1;
    animation: iconGlowBorder 2s ease-in-out infinite;
}

.metric-icon:hover {
    transform: scale(1.15) rotate(5deg);
    box-shadow: 0 12px 32px rgba(0,0,0,0.3), 0 0 30px var(--metric-color);
}

.metric-icon i {
    position: relative;
    z-index: 3;
    transition: all 0.3s ease;
    filter: drop-shadow(0 2px 4px rgba(0,0,0,0.2));
}

.metric-icon:hover i {
    transform: scale(1.2);
    filter: drop-shadow(0 4px 8px rgba(0,0,0,0.3));
}

@keyframes iconGlowBorder {
    0%, 100% {
        opacity: 0.6;
    }
    50% {
        opacity: 1;
    }
}



.metric-content {
    flex: 1;
    min-width: 0;
}

.metric-value {
    font-size: 30px;
    font-weight: 800;
    background: linear-gradient(135deg, #1e293b 0%, #475569 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    line-height: 1.2;
    margin-bottom: 6px;
    letter-spacing: -1px;
    transition: all 0.3s ease;
}


.metric-label {
    font-size: 14px;
    color: #64748b;
    font-weight: 600;
    margin-bottom: 8px;
}

.metric-trend {
    display: inline-flex;
    align-items: center;
    gap: 4px;
    padding: 4px 10px;
    border-radius: 8px;
    font-size: 11px;
    font-weight: 600;
}

.metric-trend.positive {
    background: #d1fae5;
    color: #059669;
}

.metric-trend.neutral {
    background: #e0e7ff;
    color: #2563eb;
}

.metric-sub-info {
    display: flex;
    gap: 12px;
    margin-top: 8px;
    font-size: 11px;
}

.metric-sub-info .income {
    color: #10b981;
    font-weight: 600;
}

.metric-sub-info .expense {
    color: #ef4444;
    font-weight: 600;
}

/* Mobile Responsive - Metric Cards */
@media (max-width: 768px) {
    /* Metrik kutularını 2x2 grid yap - daha kompakt */
    .row.g-3 > .col-6.col-md-3.col-lg-3 {
        flex: 0 0 50% !important;
        max-width: 50% !important;
        width: 50% !important;
        padding-left: 4px !important;
        padding-right: 4px !important;
    }
    
    /* Grid gap'i küçült */
    .row.g-3 {
        gap: 8px !important;
        margin-left: -4px !important;
        margin-right: -4px !important;
    }
    
    .metric-card {
        padding: 10px !important;
        min-height: 90px !important;
        gap: 8px !important;
        border-radius: 12px !important;
    }
    
    .metric-icon {
        width: 36px !important;
        height: 36px !important;
        font-size: 18px !important;
        border-radius: 10px !important;
        flex-shrink: 0 !important;
    }
    
    .metric-content {
        flex: 1 !important;
        min-width: 0 !important;
    }
    
    .metric-value {
        font-size: 18px !important;
        margin-bottom: 2px !important;
        line-height: 1.2 !important;
        font-weight: 700 !important;
    }
    
    .metric-label {
        font-size: 10px !important;
        margin-bottom: 3px !important;
        line-height: 1.2 !important;
        font-weight: 500 !important;
    }
    
    .metric-trend {
        font-size: 8px !important;
        padding: 2px 5px !important;
        gap: 2px !important;
        border-radius: 4px !important;
    }
    
    .metric-trend i {
        font-size: 8px !important;
    }
    
    .metric-trend span {
        font-size: 8px !important;
    }
    
    .metric-sub-info {
        font-size: 8px !important;
        gap: 4px !important;
        margin-top: 2px !important;
    }
    
    .metric-sub-info .income,
    .metric-sub-info .expense {
        font-size: 8px !important;
        padding: 1px 3px !important;
    }
}

@media (max-width: 991px) and (min-width: 769px) {
    .metric-card {
        padding: 20px !important;
        min-height: 110px !important;
        gap: 18px !important;
    }
    
    .metric-icon {
        width: 55px !important;
        height: 55px !important;
        font-size: 26px !important;
    }
    
    .metric-value {
        font-size: 27px !important;
    }
    
    .metric-label {
        font-size: 13px !important;
    }
}

/* Secondary Metric Cards */
.secondary-metric-card {
    background: rgba(255, 255, 255, 0.7);
    backdrop-filter: blur(15px);
    -webkit-backdrop-filter: blur(15px);
    border-radius: 16px;
    padding: 20px;
    display: flex;
    align-items: center;
    gap: 16px;
    box-shadow: 0 4px 16px rgba(0,0,0,0.08), 0 0 0 1px rgba(255,255,255,0.5);
    border: 1px solid rgba(255, 255, 255, 0.3);
    transition: box-shadow 0.2s ease;
    position: relative;
    overflow: hidden;
}

.secondary-metric-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 4px;
    height: 100%;
    transform: scaleY(0);
    transition: transform 0.3s ease;
}

.blue-card::before { background: #2563eb; }
.green-card::before { background: #10b981; }
.orange-card::before { background: #f97316; }

.secondary-metric-card:hover::before {
    transform: scaleY(1);
}

.secondary-metric-card:hover {
    box-shadow: 0 4px 16px rgba(0,0,0,0.08);
    background: rgba(255, 255, 255, 0.9);
}

.secondary-metric-icon {
    width: 56px;
    height: 56px;
    border-radius: 14px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
    color: white;
    flex-shrink: 0;
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    cursor: pointer;
    overflow: hidden;
    animation: iconShadowPulseSecondary 3s ease-in-out infinite;
}

@keyframes iconShadowPulseSecondary {
    0%, 100% {
        box-shadow: 0 4px 16px rgba(0,0,0,0.2), 0 0 15px var(--secondary-color, rgba(102, 126, 234, 0.4));
    }
    50% {
        box-shadow: 0 4px 16px rgba(0,0,0,0.2), 0 0 30px var(--secondary-color, rgba(102, 126, 234, 0.8));
    }
}

.secondary-metric-icon::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(255,255,255,0.3) 0%, transparent 70%);
    animation: iconRotate 3s linear infinite;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.secondary-metric-icon:hover::before {
    opacity: 1;
}

.secondary-metric-icon::after {
    content: '';
    position: absolute;
    inset: -2px;
    border-radius: 14px;
    padding: 2px;
    background: linear-gradient(45deg, var(--secondary-color), var(--secondary-color));
    -webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
    -webkit-mask-composite: xor;
    mask-composite: exclude;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.secondary-metric-icon:hover::after {
    opacity: 1;
    animation: iconGlowBorder 2s ease-in-out infinite;
}

.secondary-metric-icon:hover {
    transform: scale(1.15) rotate(5deg);
    box-shadow: 0 8px 24px rgba(0,0,0,0.3), 0 0 30px var(--secondary-color);
}

.secondary-metric-icon i {
    position: relative;
    z-index: 3;
    transition: all 0.3s ease;
    filter: drop-shadow(0 2px 4px rgba(0,0,0,0.2));
}

.secondary-metric-icon:hover i {
    transform: scale(1.2);
    filter: drop-shadow(0 4px 8px rgba(0,0,0,0.3));
}


.secondary-metric-icon.blue { 
    background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
    --secondary-color: #2563eb;
    box-shadow: 0 4px 16px rgba(37, 99, 235, 0.3);
}
.secondary-metric-icon.green { 
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    --secondary-color: #10b981;
    box-shadow: 0 4px 16px rgba(16, 185, 129, 0.3);
}
.secondary-metric-icon.orange { 
    background: linear-gradient(135deg, #f97316 0%, #ea580c 100%);
    --secondary-color: #f97316;
    box-shadow: 0 4px 16px rgba(249, 115, 22, 0.3);
}

.secondary-metric-content {
    flex: 1;
    min-width: 0;
}

.secondary-metric-value {
    font-size: 24px;
    font-weight: 800;
    background: linear-gradient(135deg, #1e293b 0%, #475569 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    line-height: 1.2;
    margin-bottom: 4px;
    letter-spacing: -0.5px;
    transition: all 0.3s ease;
}


.secondary-metric-label {
    font-size: 11px;
    color: #64748b;
    font-weight: 500;
}

/* Dashboard Cards */
.dashboard-card {
    background: rgba(255, 255, 255, 0.75);
    backdrop-filter: blur(20px) saturate(180%);
    -webkit-backdrop-filter: blur(20px) saturate(180%);
    border-radius: 24px;
    box-shadow: 0 8px 32px rgba(0,0,0,0.1), 0 0 0 1px rgba(255,255,255,0.5);
    border: 1px solid rgba(255, 255, 255, 0.3);
    overflow: hidden;
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    z-index: 5;
}

.dashboard-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 3px;
    background: var(--card-theme-color, #667eea);
    opacity: 0;
    transition: opacity 0.3s ease;
}

.dashboard-card:hover::before {
    opacity: 1;
}

.dashboard-card.card-primary::before { --card-theme-color: #2563eb; }
.dashboard-card.card-success::before { --card-theme-color: #10b981; }
.dashboard-card.card-info::before { --card-theme-color: #3b82f6; }
.dashboard-card.card-warning::before { --card-theme-color: #f59e0b; }
.dashboard-card.card-danger::before { --card-theme-color: #ef4444; }
.dashboard-card.card-purple::before { --card-theme-color: #8b5cf6; }
.dashboard-card.card-pink::before { --card-theme-color: #ec4899; }
.dashboard-card.card-blue::before { --card-theme-color: #2563eb; }
.dashboard-card.card-green::before { --card-theme-color: #10b981; }
.dashboard-card.card-orange::before { --card-theme-color: #f97316; }
.dashboard-card.card-yellow::before { --card-theme-color: #f59e0b; }

.dashboard-card:hover {
    box-shadow: 0 20px 60px rgba(0,0,0,0.15), 0 0 40px rgba(102, 126, 234, 0.2);
    transform: translateY(-5px) scale(1.02);
    border-color: rgba(102, 126, 234, 0.5);
}

@keyframes gradientShift {
    0% {
        background-position: 0% 50%;
    }
    50% {
        background-position: 100% 50%;
    }
    100% {
        background-position: 0% 50%;
    }
}

.card-header-modern {
    padding: 20px 24px;
    border-bottom: 1px solid #e2e8f0;
    background: #f8fafc;
}

.card-title-modern {
    font-size: 18px;
    font-weight: 700;
    color: #1e293b;
    margin: 0;
    display: flex;
    align-items: center;
}

.card-subtitle-modern {
    font-size: 12px;
    color: #64748b;
    margin: 4px 0 0 0;
}

.card-body-modern {
    padding: 24px;
}

.chart-container {
    position: relative;
    height: 300px;
    margin-bottom: 20px;
    padding: 20px;
    background: linear-gradient(135deg, rgba(102, 126, 234, 0.05) 0%, rgba(118, 75, 162, 0.05) 100%);
    border-radius: 16px;
    border: 1px solid rgba(102, 126, 234, 0.1);
}

.chart-container-small {
    position: relative;
    height: 200px;
    padding: 15px;
    background: linear-gradient(135deg, rgba(102, 126, 234, 0.05) 0%, rgba(118, 75, 162, 0.05) 100%);
    border-radius: 12px;
    border: 1px solid rgba(102, 126, 234, 0.1);
}

.chart-summary {
    display: flex;
    gap: 24px;
    padding-top: 20px;
    border-top: 1px solid #e2e8f0;
}

.summary-item {
    flex: 1;
    text-align: center;
}

.summary-value {
    font-size: 24px;
    font-weight: 700;
    color: #1e293b;
    margin-bottom: 4px;
}

.summary-label {
    font-size: 12px;
    color: #64748b;
}

/* Period Selector */
.period-selector {
    display: flex;
    gap: 4px;
    background: #f1f5f9;
    padding: 4px;
    border-radius: 10px;
}

.period-btn {
    padding: 6px 16px;
    border: none;
    background: transparent;
    color: #64748b;
    font-size: 12px;
    font-weight: 600;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.2s;
}

.period-btn:hover {
    background: white;
    color: #475569;
}

.period-btn.active {
    background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
    color: white;
    box-shadow: 0 2px 8px rgba(102, 126, 234, 0.3);
}

/* Comparison List */
.comparison-list {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.comparison-item {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 16px;
    background: #f8fafc;
    border-radius: 12px;
    border: 1px solid #e2e8f0;
    transition: all 0.2s;
}

.comparison-item:hover {
    background: #f1f5f9;
}

.comparison-info {
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.comparison-label {
    font-size: 11px;
    color: #64748b;
}

.comparison-value {
    font-size: 18px;
    font-weight: 700;
    color: #1e293b;
}

.comparison-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
    color: white;
}

.comparison-icon.positive {
    background: #10b981;
}

.comparison-icon.neutral {
    background: #64748b;
}

/* Summary Stats */
.summary-stats {
    display: flex;
    flex-direction: column;
    gap: 16px;
}

.summary-stat-item {
    display: flex;
    align-items: center;
    gap: 16px;
    padding: 16px;
    background: #f8fafc;
    border-radius: 12px;
    border: 1px solid #e2e8f0;
}

.stat-icon {
    width: 48px;
    height: 48px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
    color: white;
    flex-shrink: 0;
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    cursor: pointer;
    position: relative;
    overflow: hidden;
}

.stat-icon::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(255,255,255,0.3) 0%, transparent 70%);
    animation: iconRotate 3s linear infinite;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.stat-icon:hover::before {
    opacity: 1;
}

.stat-icon::after {
    content: '';
    position: absolute;
    inset: -2px;
    border-radius: 10px;
    padding: 2px;
    background: currentColor;
    -webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
    -webkit-mask-composite: xor;
    mask-composite: exclude;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.stat-icon:hover::after {
    opacity: 1;
    animation: iconGlowBorder 2s ease-in-out infinite;
}

.stat-icon:hover {
    transform: scale(1.15) rotate(5deg);
    box-shadow: 0 8px 20px rgba(0,0,0,0.3);
}

.stat-icon i {
    position: relative;
    z-index: 3;
    transition: all 0.3s ease;
    filter: drop-shadow(0 2px 4px rgba(0,0,0,0.2));
}

.stat-icon:hover i {
    transform: scale(1.2);
    filter: drop-shadow(0 4px 8px rgba(0,0,0,0.3));
}

.stat-icon.yellow { background: #f59e0b; }
.stat-icon.green { background: #10b981; }
.stat-icon.blue { background: #3b82f6; }

.stat-content {
    flex: 1;
}

.stat-value {
    font-size: 20px;
    font-weight: 700;
    color: #1e293b;
    margin-bottom: 4px;
}

.stat-label {
    font-size: 12px;
    color: #64748b;
}

/* Top Customers */
.top-customers-list {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.customer-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 16px;
    background: rgba(248, 250, 252, 0.8);
    backdrop-filter: blur(10px);
    border-radius: 16px;
    border: 1px solid rgba(226, 232, 240, 0.5);
    transition: box-shadow 0.2s ease;
    position: relative;
    overflow: hidden;
}

.customer-item::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    height: 100%;
    width: 4px;
    background: linear-gradient(135deg, #ec4899 0%, #f472b6 100%);
    transform: scaleY(0);
    transition: transform 0.3s ease;
}

.customer-item:hover::before {
    transform: scaleY(1);
}

.customer-item:hover {
    background: rgba(241, 245, 249, 0.95);
    box-shadow: 0 4px 16px rgba(0,0,0,0.08);
    border-color: rgba(203, 213, 225, 0.8);
}

.customer-rank {
    width: 40px;
    height: 40px;
    border-radius: 12px;
    background: linear-gradient(135deg, #ec4899 0%, #f472b6 100%);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 800;
    font-size: 16px;
    flex-shrink: 0;
    box-shadow: 0 4px 16px rgba(236, 72, 153, 0.4);
    transition: all 0.3s ease;
    position: relative;
}


.customer-info {
    flex: 1;
    min-width: 0;
}

.customer-name {
    font-size: 14px;
    font-weight: 600;
    color: #1e293b;
    margin-bottom: 4px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.customer-stats {
    display: flex;
    gap: 12px;
    font-size: 11px;
    color: #64748b;
}

.customer-stats span {
    display: flex;
    align-items: center;
    gap: 4px;
}

/* Quick Actions */
.quick-actions-card {
    background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
    color: white;
    position: relative;
    overflow: hidden;
}


.quick-actions-card .card-header-modern {
    background: rgba(255,255,255,0.1);
    border-bottom: 1px solid rgba(255,255,255,0.2);
}

.quick-actions-card .card-title-modern {
    color: #1e293b;
}

.quick-actions-card .card-subtitle-modern {
    color: #64748b;
}

.quick-actions-list {
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.quick-action-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 18px;
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(226, 232, 240, 0.8);
    border-radius: 16px;
    color: #1e293b;
    text-align: left;
    width: 100%;
    transition: box-shadow 0.2s ease;
    cursor: pointer;
    position: relative;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.quick-action-item::before {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    width: 0;
    height: 0;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.2);
    transform: translate(-50%, -50%);
    transition: width 0.6s, height 0.6s;
}

.quick-action-item:hover::before {
    width: 300px;
    height: 300px;
}

.quick-action-item:hover {
    background: rgba(255, 255, 255, 1);
    box-shadow: 0 4px 16px rgba(37, 99, 235, 0.1);
    border-color: rgba(37, 99, 235, 0.3);
}

.action-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
    color: white;
    flex-shrink: 0;
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    overflow: hidden;
    cursor: pointer;
}

.action-icon::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(255,255,255,0.3) 0%, transparent 70%);
    animation: iconRotate 3s linear infinite;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.action-icon:hover::before {
    opacity: 1;
}

.action-icon::after {
    content: '';
    position: absolute;
    inset: -2px;
    border-radius: 12px;
    padding: 2px;
    background: currentColor;
    -webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
    -webkit-mask-composite: xor;
    mask-composite: exclude;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.action-icon:hover::after {
    opacity: 1;
    animation: iconGlowBorder 2s ease-in-out infinite;
}

.action-icon:hover {
    transform: scale(1.2) rotate(5deg);
    box-shadow: 0 8px 20px rgba(0,0,0,0.2), 0 0 25px currentColor;
}

.action-icon i {
    position: relative;
    z-index: 3;
    transition: all 0.3s ease;
    filter: drop-shadow(0 2px 4px rgba(0,0,0,0.2));
}

.action-icon:hover i {
    transform: scale(1.3);
    filter: drop-shadow(0 4px 8px rgba(0,0,0,0.3));
}


.action-icon.primary { 
    background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
}
.action-icon.success { 
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
}
.action-icon.warning { 
    background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
}

.action-content {
    flex: 1;
}

.action-title {
    font-size: 14px;
    font-weight: 700;
    margin-bottom: 2px;
    color: #1e293b;
}

.action-desc {
    font-size: 11px;
    color: #64748b;
    font-weight: 500;
}

.action-arrow {
    font-size: 18px;
    color: #94a3b8;
    transition: all 0.3s ease;
}

.quick-action-item:hover .action-arrow {
    color: #2563eb;
}

/* Status List */
.status-list {
    display: flex;
    flex-direction: column;
    gap: 8px;
    margin-top: 16px;
}

.status-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 12px;
    background: #f8fafc;
    border-radius: 10px;
    border: 1px solid #e2e8f0;
}

.status-indicator {
    width: 12px;
    height: 12px;
    border-radius: 50%;
    box-shadow: 0 0 8px currentColor;
}

.status-indicator.confirmed {
    background: #2563eb;
    color: #2563eb;
}

.status-indicator.open {
    background: #f59e0b;
    color: #f59e0b;
}

.status-indicator.cancelled {
    background: #ef4444;
    color: #ef4444;
}

.status-label {
    flex: 1;
    font-size: 13px;
    color: #475569;
    font-weight: 500;
}

.status-value {
    font-size: 14px;
    font-weight: 700;
    color: #1e293b;
}

/* Reservations List */
.reservations-list {
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.reservation-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 16px;
    background: rgba(248, 250, 252, 0.8);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(226, 232, 240, 0.5);
    border-radius: 16px;
    text-decoration: none;
    color: inherit;
    transition: box-shadow 0.2s ease;
    position: relative;
    overflow: hidden;
}

.reservation-item::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    height: 100%;
    width: 4px;
    background: linear-gradient(135deg, #f59e0b 0%, #f97316 100%);
    transform: scaleY(0);
    transition: transform 0.3s ease;
}

.reservation-item:hover::before {
    transform: scaleY(1);
}

.reservation-item:hover {
    background: rgba(241, 245, 249, 0.95);
    border-color: rgba(203, 213, 225, 0.8);
    box-shadow: 0 4px 16px rgba(0,0,0,0.08);
}

.reservation-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    background: linear-gradient(135deg, #f59e0b 0%, #f97316 100%);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
    flex-shrink: 0;
    box-shadow: 0 4px 16px rgba(245, 158, 11, 0.3);
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.reservation-icon::before {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    width: 0;
    height: 0;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.3);
    transform: translate(-50%, -50%);
    transition: width 0.6s, height 0.6s;
}


.reservation-item:hover .reservation-icon::before {
    width: 100px;
    height: 100px;
}

.reservation-info {
    flex: 1;
    min-width: 0;
}

.reservation-name {
    font-size: 14px;
    font-weight: 600;
    color: #1e293b;
    margin-bottom: 4px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.reservation-details {
    display: flex;
    gap: 12px;
    font-size: 11px;
    color: #64748b;
    align-items: center;
}

.reservation-details span {
    display: flex;
    align-items: center;
    gap: 4px;
}

.reservation-badge {
    padding: 2px 8px;
    border-radius: 6px;
    font-size: 10px;
    font-weight: 600;
}

.reservation-badge.status-confirmed {
    background: #dbeafe;
    color: #1e40af;
}

.reservation-badge.status-open {
    background: #fef3c7;
    color: #92400e;
}

.reservation-badge.status-cancelled {
    background: #fee2e2;
    color: #991b1b;
}

/* View All Link */
.view-all-link {
    font-size: 13px;
    color: #2563eb;
    text-decoration: none;
    font-weight: 700;
    transition: all 0.3s ease;
    display: inline-flex;
    align-items: center;
    gap: 4px;
    padding: 6px 12px;
    border-radius: 8px;
    background: rgba(102, 126, 234, 0.1);
}

.view-all-link:hover {
    color: #1e40af;
    background: rgba(102, 126, 234, 0.2);
}

/* Çift ok sorunu - CSS'teki ::after kaldırıldı, HTML'deki ok kullanılıyor */
.view-all-link::after {
    display: none;
}


/* Empty State */
.empty-state {
    text-align: center;
    padding: 40px 20px;
    color: #94a3b8;
}

.empty-state i {
    font-size: 48px;
    margin-bottom: 12px;
    display: block;
}

.empty-state p {
    font-size: 14px;
    margin: 0;
}

/* Performance Stats */
.performance-stat {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 14px;
    background: rgba(248, 250, 252, 0.8);
    backdrop-filter: blur(10px);
    border-radius: 12px;
    border: 1px solid rgba(226, 232, 240, 0.5);
    transition: all 0.3s ease;
}

.performance-stat:hover {
    box-shadow: 0 4px 16px rgba(0,0,0,0.08);
    background: rgba(255, 255, 255, 0.95);
}

.performance-icon {
    width: 44px;
    height: 44px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
    color: white;
    box-shadow: 0 4px 16px rgba(0,0,0,0.2);
    flex-shrink: 0;
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    cursor: pointer;
    position: relative;
    overflow: hidden;
}

.performance-icon::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(255,255,255,0.3) 0%, transparent 70%);
    animation: iconRotate 3s linear infinite;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.performance-icon:hover::before {
    opacity: 1;
}

.performance-icon::after {
    content: '';
    position: absolute;
    inset: -2px;
    border-radius: 14px;
    padding: 2px;
    background: currentColor;
    -webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
    -webkit-mask-composite: xor;
    mask-composite: exclude;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.performance-icon:hover::after {
    opacity: 1;
    animation: iconGlowBorder 2s ease-in-out infinite;
}

.performance-icon:hover {
    transform: scale(1.15) rotate(5deg);
    box-shadow: 0 8px 24px rgba(0,0,0,0.3), 0 0 30px currentColor;
}

.performance-icon i {
    position: relative;
    z-index: 3;
    transition: all 0.3s ease;
    filter: drop-shadow(0 2px 4px rgba(0,0,0,0.2));
}

.performance-icon:hover i {
    transform: scale(1.2);
    filter: drop-shadow(0 4px 8px rgba(0,0,0,0.3));
}

.performance-content {
    flex: 1;
}

.performance-value {
    font-size: 18px;
    font-weight: 700;
    background: linear-gradient(135deg, #1e293b 0%, #475569 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    margin-bottom: 2px;
    line-height: 1.2;
}

.performance-label {
    font-size: 11px;
    color: #64748b;
    font-weight: 500;
    line-height: 1.2;
}

/* Quick Stats */
.quick-stats-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 12px;
}

.quick-stats-grid > a {
    text-decoration: none;
    color: inherit;
    display: block;
}

.quick-stat-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 12px;
    padding: 20px;
    background: rgba(248, 250, 252, 0.8);
    backdrop-filter: blur(10px);
    border-radius: 16px;
    border: 1px solid rgba(226, 232, 240, 0.5);
    transition: all 0.3s ease;
    text-align: center;
}

.quick-stat-item:hover {
    box-shadow: 0 4px 16px rgba(0,0,0,0.08);
    background: rgba(255, 255, 255, 0.95);
}

.quick-stat-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
    color: white;
    box-shadow: 0 4px 16px rgba(0,0,0,0.2);
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    cursor: pointer;
    position: relative;
    overflow: hidden;
}

.quick-stat-icon::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(255,255,255,0.3) 0%, transparent 70%);
    animation: iconRotate 3s linear infinite;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.quick-stat-icon:hover::before {
    opacity: 1;
}

.quick-stat-icon::after {
    content: '';
    position: absolute;
    inset: -2px;
    border-radius: 12px;
    padding: 2px;
    background: currentColor;
    -webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
    -webkit-mask-composite: xor;
    mask-composite: exclude;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.quick-stat-icon:hover::after {
    opacity: 1;
    animation: iconGlowBorder 2s ease-in-out infinite;
}

.quick-stat-icon:hover {
    transform: scale(1.15) rotate(5deg);
    box-shadow: 0 8px 24px rgba(0,0,0,0.3), 0 0 30px currentColor;
}

.quick-stat-icon i {
    position: relative;
    z-index: 3;
    transition: all 0.3s ease;
    filter: drop-shadow(0 2px 4px rgba(0,0,0,0.2));
}

.quick-stat-icon:hover i {
    transform: scale(1.2);
    filter: drop-shadow(0 4px 8px rgba(0,0,0,0.3));
}

/* Quick Access Cards */
.quick-access-card {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 12px;
    padding: 20px;
    background: rgba(248, 250, 252, 0.8);
    backdrop-filter: blur(10px);
    border-radius: 16px;
    border: 1px solid rgba(226, 232, 240, 0.5);
    text-decoration: none;
    color: inherit;
    transition: box-shadow 0.2s ease;
    position: relative;
    overflow: hidden;
}

.quick-access-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 3px;
    background: linear-gradient(90deg, #2563eb, #1e40af);
    transform: scaleX(0);
    transition: transform 0.3s ease;
}

.quick-access-card:hover::before {
    transform: scaleX(1);
}

.quick-access-card:hover {
    box-shadow: 0 4px 16px rgba(37, 99, 235, 0.15);
    background: rgba(255, 255, 255, 0.95);
    border-color: rgba(37, 99, 235, 0.3);
}

.quick-access-icon {
    width: 56px;
    height: 56px;
    border-radius: 14px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
    color: white;
    box-shadow: 0 4px 16px rgba(0,0,0,0.2);
    transition: all 0.3s ease;
}


.quick-access-label {
    font-size: 13px;
    font-weight: 600;
    color: #1e293b;
    text-align: center;
}

/* Kompakt Hızlı Erişim Kartları */
.quick-access-card-compact {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 8px;
    padding: 12px 8px;
    background: rgba(248, 250, 252, 0.8);
    backdrop-filter: blur(10px);
    border-radius: 12px;
    border: 1px solid rgba(226, 232, 240, 0.5);
    text-decoration: none;
    color: inherit;
    transition: box-shadow 0.2s ease;
    position: relative;
    overflow: hidden;
}

.quick-access-card-compact::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 3px;
    background: linear-gradient(90deg, #2563eb, #1e40af);
    transform: scaleX(0);
    transition: transform 0.3s ease;
}

.quick-access-card-compact:hover::before {
    transform: scaleX(1);
}

.quick-access-card-compact:hover {
    box-shadow: 0 4px 16px rgba(37, 99, 235, 0.1);
    background: rgba(255, 255, 255, 0.95);
    border-color: rgba(37, 99, 235, 0.3);
}


.quick-access-icon-compact {
    width: 56px;
    height: 56px;
    border-radius: 14px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 28px;
    color: white;
    box-shadow: 0 2px 8px rgba(0,0,0,0.15);
    transition: all 0.3s ease;
}


.quick-access-label-compact {
    font-size: 13px !important;
    font-weight: 600;
    color: #1e293b;
    text-align: center;
    line-height: 1.3;
}

/* Help Info Items */
.help-info-list {
    display: flex;
    flex-direction: column;
    gap: 16px;
}

.help-info-item {
    display: flex;
    gap: 16px;
    padding: 16px;
    background: rgba(248, 250, 252, 0.8);
    backdrop-filter: blur(10px);
    border-radius: 16px;
    border: 1px solid rgba(226, 232, 240, 0.5);
    transition: box-shadow 0.2s ease;
}

.help-info-item:hover {
    box-shadow: 0 4px 16px rgba(0,0,0,0.08);
    background: rgba(255, 255, 255, 0.95);
    border-color: rgba(37, 99, 235, 0.3);
}

.help-info-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
    flex-shrink: 0;
    transition: all 0.3s ease;
}


.help-info-content {
    flex: 1;
}

.help-info-title {
    font-size: 14px;
    font-weight: 700;
    color: #1e293b;
    margin-bottom: 6px;
}

.help-info-text {
    font-size: 12px;
    color: #64748b;
    line-height: 1.5;
}

.quick-stat-content {
    width: 100%;
}

.quick-stat-value {
    font-size: 20px;
    font-weight: 800;
    background: linear-gradient(135deg, #1e293b 0%, #475569 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    margin-bottom: 4px;
}

.quick-stat-label {
    font-size: 11px;
    color: #64748b;
    font-weight: 500;
}

/* Modern Table Styles */
.table-modern {
    width: 100%;
    border-collapse: separate;
    border-spacing: 0;
}

.table-modern thead {
    background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(118, 75, 162, 0.1) 100%);
}

.table-modern thead th {
    padding: 16px;
    text-align: left;
    font-weight: 700;
    color: #1e293b;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    border-bottom: 2px solid rgba(102, 126, 234, 0.2);
    position: relative;
}

.table-modern thead th::after {
    content: '';
    position: absolute;
    bottom: -2px;
    left: 0;
    width: 0;
    height: 2px;
    background: linear-gradient(90deg, #667eea, #764ba2);
    transition: width 0.3s ease;
}

.table-modern thead th:hover::after {
    width: 100%;
}

.table-modern tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid rgba(226, 232, 240, 0.5);
}

.table-modern tbody tr:hover {
    background: linear-gradient(90deg, rgba(102, 126, 234, 0.05) 0%, rgba(118, 75, 162, 0.05) 100%);
    transform: translateX(5px);
    box-shadow: -5px 0 15px rgba(102, 126, 234, 0.2);
}

.table-modern tbody a {
    display: table-row;
    text-decoration: none;
    color: inherit;
}

.table-modern tbody a:hover {
    text-decoration: none;
    color: inherit;
}

.table-row-link {
    cursor: pointer;
    transition: all 0.3s ease;
    border-bottom: 1px solid rgba(226, 232, 240, 0.5);
}

.table-row-link:hover {
    background: linear-gradient(90deg, rgba(102, 126, 234, 0.05) 0%, rgba(118, 75, 162, 0.05) 100%) !important;
    transform: translateX(5px);
    box-shadow: -5px 0 15px rgba(102, 126, 234, 0.2);
}

.table-modern tbody td {
    padding: 16px;
    color: #475569;
    font-size: 14px;
    font-weight: 500;
}

.table-modern tbody td:first-child {
    font-weight: 600;
    color: #1e293b;
}

.trend-badge {
    display: inline-flex;
    align-items: center;
    gap: 4px;
    padding: 4px 12px;
    border-radius: 12px;
    font-size: 12px;
    font-weight: 600;
}

.trend-badge.positive {
    background: rgba(16, 185, 129, 0.1);
    color: #059669;
}

.trend-badge.negative {
    background: rgba(239, 68, 68, 0.1);
    color: #dc2626;
}

.trend-badge.neutral {
    background: rgba(100, 116, 139, 0.1);
    color: #64748b;
}

.trend-badge.warning {
    background: rgba(245, 158, 11, 0.1);
    color: #d97706;
}

/* Revenue Summary */
.revenue-summary {
    display: flex;
    flex-direction: column;
    gap: 16px;
}

.revenue-summary-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 12px;
    background: rgba(248, 250, 252, 0.8);
    border-radius: 12px;
    border: 1px solid rgba(226, 232, 240, 0.5);
    transition: all 0.3s ease;
}

.revenue-summary-item:hover {
    background: rgba(241, 245, 249, 0.95);
    transform: translateX(5px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.08);
}

.revenue-label {
    font-size: 12px;
    color: #64748b;
    font-weight: 500;
}

.revenue-value {
    font-size: 16px;
    font-weight: 700;
    color: #1e293b;
}

.revenue-value.pending {
    color: #f59e0b;
}

/* Activity Summary */
.activity-summary {
    display: flex;
    flex-direction: column;
    gap: 16px;
}

.activity-item {
    display: flex;
    align-items: center;
    gap: 16px;
    padding: 16px;
    background: rgba(248, 250, 252, 0.8);
    border-radius: 12px;
    border: 1px solid rgba(226, 232, 240, 0.5);
    transition: all 0.3s ease;
}

.activity-item:hover {
    background: rgba(241, 245, 249, 0.95);
    transform: translateX(5px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.08);
}

.activity-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
    color: white;
    flex-shrink: 0;
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.activity-icon::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(255,255,255,0.3) 0%, transparent 70%);
    animation: iconRotate 3s linear infinite;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.activity-item:hover .activity-icon::before {
    opacity: 1;
}

.activity-item:hover .activity-icon {
    transform: scale(1.1) rotate(5deg);
    box-shadow: 0 6px 16px rgba(0,0,0,0.3);
}

.activity-content {
    flex: 1;
}

.activity-value {
    font-size: 20px;
    font-weight: 800;
    color: #1e293b;
    margin-bottom: 4px;
}

.activity-value.positive {
    color: #10b981;
}

.activity-value.negative {
    color: #ef4444;
}

.activity-label {
    font-size: 11px;
    color: #64748b;
    font-weight: 500;
}

/* System Status */
.system-status-list {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.system-status-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 12px;
    background: rgba(248, 250, 252, 0.8);
    border-radius: 12px;
    border: 1px solid rgba(226, 232, 240, 0.5);
    transition: all 0.3s ease;
}

.system-status-item:hover {
    background: rgba(241, 245, 249, 0.95);
    transform: translateX(5px);
}

.status-indicator.active {
    width: 12px;
    height: 12px;
    border-radius: 50%;
    background: #10b981;
    box-shadow: 0 0 8px rgba(16, 185, 129, 0.5);
    animation: pulseStatus 2s ease-in-out infinite;
}

@keyframes pulseStatus {
    0%, 100% {
        box-shadow: 0 0 8px rgba(16, 185, 129, 0.5);
    }
    50% {
        box-shadow: 0 0 16px rgba(16, 185, 129, 0.8);
    }
}

.status-content {
    flex: 1;
}

.status-title {
    font-size: 13px;
    font-weight: 600;
    color: #1e293b;
    margin-bottom: 2px;
}

.status-desc {
    font-size: 11px;
    color: #64748b;
}

/* Responsive */
/* Mobil Performans Optimizasyonları */
@media (max-width: 768px) {
    /* Body ve HTML'de margin/padding yok - arka plan çerçeve sorunu */
    body,
    html {
        margin: 0 !important;
        padding: 0 !important;
        overflow-x: hidden !important;
    }
    
    /* Container genişlik ayarları */
    #dashboardContent {
        padding: 10px !important;
        margin: 0 !important;
        width: 100% !important;
        max-width: 100% !important;
        box-sizing: border-box !important;
    }
    
    /* Arka plan animasyonu - BEYAZ ÇERÇEVE SORUNU ÇÖZÜLDÜ */
    .animated-background,
    .animated-background * {
        margin: 0 !important;
        padding: 0 !important;
        border: none !important;
        outline: none !important;
        box-sizing: border-box !important;
        box-shadow: none !important;
    }
    
    .gradient-orb,
    #particlesCanvas,
    .grid-pattern {
        margin: 0 !important;
        padding: 0 !important;
        border: none !important;
        outline: none !important;
        box-shadow: none !important;
    }
    
    /* Tüm row'lar mobilde tam genişlik */
    #dashboardContent .row {
        margin-left: 0 !important;
        margin-right: 0 !important;
        display: flex !important;
        flex-direction: column !important;
    }
    
    /* SAĞ KOLON MOBİLDE KESIN ALT ALTA - TÜM FLOAT'LARI KALDIR */
    #dashboardContent .row.g-4 > [class*="col-lg-4"],
    #dashboardContent .row.g-4 > [class*="col-xl-4"] {
        width: 100% !important;
        max-width: 100% !important;
        flex: 0 0 100% !important;
        float: none !important;
        clear: both !important;
        order: 2 !important;
        display: block !important;
        position: relative !important;
        padding-left: 8px !important;
        padding-right: 8px !important;
        margin-left: 0 !important;
        margin-right: 0 !important;
        margin-top: 1.5rem !important;
    }
    
    /* SOL KOLON MOBİLDE ÜSTTE */
    #dashboardContent .row.g-4 > [class*="col-lg-8"],
    #dashboardContent .row.g-4 > [class*="col-xl-8"] {
        width: 100% !important;
        max-width: 100% !important;
        flex: 0 0 100% !important;
        float: none !important;
        clear: both !important;
        order: 1 !important;
        display: block !important;
        position: relative !important;
        padding-left: 8px !important;
        padding-right: 8px !important;
        margin-left: 0 !important;
        margin-right: 0 !important;
    }
    
    /* SAĞ KOLON İÇİNDEKİ TÜM ELEMANLAR MOBİLDE NORMAL */
    #dashboardContent .row.g-4 > [class*="col-lg-4"] > *,
    #dashboardContent .row.g-4 > [class*="col-xl-4"] > *,
    #dashboardContent .row.g-4 > [class*="col-lg-4"] > a,
    #dashboardContent .row.g-4 > [class*="col-xl-4"] > a {
        width: 100% !important;
        float: none !important;
        clear: both !important;
        display: block !important;
        margin-left: 0 !important;
        margin-right: 0 !important;
        order: 0 !important;
        position: relative !important;
    }
    
    /* METRİK KARTLARI MOBİLDE 2 SÜTUN - İKİŞERLİ DÜZEN - ZORLA - ÖNCELİK */
    #dashboardContent .row.g-3 {
        display: flex !important;
        flex-wrap: wrap !important;
        margin-left: 0 !important;
        margin-right: 0 !important;
        gap: 0 !important;
    }
    
    /* METRİK KARTLARI İKİŞERLİ - TÜM EKRAN BOYUTLARINDA */
    #dashboardContent .row.g-3 > [class*="col-6"],
    #dashboardContent .row.g-3 > [class*="col-md-6"],
    #dashboardContent .row.g-3 > [class*="col-lg-3"],
    #dashboardContent .row.g-3 > div[class*="col-"] {
        width: 50% !important;
        flex: 0 0 50% !important;
        max-width: 50% !important;
        padding-left: 6px !important;
        padding-right: 6px !important;
        margin-left: 0 !important;
        margin-right: 0 !important;
        margin-bottom: 12px !important;
        float: left !important;
        display: block !important;
        box-sizing: border-box !important;
    }
    
    /* Diğer row'lar için genel kural */
    #dashboardContent .row:not(.g-3) > [class*="col-"] {
        width: 100% !important;
        flex: 0 0 100% !important;
        max-width: 100% !important;
        padding-left: 8px !important;
        padding-right: 8px !important;
        margin-bottom: 1rem !important;
        float: none !important;
        clear: both !important;
    }
    
    /* İKİŞERLİ PADDING AYARLARI - TEK SATIR */
    #dashboardContent .row.g-3 > [class*="col-"]:nth-child(odd) {
        padding-right: 3px !important;
        padding-left: 6px !important;
    }
    
    #dashboardContent .row.g-3 > [class*="col-"]:nth-child(even) {
        padding-left: 3px !important;
        padding-right: 6px !important;
    }
    
    /* Glass effect'leri mobilde kaldır - çok ağır */
    .glass-effect,
    .glass-card {
        backdrop-filter: none !important;
        -webkit-backdrop-filter: none !important;
        background: rgba(255, 255, 255, 0.95) !important;
    }
    
    /* Tüm transition'ları kaldır veya azalt - performans için */
    * {
        transition: none !important;
        animation: none !important;
    }
    
    /* CHART CONTAINER'LARI MOBİLDE GÖRÜNÜR YAP - ZORLA */
    .chart-container,
    .chart-container-small {
        display: block !important;
        visibility: visible !important;
        opacity: 1 !important;
        width: 100% !important;
        height: 200px !important;
        padding: 10px !important;
        margin: 0 !important;
        position: relative !important;
        overflow: visible !important;
    }
    
    .chart-container-small {
        height: 150px !important;
        padding: 8px !important;
    }
    
    /* CANVAS ELEMENTLERİ MOBİLDE GÖRÜNÜR - ZORLA */
    canvas,
    #statisticsChart,
    #revenueChart,
    #statusPieChart,
    #revenueAreaChart,
    #visitorsChart {
        display: block !important;
        visibility: visible !important;
        opacity: 1 !important;
        width: 100% !important;
        height: 100% !important;
        max-width: 100% !important;
        max-height: 100% !important;
        margin: 0 !important;
        padding: 0 !important;
        border: none !important;
        outline: none !important;
        box-sizing: border-box !important;
        position: relative !important;
    }
    
    /* Chart parent container'ları */
    .dashboard-card .card-body-modern .chart-container,
    .dashboard-card .card-body-modern .chart-container-small {
        display: block !important;
        visibility: visible !important;
        opacity: 1 !important;
    }
    
    /* Tablolar için mobil uyumluluk - KARTLAR GÖRÜNÜMÜ */
    .table-responsive {
        overflow-x: visible !important;
        -webkit-overflow-scrolling: touch !important;
        display: block !important;
        width: 100% !important;
        position: relative !important;
    }
    
    .table-modern {
        width: 100% !important;
        display: block !important;
        border-collapse: separate !important;
        border-spacing: 0 !important;
    }
    
    .table-modern thead {
        display: none !important;
    }
    
    .table-modern tbody {
        display: block !important;
        width: 100% !important;
    }
    
    .table-modern tbody tr {
        display: block !important;
        width: 100% !important;
        margin-bottom: 12px !important;
        background: #ffffff !important;
        border: 1px solid #e2e8f0 !important;
        border-radius: 12px !important;
        padding: 12px !important;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08) !important;
    }
    
    .table-modern tbody td {
        display: flex !important;
        justify-content: space-between !important;
        align-items: center !important;
        width: 100% !important;
        padding: 8px 0 !important;
        font-size: 13px !important;
        text-align: left !important;
        border: none !important;
        white-space: normal !important;
    }
    
    .table-modern tbody td:before {
        content: attr(data-label) !important;
        font-weight: 700 !important;
        color: #1e293b !important;
        display: inline-block !important;
        margin-right: 10px !important;
        font-size: 12px !important;
        flex-shrink: 0 !important;
    }
    
    .table-modern tbody td:first-child {
        font-weight: 600 !important;
        font-size: 14px !important;
        color: #1e293b !important;
        padding-bottom: 8px !important;
        border-bottom: 1px solid #e2e8f0 !important;
        margin-bottom: 8px !important;
        display: block !important;
    }
    
    .table-modern tbody td:first-child:before {
        display: none !important;
    }
    
    .table-modern tbody td:first-child i {
        margin-right: 6px !important;
    }
    
    .trend-badge {
        font-size: 11px !important;
        padding: 4px 10px !important;
        display: inline-block !important;
        margin-top: 4px !important;
    }
    
    /* Tablo scroll göstergesi kaldırıldı - artık kart görünümü */
    .table-responsive::after {
        display: none !important;
    }
    
    /* Will-change property'lerini kaldır */
    * {
        will-change: auto !important;
    }
    
    /* Transform animasyonlarını kaldır */
    * {
        transform: none !important;
    }
    
    /* Tüm backdrop-filter'ları mobilde kaldır */
    [style*="backdrop-filter"],
    [style*="backdrop-filter"] * {
        backdrop-filter: none !important;
        -webkit-backdrop-filter: none !important;
    }
    
    /* Arka plan animasyonu - beyaz çerçeve sorunu düzelt */
    .animated-background {
        margin: 0 !important;
        padding: 0 !important;
        border: none !important;
        outline: none !important;
        box-sizing: border-box !important;
    }
    
    .gradient-orb {
        margin: 0 !important;
        padding: 0 !important;
        border: none !important;
        outline: none !important;
    }
    
    #particlesCanvas {
        margin: 0 !important;
        padding: 0 !important;
        border: none !important;
        outline: none !important;
    }
    
    .grid-pattern {
        margin: 0 !important;
        padding: 0 !important;
        border: none !important;
        outline: none !important;
    }
    
    /* Box-shadow'ları azalt - performans için */
    * {
        box-shadow: none !important;
    }
    
    /* Gradient'leri basitleştir - performans için */
    .metric-card,
    .dashboard-card,
    .quick-action-item {
        background: #ffffff !important;
        background-image: none !important;
    }
    
    /* Yeni Rezervasyon butonu mobilde mavi kalmalı */
    .quick-action-btn.btn-new-reservation {
        background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%) !important;
        background-image: linear-gradient(135deg, #2563eb 0%, #1e40af 100%) !important;
        color: white !important;
        border: 1px solid rgba(255, 255, 255, 0.3) !important;
    }
    
    .quick-action-btn:not(.btn-new-reservation) {
        background: #ffffff !important;
        background-image: none !important;
    }
    
    /* Hover efektlerini kaldır */
    *:hover {
        transform: none !important;
        box-shadow: none !important;
    }
    
    /* Görsel efektleri kaldır */
    .greeting-icon,
    .metric-icon,
    .action-icon {
        box-shadow: none !important;
    }
    
    /* Scroll performansı için */
    * {
        -webkit-overflow-scrolling: touch;
        overscroll-behavior: contain;
    }
    
    /* GPU hızlandırmayı kaldır - mobilde sorun çıkarabilir */
    * {
        transform: translateZ(0) !important;
        -webkit-transform: translateZ(0) !important;
    }
    
    .dashboard-title {
        font-size: 22px;
    }
    
    .greeting-icon {
        width: 48px;
        height: 48px;
        font-size: 20px;
    }
    
    .metric-value {
        font-size: 22px;
    }
    
    .metric-icon {
        width: 48px;
        height: 48px;
        font-size: 20px;
    }
    
    .quick-actions-header {
        flex-direction: column;
        width: 100%;
    }
    
    .quick-action-btn {
        width: 100%;
        justify-content: center;
    }
    
    .period-selector {
        flex-wrap: wrap;
        width: 100%;
        margin-top: 12px;
    }
    
    .period-btn {
        flex: 1;
        min-width: 60px;
    }
    
    /* Dashboard Cards */
    .dashboard-card {
        margin-bottom: 15px !important;
    }
    
    .card-header-modern {
        padding: 15px !important;
    }
    
    .card-body-modern {
        padding: 15px !important;
    }
    
    .card-title-modern {
        font-size: 16px !important;
    }
    
    .card-subtitle-modern {
        font-size: 11px !important;
    }
    
    /* Metrics */
    .metric-card {
        padding: 15px !important;
    }
    
    .metric-value {
        font-size: 20px !important;
    }
    
    .metric-label {
        font-size: 11px !important;
    }
    
    .secondary-metric-card {
        padding: 12px !important;
    }
    
    .secondary-metric-value {
        font-size: 16px !important;
    }
    
    .secondary-metric-label {
        font-size: 10px !important;
    }
    
    /* Quick Access */
    .quick-access-card-compact {
        padding: 8px 4px !important;
    }
    
    .quick-access-icon-compact {
        width: 32px !important;
        height: 32px !important;
        font-size: 14px !important;
    }
    
    .quick-access-label-compact {
        font-size: 9px !important;
    }
    
    /* Charts - MOBİLDE GÖRÜNÜR */
    .chart-container {
        height: 250px !important;
        padding: 15px !important;
        display: block !important;
        visibility: visible !important;
        opacity: 1 !important;
    }
    
    .chart-container-small {
        height: 180px !important;
        padding: 10px !important;
        display: block !important;
        visibility: visible !important;
        opacity: 1 !important;
    }
    
    /* Canvas elementleri mobilde görünür */
    canvas {
        display: block !important;
        visibility: visible !important;
        opacity: 1 !important;
        width: 100% !important;
        height: auto !important;
    }
    
    /* PERFORMANS İSTATİSTİKLERİ - KÜÇÜLT VE YAN YANA - ZORLA */
    .performance-stat {
        padding: 8px !important;
        margin-bottom: 6px !important;
        gap: 8px !important;
        display: flex !important;
        align-items: center !important;
    }
    
    .performance-icon {
        width: 36px !important;
        height: 36px !important;
        font-size: 14px !important;
        flex-shrink: 0 !important;
        min-width: 36px !important;
    }
    
    .performance-content {
        flex: 1 !important;
        min-width: 0 !important;
    }
    
    .performance-value {
        font-size: 13px !important;
        margin-bottom: 2px !important;
        line-height: 1.2 !important;
    }
    
    .performance-label {
        font-size: 9px !important;
        line-height: 1.2 !important;
    }
    
    /* PERFORMANS İSTATİSTİKLERİ MOBİLDE 2 SÜTUN - YAN YANA - ZORLA */
    #dashboardContent .row.g-3 .col-6.col-md-3,
    #dashboardContent .row.g-3 > [class*="col-md-3"] {
        width: 50% !important;
        flex: 0 0 50% !important;
        max-width: 50% !important;
        padding-left: 6px !important;
        padding-right: 6px !important;
        margin-left: 0 !important;
        margin-right: 0 !important;
        float: none !important;
        display: block !important;
    }
    
    /* İlk iki: yan yana */
    #dashboardContent .row.g-3 .col-6.col-md-3:nth-child(1),
    #dashboardContent .row.g-3 > [class*="col-md-3"]:nth-child(1) {
        padding-right: 3px !important;
        padding-left: 6px !important;
    }
    
    #dashboardContent .row.g-3 .col-6.col-md-3:nth-child(2),
    #dashboardContent .row.g-3 > [class*="col-md-3"]:nth-child(2) {
        padding-left: 3px !important;
        padding-right: 6px !important;
    }
    
    /* İkinci iki: yan yana */
    #dashboardContent .row.g-3 .col-6.col-md-3:nth-child(3),
    #dashboardContent .row.g-3 > [class*="col-md-3"]:nth-child(3) {
        padding-right: 3px !important;
        padding-left: 6px !important;
    }
    
    #dashboardContent .row.g-3 .col-6.col-md-3:nth-child(4),
    #dashboardContent .row.g-3 > [class*="col-md-3"]:nth-child(4) {
        padding-left: 3px !important;
        padding-right: 6px !important;
    }
    
    /* Lists */
    .reservation-item {
        padding: 12px !important;
    }
    
    .help-info-item {
        padding: 12px !important;
        gap: 12px !important;
    }
    
    .help-info-icon {
        width: 40px !important;
        height: 40px !important;
        font-size: 18px !important;
    }
    
    .help-info-title {
        font-size: 13px !important;
    }
    
    .help-info-text {
        font-size: 11px !important;
    }
    
    /* Quick Actions */
    .quick-action-item {
        padding: 12px !important;
        width: 100% !important;
        margin-bottom: 8px !important;
    }
    
    .action-icon {
        width: 36px !important;
        height: 36px !important;
        font-size: 16px !important;
        flex-shrink: 0 !important;
    }
    
    .action-content {
        flex: 1 !important;
        min-width: 0 !important;
    }
    
    .action-title {
        font-size: 13px !important;
        white-space: nowrap !important;
        overflow: hidden !important;
        text-overflow: ellipsis !important;
    }
    
    .action-desc {
        font-size: 10px !important;
        white-space: nowrap !important;
        overflow: hidden !important;
        text-overflow: ellipsis !important;
    }
    
    .action-arrow {
        font-size: 14px !important;
        flex-shrink: 0 !important;
    }
    
    /* Status List */
    .status-list {
        display: flex !important;
        flex-direction: column !important;
        gap: 10px !important;
    }
    
    .status-item {
        padding: 10px !important;
        display: flex !important;
        align-items: center !important;
        gap: 10px !important;
    }
    
    .status-indicator {
        width: 12px !important;
        height: 12px !important;
        flex-shrink: 0 !important;
    }
    
    .status-label {
        font-size: 12px !important;
        flex: 1 !important;
    }
    
    .status-value {
        font-size: 13px !important;
        font-weight: 600 !important;
    }
    
    /* Reservations List */
    .reservations-list {
        display: flex !important;
        flex-direction: column !important;
        gap: 8px !important;
    }
    
    .reservation-item {
        padding: 10px !important;
        display: flex !important;
        align-items: center !important;
        gap: 12px !important;
        width: 100% !important;
    }
    
    .reservation-icon {
        width: 36px !important;
        height: 36px !important;
        font-size: 16px !important;
        flex-shrink: 0 !important;
    }
    
    .reservation-info {
        flex: 1 !important;
        min-width: 0 !important;
    }
    
    .reservation-name {
        font-size: 13px !important;
        font-weight: 600 !important;
        white-space: nowrap !important;
        overflow: hidden !important;
        text-overflow: ellipsis !important;
        margin-bottom: 4px !important;
    }
    
    .reservation-details {
        display: flex !important;
        flex-wrap: wrap !important;
        gap: 8px !important;
        font-size: 11px !important;
    }
    
    .reservation-details span {
        display: flex !important;
        align-items: center !important;
        gap: 4px !important;
    }
    
    .reservation-badge {
        font-size: 10px !important;
        padding: 2px 6px !important;
    }
    
    /* Quick Stats Grid */
    .quick-stats-grid {
        display: grid !important;
        grid-template-columns: repeat(2, 1fr) !important;
        gap: 10px !important;
    }
    
    .quick-stat-item {
        padding: 12px !important;
        display: flex !important;
        flex-direction: column !important;
        align-items: center !important;
        gap: 8px !important;
    }
    
    .quick-stat-icon {
        width: 40px !important;
        height: 40px !important;
        font-size: 18px !important;
    }
    
    .quick-stat-value {
        font-size: 18px !important;
        font-weight: 700 !important;
    }
    
    .quick-stat-label {
        font-size: 10px !important;
        text-align: center !important;
    }
    
    /* Revenue Summary */
    .revenue-summary {
        display: flex !important;
        flex-direction: column !important;
        gap: 12px !important;
    }
    
    .revenue-summary-item {
        padding: 10px !important;
        display: flex !important;
        justify-content: space-between !important;
        align-items: center !important;
        border-bottom: 1px solid #e2e8f0 !important;
    }
    
    .revenue-summary-item:last-child {
        border-bottom: none !important;
    }
    
    .revenue-label {
        font-size: 12px !important;
        color: #64748b !important;
    }
    
    .revenue-value {
        font-size: 14px !important;
        font-weight: 600 !important;
    }
    
    .revenue-value.pending {
        color: #f59e0b !important;
    }
    
    /* Activity Summary */
    .activity-summary {
        display: flex !important;
        flex-direction: column !important;
        gap: 12px !important;
    }
    
    .activity-item {
        padding: 10px !important;
        display: flex !important;
        align-items: center !important;
        gap: 12px !important;
    }
    
    .activity-icon {
        width: 40px !important;
        height: 40px !important;
        font-size: 18px !important;
        flex-shrink: 0 !important;
    }
    
    .activity-content {
        flex: 1 !important;
        min-width: 0 !important;
    }
    
    .activity-value {
        font-size: 16px !important;
        font-weight: 700 !important;
        margin-bottom: 2px !important;
    }
    
    .activity-label {
        font-size: 11px !important;
        color: #64748b !important;
    }
    
    /* System Status List */
    .system-status-list {
        display: flex !important;
        flex-direction: column !important;
        gap: 12px !important;
    }
    
    .system-status-item {
        padding: 10px !important;
        display: flex !important;
        align-items: center !important;
        gap: 12px !important;
    }
    
    .system-status-item .status-indicator {
        width: 10px !important;
        height: 10px !important;
        flex-shrink: 0 !important;
    }
    
    .system-status-item .status-content {
        flex: 1 !important;
        min-width: 0 !important;
    }
    
    .system-status-item .status-title {
        font-size: 12px !important;
        margin-bottom: 2px !important;
    }
    
    .system-status-item .status-desc {
        font-size: 10px !important;
    }
    
    /* Empty State */
    .empty-state {
        padding: 20px !important;
        text-align: center !important;
    }
    
    .empty-state i {
        font-size: 32px !important;
        color: #cbd5e1 !important;
        margin-bottom: 8px !important;
    }
    
    .empty-state p {
        font-size: 12px !important;
        color: #94a3b8 !important;
    }
    
    /* View All Link */
    .view-all-link {
        font-size: 11px !important;
        white-space: nowrap !important;
    }
    
    /* Card Header Flex */
    .card-header-modern .d-flex {
        flex-wrap: wrap !important;
        gap: 8px !important;
    }
}

@media (max-width: 480px) {
    .dashboard-title {
        font-size: 18px !important;
    }
    
    .metric-value {
        font-size: 18px !important;
    }
    
    .secondary-metric-value {
        font-size: 14px !important;
    }
    
    /* Küçük ekranlar için tablo optimizasyonu - KART GÖRÜNÜMÜ */
    .table-modern tbody tr {
        padding: 10px !important;
        margin-bottom: 10px !important;
    }
    
    .table-modern tbody td {
        padding: 6px 0 !important;
        font-size: 12px !important;
    }
    
    .table-modern tbody td:first-child {
        font-size: 13px !important;
        padding-bottom: 6px !important;
        margin-bottom: 6px !important;
    }
    
    .table-modern tbody td:before {
        font-size: 11px !important;
        width: 35% !important;
    }
    
    .trend-badge {
        font-size: 10px !important;
        padding: 3px 8px !important;
    }
    
    /* Kartlar mobilde tam genişlik */
    .dashboard-card {
        margin-left: 0 !important;
        margin-right: 0 !important;
        border-radius: 16px !important;
    }
    
    /* Row ve column düzenlemeleri mobilde */
    #dashboardContent .row > [class*="col-"] {
        padding-left: 6px !important;
        padding-right: 6px !important;
    }
    
    /* Metrik kartları mobilde */
    .metric-card,
    .secondary-metric-card {
        margin-bottom: 10px !important;
    }
    
    /* Hızlı erişim kartları mobilde - 2'şer yan yana */
    .row.g-2 > .col-6 {
        flex: 0 0 50% !important;
        max-width: 50% !important;
        width: 50% !important;
        padding-left: 4px !important;
        padding-right: 4px !important;
    }
    
    .row.g-2 {
        gap: 8px !important;
        margin-left: -4px !important;
        margin-right: -4px !important;
    }
    
    /* Hızlı erişim card body padding'i küçült */
    .dashboard-card .card-body-modern.py-3 {
        padding-top: 12px !important;
        padding-bottom: 12px !important;
        padding-left: 8px !important;
        padding-right: 8px !important;
    }
    
    .quick-access-card-compact {
        padding: 8px 4px !important;
        gap: 6px !important;
        border-radius: 10px !important;
    }
    
    .quick-access-icon-compact {
        width: 40px !important;
        height: 40px !important;
        font-size: 20px !important;
        border-radius: 10px !important;
    }
    
    .quick-access-label-compact {
        font-size: 10px !important;
        line-height: 1.2 !important;
        font-weight: 500 !important;
        text-align: center !important;
    }
    
    /* Header düzenlemeleri */
    .dashboard-header {
        padding: 16px 0 !important;
    }
    
    .quick-actions-header {
        flex-direction: column !important;
        gap: 8px !important;
    }
    
    .quick-action-btn {
        width: 100% !important;
        padding: 10px 16px !important;
    }
    
    /* Sağ Menü - Çok Küçük Ekranlar İçin */
    .quick-action-item {
        padding: 10px !important;
    }
    
    .action-icon {
        width: 32px !important;
        height: 32px !important;
        font-size: 14px !important;
    }
    
    .action-title {
        font-size: 12px !important;
    }
    
    .action-desc {
        font-size: 9px !important;
    }
    
    .quick-stats-grid {
        grid-template-columns: 1fr !important;
        gap: 8px !important;
    }
    
    .quick-stat-item {
        padding: 10px !important;
        flex-direction: row !important;
        justify-content: flex-start !important;
    }
    
    .quick-stat-icon {
        width: 36px !important;
        height: 36px !important;
        font-size: 16px !important;
    }
    
    .quick-stat-value {
        font-size: 16px !important;
    }
    
    .quick-stat-label {
        font-size: 9px !important;
    }
    
    .revenue-summary-item {
        padding: 8px !important;
        flex-direction: column !important;
        align-items: flex-start !important;
        gap: 4px !important;
    }
    
    .revenue-label {
        font-size: 11px !important;
    }
    
    .revenue-value {
        font-size: 13px !important;
    }
    
    .activity-item {
        padding: 8px !important;
    }
    
    .activity-icon {
        width: 36px !important;
        height: 36px !important;
        font-size: 16px !important;
    }
    
    .activity-value {
        font-size: 14px !important;
    }
    
    .activity-label {
        font-size: 10px !important;
    }
    
    .reservation-item {
        padding: 8px !important;
    }
    
    .reservation-icon {
        width: 32px !important;
        height: 32px !important;
        font-size: 14px !important;
    }
    
    .reservation-name {
        font-size: 12px !important;
    }
    
    .reservation-details {
        font-size: 10px !important;
    }
    
    .status-item {
        padding: 8px !important;
    }
    
    .status-label {
        font-size: 11px !important;
    }
    
    .status-value {
        font-size: 12px !important;
    }
    
    .system-status-item {
        padding: 8px !important;
    }
    
    .card-header-modern {
        padding: 12px !important;
    }
    
    .card-body-modern {
        padding: 12px !important;
    }
    
    .card-title-modern {
        font-size: 14px !important;
    }
    
    .card-subtitle-modern {
        font-size: 10px !important;
    }
    
    .chart-container {
        height: 200px !important;
    }
    
    .chart-container-small {
        height: 150px !important;
    }
    
    /* Çok küçük ekranlar için ek küçültme */
    .quick-access-card-compact {
        padding: 6px 3px !important;
        gap: 4px !important;
    }
    
    .quick-access-icon-compact {
        width: 36px !important;
        height: 36px !important;
        font-size: 18px !important;
    }
    
    .quick-access-label-compact {
        font-size: 9px !important;
    }
    
    /* Metric kartları da küçült */
    .metric-card {
        padding: 8px !important;
        min-height: 80px !important;
    }
    
    .metric-icon {
        width: 32px !important;
        height: 32px !important;
        font-size: 16px !important;
    }
    
    .metric-value {
        font-size: 16px !important;
    }
    
    .metric-label {
        font-size: 9px !important;
    }
}

/* MOBİL GÖRÜNÜM - GÜÇLÜ OVERRIDE - EN SON EKLENMELİ */
@media screen and (max-width: 768px) {
    /* İstatistik kutuları - 2'şer yan yana ve küçük */
    #dashboardContent .row.g-3 > .col-6.col-md-3.col-lg-3,
    .row.g-3 > .col-6.col-md-3.col-lg-3 {
        flex: 0 0 50% !important;
        max-width: 50% !important;
        width: 50% !important;
        padding-left: 4px !important;
        padding-right: 4px !important;
    }
    
    #dashboardContent .row.g-3,
    .row.g-3 {
        gap: 8px !important;
        margin-left: -4px !important;
        margin-right: -4px !important;
    }
    
    #dashboardContent .metric-card,
    .metric-card {
        padding: 10px !important;
        min-height: 90px !important;
        max-height: 95px !important;
        gap: 8px !important;
        border-radius: 12px !important;
        display: flex !important;
        align-items: center !important;
    }
    
    #dashboardContent .metric-card .metric-icon,
    .metric-card .metric-icon {
        width: 36px !important;
        height: 36px !important;
        font-size: 18px !important;
        border-radius: 10px !important;
        flex-shrink: 0 !important;
        min-width: 36px !important;
    }
    
    #dashboardContent .metric-card .metric-content,
    .metric-card .metric-content {
        flex: 1 !important;
        min-width: 0 !important;
        overflow: hidden !important;
    }
    
    #dashboardContent .metric-card .metric-value,
    .metric-card .metric-value {
        font-size: 18px !important;
        line-height: 1.2 !important;
        font-weight: 700 !important;
        margin-bottom: 2px !important;
    }
    
    #dashboardContent .metric-card .metric-label,
    .metric-card .metric-label {
        font-size: 10px !important;
        line-height: 1.2 !important;
        font-weight: 500 !important;
        margin-bottom: 3px !important;
    }
    
    #dashboardContent .metric-card .metric-trend,
    .metric-card .metric-trend {
        font-size: 8px !important;
        padding: 2px 5px !important;
        gap: 2px !important;
        border-radius: 4px !important;
        display: flex !important;
        align-items: center !important;
    }
    
    #dashboardContent .metric-card .metric-trend i,
    .metric-card .metric-trend i {
        font-size: 8px !important;
    }
    
    #dashboardContent .metric-card .metric-trend span,
    .metric-card .metric-trend span {
        font-size: 8px !important;
    }
    
    /* Hızlı erişim kutuları - 2'şer yan yana ve küçük - GÜÇLÜ OVERRIDE */
    #dashboardContent .row.g-2 > div[class*="col-"],
    .row.g-2 > div[class*="col-"],
    .row.g-2 > .col-6,
    .row.g-2 > .col-6.col-md-4.col-lg-2,
    div.row.g-2 > div.col-6.col-md-4.col-lg-2,
    body .row.g-2 .col-6,
    body .row.g-2 [class*="col-"] {
        flex: 0 0 50% !important;
        max-width: 50% !important;
        width: 50% !important;
        padding-left: 4px !important;
        padding-right: 4px !important;
        float: left !important;
        display: block !important;
        box-sizing: border-box !important;
        clear: none !important;
    }
    
    #dashboardContent .row.g-2,
    .row.g-2,
    div.row.g-2,
    body .row.g-2 {
        gap: 8px !important;
        margin-left: -4px !important;
        margin-right: -4px !important;
        display: flex !important;
        flex-wrap: wrap !important;
        flex-direction: row !important;
        align-items: stretch !important;
    }
    
    /* Clearfix için */
    .row.g-2::after {
        content: "";
        display: table;
        clear: both;
    }
    
    #dashboardContent .card-body-modern.py-3,
    .card-body-modern.py-3 {
        padding-top: 12px !important;
        padding-bottom: 12px !important;
        padding-left: 8px !important;
        padding-right: 8px !important;
    }
    
    #dashboardContent .quick-access-card-compact,
    .quick-access-card-compact {
        padding: 8px 4px !important;
        gap: 6px !important;
        border-radius: 10px !important;
        display: flex !important;
        flex-direction: column !important;
        align-items: center !important;
    }
    
    #dashboardContent .quick-access-card-compact .quick-access-icon-compact,
    .quick-access-card-compact .quick-access-icon-compact {
        width: 40px !important;
        height: 40px !important;
        font-size: 20px !important;
        border-radius: 10px !important;
    }
    
    #dashboardContent .quick-access-card-compact .quick-access-label-compact,
    .quick-access-card-compact .quick-access-label-compact {
        font-size: 10px !important;
        line-height: 1.2 !important;
        font-weight: 500 !important;
        text-align: center !important;
    }
}

/* Çok küçük ekranlar için ek küçültme */
@media screen and (max-width: 480px) {
    #dashboardContent .metric-card,
    .metric-card {
        padding: 8px !important;
        min-height: 80px !important;
        max-height: 85px !important;
    }
    
    #dashboardContent .metric-card .metric-icon,
    .metric-card .metric-icon {
        width: 32px !important;
        height: 32px !important;
        font-size: 16px !important;
    }
    
    #dashboardContent .metric-card .metric-value,
    .metric-card .metric-value {
        font-size: 16px !important;
    }
    
    #dashboardContent .metric-card .metric-label,
    .metric-card .metric-label {
        font-size: 9px !important;
    }
    
    #dashboardContent .quick-access-card-compact .quick-access-icon-compact,
    .quick-access-card-compact .quick-access-icon-compact {
        width: 36px !important;
        height: 36px !important;
        font-size: 18px !important;
    }
    
    #dashboardContent .quick-access-card-compact .quick-access-label-compact,
    .quick-access-card-compact .quick-access-label-compact {
        font-size: 9px !important;
    }
}

/* HIZLI ERİŞİM - MOBİL İÇİN EN GÜÇLÜ OVERRIDE - TÜM EKRAN BOYUTLARI İÇİN */
@media screen and (max-width: 991px) {
    .quick-access-row,
    .row.g-2.quick-access-row {
        display: flex !important;
        flex-wrap: wrap !important;
        flex-direction: row !important;
        margin-left: -4px !important;
        margin-right: -4px !important;
    }
    
    .quick-access-item,
    .row.g-2 .quick-access-item,
    .quick-access-row .quick-access-item,
    .quick-access-row .col-6,
    .row.g-2.quick-access-row > div[class*="col-"] {
        flex: 0 0 50% !important;
        max-width: 50% !important;
        width: 50% !important;
        padding-left: 4px !important;
        padding-right: 4px !important;
        box-sizing: border-box !important;
        float: none !important;
        display: block !important;
    }
}

/* 768px altı için ekstra güçlendirme */
@media screen and (max-width: 768px) {
    .quick-access-row,
    .row.g-2.quick-access-row {
        display: flex !important;
        flex-wrap: wrap !important;
        flex-direction: row !important;
        margin-left: -4px !important;
        margin-right: -4px !important;
    }
    
    .quick-access-item,
    .row.g-2 .quick-access-item,
    .quick-access-row .quick-access-item,
    .quick-access-row .col-6,
    .row.g-2.quick-access-row > div[class*="col-"],
    body .quick-access-row > div,
    body .quick-access-row [class*="col-"] {
        flex: 0 0 50% !important;
        max-width: 50% !important;
        width: 50% !important;
        min-width: 50% !important;
        padding-left: 4px !important;
        padding-right: 4px !important;
        box-sizing: border-box !important;
        float: none !important;
        display: block !important;
        position: relative !important;
    }
}
</style>
@endpush

@push('scripts')
<!-- Chart.js sadece desktop'ta yükle - mobil performans için -->
<script>
// Mobil kontrolü - CHART'LAR MOBİLDE DE GÖSTERİLECEK
const isMobileDevice = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) || window.innerWidth <= 768;

// TÜM CİHAZLARDA Chart.js yükle (mobilde de çalışsın)
    const script = document.createElement('script');
    script.src = 'https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js';
    script.async = true;
    script.onload = function() {
        // Chart.js yüklendikten sonra chart'ları başlat
        if (typeof initCharts === 'function') {
            initCharts();
        }
    };
    document.head.appendChild(script);

// Mobilde chart container'ları GÖSTER (gizleme kaldırıldı)
    document.addEventListener('DOMContentLoaded', function() {
        document.querySelectorAll('.chart-container, .chart-container-small').forEach(el => {
        el.style.display = 'block';
        el.style.visibility = 'visible';
        el.style.opacity = '1';
    });
    
    // Canvas elementlerini de göster
    document.querySelectorAll('canvas').forEach(canvas => {
        canvas.style.display = 'block';
        canvas.style.visibility = 'visible';
        canvas.style.opacity = '1';
    });
});
</script>
<script>
// Particles Animation
// Particles canvas kaldırıldı
function initParticles() {
    // Kaldırıldı
    return;
    
    const particles = [];
    const particleCount = 50;
    
    class Particle {
        constructor() {
            this.x = Math.random() * canvas.width;
            this.y = Math.random() * canvas.height;
            this.size = Math.random() * 3 + 1;
            this.speedX = Math.random() * 2 - 1;
            this.speedY = Math.random() * 2 - 1;
            this.opacity = Math.random() * 0.5 + 0.2;
            this.color = `rgba(${Math.random() > 0.5 ? '102, 126, 234' : '118, 75, 162'}, ${this.opacity})`;
        }
        
        update() {
            this.x += this.speedX;
            this.y += this.speedY;
            
            if (this.x > canvas.width) this.x = 0;
            if (this.x < 0) this.x = canvas.width;
            if (this.y > canvas.height) this.y = 0;
            if (this.y < 0) this.y = canvas.height;
        }
        
        draw() {
            ctx.fillStyle = this.color;
            ctx.beginPath();
            ctx.arc(this.x, this.y, this.size, 0, Math.PI * 2);
            ctx.fill();
        }
    }
    
    for (let i = 0; i < particleCount; i++) {
        particles.push(new Particle());
    }
    
    function animate() {
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        
        particles.forEach(particle => {
            particle.update();
            particle.draw();
        });
        
        // Connect nearby particles
        particles.forEach((particle, i) => {
            particles.slice(i + 1).forEach(otherParticle => {
                const dx = particle.x - otherParticle.x;
                const dy = particle.y - otherParticle.y;
                const distance = Math.sqrt(dx * dx + dy * dy);
                
                if (distance < 100) {
                    ctx.strokeStyle = `rgba(102, 126, 234, ${0.2 * (1 - distance / 100)})`;
                    ctx.lineWidth = 1;
                    ctx.beginPath();
                    ctx.moveTo(particle.x, particle.y);
                    ctx.lineTo(otherParticle.x, otherParticle.y);
                    ctx.stroke();
                }
            });
        });
        
        requestAnimationFrame(animate);
    }
    
    animate();
    
    window.addEventListener('resize', () => {
        canvas.width = window.innerWidth;
        canvas.height = window.innerHeight;
    });
}

// Dashboard Loading Animation
document.addEventListener('DOMContentLoaded', function() {
    const loader = document.getElementById('dashboardLoader');
    const content = document.getElementById('dashboardContent');
    
    // Direkt göster (açılış animasyonu yok)
        if (loader) loader.style.display = 'none';
        if (content) {
            content.style.display = 'block';
            content.style.opacity = '1';
        }
    
    // Particles kaldırıldı
    
    // Animasyonları kaldır - direkt görünsünler
    const animatedElements = document.querySelectorAll('.metric-card, .secondary-metric-card, .dashboard-card, .quick-access-card-compact, .quick-action-item, .reservation-item, .customer-item, .comparison-item, .summary-stat-item, .performance-stat, .quick-stat-item');
    animatedElements.forEach((el) => {
        el.style.animation = 'none';
        el.style.opacity = '1';
        el.style.transform = 'none';
    });
    
    // Yeni Rezervasyon butonları için event listener
    const newResBtn = document.getElementById('newReservationBtn');
    const newResBtn2 = document.getElementById('newReservationBtn2');
    
    function handleNewReservation() {
        // Modal'ı aç
        if (typeof window.openNewReservationModal === 'function') {
            window.openNewReservationModal();
        } else {
            // Fallback: Rezervasyonlar sayfasına yönlendir
            window.location.href = '{{ route("admin.rezervasyonlar.index") }}';
        }
    }
    
    if (newResBtn) {
        newResBtn.addEventListener('click', handleNewReservation);
    }
    if (newResBtn2) {
        newResBtn2.addEventListener('click', handleNewReservation);
    }
    
    // Hızlı erişim butonları için event listener'lar - window objesi kontrolü
    document.querySelectorAll('.quick-action-item').forEach(function(button) {
        button.addEventListener('click', function(e) {
            const onclick = this.getAttribute('onclick');
            if (onclick) {
                try {
                    // onclick'i çalıştır
                    eval(onclick);
                } catch (error) {
                    console.error('Quick action button error:', error);
                }
            }
        });
    });
});
</script>
<!-- AOS kütüphanesi yüklenmiyor - animasyonlar devre dışı -->
<script>
// Animasyonlar aktif - direkt görünsünler
document.addEventListener('DOMContentLoaded', function() {
    // CSS animasyonları ekle
    const style = document.createElement('style');
    style.textContent = `
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        @keyframes scaleIn {
            from {
                opacity: 0;
                transform: scale(0.9);
            }
            to {
                opacity: 1;
                transform: scale(1);
            }
        }
        
        /* Yüklenme animasyonları kaldırıldı - direkt görünsünler */
        /* Yüklenme animasyonları kaldırıldı - direkt görünsünler */
        .metric-card,
        .secondary-metric-card,
        .dashboard-card,
        .quick-access-card-compact,
        .quick-action-item,
        .reservation-item,
        .customer-item,
        .comparison-item,
        .summary-stat-item,
        .performance-stat,
        .quick-stat-item {
            animation: none !important;
            opacity: 1 !important;
            transform: none !important;
        }
        
        /* Link olan kartlar için pointer cursor */
        a .dashboard-card,
        a .metric-card {
            cursor: pointer;
        }
        
        .greeting-icon {
            animation: iconFloat 3s ease-in-out infinite, iconGlow 2s ease-in-out infinite;
        }
        
        .secondary-metric-icon {
            animation: scaleIn 0.5s ease-out both;
        }
        
        .secondary-metric-icon:hover {
            animation: iconPulse 1s ease-in-out infinite;
        }
        
        .action-icon {
            animation: scaleIn 0.4s ease-out both;
        }
        
        .action-icon:hover {
            animation: iconPulse 0.8s ease-in-out infinite;
        }
        
        .stat-icon {
            animation: scaleIn 0.4s ease-out both;
        }
        
        .stat-icon:hover {
            animation: iconPulse 1s ease-in-out infinite;
        }
        
        .performance-icon {
            animation: scaleIn 0.5s ease-out both;
        }
        
        .performance-icon:hover {
            animation: iconPulse 1s ease-in-out infinite;
        }
        
        .quick-stat-icon {
            animation: scaleIn 0.4s ease-out both;
        }
        
        .quick-stat-icon:hover {
            animation: iconPulse 1s ease-in-out infinite;
        }
        
        @keyframes iconPulse {
            0%, 100% {
                transform: scale(1);
                box-shadow: 0 4px 16px rgba(0,0,0,0.2);
            }
            50% {
                transform: scale(1.1);
                box-shadow: 0 8px 24px rgba(0,0,0,0.4);
            }
        }
    `;
    document.head.appendChild(style);
});

// Counter Animation - DEVRE DIŞI (Sayılar direkt gösteriliyor)

// Global chart variables - window objesine atanarak çakışmayı önle
if (typeof window.statisticsChart === 'undefined') {
    window.statisticsChart = null;
}
// visitorsChart kaldırıldı
if (typeof window.revenueChart === 'undefined') {
    window.revenueChart = null;
}

// Chart data for different periods
const chartData = {
    '1D': {
        labels: {!! json_encode(array_column($last7Days ?? [], 'date')) !!},
        data: {!! json_encode(array_column($last7Days ?? [], 'count')) !!}
    },
    '1W': {
        labels: {!! json_encode(array_column($last12Weeks ?? [], 'date')) !!},
        data: {!! json_encode(array_column($last12Weeks ?? [], 'count')) !!}
    },
    '1M': {
        labels: {!! json_encode(array_column($last12Months ?? [], 'date')) !!},
        data: {!! json_encode(array_column($last12Months ?? [], 'count')) !!}
    },
    '1Y': {
        labels: {!! json_encode(array_column($last12Months ?? [], 'date')) !!},
        data: {!! json_encode(array_column($last12Months ?? [], 'count')) !!}
    }
};

// Wait for Chart.js to load
function initCharts() {
    // MOBİLDE DE CHART'LARI OLUŞTUR (performans sorunu yok)
    // if (isMobileDevice) {
    //     console.log('Mobil cihaz tespit edildi - Chart\'lar devre dışı bırakıldı (performans)');
    //     return;
    // }
    
    if (typeof Chart === 'undefined') {
        console.error('Chart.js yüklenmedi!');
        setTimeout(initCharts, 100);
        return;
    }

    // Statistics Chart (Bar)
    const ctx = document.getElementById('statisticsChart');
    if (ctx) {
        let defaultLabels = [];
        let defaultData = [];
        
        if (chartData && chartData['1M'] && chartData['1M'].labels && chartData['1M'].labels.length > 0) {
            defaultLabels = chartData['1M'].labels;
            defaultData = chartData['1M'].data;
        } else if (chartData && chartData['1D'] && chartData['1D'].labels && chartData['1D'].labels.length > 0) {
            defaultLabels = chartData['1D'].labels;
            defaultData = chartData['1D'].data;
        } else {
            defaultLabels = ['Veri Yok'];
            defaultData = [0];
        }
        
        try {
            window.statisticsChart = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: defaultLabels,
                    datasets: [{
                        label: 'Rezervasyon Sayısı',
                        data: defaultData,
                        backgroundColor: 'rgba(102, 126, 234, 0.8)',
                        borderColor: 'rgba(102, 126, 234, 1)',
                        borderWidth: 2,
                        borderRadius: 8,
                        borderSkipped: false,
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        },
                        tooltip: {
                            backgroundColor: 'rgba(0, 0, 0, 0.9)',
                            padding: 12,
                            titleFont: {
                                size: 13,
                                weight: '600'
                            },
                            bodyFont: {
                                size: 12
                            },
                            cornerRadius: 8,
                            displayColors: false,
                            borderColor: 'rgba(102, 126, 234, 0.5)',
                            borderWidth: 1
                        }
                    },
                    scales: {
                        x: {
                            ticks: {
                                color: '#64748b',
                                font: {
                                    size: 11
                                }
                            },
                            grid: {
                                color: 'rgba(148, 163, 184, 0.2)',
                                drawBorder: false
                            }
                        },
                        y: {
                            beginAtZero: true,
                            ticks: {
                                color: '#64748b',
                                font: {
                                    size: 11
                                }
                            },
                            grid: {
                                color: 'rgba(148, 163, 184, 0.2)',
                                drawBorder: false
                            }
                        }
                    }
                }
            });
        } catch (error) {
            console.error('Statistics Chart oluşturma hatası:', error);
        }
    }

    // Revenue Chart (Line)
    const revenueCtx = document.getElementById('revenueChart');
    if (revenueCtx) {
        try {
            revenueChart = new Chart(revenueCtx, {
                type: 'line',
                data: {
                    labels: {!! json_encode(array_column($last30DaysRevenue ?? [], 'date')) !!},
                    datasets: [{
                        label: 'Gelir (₺)',
                        data: {!! json_encode(array_column($last30DaysRevenue ?? [], 'revenue')) !!},
                        borderColor: 'rgba(67, 233, 123, 1)',
                        backgroundColor: 'rgba(67, 233, 123, 0.1)',
                        borderWidth: 2.5,
                        fill: true,
                        tension: 0.4,
                        pointRadius: 3,
                        pointHoverRadius: 5,
                        pointBackgroundColor: '#43e97b',
                        pointBorderColor: '#fff',
                        pointBorderWidth: 2,
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        },
                        tooltip: {
                            backgroundColor: 'rgba(0, 0, 0, 0.9)',
                            padding: 12,
                            titleFont: {
                                size: 13,
                                weight: '600'
                            },
                            bodyFont: {
                                size: 12
                            },
                            cornerRadius: 8,
                            displayColors: false,
                            borderColor: 'rgba(67, 233, 123, 0.5)',
                            borderWidth: 1,
                            callbacks: {
                                label: function(context) {
                                    return context.parsed.y.toLocaleString('tr-TR') + ' ₺';
                                }
                            }
                        }
                    },
                    scales: {
                        x: {
                            ticks: {
                                color: '#94a3b8',
                                font: {
                                    size: 10
                                },
                                maxRotation: 45,
                                minRotation: 45
                            },
                            grid: {
                                color: 'rgba(148, 163, 184, 0.2)',
                                drawBorder: false
                            }
                        },
                        y: {
                            beginAtZero: true,
                            ticks: {
                                color: '#64748b',
                                font: {
                                    size: 10
                                },
                                callback: function(value) {
                                    if (value >= 1000) {
                                        return (value / 1000).toFixed(1) + 'K ₺';
                                    }
                                    return value.toLocaleString('tr-TR') + ' ₺';
                                }
                            },
                            grid: {
                                color: 'rgba(148, 163, 184, 0.2)',
                                drawBorder: false
                            }
                        }
                    }
                }
            });
        } catch (error) {
            console.error('Revenue Chart oluşturma hatası:', error);
        }
    }

    // Visitors Chart kaldırıldı (Status Distribution kaldırıldı)

    // Revenue Area Chart - Haftalık (Son 7 Gün)
    const revenueAreaCtx = document.getElementById('revenueAreaChart');
    if (revenueAreaCtx) {
        try {
            // Son 7 günlük veriyi al
            const last7DaysRevenue = {!! json_encode(array_slice($last30DaysRevenue ?? [], -7)) !!};
            new Chart(revenueAreaCtx, {
                type: 'line',
                data: {
                    labels: last7DaysRevenue.map(d => d.date),
                    datasets: [{
                        label: 'Gelir (₺)',
                        data: last7DaysRevenue.map(d => d.revenue),
                        borderColor: 'rgba(67, 233, 123, 1)',
                        backgroundColor: 'rgba(67, 233, 123, 0.2)',
                        borderWidth: 3,
                        fill: true,
                        tension: 0.5,
                        pointRadius: 4,
                        pointHoverRadius: 6,
                        pointBackgroundColor: '#43e97b',
                        pointBorderColor: '#fff',
                        pointBorderWidth: 2,
                        pointHoverBackgroundColor: '#38f9d7',
                        pointHoverBorderColor: '#fff',
                        pointHoverBorderWidth: 3
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        },
                        tooltip: {
                            backgroundColor: 'rgba(0, 0, 0, 0.9)',
                            padding: 12,
                            cornerRadius: 8,
                            callbacks: {
                                label: function(context) {
                                    return context.parsed.y.toLocaleString('tr-TR') + ' ₺';
                                }
                            }
                        }
                    },
                    scales: {
                        x: {
                            ticks: {
                                color: '#64748b',
                                font: { size: 10 }
                            },
                            grid: {
                                color: 'rgba(148, 163, 184, 0.1)',
                                drawBorder: false
                            }
                        },
                        y: {
                            beginAtZero: true,
                            ticks: {
                                color: '#64748b',
                                font: { size: 10 },
                                callback: function(value) {
                                    if (value >= 1000) {
                                        return (value / 1000).toFixed(1) + 'K ₺';
                                    }
                                    return value.toLocaleString('tr-TR') + ' ₺';
                                }
                            },
                            grid: {
                                color: 'rgba(148, 163, 184, 0.1)',
                                drawBorder: false
                            }
                        }
                    },
                    animation: {
                        duration: 2000,
                        easing: 'easeInOutQuart'
                    }
                }
            });
        } catch (error) {
            console.error('Revenue Area Chart oluşturma hatası:', error);
        }
    }
}

// Make changePeriod function available globally
window.changePeriod = function(period) {
    // Update button styles
    document.querySelectorAll('.period-btn').forEach(btn => {
        btn.classList.remove('active');
    });
    event.target.classList.add('active');
    
    // Update chart data
    if (window.statisticsChart && chartData && chartData[period]) {
        const periodData = chartData[period];
        if (periodData.labels && periodData.data && periodData.labels.length > 0) {
            window.statisticsChart.data.labels = periodData.labels;
            window.statisticsChart.data.datasets[0].data = periodData.data;
            window.statisticsChart.update('active');
        }
    }
};

// Initialize charts when page loads - TÜM CİHAZLARDA (mobilde de)
// if (!isMobileDevice) { // KALDIRILDI - mobilde de çalışsın
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', function() {
            // Chart.js yüklenene kadar bekle
            if (typeof Chart !== 'undefined') {
                initCharts();
            } else {
                setTimeout(function() {
                    if (typeof Chart !== 'undefined') {
                        initCharts();
                    }
                }, 500);
            }
        });
    } else {
        if (typeof Chart !== 'undefined') {
            initCharts();
        }
    }
// }
</script>
@endpush
