@extends('layouts.admin')

@section('title', 'Sık Sorulan Sorular')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Yardım - SSS</li>
@endsection

@section('content')
<style>
    .help-hero {
        background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
        border-radius: 20px;
        padding: 40px;
        color: white;
        margin-bottom: 30px;
        box-shadow: 0 10px 30px rgba(37, 99, 235, 0.3);
    }
    
    .help-hero h1 {
        font-size: 36px;
        font-weight: 700;
        margin-bottom: 10px;
    }
    
    .help-hero p {
        font-size: 18px;
        opacity: 0.9;
        margin: 0;
    }
    
    .faq-category {
        margin-bottom: 30px;
    }
    
    .faq-category-title {
        font-size: 24px;
        font-weight: 700;
        color: #1e293b;
        margin-bottom: 20px;
        display: flex;
        align-items: center;
        gap: 12px;
        padding-bottom: 10px;
        border-bottom: 3px solid #e2e8f0;
    }
    
    .faq-category-title i {
        font-size: 28px;
        color: #2563eb;
    }
    
    .accordion-item {
        border: none;
        margin-bottom: 12px;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        transition: all 0.3s ease;
    }
    
    .accordion-item:hover {
        box-shadow: 0 4px 16px rgba(0,0,0,0.12);
        transform: translateY(-2px);
    }
    
    .accordion-button {
        background: linear-gradient(135deg, #f8fafc 0%, #ffffff 100%);
        border: none;
        padding: 20px 24px;
        font-weight: 600;
        font-size: 16px;
        color: #1e293b;
        box-shadow: none;
    }
    
    .accordion-button:not(.collapsed) {
        background: linear-gradient(135deg, #dbeafe 0%, #eff6ff 100%);
        color: #2563eb;
        box-shadow: none;
    }
    
    .accordion-button:focus {
        box-shadow: none;
        border-color: transparent;
    }
    
    .accordion-body {
        padding: 24px;
        background: white;
        color: #475569;
        line-height: 1.8;
        font-size: 15px;
    }
    
    .accordion-body ul {
        margin: 12px 0;
        padding-left: 24px;
    }
    
    .accordion-body li {
        margin-bottom: 8px;
    }
    
    .help-card {
        background: white;
        border-radius: 16px;
        padding: 30px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        margin-bottom: 30px;
    }
    
    .quick-links {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 20px;
        margin-top: 30px;
    }
    
    .quick-link-card {
        background: linear-gradient(135deg, #f8fafc 0%, #ffffff 100%);
        border: 2px solid #e2e8f0;
        border-radius: 12px;
        padding: 24px;
        text-align: center;
        transition: all 0.3s ease;
        cursor: pointer;
        text-decoration: none;
        color: inherit;
    }
    
    .quick-link-card:hover {
        transform: translateY(-4px);
        border-color: #2563eb;
        box-shadow: 0 8px 24px rgba(37, 99, 235, 0.15);
        text-decoration: none;
        color: inherit;
    }
    
    .quick-link-card i {
        font-size: 36px;
        color: #2563eb;
        margin-bottom: 12px;
    }
    
    .quick-link-card h5 {
        font-weight: 600;
        color: #1e293b;
        margin-bottom: 8px;
    }
    
    .quick-link-card p {
        color: #64748b;
        font-size: 14px;
        margin: 0;
    }
    
    .search-box {
        position: relative;
        margin-bottom: 30px;
    }
    
    .search-box input {
        padding: 16px 20px 16px 50px;
        border-radius: 12px;
        border: 2px solid #e2e8f0;
        font-size: 16px;
        width: 100%;
        transition: all 0.3s ease;
    }
    
    .search-box input:focus {
        border-color: #2563eb;
        box-shadow: 0 0 0 4px rgba(37, 99, 235, 0.1);
        outline: none;
    }
    
    .search-box i {
        position: absolute;
        left: 18px;
        top: 50%;
        transform: translateY(-50%);
        color: #64748b;
        font-size: 20px;
    }
</style>

<div class="container-fluid">
    <!-- Hero Section -->
    <div class="help-hero">
        <h1><i class="bi bi-question-circle me-3"></i>Yardım Merkezi</h1>
        <p>Sık sorulan sorular ve kullanım kılavuzu</p>
    </div>
    
    <!-- Arama Kutusu -->
    <div class="search-box">
        <i class="bi bi-search"></i>
        <input type="text" id="faqSearch" placeholder="Sorunuzu arayın..." autocomplete="off">
    </div>
    
    <!-- Hızlı Erişim -->
    <div class="quick-links">
        <a href="#rezervasyonlar" class="quick-link-card">
            <i class="bi bi-calendar-check"></i>
            <h5>Rezervasyonlar</h5>
            <p>Rezervasyon oluşturma ve yönetimi</p>
        </a>
        <a href="#musteriler" class="quick-link-card">
            <i class="bi bi-people"></i>
            <h5>Müşteriler</h5>
            <p>Müşteri ekleme ve düzenleme</p>
        </a>
        <a href="#muhasebe" class="quick-link-card">
            <i class="bi bi-cash-stack"></i>
            <h5>Muhasebe</h5>
            <p>Gelir-gider ve kasa işlemleri</p>
        </a>
        <a href="{{ route('admin.help.support') }}" class="quick-link-card">
            <i class="bi bi-headset"></i>
            <h5>Destek Talebi</h5>
            <p>Yardıma mı ihtiyacınız var?</p>
        </a>
    </div>
    
    <!-- Rezervasyonlar -->
    <div class="help-card" id="rezervasyonlar">
        <div class="faq-category">
            <div class="faq-category-title">
                <i class="bi bi-calendar-check"></i>
                <span>Rezervasyon İşlemleri</span>
            </div>
            
            <div class="accordion" id="faqReservations">
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faq1">
                            <i class="bi bi-plus-circle me-2"></i> Rezervasyon nasıl oluşturulur?
                        </button>
                    </h2>
                    <div id="faq1" class="accordion-collapse collapse show" data-bs-parent="#faqReservations">
                        <div class="accordion-body">
                            <strong>Rezervasyon oluşturmanın birkaç yolu vardır:</strong>
                            <ul>
                                <li><strong>Takvimden:</strong> Rezervasyon Takvimi sayfasından istediğiniz tarihe tıklayarak yeni rezervasyon oluşturabilirsiniz.</li>
                                <li><strong>Rezervasyon Listesi:</strong> Rezervasyon İşlemleri menüsünden "Tüm Rezervasyonlar" sayfasına gidin ve "Yeni Rezervasyon" butonuna tıklayın.</li>
                                <li><strong>Hızlı Erişim:</strong> Takvim sayfasının altındaki "Yeni Rezervasyon" butonunu kullanabilirsiniz.</li>
                            </ul>
                            <p class="mt-3"><strong>Rezervasyon oluştururken:</strong></p>
                            <ul>
                                <li>Müşteri seçimi yapın (yoksa yeni müşteri ekleyebilirsiniz)</li>
                                <li>Salon seçin</li>
                                <li>Tarih ve saat aralığını belirleyin</li>
                                <li>Yemekler, ekstralar ve organizasyon ücretlerini ekleyin</li>
                                <li>Rezervasyon ücreti ve kapora bilgilerini girin</li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq2">
                            <i class="bi bi-x-circle me-2"></i> Rezervasyon nasıl iptal edilir?
                        </button>
                    </h2>
                    <div id="faq2" class="accordion-collapse collapse" data-bs-parent="#faqReservations">
                        <div class="accordion-body">
                            Rezervasyonu iptal etmek için:
                            <ol>
                                <li>Rezervasyon detay sayfasına gidin</li>
                                <li>Durum alanından "İptal" seçeneğini seçin</li>
                                <li>Değişiklikleri kaydedin</li>
                            </ol>
                            <p class="mt-3"><strong>Not:</strong> İptal edilen rezervasyonlar takvimde görünmez ve istatistiklerde "İptal" kategorisinde gösterilir.</p>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq3">
                            <i class="bi bi-check-circle me-2"></i> Rezervasyon nasıl onaylanır?
                        </button>
                    </h2>
                    <div id="faq3" class="accordion-collapse collapse" data-bs-parent="#faqReservations">
                        <div class="accordion-body">
                            Rezervasyonu onaylamak için:
                            <ol>
                                <li>Rezervasyon detay sayfasına gidin</li>
                                <li>Durum alanından "Onaylandı" seçeneğini seçin</li>
                                <li>Değişiklikleri kaydedin</li>
                            </ol>
                            <p class="mt-3">Onaylanan rezervasyonlar takvimde yeşil renkte görünür ve istatistiklerde "Onaylanan" kategorisinde gösterilir.</p>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq4">
                            <i class="bi bi-receipt me-2"></i> Fatura nasıl oluşturulur?
                        </button>
                    </h2>
                    <div id="faq4" class="accordion-collapse collapse" data-bs-parent="#faqReservations">
                        <div class="accordion-body">
                            Yeni rezervasyon oluştururken "Onayla ve Faturalandır" butonuna tıkladığınızda:
                            <ul>
                                <li>Fatura önizlemesi gösterilir</li>
                                <li>Fatura PDF olarak oluşturulur ve storage'a kaydedilir</li>
                                <li>Her salon için özel sözleşme PDF'i oluşturulur</li>
                                <li>WhatsApp/SMS gönderimi için mesaj hazırlanır</li>
                            </ul>
                            <p class="mt-3">Faturalar "Faturalar" menüsünden görüntülenebilir ve PDF olarak indirilebilir.</p>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq5">
                            <i class="bi bi-clock me-2"></i> Takvimde saat seçimi nasıl yapılır?
                        </button>
                    </h2>
                    <div id="faq5" class="accordion-collapse collapse" data-bs-parent="#faqReservations">
                        <div class="accordion-body">
                            Rezervasyon oluştururken:
                            <ul>
                                <li><strong>Başlangıç Saati:</strong> Rezervasyonun başlayacağı saati seçin</li>
                                <li><strong>Bitiş Saati:</strong> Rezervasyonun biteceği saati seçin</li>
                            </ul>
                            <p class="mt-3"><strong>Önemli:</strong> Sistem, seçtiğiniz tarih ve saatte daha önce rezervasyon olup olmadığını kontrol eder. Dolu saatler seçilemez.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Müşteriler -->
    <div class="help-card" id="musteriler">
        <div class="faq-category">
            <div class="faq-category-title">
                <i class="bi bi-people"></i>
                <span>Müşteri Yönetimi</span>
            </div>
            
            <div class="accordion" id="faqCustomers">
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq6">
                            <i class="bi bi-person-plus me-2"></i> Yeni müşteri nasıl eklenir?
                        </button>
                    </h2>
                    <div id="faq6" class="accordion-collapse collapse" data-bs-parent="#faqCustomers">
                        <div class="accordion-body">
                            Yeni müşteri eklemenin yolları:
                            <ul>
                                <li><strong>Müşteriler Sayfası:</strong> Müşteriler menüsünden "Yeni Müşteri" butonuna tıklayın</li>
                                <li><strong>Rezervasyon Oluştururken:</strong> Yeni rezervasyon modalında "Yeni Müşteri Ekle" butonunu kullanın</li>
                            </ul>
                            <p class="mt-3"><strong>Müşteri bilgileri:</strong></p>
                            <ul>
                                <li>İsim (zorunlu)</li>
                                <li>Telefon (opsiyonel)</li>
                                <li>E-posta (opsiyonel)</li>
                                <li>Adres (opsiyonel)</li>
                                <li>Notlar (opsiyonel)</li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq7">
                            <i class="bi bi-search me-2"></i> Müşteri nasıl aranır?
                        </button>
                    </h2>
                    <div id="faq7" class="accordion-collapse collapse" data-bs-parent="#faqCustomers">
                        <div class="accordion-body">
                            Müşteri arama yöntemleri:
                            <ul>
                                <li><strong>Rezervasyon Oluştururken:</strong> Müşteri seçim alanına isim veya telefon numarası yazarak arama yapabilirsiniz</li>
                                <li><strong>Müşteriler Sayfası:</strong> Sayfanın üst kısmındaki arama kutusunu kullanabilirsiniz</li>
                                <li><strong>Header Arama:</strong> Üst menüdeki global arama kutusunu kullanabilirsiniz</li>
                            </ul>
                            <p class="mt-3">Arama, müşteri ismi ve telefon numarasına göre yapılır.</p>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq8">
                            <i class="bi bi-wallet2 me-2"></i> Müşteri bakiyesi nedir?
                        </button>
                    </h2>
                    <div id="faq8" class="accordion-collapse collapse" data-bs-parent="#faqCustomers">
                        <div class="accordion-body">
                            Müşteri bakiyesi, müşterinin size olan borç/alacak durumunu gösterir:
                            <ul>
                                <li><strong>Pozitif Bakiye:</strong> Müşteri size borçludur</li>
                                <li><strong>Negatif Bakiye:</strong> Müşteriye borçlusunuz</li>
                                <li><strong>Sıfır Bakiye:</strong> Hesap kapalı</li>
                            </ul>
                            <p class="mt-3"><strong>Bakiye nasıl değişir?</strong></p>
                            <ul>
                                <li><strong>Gelir Eklendiğinde:</strong> Müşteri bakiyesinden borç düşer (negatif olabilir)</li>
                                <li><strong>Gider Eklendiğinde:</strong> Müşteri bakiyesine borç eklenir</li>
                                <li><strong>Rezervasyon Oluşturulduğunda:</strong> Rezervasyon ücreti bakiyeye eklenir</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Muhasebe -->
    <div class="help-card" id="muhasebe">
        <div class="faq-category">
            <div class="faq-category-title">
                <i class="bi bi-cash-stack"></i>
                <span>Muhasebe ve Kasa İşlemleri</span>
            </div>
            
            <div class="accordion" id="faqAccounting">
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq9">
                            <i class="bi bi-plus-circle me-2"></i> Gelir nasıl eklenir?
                        </button>
                    </h2>
                    <div id="faq9" class="accordion-collapse collapse" data-bs-parent="#faqAccounting">
                        <div class="accordion-body">
                            Gelir eklemek için:
                            <ol>
                                <li>Muhasebe menüsünden "Kasa" sayfasına gidin</li>
                                <li>"Gelir Ekle" butonuna tıklayın</li>
                                <li>Formu doldurun:
                                    <ul>
                                        <li>Tutar (zorunlu)</li>
                                        <li>Tarih (zorunlu)</li>
                                        <li>Müşteri (opsiyonel)</li>
                                        <li>Rezervasyon (opsiyonel)</li>
                                        <li>Açıklama (opsiyonel)</li>
                                    </ul>
                                </li>
                                <li>"Kaydet" butonuna tıklayın</li>
                            </ol>
                            <p class="mt-3"><strong>Önemli:</strong> Gelir eklendiğinde müşteri bakiyesinden borç düşer. Eğer fazla gelir eklenirse müşteri bakiyesi negatife düşer (müşteriye borçlu olursunuz).</p>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq10">
                            <i class="bi bi-dash-circle me-2"></i> Gider nasıl eklenir?
                        </button>
                    </h2>
                    <div id="faq10" class="accordion-collapse collapse" data-bs-parent="#faqAccounting">
                        <div class="accordion-body">
                            Gider eklemek için:
                            <ol>
                                <li>Muhasebe menüsünden "Kasa" sayfasına gidin</li>
                                <li>"Gider Ekle" butonuna tıklayın</li>
                                <li>Formu doldurun (gelir ekleme ile aynı alanlar)</li>
                                <li>"Kaydet" butonuna tıklayın</li>
                            </ol>
                            <p class="mt-3"><strong>Önemli:</strong> Gider eklendiğinde müşteri seçildiyse, müşteri bakiyesine borç olarak eklenir. Bu, müşteriye ekstra bir şey eklediğinizde kullanılır.</p>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq11">
                            <i class="bi bi-pencil me-2"></i> İşlem nasıl düzenlenir?
                        </button>
                    </h2>
                    <div id="faq11" class="accordion-collapse collapse" data-bs-parent="#faqAccounting">
                        <div class="accordion-body">
                            İşlem düzenlemek için:
                            <ol>
                                <li>Kasa sayfasındaki işlem listesinde düzenlemek istediğiniz işlemin yanındaki "Düzenle" butonuna tıklayın</li>
                                <li>Açılan modal'da:
                                    <ul>
                                        <li>Tutarı değiştirebilirsiniz</li>
                                        <li>Tarihi değiştirebilirsiniz</li>
                                        <li>Müşteriyi değiştirebilirsiniz</li>
                                        <li>Açıklamayı değiştirebilirsiniz</li>
                                    </ul>
                                </li>
                                <li>"Güncelle" butonuna tıklayın</li>
                            </ol>
                            <p class="mt-3"><strong>Not:</strong> İşlem düzenlendiğinde bakiyeler otomatik olarak güncellenir.</p>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq12">
                            <i class="bi bi-trash me-2"></i> İşlem nasıl silinir?
                        </button>
                    </h2>
                    <div id="faq12" class="accordion-collapse collapse" data-bs-parent="#faqAccounting">
                        <div class="accordion-body">
                            İşlem silmek için:
                            <ol>
                                <li>Kasa sayfasındaki işlem listesinde silmek istediğiniz işlemin yanındaki "Sil" butonuna tıklayın</li>
                                <li>Onay mesajını kabul edin</li>
                            </ol>
                            <p class="mt-3"><strong>Önemli:</strong> İşlem silindiğinde bakiyeler otomatik olarak geri alınır. Bu işlem geri alınamaz, dikkatli olun.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Genel Sorular -->
    <div class="help-card">
        <div class="faq-category">
            <div class="faq-category-title">
                <i class="bi bi-info-circle"></i>
                <span>Genel Sorular</span>
            </div>
            
            <div class="accordion" id="faqGeneral">
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq13">
                            <i class="bi bi-shield-check me-2"></i> Verilerim güvende mi?
                        </button>
                    </h2>
                    <div id="faq13" class="accordion-collapse collapse" data-bs-parent="#faqGeneral">
                        <div class="accordion-body">
                            <p>Evet, tüm verileriniz güvendedir. Sistem şu güvenlik önlemlerini kullanır:</p>
                            <ul>
                                <li>Kullanıcı bazlı veri izolasyonu (rezervasyoncu ve admin rolleri sadece kendi verilerini görür)</li>
                                <li>Güvenli veritabanı bağlantıları</li>
                                <li>Düzenli yedekleme</li>
                                <li>Şifreli veri saklama</li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq14">
                            <i class="bi bi-phone me-2"></i> Destek nasıl alabilirim?
                        </button>
                    </h2>
                    <div id="faq14" class="accordion-collapse collapse" data-bs-parent="#faqGeneral">
                        <div class="accordion-body">
                            Destek almak için:
                            <ul>
                                <li><strong>Yardım Menüsü:</strong> "Yardım > Destek Talebi" sayfasından destek talebi oluşturabilirsiniz</li>
                                <li><strong>E-posta:</strong> Destek ekibimize e-posta gönderebilirsiniz</li>
                                <li><strong>Telefon:</strong> Müşteri hizmetleri hattımızı arayabilirsiniz</li>
                            </ul>
                            <p class="mt-3">Destek talebiniz en kısa sürede yanıtlanacaktır.</p>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Arama fonksiyonu
    const searchInput = document.getElementById('faqSearch');
    
    if (searchInput) {
        searchInput.addEventListener('input', function(e) {
            const searchTerm = e.target.value.toLowerCase().trim();
            const accordionItems = document.querySelectorAll('.accordion-item');
            const helpCards = document.querySelectorAll('.help-card');
            
            if (searchTerm === '') {
                // Arama boşsa tüm öğeleri göster
                accordionItems.forEach(item => {
                    item.style.display = '';
                });
                helpCards.forEach(card => {
                    card.style.display = '';
                });
                return;
            }
            
            let hasResults = false;
            
            accordionItems.forEach(item => {
                const question = item.querySelector('.accordion-button')?.textContent.toLowerCase() || '';
                const answer = item.querySelector('.accordion-body')?.textContent.toLowerCase() || '';
                
                if (question.includes(searchTerm) || answer.includes(searchTerm)) {
                    item.style.display = '';
                    hasResults = true;
                } else {
                    item.style.display = 'none';
                }
            });
            
            // Eğer kategori içinde sonuç varsa kategoriyi göster, yoksa gizle
            helpCards.forEach(card => {
                const visibleItems = card.querySelectorAll('.accordion-item[style=""]');
                const allItems = card.querySelectorAll('.accordion-item');
                
                if (visibleItems.length > 0 || searchTerm === '') {
                    card.style.display = '';
                } else {
                    card.style.display = 'none';
                }
            });
            
            // Sonuç yoksa mesaj göster
            const noResultsMessage = document.getElementById('noResultsMessage');
            if (!hasResults && searchTerm !== '') {
                if (!noResultsMessage) {
                    const message = document.createElement('div');
                    message.id = 'noResultsMessage';
                    message.className = 'alert alert-info mt-4';
                    message.innerHTML = '<i class="bi bi-info-circle me-2"></i>Aradığınız kriterlere uygun sonuç bulunamadı.';
                    const container = document.querySelector('.container-fluid');
                    if (container) {
                        container.appendChild(message);
                    }
                }
            } else {
                if (noResultsMessage) {
                    noResultsMessage.remove();
                }
            }
        });
        
        // Enter tuşu ile arama
        searchInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
            }
        });
    }
    
    // Smooth scroll for quick links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
});
</script>
@endpush
@endsection
