@extends('layouts.admin')

@section('title', 'Destek Talebi')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.help.faq') }}">Yardım</a></li>
    <li class="breadcrumb-item active">Destek Talebi</li>
@endsection

@section('content')
<style>
    .support-hero {
        background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
        border-radius: 20px;
        padding: 40px;
        color: white;
        margin-bottom: 30px;
        box-shadow: 0 10px 30px rgba(124, 58, 237, 0.3);
    }
    
    .support-hero h1 {
        font-size: 36px;
        font-weight: 700;
        margin-bottom: 10px;
    }
    
    .support-hero p {
        font-size: 18px;
        opacity: 0.9;
        margin: 0;
    }
    
    .support-card {
        background: white;
        border-radius: 16px;
        padding: 40px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        margin-bottom: 30px;
    }
    
    .form-label {
        font-weight: 600;
        color: #1e293b;
        margin-bottom: 8px;
        font-size: 15px;
    }
    
    .form-control, .form-select {
        border-radius: 12px;
        border: 2px solid #e2e8f0;
        padding: 14px 18px;
        font-size: 15px;
        transition: all 0.3s ease;
    }
    
    .form-control:focus, .form-select:focus {
        border-color: #2563eb;
        box-shadow: 0 0 0 4px rgba(124, 58, 237, 0.1);
        outline: none;
    }
    
    .form-control::placeholder {
        color: #94a3b8;
    }
    
    textarea.form-control {
        min-height: 150px;
        resize: vertical;
    }
    
    .btn-submit {
        background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
        border: none;
        padding: 14px 32px;
        font-weight: 600;
        font-size: 16px;
        border-radius: 12px;
        color: white;
        transition: all 0.3s ease;
        box-shadow: 0 4px 12px rgba(124, 58, 237, 0.3);
    }
    
    .btn-submit:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(124, 58, 237, 0.4);
    }
    
    .info-box {
        background: linear-gradient(135deg, #f8fafc 0%, #ffffff 100%);
        border: 2px solid #e2e8f0;
        border-radius: 12px;
        padding: 24px;
        margin-top: 30px;
    }
    
    .info-box h5 {
        color: #1e293b;
        font-weight: 600;
        margin-bottom: 16px;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .info-box ul {
        margin: 0;
        padding-left: 24px;
        color: #475569;
    }
    
    .info-box li {
        margin-bottom: 8px;
        line-height: 1.6;
    }
    
    .contact-cards {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 20px;
        margin-top: 30px;
    }
    
    .contact-card {
        background: linear-gradient(135deg, #f8fafc 0%, #ffffff 100%);
        border: 2px solid #e2e8f0;
        border-radius: 12px;
        padding: 24px;
        text-align: center;
        transition: all 0.3s ease;
    }
    
    .contact-card:hover {
        transform: translateY(-4px);
        border-color: #2563eb;
        box-shadow: 0 8px 24px rgba(124, 58, 237, 0.15);
    }
    
    .contact-card i {
        font-size: 36px;
        color: #2563eb;
        margin-bottom: 12px;
    }
    
    .contact-card h5 {
        font-weight: 600;
        color: #1e293b;
        margin-bottom: 8px;
    }
    
    .contact-card p {
        color: #64748b;
        font-size: 14px;
        margin: 0;
    }
    
    .required-field {
        color: #dc2626;
    }
</style>

<div class="container-fluid">
    <!-- Hero Section -->
    <div class="support-hero">
        <h1><i class="bi bi-headset me-3"></i>Destek Merkezi</h1>
        <p>Size yardımcı olmaktan mutluluk duyarız</p>
    </div>
    
    <div class="row">
        <div class="col-lg-8">
            <div class="support-card">
                <h3 class="mb-4" style="color: #1e293b; font-weight: 700;">
                    <i class="bi bi-envelope-paper me-2" style="color: #7c3aed;"></i>Destek Talebi Oluştur
                </h3>
                
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif
                
                @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="bi bi-exclamation-circle me-2"></i>
                        <ul class="mb-0">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif
                
                <form method="POST" action="{{ route('admin.help.submit') }}">
                    @csrf
                    
                    <div class="mb-4">
                        <label class="form-label">
                            Konu <span class="required-field">*</span>
                        </label>
                        <input type="text" name="subject" class="form-control" placeholder="Örn: Rezervasyon oluşturma sorunu" value="{{ old('subject') }}" required>
                        <small class="text-muted">Sorununuzu kısaca özetleyin</small>
                    </div>
                    
                    <div class="mb-4">
                        <label class="form-label">
                            Kategori
                        </label>
                        <select name="category" class="form-select">
                            <option value="">Kategori Seçiniz</option>
                            <option value="technical" {{ old('category') == 'technical' ? 'selected' : '' }}>Teknik Sorun</option>
                            <option value="billing" {{ old('category') == 'billing' ? 'selected' : '' }}>Faturalama</option>
                            <option value="feature" {{ old('category') == 'feature' ? 'selected' : '' }}>Özellik İsteği</option>
                            <option value="other" {{ old('category') == 'other' ? 'selected' : '' }}>Diğer</option>
                        </select>
                    </div>
                    
                    <div class="mb-4">
                        <label class="form-label">
                            Mesaj <span class="required-field">*</span>
                        </label>
                        <textarea name="message" class="form-control" rows="8" placeholder="Sorununuzu veya isteğinizi detaylı olarak açıklayın..." required>{{ old('message') }}</textarea>
                        <small class="text-muted">Mümkün olduğunca detaylı bilgi verin, böylece size daha hızlı yardımcı olabiliriz</small>
                    </div>
                    
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-submit">
                            <i class="bi bi-send me-2"></i>Gönder
                        </button>
                        <a href="{{ route('admin.help.faq') }}" class="btn btn-outline-secondary" style="padding: 14px 32px; border-radius: 12px;">
                            <i class="bi bi-arrow-left me-2"></i>SSS'ye Dön
                        </a>
                    </div>
                </form>
            </div>
        </div>
        
        <div class="col-lg-4">
            <div class="info-box">
                <h5>
                    <i class="bi bi-info-circle" style="color: #7c3aed;"></i>
                    Bilgilendirme
                </h5>
                <ul>
                    <li>Destek talebiniz en geç 24 saat içinde yanıtlanacaktır</li>
                    <li>Teknik sorunlar için ekran görüntüsü eklemeniz yardımcı olur</li>
                    <li>Acil durumlar için telefon desteğimizi kullanabilirsiniz</li>
                    <li>SSS sayfasını kontrol ederek hızlı çözüm bulabilirsiniz</li>
                </ul>
            </div>
            
            <div class="contact-cards">
                <div class="contact-card">
                    <i class="bi bi-envelope"></i>
                    <h5>E-posta</h5>
                    <p>destek@example.com</p>
                </div>
                
                <div class="contact-card">
                    <i class="bi bi-telephone"></i>
                    <h5>Telefon</h5>
                    <p>0850 XXX XX XX</p>
                </div>
                
                <div class="contact-card">
                    <i class="bi bi-clock"></i>
                    <h5>Çalışma Saatleri</h5>
                    <p>Pazartesi - Cuma<br>09:00 - 18:00</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
