<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Fatura - {{ $invoice->invoice_number ?? ($reservation->code ?? $reservation->id ?? '') }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'dejavu sans', sans-serif;
            font-size: 11px;
            color: #333;
            background: white;
            padding: 15px 25px;
        }
        .header {
            width: 100%;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 2px solid #dc2626;
        }
        .header-table {
            width: 100%;
        }
        .header-table td {
            vertical-align: top;
        }
        .salon-name {
            font-size: 22px;
            color: #dc2626;
            font-weight: bold;
            margin-bottom: 5px;
        }
        .salon-address {
            font-size: 10px;
            color: #666;
            line-height: 1.4;
        }
        .invoice-title {
            font-size: 24px;
            font-weight: bold;
            color: #1e40af;
            text-align: right;
            margin-bottom: 8px;
        }
        .invoice-info {
            text-align: right;
            font-size: 11px;
        }
        .invoice-info-row {
            margin-bottom: 3px;
        }
        .invoice-info-label {
            color: #666;
        }
        .invoice-info-value {
            color: #333;
            font-weight: bold;
            margin-left: 5px;
        }
        .customer-section {
            margin: 15px 0;
            padding: 10px 0;
            border-bottom: 1px solid #dc2626;
        }
        .customer-label {
            font-size: 11px;
            color: #dc2626;
            font-weight: bold;
            margin-bottom: 3px;
        }
        .customer-name {
            font-size: 13px;
            font-weight: bold;
            color: #333;
            margin-bottom: 3px;
        }
        .website-info {
            font-size: 11px;
            color: #dc2626;
            font-weight: bold;
            margin-top: 8px;
        }
        table.items {
            width: 100%;
            border-collapse: collapse;
            margin: 15px 0;
        }
        table.items thead {
            background-color: #e0e7ff;
        }
        table.items th {
            padding: 10px 6px;
            text-align: left;
            font-size: 10px;
            font-weight: bold;
            color: #1e40af;
            border: 1px solid #cbd5e1;
        }
        table.items td {
            padding: 8px 6px;
            border: 1px solid #e5e7eb;
            font-size: 10px;
        }
        table.items tbody tr:nth-child(even) {
            background-color: #f9fafb;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .totals-section {
            margin-top: 20px;
            width: 100%;
        }
        .totals-table {
            width: 100%;
        }
        .totals-box {
            float: right;
            width: 250px;
        }
        .total-row {
            padding: 6px 0;
            font-size: 11px;
            border-bottom: 1px solid #e5e7eb;
        }
        .total-row:last-child {
            border-bottom: none;
        }
        .total-label {
            color: #666;
            font-weight: bold;
        }
        .total-value {
            font-weight: bold;
            color: #333;
            text-align: right;
        }
        .grand-total {
            border-top: 2px solid #1e40af;
            padding-top: 8px;
            margin-top: 5px;
        }
        .grand-total .total-label {
            color: #1e40af;
            font-size: 13px;
        }
        .grand-total .total-value {
            color: #1e40af;
            font-size: 16px;
        }
        .deposit-row .total-label,
        .deposit-row .total-value {
            color: #059669;
        }
    </style>
</head>
<body>
    <div class="header">
        <table class="header-table">
            <tr>
                <td style="width: 50%;">
                    <div class="salon-name">{{ $salonName ?? 'Düğün Salonu' }}</div>
                    <div class="salon-address">{{ $salonAddress ?? $address }}</div>
                </td>
                <td style="width: 50%;">
                    <div class="invoice-title">{{ $salonName ?? 'Düğün Salonu' }}</div>
                    <div class="invoice-info">
                        <div class="invoice-info-row">
                            <span class="invoice-info-label">Tarih</span>
                            <span class="invoice-info-value">
                                @if(isset($transaction) || !$reservation)
                                    {{ isset($invoiceDate) ? \Carbon\Carbon::parse($invoiceDate)->format('d/m/Y') : ($invoice->invoice_date ? \Carbon\Carbon::parse($invoice->invoice_date)->format('d/m/Y') : now()->format('d/m/Y')) }}
                                @else
                                    {{ $reservation->date->format('d/m/Y') }}
                                @endif
                            </span>
                        </div>
                    </div>
                </td>
            </tr>
        </table>
    </div>
    
    <div class="customer-section">
        <div class="customer-label">Sayın</div>
        <div class="customer-name">
            @if(isset($transaction) || !$reservation)
                {{ $customerName ?? ($invoice->customer->name ?? 'Müşteri') }}
            @else
                {{ $reservation->customer->name }}
            @endif
        </div>
        <div class="website-info">adugun.com</div>
    </div>
    
    <table class="items">
        <thead>
            <tr>
                <th style="width: 25%;">Cinsi</th>
                <th style="width: 20%;">Miktarı</th>
                <th style="width: 25%;">Fiyatı(₺)</th>
                <th style="width: 30%;">Tutarı(₺)</th>
            </tr>
        </thead>
        <tbody>
            @foreach($items as $item)
            <tr>
                <td>{{ $item['name'] }}</td>
                <td class="text-center">{{ $item['quantity'] }}</td>
                <td class="text-right">{{ number_format($item['price'], 2, ',', '.') }}</td>
                <td class="text-right">{{ number_format($item['total'], 2, ',', '.') }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    
    <div class="totals-section">
        <div class="totals-box">
            <table style="width: 100%;">
                <tr class="total-row">
                    <td class="total-label">Toplam</td>
                    <td class="total-value">{{ number_format($subtotal, 2, ',', '.') }}</td>
                </tr>
                @if(($depositPaid ?? 0) > 0)
                <tr class="total-row deposit-row">
                    <td class="total-label">Alınan Kapora</td>
                    <td class="total-value">{{ number_format($depositPaid ?? 0, 2, ',', '.') }}</td>
                </tr>
                @endif
                <tr class="total-row grand-total">
                    <td class="total-label">Genel Toplam</td>
                    <td class="total-value">{{ number_format($grandTotal - ($depositPaid ?? 0), 2, ',', '.') }}</td>
                </tr>
            </table>
        </div>
    </div>
</body>
</html>
