@extends('layouts.admin')

@section('title', 'Aylık Rezervasyon Raporu')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Aylık Rezervasyon Raporu</li>
@endsection

@section('content')
    <h2 class="mb-4">Aylık Rezervasyon Raporu</h2>
    
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" action="{{ route('admin.reports.monthly-reservations') }}" class="row g-3">
                <div class="col-md-6">
                    <label class="form-label fw-bold">Ay Seçin</label>
                    <input type="month" name="month" class="form-control form-control-lg" value="{{ $month }}">
                </div>
                <div class="col-md-6 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary btn-lg">
                        <i class="bi bi-search"></i> Filtrele
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-calendar-month"></i> {{ \Carbon\Carbon::parse($month)->format('F Y') }} Rezervasyonları</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Rezervasyon Kodu</th>
                            <th>Müşteri</th>
                            <th>Tarih</th>
                            <th>Salon</th>
                            <th>Durum</th>
                            <th>Tutar</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($reservations as $reservation)
                            <tr>
                                <td>{{ $reservation->code }}</td>
                                <td>{{ $reservation->customer->name }}</td>
                                <td>{{ $reservation->date->format('d.m.Y') }}</td>
                                <td>{{ $reservation->salon->name }}</td>
                                <td>
                                    @if($reservation->status == 'open')
                                        <span class="badge bg-warning">Açık</span>
                                    @elseif($reservation->status == 'confirmed')
                                        <span class="badge bg-success">Onaylandı</span>
                                    @elseif($reservation->status == 'cancelled')
                                        <span class="badge bg-danger">İptal</span>
                                    @else
                                        <span class="badge bg-info">Tamamlandı</span>
                                    @endif
                                </td>
                                <td>{{ number_format($reservation->total_price, 2) }} ₺</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center">Rezervasyon bulunamadı.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

