@extends('layouts.admin')

@section('title', 'Rezervasyon Takvimi')

@section('content')
<style>
    body {
        padding-top: var(--header-height) !important;
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
    }
    .main-content {
        padding: 0 !important;
        margin: 0 !important;
    }
    
    .calendar-container {
        background: white;
        border-radius: 0;
        box-shadow: none;
        overflow: hidden;
        margin: 0;
        width: 100%;
        min-height: 100vh;
        display: flex;
        flex-direction: column;
    }
    
    .calendar-header {
        background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
        padding: 24px 32px;
        color: white;
    }
    
    .calendar-header h2 {
        color: white;
        font-weight: 700;
        font-size: 28px;
        margin: 0;
        text-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    
    .calendar-controls {
        display: flex;
        gap: 12px;
        margin-top: 16px;
        flex-wrap: wrap;
    }
    
    .view-btn {
        padding: 10px 20px;
        border: 2px solid rgba(255,255,255,0.3);
        background: rgba(255,255,255,0.15);
        color: white;
        border-radius: 25px !important;
        font-weight: 600;
        font-size: 14px;
        cursor: pointer;
        transition: all 0.3s ease;
        backdrop-filter: blur(10px);
    }
    
    .view-btn:hover {
        background: rgba(255,255,255,0.25);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    }
    
    .view-btn.active {
        background: white;
        color: #2563eb;
        border-color: white;
        box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    }
    
    .salon-filter-wrapper {
        position: relative;
        min-width: 280px;
    }
    
    .salon-filter-input {
        width: 100%;
        padding: 12px 16px;
        border: 2px solid rgba(255,255,255,0.3);
        background: rgba(255,255,255,0.15);
        color: white;
        border-radius: 12px;
        font-size: 14px;
        backdrop-filter: blur(10px);
        transition: all 0.3s ease;
    }
    
    .salon-filter-input::placeholder {
        color: rgba(255,255,255,0.7);
    }
    
    .salon-filter-input:focus {
        outline: none;
        border-color: white;
        background: rgba(255,255,255,0.25);
        box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    }
    
    .new-reservation-btn {
        padding: 12px 24px;
        background: white;
        color: #2563eb;
        border: none;
        border-radius: 12px;
        font-weight: 700;
        font-size: 14px;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    }
    
    .new-reservation-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(0,0,0,0.25);
    }
    
    .events-sidebar {
        background: white;
        border-radius: 24px;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
        overflow: hidden;
        height: fit-content;
    }
    
    .events-sidebar-header {
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        padding: 20px 24px;
        border-bottom: 2px solid #e2e8f0;
    }
    
    .events-sidebar-header h5 {
        color: #1e293b;
        font-weight: 700;
        font-size: 18px;
        margin: 0;
    }
    
    .event-category-card {
        background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
        border: 2px solid #e2e8f0;
        border-radius: 16px;
        padding: 20px;
        margin-bottom: 16px;
        cursor: pointer;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
        overflow: hidden;
    }
    
    .event-category-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 4px;
        height: 100%;
        background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
        transform: scaleY(0);
        transition: transform 0.3s ease;
    }
    
    .event-category-card:hover {
        transform: translateX(8px);
        border-color: #2563eb;
        box-shadow: 0 8px 24px rgba(37, 99, 235, 0.15);
    }
    
    .event-category-card:hover::before {
        transform: scaleY(1);
    }
    
    .event-icon {
        width: 50px;
        height: 50px;
        border-radius: 14px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        color: white;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    }
    
    .upcoming-event-card {
        background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
        border: 2px solid #e2e8f0;
        border-radius: 16px;
        padding: 18px;
        margin-bottom: 12px;
        cursor: pointer;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
    }
    
    .upcoming-event-card:hover {
        transform: translateY(-4px);
        border-color: #2563eb;
        box-shadow: 0 8px 24px rgba(37, 99, 235, 0.2);
    }
    
    .event-status-badge {
        width: 10px;
        height: 10px;
        border-radius: 50%;
        display: inline-block;
        margin-right: 8px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.2);
    }
    
    .fc {
        font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
    }
    
    .fc-toolbar {
        padding: 20px 32px !important;
        background: white;
        border-bottom: 2px solid #e2e8f0;
    }
    
    .fc-toolbar-title {
        font-size: 26px !important;
        font-weight: 700 !important;
        color: #1e293b !important;
        letter-spacing: -0.5px;
    }
    
    .fc-button {
        background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%) !important;
        border: none !important;
        color: white !important;
        padding: 10px 20px !important;
        font-size: 14px !important;
        border-radius: 12px !important;
        font-weight: 600 !important;
        transition: all 0.3s ease !important;
        box-shadow: 0 2px 8px rgba(37, 99, 235, 0.2) !important;
    }
    
    .fc-button:hover {
        background: linear-gradient(135deg, #1e40af 0%, #1e3a8a 100%) !important;
        transform: translateY(-2px) !important;
        box-shadow: 0 4px 12px rgba(37, 99, 235, 0.3) !important;
    }
    
    .fc-button:active {
        transform: translateY(0) !important;
    }
    
    .fc-button-group {
        gap: 8px !important;
    }
    
    .fc-col-header-cell {
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%) !important;
        padding: 16px 8px !important;
        border-color: #e2e8f0 !important;
        font-weight: 700 !important;
        color: #475569 !important;
        font-size: 13px !important;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .fc-daygrid-day {
        background: white !important;
        border-color: #e2e8f0 !important;
        min-height: 140px !important;
        transition: all 0.2s ease;
        position: relative;
    }
    
    .fc-daygrid-day:hover {
        background: #f8fafc !important;
    }
    
    .fc-day-today {
        background: linear-gradient(135deg, #dbeafe 0%, #bfdbfe 100%) !important;
        position: relative;
    }
    
    .fc-day-today::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 4px;
        height: 100%;
        background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
    }
    
    .fc-daygrid-day-number {
        padding: 0 !important;
        font-weight: 600 !important;
        color: #1e293b !important;
        font-size: 14px !important;
        width: 32px !important;
        height: 32px !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
        border-radius: 50% !important;
        background: transparent !important;
        margin: 6px auto !important;
        text-decoration: none !important;
        border: none !important;
    }
    
    .fc-day-today .fc-daygrid-day-number {
        color: white !important;
        background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%) !important;
        font-weight: 700 !important;
        box-shadow: 0 2px 8px rgba(37, 99, 235, 0.3) !important;
    }
    
    .fc-daygrid-day-number:hover {
        background: #f1f5f9 !important;
        color: #2563eb !important;
    }
    
    .fc-day-today .fc-daygrid-day-number:hover {
        background: linear-gradient(135deg, #1e40af 0%, #1e3a8a 100%) !important;
        color: white !important;
    }
    
    .fc-event {
        border: none !important;
        padding: 10px 14px !important;
        border-radius: 12px !important;
        cursor: pointer !important;
        font-size: 13px !important;
        margin: 4px 2px !important;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15) !important;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
        font-weight: 600 !important;
        border-left: 4px solid rgba(255,255,255,0.5) !important;
    }
    
    .fc-event:hover {
        transform: translateY(-3px) scale(1.02) !important;
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.25) !important;
        z-index: 10 !important;
    }
    
    .fc-event-title {
        font-weight: 600 !important;
    }
    
    .fc-daygrid-event {
        white-space: nowrap !important;
        overflow: hidden !important;
        text-overflow: ellipsis !important;
    }
    
    .fc-scrollgrid {
        border: 2px solid #e2e8f0 !important;
        border-radius: 16px !important;
        overflow: hidden !important;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.06) !important;
    }
    
    .fc-scrollgrid-section > * {
        border-radius: 0 !important;
    }
    
    .fc-scrollgrid-section:first-child > * > .fc-col-header-cell:first-child {
        border-top-left-radius: 14px !important;
    }
    
    .fc-scrollgrid-section:first-child > * > .fc-col-header-cell:last-child {
        border-top-right-radius: 14px !important;
    }
    
    .fc-view-harness {
        padding: 0 32px 32px 32px !important;
        flex: 1;
        overflow: auto;
    }
    
    #calendar {
        flex: 1;
        min-height: 0;
    }
    
    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: #64748b;
    }
    
    .empty-state-icon {
        font-size: 64px;
        color: #cbd5e1;
        margin-bottom: 16px;
    }
    
    .calendar-footer {
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        border-top: 2px solid #e2e8f0;
        padding: 32px;
        margin-top: 0;
    }
    
    .info-box {
        background: white;
        border: none;
        border-radius: 24px;
        padding: 28px;
        margin-bottom: 24px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
        overflow: hidden;
    }
    
    .info-box::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, #2563eb 0%, #1e40af 100%);
        transform: scaleX(0);
        transition: transform 0.3s ease;
    }
    
    .info-box:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 30px rgba(37, 99, 235, 0.15);
    }
    
    .info-box:hover::before {
        transform: scaleX(1);
    }
    
    .info-box-title {
        font-size: 20px;
        font-weight: 700;
        color: #1e293b;
        margin-bottom: 24px;
        display: flex;
        align-items: center;
        gap: 12px;
        padding-bottom: 16px;
        border-bottom: 2px solid #f1f5f9;
    }
    
    .info-box-title i {
        font-size: 24px;
        width: 40px;
        height: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 12px;
        background: linear-gradient(135deg, #eff6ff 0%, #dbeafe 100%);
    }
    
    .info-box-title i.text-warning {
        background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
    }
    
    .info-box-title i.text-primary {
        background: linear-gradient(135deg, #dbeafe 0%, #bfdbfe 100%);
    }
    
    @media (max-width: 768px) {
        .calendar-container {
            margin: 0;
            border-radius: 0;
        }
        
        .calendar-header {
            padding: 16px 20px;
        }
        
        .calendar-header h2 {
            font-size: 22px;
        }
        
        .fc-toolbar {
            padding: 16px 20px !important;
        }
        
        .fc-view-harness {
            padding: 0 16px 16px 16px !important;
        }
        
        .calendar-footer {
            padding: 16px 20px !important;
        }
        
        .info-box {
            padding: 20px;
            border-radius: 20px;
        }
    }
</style>

<div class="container-fluid px-0">
    <div class="row g-0 mx-0">
        <!-- Tam Sayfa Takvim -->
        <div class="col-12 px-0">
            <div class="calendar-container">
                <div class="calendar-header">
                    <h2><i class="bi bi-calendar-heart me-2"></i> Rezervasyon Takvimi</h2>
                    <div class="calendar-controls">
                        <div class="salon-filter-wrapper">
                            <input type="text" id="salonFilterInput" class="salon-filter-input" placeholder="🔍 Salon ara..." autocomplete="off">
                            <select id="salonFilter" class="form-select" style="display: none;">
                                <option value="">Tüm Salonlar</option>
                                @foreach($salons ?? [] as $salon)
                                    <option value="{{ $salon->id }}" data-name="{{ strtolower($salon->name) }}">{{ $salon->name }}</option>
                                @endforeach
                            </select>
                            <div id="salonFilterDropdown" class="position-absolute w-100" style="display: none; top: 100%; left: 0; z-index: 1000; background: white; border: 2px solid #2563eb; border-radius: 12px; box-shadow: 0 8px 25px rgba(0,0,0,0.15); max-height: 300px; overflow-y: auto; margin-top: 8px;">
                            </div>
                        </div>
                        <button type="button" onclick="openNewReservationModal()" class="new-reservation-btn">
                            <i class="bi bi-plus-circle me-2"></i> Yeni Rezervasyon
                        </button>
                        <div class="d-flex gap-2">
                            <button type="button" class="view-btn active" id="viewMonth" onclick="changeCalendarView('dayGridMonth')">
                                <i class="bi bi-calendar-month me-1"></i> Ay
                            </button>
                            <button type="button" class="view-btn" id="viewWeek" onclick="changeCalendarView('timeGridWeek')">
                                <i class="bi bi-calendar-week me-1"></i> Hafta
                            </button>
                            <button type="button" class="view-btn" id="viewDay" onclick="changeCalendarView('timeGridDay')">
                                <i class="bi bi-calendar-day me-1"></i> Gün
                            </button>
                            <button type="button" class="view-btn" id="viewList" onclick="changeCalendarView('listWeek')">
                                <i class="bi bi-list-ul me-1"></i> Liste
                            </button>
                        </div>
                    </div>
                </div>
                <div id="calendar"></div>
                
                <!-- Alt Kısım - Güzel Kutular İçinde -->
                <div class="calendar-footer">
                    <div class="container-fluid px-0">
                        <div class="row g-4">
                            <!-- Bugünkü Randevular Kutusu -->
                            <div class="col-12">
                                <div class="card shadow-sm border-0" style="background: #ffffff; border-left: 4px solid #2563eb !important;">
                                    <div class="card-header bg-transparent border-bottom border-light py-3">
                                        <div class="d-flex align-items-center gap-2">
                                            <i class="bi bi-calendar-day text-primary" style="font-size: 20px;"></i>
                                            <h5 class="mb-0 fw-bold text-dark">Bugünkü Randevular</h5>
                                        </div>
                                    </div>
                                    <div class="card-body p-4">
                                        <div id="todayReservations" class="row g-3">
                                            <div class="col-12 text-center text-muted py-4">
                                                <i class="bi bi-hourglass-split" style="font-size: 32px; opacity: 0.5;"></i>
                                                <p class="mt-2 mb-0">Yükleniyor...</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- İstatistikler Kutusu -->
                            <div class="col-lg-8">
                                <div class="info-box" style="background: linear-gradient(135deg, #ffffff 0%, #f0f9ff 100%); border-left: 5px solid #0ea5e9;">
                                    <div class="info-box-title">
                                        <i class="bi bi-bar-chart-fill text-primary"></i>
                                        <span>Bu Ay İstatistikleri</span>
                                    </div>
                                    <div class="row g-3">
                                        <div class="col-md-3 col-sm-6">
                                            <div class="stat-card" style="background: linear-gradient(135deg, #dbeafe 0%, #bfdbfe 100%); border-radius: 20px; padding: 24px; text-align: center; border: none; box-shadow: 0 4px 12px rgba(37, 99, 235, 0.15);">
                                                <div class="stat-icon mb-3" style="font-size: 36px; color: #2563eb;">
                                                    <i class="bi bi-calendar-check"></i>
                                                </div>
                                                <div class="stat-value fw-bold" style="font-size: 28px; color: #1e293b; margin-bottom: 8px;" id="statTotalReservations">0</div>
                                                <div class="stat-label text-muted" style="font-size: 13px; font-weight: 500;">Toplam Rezervasyon</div>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-sm-6">
                                            <div class="stat-card" style="background: linear-gradient(135deg, #dcfce7 0%, #bbf7d0 100%); border-radius: 20px; padding: 24px; text-align: center; border: none; box-shadow: 0 4px 12px rgba(22, 163, 74, 0.15);">
                                                <div class="stat-icon mb-3" style="font-size: 36px; color: #16a34a;">
                                                    <i class="bi bi-check-circle"></i>
                                                </div>
                                                <div class="stat-value fw-bold" style="font-size: 28px; color: #1e293b; margin-bottom: 8px;" id="statConfirmed">0</div>
                                                <div class="stat-label text-muted" style="font-size: 13px; font-weight: 500;">Onaylanan</div>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-sm-6">
                                            <div class="stat-card" style="background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%); border-radius: 20px; padding: 24px; text-align: center; border: none; box-shadow: 0 4px 12px rgba(217, 119, 6, 0.15);">
                                                <div class="stat-icon mb-3" style="font-size: 36px; color: #d97706;">
                                                    <i class="bi bi-clock-history"></i>
                                                </div>
                                                <div class="stat-value fw-bold" style="font-size: 28px; color: #1e293b; margin-bottom: 8px;" id="statOpen">0</div>
                                                <div class="stat-label text-muted" style="font-size: 13px; font-weight: 500;">Açık</div>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-sm-6">
                                            <div class="stat-card" style="background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%); border-radius: 20px; padding: 24px; text-align: center; border: none; box-shadow: 0 4px 12px rgba(220, 38, 38, 0.15);">
                                                <div class="stat-icon mb-3" style="font-size: 36px; color: #dc2626;">
                                                    <i class="bi bi-x-circle"></i>
                                                </div>
                                                <div class="stat-value fw-bold" style="font-size: 28px; color: #1e293b; margin-bottom: 8px;" id="statCancelled">0</div>
                                                <div class="stat-label text-muted" style="font-size: 13px; font-weight: 500;">İptal</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Hızlı Erişim Kutusu -->
                            <div class="col-lg-4">
                                <div class="info-box">
                                    <div class="info-box-title">
                                        <i class="bi bi-lightning-fill text-warning"></i>
                                        <span>Hızlı Erişim</span>
                                    </div>
                                    <div class="d-flex flex-column gap-2">
                                        <a href="{{ route('admin.rezervasyonlar.index') }}" class="quick-action-btn" style="display: flex; align-items: center; gap: 12px; padding: 14px 18px; background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%); border: 2px solid #e2e8f0; border-radius: 12px; text-decoration: none; color: #1e293b; font-weight: 600; transition: all 0.3s ease;">
                                            <div style="width: 40px; height: 40px; border-radius: 10px; background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%); display: flex; align-items: center; justify-content: center; color: white; font-size: 18px;">
                                                <i class="bi bi-list-ul"></i>
                                            </div>
                                            <span>Rezervasyon Listesi</span>
                                            <i class="bi bi-arrow-right ms-auto"></i>
                                        </a>
                                        <a href="javascript:void(0)" onclick="openNewReservationModal()" class="quick-action-btn" style="display: flex; align-items: center; gap: 12px; padding: 14px 18px; background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%); border: 2px solid #e2e8f0; border-radius: 12px; text-decoration: none; color: #1e293b; font-weight: 600; transition: all 0.3s ease;">
                                            <div style="width: 40px; height: 40px; border-radius: 10px; background: linear-gradient(135deg, #16a34a 0%, #15803d 100%); display: flex; align-items: center; justify-content: center; color: white; font-size: 18px;">
                                                <i class="bi bi-plus-circle"></i>
                                            </div>
                                            <span>Yeni Rezervasyon</span>
                                            <i class="bi bi-arrow-right ms-auto"></i>
                                        </a>
                                        <a href="{{ route('admin.customers.index') }}" class="quick-action-btn" style="display: flex; align-items: center; gap: 12px; padding: 14px 18px; background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%); border: 2px solid #e2e8f0; border-radius: 12px; text-decoration: none; color: #1e293b; font-weight: 600; transition: all 0.3s ease;">
                                            <div style="width: 40px; height: 40px; border-radius: 10px; background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%); display: flex; align-items: center; justify-content: center; color: white; font-size: 18px;">
                                                <i class="bi bi-people"></i>
                                            </div>
                                            <span>Müşteriler</span>
                                            <i class="bi bi-arrow-right ms-auto"></i>
                                        </a>
                                        <a href="{{ route('admin.settings.salons.index') }}" class="quick-action-btn" style="display: flex; align-items: center; gap: 12px; padding: 14px 18px; background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%); border: 2px solid #e2e8f0; border-radius: 12px; text-decoration: none; color: #1e293b; font-weight: 600; transition: all 0.3s ease;">
                                            <div style="width: 40px; height: 40px; border-radius: 10px; background: linear-gradient(135deg, #d97706 0%, #b45309 100%); display: flex; align-items: center; justify-content: center; color: white; font-size: 18px;">
                                                <i class="bi bi-building"></i>
                                            </div>
                                            <span>Salonlar</span>
                                            <i class="bi bi-arrow-right ms-auto"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- YENİ REZERVASYON MODAL -->
@include('admin.reservations.partials.new-reservation-modal')

<style>
    .quick-action-btn:hover {
        transform: translateX(6px) translateY(-2px);
        border-color: #2563eb !important;
        box-shadow: 0 8px 24px rgba(37, 99, 235, 0.2) !important;
        background: linear-gradient(135deg, #eff6ff 0%, #dbeafe 100%) !important;
    }
    
    .stat-card {
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        cursor: pointer;
    }
    
    .stat-card:hover {
        transform: translateY(-6px) scale(1.02);
        box-shadow: 0 12px 32px rgba(0, 0, 0, 0.15) !important;
    }
    
    .today-reservation-card {
        border-radius: 12px !important;
        transition: none !important;
        animation: none !important;
    }
    
    .today-reservation-card:hover {
        border-radius: 12px !important;
        transform: none !important;
    }
    
    @media (max-width: 768px) {
        .calendar-footer {
            padding: 16px 20px !important;
        }
    }
</style>
@endsection

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.css" rel="stylesheet">
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/locales/tr.js"></script>
<script>
let calendar;
let currentView = 'dayGridMonth';

document.addEventListener('DOMContentLoaded', function() {
    const calendarEl = document.getElementById('calendar');
    const salonFilter = document.getElementById('salonFilter');
    
    if (!calendarEl) return;
    
    calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',
        locale: 'tr',
        firstDay: 1,
        headerToolbar: {
            left: 'prev,next today',
            center: 'title',
            right: ''
        },
        height: 'auto',
        contentHeight: 'auto',
        aspectRatio: 1.8,
        themeSystem: 'standard',
        events: function(info, successCallback, failureCallback) {
            const start = info.startStr;
            const end = info.endStr;
            let url = `{{ route('admin.reservations.calendar.feed') }}?start=${start}&end=${end}`;
            
            if (salonFilter && salonFilter.value) {
                url += `&salon_id=${salonFilter.value}`;
            }
            
            fetch(url)
                .then(response => response.json())
                .then(data => {
                    successCallback(data);
                    loadUpcomingEvents(data);
                    updateStatistics(data);
                    loadTodayReservations(data);
                })
                .catch(error => {
                    console.error('Takvim yükleme hatası:', error);
                    failureCallback(error);
                });
        },
        eventClick: function(info) {
            if (info.event.url) {
                window.location.href = info.event.url;
            }
        },
        dateClick: function(info) {
            // FullCalendar'dan gelen tarih zaten YYYY-MM-DD formatında
            const selectedDate = info.dateStr;
            
            // Modal'ı aç ve seçilen tarihi gönder
            openNewReservationModal(selectedDate);
        },
        eventDisplay: 'block',
        eventTimeFormat: {
            hour: '2-digit',
            minute: '2-digit',
            hour12: false
        },
        dayMaxEvents: 3,
        moreLinkClick: 'popover'
    });
    
    calendar.render();
    
    // Salon filtresi autocomplete
    const salonFilterInput = document.getElementById('salonFilterInput');
    const salonFilterDropdown = document.getElementById('salonFilterDropdown');
    let allSalons = [];
    
    if (salonFilter) {
        Array.from(salonFilter.options).forEach(option => {
            if (option.value) {
                allSalons.push({
                    id: option.value,
                    name: option.textContent.trim(),
                    searchName: option.dataset.name || option.textContent.trim().toLowerCase()
                });
            }
        });
    }
    
    function showAllSalonsOption() {
        if (!salonFilterDropdown) return;
        salonFilterDropdown.innerHTML = '';
        const allOption = document.createElement('div');
        allOption.style.cssText = 'padding: 12px 16px; cursor: pointer; border-bottom: 1px solid #e2e8f0; transition: background-color 0.2s; border-radius: 12px 12px 0 0;';
        allOption.innerHTML = '<strong style="color: #2563eb; font-size: 14px;">✨ Tüm Salonlar</strong>';
        allOption.addEventListener('click', function() {
            salonFilter.value = '';
            if (salonFilterInput) salonFilterInput.value = '';
            salonFilterDropdown.style.display = 'none';
            calendar.refetchEvents();
        });
        allOption.addEventListener('mouseenter', function() {
            this.style.backgroundColor = '#f8faff';
        });
        allOption.addEventListener('mouseleave', function() {
            this.style.backgroundColor = '';
        });
        salonFilterDropdown.appendChild(allOption);
    }
    
    if (salonFilterInput && salonFilterDropdown) {
        salonFilterInput.addEventListener('input', function(e) {
            const query = e.target.value.toLowerCase().trim();
            
            if (query.length === 0) {
                showAllSalonsOption();
                salonFilterDropdown.style.display = 'block';
                return;
            }
            
            const filtered = allSalons.filter(salon => 
                salon.searchName.includes(query) || 
                salon.name.toLowerCase().includes(query)
            );
            
            salonFilterDropdown.innerHTML = '';
            
            if (filtered.length === 0) {
                const noResult = document.createElement('div');
                noResult.style.cssText = 'padding: 20px; text-align: center; color: #64748b;';
                noResult.innerHTML = '<i class="bi bi-search" style="font-size: 24px; display: block; margin-bottom: 8px; opacity: 0.5;"></i><span>Salon bulunamadı</span>';
                salonFilterDropdown.appendChild(noResult);
            } else {
                filtered.forEach(salon => {
                    const item = document.createElement('div');
                    item.style.cssText = 'padding: 12px 16px; cursor: pointer; border-bottom: 1px solid #e2e8f0; transition: background-color 0.2s;';
                    item.innerHTML = `<span style="color: #1e293b; font-size: 14px;">${salon.name}</span>`;
                    item.addEventListener('click', function() {
                        salonFilter.value = salon.id;
                        salonFilterInput.value = salon.name;
                        salonFilterDropdown.style.display = 'none';
                        calendar.refetchEvents();
                    });
                    item.addEventListener('mouseenter', function() {
                        this.style.backgroundColor = '#f8faff';
                    });
                    item.addEventListener('mouseleave', function() {
                        this.style.backgroundColor = '';
                    });
                    salonFilterDropdown.appendChild(item);
                });
            }
            
            salonFilterDropdown.style.display = 'block';
        });
        
        salonFilterInput.addEventListener('focus', function() {
            if (salonFilterInput.value.trim() === '') {
                showAllSalonsOption();
                salonFilterDropdown.style.display = 'block';
            }
        });
        
        document.addEventListener('click', function(e) {
            if (salonFilterInput && salonFilterDropdown && 
                !salonFilterInput.contains(e.target) && 
                !salonFilterDropdown.contains(e.target)) {
                salonFilterDropdown.style.display = 'none';
            }
        });
    }
    
    if (salonFilter) {
        salonFilter.addEventListener('change', function() {
            calendar.refetchEvents();
        });
    }
});

function changeCalendarView(viewName) {
    currentView = viewName;
    calendar.changeView(viewName);
    
    // Buton stillerini güncelle
    document.querySelectorAll('.view-btn').forEach(btn => {
        btn.classList.remove('active');
    });
    
    const viewMap = {
        'dayGridMonth': 'viewMonth',
        'timeGridWeek': 'viewWeek',
        'timeGridDay': 'viewDay',
        'listWeek': 'viewList'
    };
    
    const activeBtn = document.getElementById(viewMap[viewName]);
    if (activeBtn) {
        activeBtn.classList.add('active');
    }
}

function filterByCategory(category) {
    // Kategori filtreleme fonksiyonu (ileride eklenebilir)
    console.log('Kategori filtrelendi:', category);
}

function loadUpcomingEvents(events) {
    const now = new Date();
    const upcoming = events
        .filter(event => {
            const eventDate = new Date(event.start);
            return eventDate >= now;
        })
        .sort((a, b) => new Date(a.start) - new Date(b.start))
        .slice(0, 5);
    
    const container = document.getElementById('upcomingEventsList');
    if (!container) return;
    
    if (upcoming.length === 0) {
        container.innerHTML = `
            <div class="empty-state">
                <div class="empty-state-icon">
                    <i class="bi bi-calendar-x"></i>
                </div>
                <p class="text-muted mb-0" style="font-size: 14px;">Yaklaşan rezervasyon bulunmamaktadır.</p>
            </div>
        `;
        return;
    }
    
    container.innerHTML = upcoming.map(event => {
        const date = new Date(event.start);
        const months = ['Oca', 'Şub', 'Mar', 'Nis', 'May', 'Haz', 'Tem', 'Ağu', 'Eyl', 'Eki', 'Kas', 'Ara'];
        const day = date.getDate();
        const month = months[date.getMonth()];
        const year = date.getFullYear();
        const dateStr = `${day} ${month} ${year}`;
        const timeStr = date.toLocaleTimeString('tr-TR', { hour: '2-digit', minute: '2-digit' });
        const title = event.title.split(' - ')[0];
        
        return `
            <div class="upcoming-event-card" onclick="window.location.href='${event.url || '#'}'">
                <div class="d-flex align-items-start gap-3">
                    <span class="event-status-badge" style="background: ${event.color}; margin-top: 6px;"></span>
                    <div class="flex-grow-1">
                        <h6 class="text-dark mb-1 fw-bold" style="font-size: 15px;">${title}</h6>
                        <div class="d-flex align-items-center gap-2 mb-1">
                            <i class="bi bi-calendar3 text-muted" style="font-size: 12px;"></i>
                            <small class="text-muted" style="font-size: 12px;">${dateStr}</small>
                        </div>
                        <div class="d-flex align-items-center gap-2">
                            <i class="bi bi-clock text-muted" style="font-size: 12px;"></i>
                            <small class="text-muted" style="font-size: 12px;">${timeStr}</small>
                        </div>
                    </div>
                    <i class="bi bi-chevron-right text-muted"></i>
                </div>
            </div>
        `;
    }).join('');
}

function updateStatistics(events) {
    const now = new Date();
    const currentMonth = now.getMonth();
    const currentYear = now.getFullYear();
    
    // Bu ayın rezervasyonlarını filtrele
    const thisMonthEvents = events.filter(event => {
        const eventDate = new Date(event.start);
        return eventDate.getMonth() === currentMonth && eventDate.getFullYear() === currentYear;
    });
    
    // İstatistikleri hesapla
    const total = thisMonthEvents.length;
    const confirmed = thisMonthEvents.filter(e => e.extendedProps?.status === 'confirmed').length;
    const open = thisMonthEvents.filter(e => e.extendedProps?.status === 'open').length;
    const cancelled = thisMonthEvents.filter(e => e.extendedProps?.status === 'cancelled').length;
    
    // DOM'a yaz
    const totalEl = document.getElementById('statTotalReservations');
    const confirmedEl = document.getElementById('statConfirmed');
    const openEl = document.getElementById('statOpen');
    const cancelledEl = document.getElementById('statCancelled');
    
    if (totalEl) totalEl.textContent = total;
    if (confirmedEl) confirmedEl.textContent = confirmed;
    if (openEl) openEl.textContent = open;
    if (cancelledEl) cancelledEl.textContent = cancelled;
}

function loadTodayReservations(events) {
    const today = new Date();
    today.setHours(0, 0, 0, 0);
    const tomorrow = new Date(today);
    tomorrow.setDate(tomorrow.getDate() + 1);
    
    // Bugünkü rezervasyonları filtrele
    const todayEvents = events.filter(event => {
        const eventDate = new Date(event.start);
        eventDate.setHours(0, 0, 0, 0);
        return eventDate.getTime() === today.getTime();
    }).sort((a, b) => {
        const timeA = new Date(a.start).getTime();
        const timeB = new Date(b.start).getTime();
        return timeA - timeB;
    });
    
    const container = document.getElementById('todayReservations');
    if (!container) return;
    
    if (todayEvents.length === 0) {
        container.innerHTML = `
            <div class="col-12">
                <div class="text-center py-5" style="background: #f8fafc; border-radius: 12px; border: 1px solid #e2e8f0;">
                    <i class="bi bi-calendar-x" style="font-size: 48px; color: #cbd5e1; margin-bottom: 12px;"></i>
                    <p class="text-muted mb-0" style="font-size: 14px;">Bugün için rezervasyon bulunmamaktadır.</p>
                </div>
            </div>
        `;
        return;
    }
    
    container.innerHTML = todayEvents.map(event => {
        const startDate = new Date(event.start);
        const endDate = new Date(event.end);
        const timeStr = startDate.toLocaleTimeString('tr-TR', { hour: '2-digit', minute: '2-digit' });
        const endTimeStr = endDate.toLocaleTimeString('tr-TR', { hour: '2-digit', minute: '2-digit' });
        const title = event.title.split(' - ')[0];
        const salon = event.title.split(' - ')[1] || '';
        
        // Durum badge rengi
        let statusBadge = '';
        let statusText = '';
        switch(event.extendedProps?.status) {
            case 'confirmed':
                statusBadge = 'bg-success';
                statusText = 'Onaylandı';
                break;
            case 'open':
                statusBadge = 'bg-warning';
                statusText = 'Açık';
                break;
            case 'completed':
                statusBadge = 'bg-info';
                statusText = 'Tamamlandı';
                break;
            default:
                statusBadge = 'bg-secondary';
                statusText = event.extendedProps?.status || 'Bilinmiyor';
        }
        
        return `
            <div class="col-md-6 col-lg-4">
                <div class="today-reservation-card" onclick="window.location.href='${event.url || '#'}'" style="background: white; border: 1px solid #e2e8f0; border-radius: 12px; padding: 16px; cursor: pointer; height: 100%; box-shadow: 0 1px 3px rgba(0,0,0,0.1);">
                    <div class="d-flex align-items-start justify-content-between mb-2">
                        <div class="d-flex align-items-center gap-2" style="flex: 1;">
                            <div style="width: 6px; height: 6px; border-radius: 50%; background: ${event.color}; flex-shrink: 0; margin-top: 6px;"></div>
                            <div style="flex: 1; min-width: 0;">
                                <h6 class="mb-0 fw-bold text-dark" style="font-size: 15px; line-height: 1.4;">${title}</h6>
                                ${salon ? `<small class="text-muted d-block mt-1" style="font-size: 12px;">${salon}</small>` : ''}
                            </div>
                        </div>
                        <span class="badge ${statusBadge} ms-2" style="font-size: 11px; flex-shrink: 0;">${statusText}</span>
                    </div>
                    <div class="d-flex align-items-center gap-3 mt-3 pt-2 border-top border-light">
                        <div class="d-flex align-items-center gap-1 text-muted" style="font-size: 13px;">
                            <i class="bi bi-clock"></i>
                            <span>${timeStr} - ${endTimeStr}</span>
                        </div>
                    </div>
                </div>
            </div>
        `;
    }).join('');
    
    // Hover efektleri için event listener ekle (sadece border rengi değişsin, animasyon yok)
    container.querySelectorAll('.today-reservation-card').forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.style.borderColor = '#2563eb';
            this.style.boxShadow = '0 2px 6px rgba(37, 99, 235, 0.2)';
        });
        card.addEventListener('mouseleave', function() {
            this.style.borderColor = '#e2e8f0';
            this.style.boxShadow = '0 1px 3px rgba(0,0,0,0.1)';
        });
    });
}
</script>
@endpush
