@extends('layouts.admin')

@section('title', 'İptal Rezervasyonlar')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">İptal Rezervasyonlar</li>
@endsection

@section('content')
    <h2 class="mb-4">İptal Rezervasyonlar</h2>
    
    <div class="card shadow-sm">
        <div class="card-header bg-danger text-white">
            <h5 class="mb-0"><i class="bi bi-x-circle"></i> İptal Edilen Rezervasyonlar</h5>
        </div>
        <div class="card-body">
            @if($reservations->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Rezervasyon Kodu</th>
                                <th>Müşteri Adı</th>
                                <th>Tarih/Saat</th>
                                <th>Salon</th>
                                <th>Toplam Tutar</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($reservations as $reservation)
                                <tr>
                                    <td>#{{ $reservation->id }}</td>
                                    <td>{{ $reservation->customer->name }}</td>
                                    <td>{{ $reservation->date->format('d.m.Y') }} {{ $reservation->start_time }}</td>
                                    <td>{{ $reservation->salon->name }}</td>
                                    <td>{{ number_format($reservation->total_price, 2) }} ₺</td>
                                    <td>
                                        <button type="button" onclick="openReservationDetailModal({{ $reservation->id }})" class="btn btn-sm btn-info">
                                            <i class="bi bi-eye"></i>
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <div class="mt-3">
                    {{ $reservations->links() }}
                </div>
            @else
                <div class="alert alert-info">
                    <i class="bi bi-info-circle"></i> İptal edilmiş rezervasyon bulunamadı.
                </div>
            @endif
        </div>
    </div>
@endsection

