@extends('layouts.admin')

@section('title', 'Günlük Rezervasyonlar')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Günlük Rezervasyonlar</li>
@endsection

@section('content')
<style>
    .date-filter-input {
        max-width: 200px;
    }
    @media (max-width: 768px) {
        .date-filter-input {
            max-width: 100%;
            width: 100%;
        }
    }
</style>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Günlük Rezervasyonlar</h2>
        <form method="GET" class="d-flex gap-2">
            <input type="date" name="date" class="form-control date-filter-input" value="{{ $date }}">
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-search"></i> Filtrele
            </button>
        </form>
    </div>
    
    <div class="card shadow-sm">
        <div class="card-header bg-info text-white">
            <h5 class="mb-0"><i class="bi bi-calendar-day"></i> {{ \Carbon\Carbon::parse($date)->format('d.m.Y') }} Tarihli Rezervasyonlar</h5>
        </div>
        <div class="card-body">
            @if($reservations->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Saat</th>
                                <th>Rezervasyon Kodu</th>
                                <th>Müşteri</th>
                                <th>Salon</th>
                                <th>Misafir Sayısı</th>
                                <th>Durum</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($reservations as $reservation)
                                <tr>
                                    <td><strong>{{ $reservation->start_time }} - {{ $reservation->end_time }}</strong></td>
                                    <td>#{{ $reservation->id }}</td>
                                    <td>{{ $reservation->customer->name }}</td>
                                    <td>{{ $reservation->salon->name }}</td>
                                    <td>{{ $reservation->guest_count }} kişi</td>
                                    <td>
                                        @if($reservation->status == 'open')
                                            <span class="badge bg-warning">Açık</span>
                                        @elseif($reservation->status == 'confirmed')
                                            <span class="badge bg-success">Onaylandı</span>
                                        @elseif($reservation->status == 'cancelled')
                                            <span class="badge bg-danger">İptal</span>
                                        @else
                                            <span class="badge bg-info">Tamamlandı</span>
                                        @endif
                                    </td>
                                    <td>
                                        <button type="button" onclick="openReservationDetailModal({{ $reservation->id }})" class="btn btn-sm btn-info">
                                            <i class="bi bi-eye"></i>
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="alert alert-info">
                    <i class="bi bi-info-circle"></i> Bu tarihte rezervasyon bulunamadı.
                </div>
            @endif
        </div>
    </div>
@endsection

