@extends('layouts.admin')

@section('title', 'Rezervasyon Düzenle')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.rezervasyonlar.index') }}">Rezervasyonlar</a></li>
    <li class="breadcrumb-item active">Düzenle</li>
@endsection

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Rezervasyon Düzenle</h2>
        <a href="{{ route('admin.rezervasyonlar.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Geri
        </a>
    </div>
    
    <div class="card shadow-sm">
        <div class="card-header border-0" style="background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);">
            <h5 class="mb-0 text-white"><i class="bi bi-pencil-square"></i> Rezervasyon Bilgileri</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.rezervasyonlar.update', $reservation->id) }}">
                @csrf
                @method('PUT')
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Müşteri *</label>
                        <select name="customer_id" class="form-select form-select-lg" required>
                            <option value="">Seçiniz</option>
                            @foreach($customers as $customer)
                                <option value="{{ $customer->id }}" {{ old('customer_id', $reservation->customer_id) == $customer->id ? 'selected' : '' }}>
                                    {{ $customer->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Salon *</label>
                        <select name="salon_id" class="form-select form-select-lg" required>
                            <option value="">Seçiniz</option>
                            @foreach($salons as $salon)
                                <option value="{{ $salon->id }}" {{ old('salon_id', $reservation->salon_id) == $salon->id ? 'selected' : '' }}>
                                    {{ $salon->name }} (Kapasite: {{ $salon->capacity }})
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label class="form-label fw-bold">Tarih *</label>
                        <input type="date" name="date" class="form-control form-control-lg" value="{{ old('date', $reservation->date->format('Y-m-d')) }}" required>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label fw-bold">Başlangıç Saati *</label>
                        <input type="time" name="start_time" class="form-control form-control-lg" value="{{ old('start_time', $reservation->start_time) }}" required>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label fw-bold">Bitiş Saati *</label>
                        <input type="time" name="end_time" class="form-control form-control-lg" value="{{ old('end_time', $reservation->end_time) }}" required>
                    </div>
                </div>
                
                @php
                    $itemsData = json_decode($reservation->items_data ?? '{}', true);
                    $brideName = $itemsData['bride_name'] ?? null;
                    $groomName = $itemsData['groom_name'] ?? null;
                    $brideGroomPhone = $itemsData['bride_groom_phone'] ?? null;
                @endphp
                
                <!-- Gelin ve Damat Bilgileri -->
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Gelin İsmi *</label>
                        <input type="text" name="bride_name" class="form-control form-control-lg" value="{{ old('bride_name', $brideName) }}" placeholder="Örn: Ayşe Demir" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Damat İsmi *</label>
                        <input type="text" name="groom_name" class="form-control form-control-lg" value="{{ old('groom_name', $groomName) }}" placeholder="Örn: Ahmet Yılmaz" required>
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">İletişim Numarası *</label>
                        <input type="tel" name="bride_groom_phone" class="form-control form-control-lg" value="{{ old('bride_groom_phone', $brideGroomPhone) }}" placeholder="05XX XXX XX XX" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Misafir Sayısı *</label>
                        <input type="number" name="guest_count" class="form-control form-control-lg" value="{{ old('guest_count', $reservation->guest_count) }}" min="1" required>
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Menü</label>
                        <select name="menu_id" class="form-select form-select-lg">
                            <option value="">Seçiniz</option>
                            @foreach($menus as $menu)
                                <option value="{{ $menu->id }}" {{ old('menu_id', $reservation->menu_id) == $menu->id ? 'selected' : '' }}>
                                    {{ $menu->name }} ({{ format_currency($menu->price, 2) }} ₺)
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label class="form-label fw-bold">Toplam Tutar *</label>
                        <div class="input-group input-group-lg">
                            <input type="number" step="0.01" name="total_price" class="form-control" value="{{ old('total_price', $reservation->total_price) }}" min="0" required>
                            <span class="input-group-text">₺</span>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label fw-bold">Ödenen Kapora</label>
                        <div class="input-group input-group-lg">
                            <input type="number" step="0.01" name="deposit_paid" class="form-control" value="{{ old('deposit_paid', $reservation->deposit_paid) }}" min="0">
                            <span class="input-group-text">₺</span>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label fw-bold">Durum *</label>
                        <select name="status" class="form-select form-select-lg" required>
                            <option value="open" {{ old('status', $reservation->status) == 'open' ? 'selected' : '' }}>Açık</option>
                            <option value="confirmed" {{ old('status', $reservation->status) == 'confirmed' ? 'selected' : '' }}>Onaylandı</option>
                            <option value="cancelled" {{ old('status', $reservation->status) == 'cancelled' ? 'selected' : '' }}>İptal</option>
                            <option value="completed" {{ old('status', $reservation->status) == 'completed' ? 'selected' : '' }}>Tamamlandı</option>
                        </select>
                    </div>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Notlar</label>
                    <textarea name="notes" class="form-control" rows="4">{{ old('notes', $reservation->notes) }}</textarea>
                </div>
                
                <div class="mb-4">
                    <label class="form-label fw-bold mb-3">Extralar</label>
                    <div class="row">
                        @foreach($extras as $extra)
                            @php
                                $selected = $reservation->extras->contains($extra->id);
                                $pivot = $selected ? $reservation->extras->find($extra->id)->pivot : null;
                            @endphp
                            <div class="col-md-6 mb-3">
                                <div class="card border">
                                    <div class="card-body">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="extras[{{ $extra->id }}][quantity]" value="1" id="extra_{{ $extra->id }}" {{ $selected ? 'checked' : '' }}>
                                            <label class="form-check-label fw-bold" for="extra_{{ $extra->id }}">
                                                {{ $extra->name }}
                                            </label>
                                        </div>
                                        <small class="text-muted">{{ $extra->description }}</small>
                                        <div class="mt-2">
                                            <strong class="text-success">{{ number_format($extra->price, 2) }} ₺</strong>
                                        </div>
                                        <input type="hidden" name="extras[{{ $extra->id }}][price]" value="{{ $extra->price }}">
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                
                <div class="d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.rezervasyonlar.index') }}" class="btn btn-lg btn-secondary">
                        <i class="bi bi-x-circle"></i> İptal
                    </a>
                    <button type="submit" class="btn btn-lg btn-primary">
                        <i class="bi bi-check-circle"></i> Güncelle
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection

