@extends('layouts.admin')

@section('title', 'Tüm Rezervasyonlar')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Tüm Rezervasyonlar</li>
@endsection

@section('content')
<style>
    .date-filter-input {
        max-width: 200px;
    }
    @media (max-width: 768px) {
        .date-filter-input {
            max-width: 100%;
            width: 100%;
        }
    }
    input[type="date"]::before {
        content: attr(placeholder);
        color: #999;
        width: 100%;
    }
    input[type="date"]:focus::before,
    input[type="date"]:valid::before {
        display: none;
    }
</style>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold mb-2" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text;">
                Tüm Rezervasyonlar
            </h2>
        </div>
        <button type="button" class="btn btn-primary" onclick="if(typeof openNewReservationModal === 'function') { openNewReservationModal(); } else { window.location.href='{{ route('admin.rezervasyonlar.create') }}'; }">
            <i class="bi bi-plus-circle"></i> Yeni Rezervasyon
        </button>
    </div>
    
    <div class="card mb-4">
        <div class="card-header border-0" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);">
            <h5 class="mb-0 text-white"><i class="bi bi-funnel me-2"></i>Filtreler</h5>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('admin.rezervasyonlar.index') }}" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Tarih</label>
                    <input type="text" name="date" class="form-control date-filter-input" value="{{ request('date') }}" placeholder="gg.aa.yyyy" onfocus="this.type='date'; if(!this.value && this.placeholder) this.placeholder='';" onblur="if(!this.value) { this.type='text'; this.placeholder='gg.aa.yyyy'; }">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Salon</label>
                    <select name="salon_id" class="form-select">
                        <option value="">Tümü</option>
                        @foreach($salons as $salon)
                            <option value="{{ $salon->id }}" {{ request('salon_id') == $salon->id ? 'selected' : '' }}>
                                {{ $salon->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Durum</label>
                    <select name="status" class="form-select">
                        <option value="">Tümü</option>
                        <option value="open" {{ request('status') == 'open' ? 'selected' : '' }}>Açık</option>
                        <option value="confirmed" {{ request('status') == 'confirmed' ? 'selected' : '' }}>Onaylandı</option>
                        <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>İptal</option>
                        <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Tamamlandı</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Müşteri Adı</label>
                    <input type="text" name="customer_name" class="form-control" value="{{ request('customer_name') }}">
                </div>
                <div class="col-12">
                    <button type="submit" class="btn btn-primary">Filtrele</button>
                    <a href="{{ route('admin.rezervasyonlar.index') }}" class="btn btn-secondary">Temizle</a>
                </div>
            </form>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header border-0 d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);">
            <h5 class="mb-0 text-white"><i class="bi bi-list-ul me-2"></i>Rezervasyon Listesi</h5>
            <form method="GET" action="{{ route('admin.rezervasyonlar.index') }}" class="d-inline-flex align-items-center gap-2">
                @foreach(request()->except('sort', 'page') as $key => $value)
                    <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                @endforeach
                <label class="form-label mb-0 small text-white-50">Sırala:</label>
                <select name="sort" class="form-select form-select-sm" style="width: auto; min-width: 150px; background: rgba(255,255,255,0.2); border: 1px solid rgba(255,255,255,0.3); color: white;" onchange="this.form.submit()">
                    <option value="date_asc" {{ request('sort', 'date_asc') == 'date_asc' ? 'selected' : '' }} style="background: #2563eb; color: white;">En Yakın Tarih</option>
                    <option value="name_asc" {{ request('sort') == 'name_asc' ? 'selected' : '' }} style="background: #2563eb; color: white;">A-Z (Müşteri)</option>
                    <option value="date_desc" {{ request('sort') == 'date_desc' ? 'selected' : '' }} style="background: #2563eb; color: white;">Yeniden Eskiye</option>
                </select>
            </form>
        </div>
        <div class="card-body">
            <div class="table-responsive d-none d-md-block">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Müşteri Adı</th>
                            <th>Tarih/Saat</th>
                            <th>Salon</th>
                            <th>Durum</th>
                            <th>Toplam Tutar</th>
                            <th>Kalan Bakiye</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($reservations as $index => $reservation)
                            @php
                                $itemsData = json_decode($reservation->items_data ?? '{}', true);
                                $brideGroomName = $itemsData['bride_groom_name'] ?? null;
                            @endphp
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center gap-2">
                                        <div class="customer-avatar" style="width: 32px; height: 32px; border-radius: 50%; background: {{ $reservation->customer->avatar_color ?? '#2563eb' }}; display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 11px; flex-shrink: 0;">
                                            {{ $reservation->customer->initials ?? '??' }}
                                        </div>
                                        <div>
                                            <div>{{ $reservation->customer->name }}</div>
                                            @if($brideGroomName)
                                                <small class="text-muted"><i class="bi bi-heart-fill text-danger"></i> {{ $brideGroomName }}</small>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                                <td>{{ $reservation->date->format('d.m.Y') }} {{ $reservation->start_time }}</td>
                                <td>{{ $reservation->salon->name }}</td>
                                <td>
                                    @if($reservation->status == 'open')
                                        <span class="badge bg-warning">Açık</span>
                                    @elseif($reservation->status == 'confirmed')
                                        <span class="badge bg-success">Onaylandı</span>
                                    @elseif($reservation->status == 'cancelled')
                                        <span class="badge bg-danger">İptal</span>
                                    @else
                                        <span class="badge bg-info">Tamamlandı</span>
                                    @endif
                                </td>
                                <td>{{ number_format($reservation->total_price, 2, ',', '.') }} ₺</td>
                                <td>
                                    @php
                                        $remaining = $reservation->total_price - ($reservation->deposit_paid ?? 0);
                                    @endphp
                                    @if($remaining > 0)
                                        <span class="text-danger fw-bold">{{ number_format($remaining, 2, ',', '.') }} ₺</span>
                                    @elseif($remaining < 0)
                                        <span class="text-success fw-bold">{{ number_format($remaining, 2, ',', '.') }} ₺</span>
                                        <br><small class="text-muted">(İade edilecek)</small>
                                    @else
                                        <span class="text-success"><i class="bi bi-check-circle"></i> 0,00 ₺</span>
                                    @endif
                                </td>
                                <td>
                                    <button type="button" onclick="openReservationDetailModal({{ $reservation->id }})" class="btn btn-sm btn-info">
                                        <i class="bi bi-eye"></i>
                                    </button>
                                    <a href="{{ route('admin.rezervasyonlar.edit', $reservation->id) }}" class="btn btn-sm btn-warning">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <form action="{{ route('admin.rezervasyonlar.destroy', $reservation->id) }}" method="POST" class="d-inline delete-form" data-message="Bu rezervasyonu silmek istediğinize emin misiniz?">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center">Rezervasyon bulunamadı.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <!-- Mobile Cards -->
            <div class="d-md-none">
                @forelse($reservations as $reservation)
                    @php
                        $itemsData = json_decode($reservation->items_data ?? '{}', true);
                        $brideGroomName = $itemsData['bride_groom_name'] ?? null;
                        $remaining = $reservation->total_price - ($reservation->deposit_paid ?? 0);
                    @endphp
                    <div class="card mb-3 mx-3 mt-3 border-start border-4" style="border-left-color: {{ $reservation->status == 'confirmed' ? '#10b981' : ($reservation->status == 'open' ? '#f59e0b' : ($reservation->status == 'cancelled' ? '#ef4444' : '#3b82f6')) }};">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <div class="d-flex align-items-center gap-2">
                                    <div class="customer-avatar" style="width: 40px; height: 40px; border-radius: 50%; background: {{ $reservation->customer->avatar_color ?? '#2563eb' }}; display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 12px; flex-shrink: 0;">
                                        {{ $reservation->customer->initials ?? '??' }}
                                    </div>
                                    <div>
                                        <h6 class="mb-1 fw-bold">{{ $reservation->customer->name }}</h6>
                                        @if($brideGroomName)
                                            <small class="text-muted"><i class="bi bi-heart-fill text-danger"></i> {{ $brideGroomName }}</small>
                                        @endif
                                    </div>
                                </div>
                                <div>
                                    @if($reservation->status == 'open')
                                        <span class="badge bg-warning">Açık</span>
                                    @elseif($reservation->status == 'confirmed')
                                        <span class="badge bg-success">Onaylandı</span>
                                    @elseif($reservation->status == 'cancelled')
                                        <span class="badge bg-danger">İptal</span>
                                    @else
                                        <span class="badge bg-info">Tamamlandı</span>
                                    @endif
                                </div>
                            </div>
                            
                            <div class="mb-2">
                                <small class="text-muted d-block">Tarih/Saat:</small>
                                <strong>{{ $reservation->date->format('d.m.Y') }} {{ $reservation->start_time }}</strong>
                            </div>
                            
                            <div class="mb-2">
                                <small class="text-muted d-block">Salon:</small>
                                <strong>{{ $reservation->salon->name }}</strong>
                            </div>
                            
                            <div class="row g-2 mb-2">
                                <div class="col-6">
                                    <small class="text-muted d-block">Toplam Tutar</small>
                                    <strong>{{ number_format($reservation->total_price, 2, ',', '.') }} ₺</strong>
                                </div>
                                <div class="col-6">
                                    <small class="text-muted d-block">Kalan Bakiye</small>
                                    @if($remaining > 0)
                                        <strong class="text-danger">{{ number_format($remaining, 2, ',', '.') }} ₺</strong>
                                    @elseif($remaining < 0)
                                        <strong class="text-success">{{ number_format($remaining, 2, ',', '.') }} ₺</strong>
                                        <br><small class="text-muted">(İade)</small>
                                    @else
                                        <span class="text-success"><i class="bi bi-check-circle"></i> 0,00 ₺</span>
                                    @endif
                                </div>
                            </div>
                            
                            <div class="d-flex flex-wrap gap-1 mt-2">
                                <button type="button" onclick="openReservationDetailModal({{ $reservation->id }})" class="btn btn-sm btn-info flex-fill">
                                    <i class="bi bi-eye"></i> Detay
                                </button>
                                <a href="{{ route('admin.rezervasyonlar.edit', $reservation->id) }}" class="btn btn-sm btn-warning">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <form action="{{ route('admin.rezervasyonlar.destroy', $reservation->id) }}" method="POST" class="d-inline delete-form" data-message="Bu rezervasyonu silmek istediğinize emin misiniz?">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="text-center py-5 px-3">
                        <i class="bi bi-calendar-x display-4 text-muted"></i>
                        <p class="text-muted mt-2">Rezervasyon bulunamadı.</p>
                    </div>
                @endforelse
            </div>
            
            <div class="mt-3">
                {{ $reservations->links() }}
            </div>
        </div>
    </div>

    <!-- YENİ REZERVASYON MODAL -->
    @include('admin.reservations.partials.new-reservation-modal')
    
    <!-- REZERVASYON DETAY MODAL -->
    <div class="modal fade" id="reservationDetailModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);">
                    <h5 class="modal-title text-white fw-bold"><i class="bi bi-eye me-2"></i>Rezervasyon Detayı</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="reservationDetailContent">
                    <div class="text-center py-5">
                        <div class="spinner-border text-primary" role="status"></div>
                    </div>
                </div>
                <div class="modal-footer flex-wrap gap-2" style="background: linear-gradient(135deg, #f1f5f9 0%, #e2e8f0 100%);">
                    <input type="hidden" id="currentReservationId" value="">
                    <input type="hidden" id="currentRemainingAmount" value="0">
                    <input type="hidden" id="currentReservationStatus" value="">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="bi bi-x-circle me-1"></i>Kapat
                    </button>
                    <button type="button" id="btnCancelReservation" class="btn btn-danger" onclick="cancelReservation()">
                        <i class="bi bi-x-octagon me-1"></i>İptal Edildi
                    </button>
                    <button type="button" id="btnCompleteReservation" class="btn btn-success btn-lg" onclick="completeReservation()">
                        <i class="bi bi-check-circle me-1"></i>Onayla ve Bitir
                    </button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script>
// Detay modal
function openReservationDetailModal(id) {
    document.getElementById('currentReservationId').value = id;
    const modal = new bootstrap.Modal(document.getElementById('reservationDetailModal'));
    document.getElementById('reservationDetailContent').innerHTML = '<div class="text-center py-5"><div class="spinner-border text-primary"></div></div>';
    modal.show();
    
    const url = '{{ route("admin.rezervasyonlar.show", ":id") }}'.replace(':id', id);
    fetch(url, { 
        headers: { 
            'Accept': 'application/json',
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || ''
        } 
    })
    .then(r => {
        if (!r.ok) {
            throw new Error('HTTP ' + r.status);
        }
        return r.json();
    })
    .then(data => {
        if (!data || !data.reservation) {
            throw new Error('Rezervasyon verisi alınamadı');
        }
        let items = '';
        if (data.items?.length) {
            items = '<table class="table table-sm"><thead><tr><th>Kalem</th><th>Miktar</th><th>Fiyat</th><th>Toplam</th></tr></thead><tbody>' +
                data.items.map(i => `<tr><td>${i.name}</td><td>${i.quantity}</td><td>${parseFloat(i.price).toFixed(2)} ₺</td><td>${parseFloat(i.total).toFixed(2)} ₺</td></tr>`).join('') +
                '</tbody></table>';
        }
        
        let statusBadge = '';
        if (data.reservation.status === 'completed') {
            statusBadge = '<span class="badge bg-success"><i class="bi bi-check-circle"></i> Tamamlandı</span>';
        } else if (data.reservation.status === 'cancelled') {
            statusBadge = '<span class="badge bg-danger"><i class="bi bi-x-circle"></i> İptal Edildi</span>';
        } else {
            statusBadge = '<span class="badge bg-primary"><i class="bi bi-clock"></i> Açık</span>';
        }
        
        const reservationDate = data.reservation.date ? new Date(data.reservation.date).toLocaleDateString('tr-TR') : '-';
        const createdDate = data.reservation.created_at ? new Date(data.reservation.created_at).toLocaleDateString('tr-TR') : '-';
        const createdTime = data.reservation.created_at ? new Date(data.reservation.created_at).toLocaleTimeString('tr-TR', {hour: '2-digit', minute: '2-digit'}) : '-';
        const remainingAmount = parseFloat(data.total_price) - parseFloat(data.deposit_paid || 0);
        
        document.getElementById('reservationDetailContent').innerHTML = `
            <div class="mb-3 text-center">${statusBadge}</div>
            <div class="row g-3">
                <!-- Müşteri -->
                <div class="col-md-4 col-sm-6">
                    <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);">
                        <div class="card-body text-white p-3">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <i class="bi bi-person-fill" style="font-size: 1.5rem;"></i>
                                <h6 class="mb-0 fw-bold">Müşteri</h6>
                            </div>
                            <div class="fw-bold">${data.customer?.name || '-'}</div>
                            ${data.customer?.phone ? `<small class="opacity-75"><i class="bi bi-telephone"></i> ${data.customer.phone}</small>` : ''}
                        </div>
                    </div>
                </div>
                
                <!-- Gelin ve Damat -->
                <div class="col-md-4 col-sm-6">
                    <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #ec4899 0%, #db2777 100%);">
                        <div class="card-body text-white p-3">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <i class="bi bi-heart-fill" style="font-size: 1.5rem;"></i>
                                <h6 class="mb-0 fw-bold">Gelin ve Damat</h6>
                            </div>
                            ${data.bride_groom_name ? `
                                <div class="fw-bold mb-1">${data.bride_groom_name}</div>
                                ${data.bride_groom_phone ? `<small class="opacity-75"><i class="bi bi-telephone"></i> ${data.bride_groom_phone}</small>` : '<small class="opacity-75">Telefon bilgisi yok</small>'}
                            ` : '<div class="opacity-75">Bilgi girilmemiş</div>'}
                        </div>
                    </div>
                </div>
                
                <!-- Salon -->
                <div class="col-md-4 col-sm-6">
                    <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%);">
                        <div class="card-body text-white p-3">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <i class="bi bi-building" style="font-size: 1.5rem;"></i>
                                <h6 class="mb-0 fw-bold">Salon</h6>
                            </div>
                            <div class="fw-bold fs-5">${data.salon?.name || '-'}</div>
                        </div>
                    </div>
                </div>
                
                <!-- Tarih -->
                <div class="col-md-4 col-sm-6">
                    <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);">
                        <div class="card-body text-white p-3">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <i class="bi bi-calendar3" style="font-size: 1.5rem;"></i>
                                <h6 class="mb-0 fw-bold">Tarih</h6>
                            </div>
                            <div class="fw-bold fs-5">${reservationDate}</div>
                        </div>
                    </div>
                </div>
                
                <!-- Saat -->
                <div class="col-md-4 col-sm-6">
                    <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);">
                        <div class="card-body text-white p-3">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <i class="bi bi-clock" style="font-size: 1.5rem;"></i>
                                <h6 class="mb-0 fw-bold">Saat</h6>
                            </div>
                            <div class="fw-bold fs-5">${data.reservation.start_time || '-'} - ${data.reservation.end_time || '-'}</div>
                        </div>
                    </div>
                </div>
                
                <!-- Rezervasyon Kodu -->
                <div class="col-md-4 col-sm-6">
                    <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #14b8a6 0%, #0d9488 100%);">
                        <div class="card-body text-white p-3">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <i class="bi bi-tag-fill" style="font-size: 1.5rem;"></i>
                                <h6 class="mb-0 fw-bold">Rezervasyon Kodu</h6>
                            </div>
                            <div class="fw-bold fs-6">${data.reservation.code || 'Yok'}</div>
                        </div>
                    </div>
                </div>
                
                <!-- Toplam Tutar -->
                <div class="col-md-4 col-sm-6">
                    <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #f97316 0%, #ea580c 100%);">
                        <div class="card-body text-white p-3">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <i class="bi bi-cash-stack" style="font-size: 1.5rem;"></i>
                                <h6 class="mb-0 fw-bold">Toplam Tutar</h6>
                            </div>
                            <div class="fw-bold fs-4">${parseFloat(data.total_price).toFixed(2)} ₺</div>
                        </div>
                    </div>
                </div>
                
                <!-- Alınan Kapora -->
                <div class="col-md-4 col-sm-6">
                    <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #22c55e 0%, #16a34a 100%);">
                        <div class="card-body text-white p-3">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <i class="bi bi-wallet2" style="font-size: 1.5rem;"></i>
                                <h6 class="mb-0 fw-bold">Alınan Kapora</h6>
                            </div>
                            <div class="fw-bold fs-4">${parseFloat(data.deposit_paid || 0).toFixed(2)} ₺</div>
                        </div>
                    </div>
                </div>
                
                <!-- Kalan Tutar -->
                <div class="col-md-4 col-sm-6">
                    <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);">
                        <div class="card-body text-white p-3">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <i class="bi bi-calculator" style="font-size: 1.5rem;"></i>
                                <h6 class="mb-0 fw-bold">Kalan Tutar</h6>
                            </div>
                            <div class="fw-bold fs-4">${remainingAmount.toFixed(2)} ₺</div>
                        </div>
                    </div>
                </div>
                
                <!-- Oluşturulma Tarihi -->
                <div class="col-md-4 col-sm-6">
                    <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #64748b 0%, #475569 100%);">
                        <div class="card-body text-white p-3">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <i class="bi bi-calendar-check" style="font-size: 1.5rem;"></i>
                                <h6 class="mb-0 fw-bold">Oluşturulma</h6>
                            </div>
                            <div class="fw-bold">${createdDate}</div>
                            <small class="opacity-75">${createdTime}</small>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Kalemler -->
            <div class="row mt-4">
                <div class="col-12">
                    <div class="card border-0 shadow-sm">
                        <div class="card-header text-white" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);">
                            <h6 class="mb-0 fw-bold"><i class="bi bi-receipt me-2"></i>Fatura Kalemleri</h6>
                        </div>
                        <div class="card-body p-0">
                            ${items || '<div class="p-3 text-center text-muted">Kalem yok</div>'}
                        </div>
                    </div>
                </div>
            </div>`;
        
        // Kalan tutarı ve status'u sakla
        const remainingAmount = parseFloat(data.total_price) - parseFloat(data.deposit_paid);
        document.getElementById('currentRemainingAmount').value = remainingAmount || 0;
        document.getElementById('currentReservationStatus').value = data.reservation.status;
        
        // Tamamlanan veya iptal edilen rezervasyonlarda işlem butonlarını gizle
        const status = data.reservation.status;
        const btnCancel = document.getElementById('btnCancelReservation');
        const btnComplete = document.getElementById('btnCompleteReservation');
        
        if (status === 'completed' || status === 'cancelled') {
            // Butonları gizle
            btnCancel.style.display = 'none';
            btnComplete.style.display = 'none';
        } else {
            // Butonları göster
            btnCancel.style.display = '';
            btnComplete.style.display = '';
        }
    })
    .catch(e => {
        console.error('Rezervasyon detay hatası:', e);
        let errorMessage = 'Rezervasyon bilgileri yüklenirken bir hata oluştu.';
        
        if (e.message) {
            errorMessage = e.message;
        }
        
        document.getElementById('reservationDetailContent').innerHTML = 
            '<div class="alert alert-danger">' +
            '<i class="bi bi-exclamation-triangle me-2"></i> <strong>Hata:</strong> ' + errorMessage +
            '</div>';
    });
}

// Rezervasyonu Onayla ve Bitir
async function completeReservation() {
    const id = document.getElementById('currentReservationId').value;
    const remaining = parseFloat(document.getElementById('currentRemainingAmount').value) || 0;
    
    if (!id) return;
    
    let message;
    if (remaining > 0) {
        message = 'Kalan ödeme (' + remaining.toFixed(2) + ' ₺) alındı olarak işaretlenecek ve rezervasyon tamamlanacak.\n\nOnaylıyor musunuz?';
    } else if (remaining < 0) {
        message = 'Müşteriye ' + Math.abs(remaining).toFixed(2) + ' ₺ fazla ödeme iade edildi olarak işaretlenecek ve rezervasyon tamamlanacak.\n\nOnaylıyor musunuz?';
    } else {
        message = 'Rezervasyon tamamlanacak.\n\nOnaylıyor musunuz?';
    }
    
    const confirmed = await customConfirm(message);
    if (!confirmed) return;
    
    const btn = document.getElementById('btnCompleteReservation');
    if (btn) {
        btn.disabled = true;
        btn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>İşleniyor...';
    }
    
    const statusUrl = '{{ route("admin.reservations.update-status", ":id") }}'.replace(':id', id);
    fetch(statusUrl, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || '',
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        },
        body: JSON.stringify({ 
            status: 'completed',
            mark_paid: true 
        })
    })
    .then(async r => {
        const contentType = r.headers.get('content-type');
        if (!r.ok) {
            // JSON response varsa parse et, yoksa hata mesajı oluştur
            if (contentType && contentType.includes('application/json')) {
                const err = await r.json();
                throw new Error(err.message || err.error || 'HTTP ' + r.status);
            } else {
                const text = await r.text();
                throw new Error('HTTP ' + r.status + ': ' + text.substring(0, 100));
            }
        }
        // JSON response kontrolü
        if (contentType && contentType.includes('application/json')) {
            return r.json();
        } else {
            throw new Error('Beklenmeyen response formatı');
        }
    })
    .then(data => {
        if (data.success) {
            bootstrap.Modal.getInstance(document.getElementById('reservationDetailModal')).hide();
            showSuccessMessage('Ödeme alındı ve rezervasyon tamamlandı!');
            setTimeout(() => location.reload(), 1500);
        } else {
            showErrorMessage(data.message || 'Hata oluştu');
            if (btn) {
                btn.disabled = false;
                btn.innerHTML = '<i class="bi bi-check-circle me-1"></i>Onayla ve Bitir';
            }
        }
    })
    .catch(e => {
        console.error('Rezervasyon tamamlama hatası:', e);
        const errorMsg = e.message || 'Rezervasyon tamamlanırken bir hata oluştu.';
        showErrorMessage(errorMsg);
        if (btn) {
            btn.disabled = false;
            btn.innerHTML = '<i class="bi bi-check-circle me-1"></i>Onayla ve Bitir';
        }
    });
}

// Rezervasyonu İptal Et
async function cancelReservation() {
    const id = document.getElementById('currentReservationId').value;
    if (!id) return;
    
    const confirmed = await customConfirm('Bu rezervasyonu iptal etmek istediğinize emin misiniz?\n\nBu işlem geri alınamaz!');
    if (!confirmed) return;
    
    const cancelUrl = '{{ route("admin.reservations.update-status", ":id") }}'.replace(':id', id);
    fetch(cancelUrl, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || '',
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        },
        body: JSON.stringify({ status: 'cancelled' })
    })
    .then(async r => {
        const contentType = r.headers.get('content-type');
        if (!r.ok) {
            if (contentType && contentType.includes('application/json')) {
                const err = await r.json();
                throw new Error(err.message || err.error || 'HTTP ' + r.status);
            } else {
                const text = await r.text();
                throw new Error('HTTP ' + r.status + ': ' + text.substring(0, 100));
            }
        }
        if (contentType && contentType.includes('application/json')) {
            return r.json();
        } else {
            throw new Error('Beklenmeyen response formatı');
        }
    })
    .then(data => {
        if (data.success) {
            bootstrap.Modal.getInstance(document.getElementById('reservationDetailModal')).hide();
            showSuccessMessage('Rezervasyon iptal edildi.');
            setTimeout(() => location.reload(), 1500);
        } else {
            showErrorMessage(data.message || 'Hata oluştu');
        }
    })
    .catch(e => {
        console.error('Rezervasyon iptal hatası:', e);
        const errorMsg = e.message || 'Rezervasyon iptal edilirken bir hata oluştu.';
        showErrorMessage(errorMsg);
    });
}

// Kalan tutar HTML'ini oluştur (pozitif/negatif duruma göre)
function getRemainingHtml(totalPrice, depositPaid) {
    const remaining = parseFloat(totalPrice) - parseFloat(depositPaid);
    
    if (remaining > 0) {
        // Müşteri bize borçlu
        return `<div class="d-flex justify-content-between text-danger fs-5">
            <span>Kalan (Müşteri Borcu):</span>
            <strong>${remaining.toFixed(2)} ₺</strong>
        </div>`;
    } else if (remaining < 0) {
        // Biz müşteriye borçluyuz (fazla ödeme aldık)
        return `<div class="d-flex justify-content-between text-success fs-5">
            <span>Fazla Ödeme (İade Edilecek):</span>
            <strong style="color: #059669;">${remaining.toFixed(2)} ₺</strong>
        </div>
        <div class="alert alert-warning mt-2 py-2 small">
            <i class="bi bi-exclamation-triangle me-1"></i>
            Müşteriye <strong>${Math.abs(remaining).toFixed(2)} ₺</strong> iade yapılması gerekiyor.
        </div>`;
    } else {
        // Tam ödeme yapılmış
        return `<div class="d-flex justify-content-between text-success fs-5">
            <span>Kalan:</span>
            <strong><i class="bi bi-check-circle me-1"></i>0.00 ₺ (Tamamlandı)</strong>
        </div>`;
    }
}

// Başarı mesajı göster
function showSuccessMessage(message) {
    showNotificationToast(message, 'success');
}

// Hata mesajı göster
function showErrorMessage(message) {
    showNotificationToast(message, 'error');
}

// Toast bildirimi göster
function showNotificationToast(message, type = 'info') {
    // Varsa eski toast'ı kaldır
    const existingToast = document.querySelector('.custom-toast');
    if (existingToast) existingToast.remove();
    
    const colors = {
        success: { bg: '#10b981', icon: 'bi-check-circle-fill' },
        error: { bg: '#ef4444', icon: 'bi-x-circle-fill' },
        warning: { bg: '#f59e0b', icon: 'bi-exclamation-triangle-fill' },
        info: { bg: '#3b82f6', icon: 'bi-info-circle-fill' }
    };
    
    const config = colors[type] || colors.info;
    
    const toast = document.createElement('div');
    toast.className = 'custom-toast';
    toast.innerHTML = `
        <div style="position: fixed; top: 20px; right: 20px; z-index: 9999999; animation: slideIn 0.3s ease;">
            <div style="background: ${config.bg}; color: white; padding: 16px 24px; border-radius: 12px; box-shadow: 0 10px 40px rgba(0,0,0,0.2); display: flex; align-items: center; gap: 12px; min-width: 300px;">
                <i class="bi ${config.icon}" style="font-size: 24px;"></i>
                <span style="font-weight: 500;">${message}</span>
            </div>
        </div>
    `;
    
    document.body.appendChild(toast);
    
    // 3 saniye sonra kaldır
    setTimeout(() => {
        toast.style.opacity = '0';
        toast.style.transition = 'opacity 0.3s ease';
        setTimeout(() => toast.remove(), 300);
    }, 3000);
}
</script>
@endsection
