@extends('layouts.admin')

@section('title', 'Açıktaki Rezervasyonlar')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item"><a href="#">Rezervasyon İşlemleri</a></li>
    <li class="breadcrumb-item active">Açıktaki Rezervasyonlar</li>
@endsection

@section('content')
    <h2 class="mb-4">Açıktaki Rezervasyonlar</h2>
    
    <div class="card">
        <div class="card-header border-0" style="background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);">
            <h5 class="mb-0 text-white">Rezervasyon Listesi</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Rezervasyon Kodu</th>
                            <th>Müşteri Adı</th>
                            <th>Tarih/Saat</th>
                            <th>Salon</th>
                            <th>Toplam Tutar</th>
                            <th>Kalan Bakiye</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($reservations as $reservation)
                            <tr>
                                <td>{{ $reservation->code }}</td>
                                <td>{{ $reservation->customer->name }}</td>
                                <td>{{ $reservation->date->format('d.m.Y') }} {{ $reservation->start_time }}</td>
                                <td>{{ $reservation->salon->name }}</td>
                                <td>{{ number_format($reservation->total_price, 2) }} ₺</td>
                                <td>{{ number_format($reservation->remaining_amount, 2) }} ₺</td>
                                <td>
                                    <button type="button" onclick="openReservationDetailModal({{ $reservation->id }})" class="btn btn-sm btn-info">
                                        <i class="bi bi-eye"></i>
                                    </button>
                                    <a href="{{ route('admin.rezervasyonlar.edit', $reservation->id) }}" class="btn btn-sm btn-warning">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center">Açık rezervasyon bulunamadı.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="mt-3">
                {{ $reservations->links() }}
            </div>
        </div>
    </div>
@endsection

