@extends('layouts.admin')

@section('title', 'Rezervasyon Detayı')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.rezervasyonlar.index') }}">Rezervasyonlar</a></li>
    <li class="breadcrumb-item active">Detay</li>
@endsection

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Rezervasyon Detayı</h2>
        <div>
            <a href="{{ route('admin.rezervasyonlar.edit', $reservation->id) }}" class="btn btn-warning">
                <i class="bi bi-pencil"></i> Düzenle
            </a>
            <a href="{{ route('admin.rezervasyonlar.index') }}" class="btn btn-secondary">
                <i class="bi bi-arrow-left"></i> Geri
            </a>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-8">
            <div class="card mb-4">
                <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%); color: white;">
                    <h5 class="mb-0 text-white"><i class="bi bi-info-circle"></i> Rezervasyon Bilgileri</h5>
                </div>
                <div class="card-body">
                    @php
                        $itemsData = json_decode($reservation->items_data ?? '{}', true);
                        $brideGroomName = $itemsData['bride_groom_name'] ?? null;
                        $brideName = $itemsData['bride_name'] ?? null;
                        $groomName = $itemsData['groom_name'] ?? null;
                        $brideGroomPhone = $itemsData['bride_groom_phone'] ?? null;
                        $remainingAmount = $reservation->total_price - ($reservation->deposit_paid ?? 0);
                    @endphp
                    
                    <div class="row g-3">
                        <!-- Müşteri -->
                        <div class="col-md-4 col-sm-6">
                            <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);">
                                <div class="card-body text-white p-3">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <i class="bi bi-person-fill" style="font-size: 1.5rem;"></i>
                                        <h6 class="mb-0 fw-bold">Müşteri</h6>
                                    </div>
                                    <div class="d-flex align-items-center gap-2">
                                        <div class="customer-avatar" style="width: 40px; height: 40px; border-radius: 50%; background: rgba(255,255,255,0.2); display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 14px; flex-shrink: 0; border: 2px solid rgba(255,255,255,0.3);">
                                            {{ $reservation->customer->initials ?? '??' }}
                                        </div>
                                        <div>
                                            <div class="fw-bold">{{ $reservation->customer->name }}</div>
                                            @if($reservation->customer->phone)
                                                <small class="opacity-75"><i class="bi bi-telephone"></i> {{ $reservation->customer->phone }}</small>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Gelin ve Damat -->
                        <div class="col-md-4 col-sm-6">
                            <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #ec4899 0%, #db2777 100%);">
                                <div class="card-body text-white p-3">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <i class="bi bi-heart-fill" style="font-size: 1.5rem;"></i>
                                        <h6 class="mb-0 fw-bold">Gelin ve Damat</h6>
                                    </div>
                                    @if($brideName || $groomName)
                                        @if($brideName)
                                            <div class="fw-bold mb-1"><i class="bi bi-person-dress me-1"></i>Gelin: {{ $brideName }}</div>
                                        @endif
                                        @if($groomName)
                                            <div class="fw-bold mb-1"><i class="bi bi-person me-1"></i>Damat: {{ $groomName }}</div>
                                        @endif
                                        @if($brideGroomPhone)
                                            <small class="opacity-75"><i class="bi bi-telephone"></i> {{ $brideGroomPhone }}</small>
                                        @else
                                            <small class="opacity-75">Telefon bilgisi yok</small>
                                        @endif
                                    @elseif($brideGroomName)
                                        <div class="fw-bold mb-1">{{ $brideGroomName }}</div>
                                        @if($brideGroomPhone)
                                            <small class="opacity-75"><i class="bi bi-telephone"></i> {{ $brideGroomPhone }}</small>
                                        @else
                                            <small class="opacity-75">Telefon bilgisi yok</small>
                                        @endif
                                    @else
                                        <div class="opacity-75">Bilgi girilmemiş</div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        
                        <!-- Salon -->
                        <div class="col-md-4 col-sm-6">
                            <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%);">
                                <div class="card-body text-white p-3">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <i class="bi bi-building" style="font-size: 1.5rem;"></i>
                                        <h6 class="mb-0 fw-bold">Salon</h6>
                                    </div>
                                    <div class="fw-bold fs-5">{{ $reservation->salon->name }}</div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Tarih -->
                        <div class="col-md-4 col-sm-6">
                            <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);">
                                <div class="card-body text-white p-3">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <i class="bi bi-calendar3" style="font-size: 1.5rem;"></i>
                                        <h6 class="mb-0 fw-bold">Tarih</h6>
                                    </div>
                                    <div class="fw-bold fs-5">{{ $reservation->date->format('d.m.Y') }}</div>
                                    <small class="opacity-75">{{ $reservation->date->locale('tr')->isoFormat('dddd') }}</small>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Saat -->
                        <div class="col-md-4 col-sm-6">
                            <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);">
                                <div class="card-body text-white p-3">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <i class="bi bi-clock" style="font-size: 1.5rem;"></i>
                                        <h6 class="mb-0 fw-bold">Saat</h6>
                                    </div>
                                    <div class="fw-bold fs-5">{{ $reservation->start_time }} - {{ $reservation->end_time }}</div>
                                    @php
                                        $start = \Carbon\Carbon::parse($reservation->start_time);
                                        $end = \Carbon\Carbon::parse($reservation->end_time);
                                        $duration = $start->diffInHours($end);
                                    @endphp
                                    <small class="opacity-75">{{ $duration }} saat</small>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Misafir Sayısı -->
                        <div class="col-md-4 col-sm-6">
                            <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #06b6d4 0%, #0891b2 100%);">
                                <div class="card-body text-white p-3">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <i class="bi bi-people-fill" style="font-size: 1.5rem;"></i>
                                        <h6 class="mb-0 fw-bold">Misafir Sayısı</h6>
                                    </div>
                                    <div class="fw-bold fs-3">{{ $reservation->guest_count }}</div>
                                    <small class="opacity-75">kişi</small>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Durum -->
                        <div class="col-md-4 col-sm-6">
                            <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);">
                                <div class="card-body text-white p-3">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <i class="bi bi-info-circle-fill" style="font-size: 1.5rem;"></i>
                                        <h6 class="mb-0 fw-bold">Durum</h6>
                                    </div>
                                    @if($reservation->status == 'open')
                                        <span class="badge bg-warning text-dark fs-6">Açık</span>
                                    @elseif($reservation->status == 'confirmed')
                                        <span class="badge bg-success fs-6">Onaylandı</span>
                                    @elseif($reservation->status == 'cancelled')
                                        <span class="badge bg-danger fs-6">İptal</span>
                                    @else
                                        <span class="badge bg-info fs-6">Tamamlandı</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        
                        <!-- Rezervasyon Kodu -->
                        <div class="col-md-4 col-sm-6">
                            <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #14b8a6 0%, #0d9488 100%);">
                                <div class="card-body text-white p-3">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <i class="bi bi-tag-fill" style="font-size: 1.5rem;"></i>
                                        <h6 class="mb-0 fw-bold">Rezervasyon Kodu</h6>
                                    </div>
                                    <div class="fw-bold fs-6">{{ $reservation->code ?? 'Yok' }}</div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Toplam Tutar -->
                        <div class="col-md-4 col-sm-6">
                            <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #f97316 0%, #ea580c 100%);">
                                <div class="card-body text-white p-3">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <i class="bi bi-cash-stack" style="font-size: 1.5rem;"></i>
                                        <h6 class="mb-0 fw-bold">Toplam Tutar</h6>
                                    </div>
                                    <div class="fw-bold fs-4">{{ number_format($reservation->total_price, 2, ',', '.') }} ₺</div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Alınan Kapora -->
                        <div class="col-md-4 col-sm-6">
                            <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #22c55e 0%, #16a34a 100%);">
                                <div class="card-body text-white p-3">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <i class="bi bi-wallet2" style="font-size: 1.5rem;"></i>
                                        <h6 class="mb-0 fw-bold">Alınan Kapora</h6>
                                    </div>
                                    <div class="fw-bold fs-4">{{ number_format($reservation->deposit_paid ?? 0, 2, ',', '.') }} ₺</div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Kalan Tutar -->
                        <div class="col-md-4 col-sm-6">
                            <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);">
                                <div class="card-body text-white p-3">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <i class="bi bi-calculator" style="font-size: 1.5rem;"></i>
                                        <h6 class="mb-0 fw-bold">Kalan Tutar</h6>
                                    </div>
                                    <div class="fw-bold fs-4">{{ number_format($remainingAmount, 2, ',', '.') }} ₺</div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Oluşturulma Tarihi -->
                        <div class="col-md-4 col-sm-6">
                            <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #64748b 0%, #475569 100%);">
                                <div class="card-body text-white p-3">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <i class="bi bi-calendar-check" style="font-size: 1.5rem;"></i>
                                        <h6 class="mb-0 fw-bold">Oluşturulma</h6>
                                    </div>
                                    <div class="fw-bold">{{ $reservation->created_at->format('d.m.Y') }}</div>
                                    <small class="opacity-75">{{ $reservation->created_at->format('H:i') }}</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    @if($reservation->notes)
                    <div class="row mt-3">
                        <div class="col-12">
                            <div class="card border-0 shadow-sm" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);">
                                <div class="card-body text-white p-3">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <i class="bi bi-sticky-fill" style="font-size: 1.5rem;"></i>
                                        <h6 class="mb-0 fw-bold">Notlar</h6>
                                    </div>
                                    <div class="opacity-90">{{ $reservation->notes }}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
            
            @if($reservation->extras->count() > 0)
            <div class="card mb-4">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0"><i class="bi bi-plus-circle"></i> Extralar</h5>
                </div>
                <div class="card-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Extra</th>
                                <th>Adet</th>
                                <th>Birim Fiyat</th>
                                <th>Toplam</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($reservation->extras as $extra)
                                <tr>
                                    <td>{{ $extra->name }}</td>
                                    <td>{{ $extra->pivot->quantity }}</td>
                                    <td>{{ number_format($extra->pivot->price, 2, ',', '.') }} ₺</td>
                                    <td>{{ number_format($extra->pivot->quantity * $extra->pivot->price, 2, ',', '.') }} ₺</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            @endif
        </div>
        
        <div class="col-md-4">
            <!-- Ödeme Geçmişi - ÜSTE TAŞINDI -->
            <div class="card mb-4">
                <div class="card-header bg-warning text-dark">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0"><i class="bi bi-receipt"></i> Ödeme Geçmişi</h5>
                        <button type="button" class="btn btn-sm btn-success" onclick="openPaymentModal()">
                            <i class="bi bi-plus"></i> Ödeme Al
                        </button>
                    </div>
                </div>
                <div class="card-body p-0">
                    @php
                        $transactions = \App\Models\Transaction::where('reservation_id', $reservation->id)
                            ->orderBy('date', 'desc')
                            ->orderBy('created_at', 'desc')
                            ->get();
                        $totalPaid = $transactions->where('type', 'income')->sum('amount');
                    @endphp
                    
                    @if($transactions->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Tarih</th>
                                        <th>Açıklama</th>
                                        <th class="text-end">Tutar</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($transactions as $transaction)
                                        <tr>
                                            <td>
                                                <small>{{ $transaction->date ? $transaction->date->format('d.m.Y') : '-' }}</small>
                                            </td>
                                            <td>
                                                <small>{{ Str::limit($transaction->description, 25) }}</small>
                                            </td>
                                            <td class="text-end">
                                                @if($transaction->type == 'income')
                                                    <span class="text-success fw-bold">+{{ number_format($transaction->amount, 2, ',', '.') }} ₺</span>
                                                @else
                                                    <span class="text-danger fw-bold">-{{ number_format($transaction->amount, 2, ',', '.') }} ₺</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot class="table-light">
                                    <tr>
                                        <td colspan="2"><strong>Toplam Ödenen</strong></td>
                                        <td class="text-end"><strong class="text-success">{{ number_format($totalPaid, 2, ',', '.') }} ₺</strong></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    @else
                        <div class="p-3 text-center text-muted">
                            <i class="bi bi-inbox"></i> Henüz ödeme kaydı yok
                        </div>
                    @endif
                </div>
            </div>
            
            <div class="card mb-4">
                <div class="card-header" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%); color: white;">
                    <h5 class="mb-0 text-white"><i class="bi bi-cash-coin"></i> Ödeme Bilgileri</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <strong>Toplam Tutar:</strong>
                        <h4 class="text-success">{{ number_format($reservation->total_price, 2, ',', '.') }} ₺</h4>
                    </div>
                    <div class="mb-3">
                        <strong>Ödenen Kapora:</strong>
                        <h5 class="text-info">{{ number_format($reservation->deposit_paid ?? 0, 2, ',', '.') }} ₺</h5>
                    </div>
                    <div class="mb-3">
                        <strong>Kalan Bakiye:</strong>
                        <h5 class="text-danger">{{ number_format($reservation->remaining_amount ?? 0, 2, ',', '.') }} ₺</h5>
                    </div>
                </div>
            </div>
            
            <div class="card mb-4">
                <div class="card-header" style="background: linear-gradient(135deg, #6b7280 0%, #4b5563 100%); color: white;">
                    <h5 class="mb-0 text-white"><i class="bi bi-person"></i> Müşteri Bilgileri</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex align-items-center gap-2 mb-2">
                        <div class="customer-avatar" style="width: 40px; height: 40px; border-radius: 50%; background: {{ $reservation->customer->avatar_color ?? '#2563eb' }}; display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 14px; flex-shrink: 0;">
                            {{ $reservation->customer->initials ?? '??' }}
                        </div>
                        <p class="mb-0"><strong>Ad:</strong> {{ $reservation->customer->name }}</p>
                    </div>
                    @if($reservation->customer->phone)
                        <p><strong>Telefon:</strong> {{ $reservation->customer->phone }}</p>
                    @endif
                    @if($reservation->customer->email)
                        <p><strong>E-posta:</strong> {{ $reservation->customer->email }}</p>
                    @endif
                    @if($reservation->customer->address)
                        <p><strong>Adres:</strong> {{ $reservation->customer->address }}</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
    
    <!-- Ödeme Al Modal -->
    <div class="modal fade" id="paymentModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title"><i class="bi bi-cash-coin"></i> Ödeme Al</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <form action="{{ route('admin.accounting.cashbox.income.store') }}" method="POST">
                    @csrf
                    <input type="hidden" name="reservation_id" value="{{ $reservation->id }}">
                    <input type="hidden" name="customer_id" value="{{ $reservation->customer_id }}">
                    <div class="modal-body">
                        <div class="alert alert-info">
                            <strong>Kalan Bakiye:</strong> {{ number_format($reservation->remaining_amount ?? 0, 2, ',', '.') }} ₺
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Ödeme Tutarı <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <input type="number" name="amount" class="form-control" step="0.01" min="0" max="{{ $reservation->remaining_amount }}" value="{{ $reservation->remaining_amount }}" required>
                                <span class="input-group-text">₺</span>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Tarih <span class="text-danger">*</span></label>
                            <input type="date" name="date" class="form-control" value="{{ date('Y-m-d') }}" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Açıklama</label>
                            <input type="text" name="description" class="form-control" value="Rezervasyon #{{ $reservation->id }} - {{ $reservation->customer->name }} ödeme">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                        <button type="submit" class="btn btn-success">
                            <i class="bi bi-check-circle"></i> Ödemeyi Kaydet
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
function openPaymentModal() {
    const modal = new bootstrap.Modal(document.getElementById('paymentModal'));
    modal.show();
}
</script>
@endpush

