@extends('layouts.admin')

@section('title', 'Takvim Ayarları')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Takvim Ayarları</li>
@endsection

@section('content')
    <h2 class="mb-4">Takvim Ayarları</h2>
    
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-calendar3"></i> Takvim Ayarları</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.settings.calendar') }}">
                @csrf
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Hafta Başlangıç Günü</label>
                    <select name="week_start_day" class="form-select form-select-lg">
                        <option value="monday" {{ ($settings['week_start_day'] ?? 'monday') == 'monday' ? 'selected' : '' }}>Pazartesi</option>
                        <option value="sunday" {{ ($settings['week_start_day'] ?? '') == 'sunday' ? 'selected' : '' }}>Pazar</option>
                    </select>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Çalışma Saatleri Başlangıç</label>
                    <input type="time" name="work_start_time" class="form-control form-control-lg" value="{{ $settings['work_start_time'] ?? '09:00' }}">
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Çalışma Saatleri Bitiş</label>
                    <input type="time" name="work_end_time" class="form-control form-control-lg" value="{{ $settings['work_end_time'] ?? '22:00' }}">
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Varsayılan Rezervasyon Süresi (Saat)</label>
                    <input type="number" step="0.5" name="default_duration" class="form-control form-control-lg" value="{{ $settings['default_duration'] ?? 4 }}" min="1">
                </div>
                
                <button type="submit" class="btn btn-lg btn-primary">
                    <i class="bi bi-check-circle"></i> Kaydet
                </button>
            </form>
        </div>
    </div>
@endsection

