@extends('layouts.admin')

@section('title', 'Email Bildirim Ayarları')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Email Bildirim Ayarları</li>
@endsection

@section('content')
    <h2 class="mb-4">Email Bildirim Ayarları</h2>
    
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-envelope"></i> Email Ayarları</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.settings.email') }}">
                @csrf
                
                <div class="mb-3">
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" name="send_reservation_confirmation" id="send_reservation_confirmation" value="1" {{ ($settings['send_reservation_confirmation'] ?? true) ? 'checked' : '' }}>
                        <label class="form-check-label fw-bold" for="send_reservation_confirmation">
                            Rezervasyon Onayı Gönder
                        </label>
                    </div>
                </div>
                
                <div class="mb-3">
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" name="send_reminder" id="send_reminder" value="1" {{ ($settings['send_reminder'] ?? true) ? 'checked' : '' }}>
                        <label class="form-check-label fw-bold" for="send_reminder">
                            Hatırlatma E-postası Gönder
                        </label>
                    </div>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Hatırlatma Süresi (Gün Öncesi)</label>
                    <input type="number" name="reminder_days_before" class="form-control form-control-lg" value="{{ $settings['reminder_days_before'] ?? 1 }}" min="1">
                </div>
                
                <button type="submit" class="btn btn-lg btn-primary">
                    <i class="bi bi-check-circle"></i> Kaydet
                </button>
            </form>
        </div>
    </div>
@endsection

